/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app;

import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import cz.miroslavbartyzal.psdiagram.app.global.PrintStreamWithTimestamp;
import cz.miroslavbartyzal.psdiagram.app.global.SettingsHolder;
import cz.miroslavbartyzal.psdiagram.app.gui.MainWindow;
import java.awt.Color;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class Main {
    public static void main(String[] args) {
        if (SettingsHolder.IS_DEPLOYMENT_MODE) {
            Main.initFileLogging();
        }
        Main.initLookAndFeel();
        ToolTipManager.sharedInstance().setDismissDelay(12000);
        UIManager.put("info", Color.WHITE);
        MainWindow.main(args);
    }

    private static void initFileLogging() {
        Main.setupGlobalExceptionHandling();
        Path logFile = Paths.get(System.getProperty("user.home"), ".psdiagram", "psdiagram.log");
        try {
            PrintStreamWithTimestamp outputFileStream = new PrintStreamWithTimestamp(Files.newOutputStream(logFile, new OpenOption[0]), true, StandardCharsets.UTF_8.toString());
            System.setOut(outputFileStream);
            System.setErr(outputFileStream);
        }
        catch (IOException ex) {
            MyExceptionHandler.handle(ex);
        }
    }

    private static void setupGlobalExceptionHandling() {
        Thread.setDefaultUncaughtExceptionHandler(new MyExceptionHandler());
    }

    private static void initLookAndFeel() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            MyExceptionHandler.handle(ex);
        }
    }
}

