/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.codeImportExport;

import cz.miroslavbartyzal.psdiagram.app.codeImportExport.JavaToFlowchartConvertor;
import cz.miroslavbartyzal.psdiagram.app.flowchart.Flowchart;
import cz.miroslavbartyzal.psdiagram.app.flowchart.FlowchartElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutSegment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Comment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Decision;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.For;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Goto;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.GotoLabel;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.IO;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.LoopEnd;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.LoopStart;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Process;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.StartEnd;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.SubRoutine;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Switch;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import cz.miroslavbartyzal.psdiagram.app.gui.dialog.MyJOptionPane;
import cz.miroslavbartyzal.psdiagram.app.parser.ConversionResult;
import cz.miroslavbartyzal.psdiagram.app.parser.SourceCodeGenerator;
import cz.miroslavbartyzal.psdiagram.app.parser.psd.AntlrPsdParser;
import cz.miroslavbartyzal.psdiagram.app.parser.psd.PSDGrammarParser;
import java.awt.HeadlessException;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JOptionPane;

public final class Java
implements SourceCodeGenerator {
    private static final String LINE_SEP = System.lineSeparator();
    private final AntlrPsdParser psdToJavaParser = new AntlrPsdParser();
    private boolean errored;
    private boolean gotoUsage;
    private boolean missingCommandWarning;
    private Boolean scannerNeeded = false;

    public static Flowchart<LayoutSegment, LayoutElement> getFlowchart(String code) {
        JavaToFlowchartConvertor javaToPsdConvertor = new JavaToFlowchartConvertor(5);
        ConversionResult conversionResult = javaToPsdConvertor.convertToPsd(code);
        if (conversionResult.isInputValid()) {
            return conversionResult.getFlowchart();
        }
        MyJOptionPane.showMessageDialog(null, conversionResult.getErrorMessage(), "Chyba p\u0159i generov\u00e1n\u00ed diagramu", 0);
        return null;
    }

    public static String getSourceCode(Flowchart<LayoutSegment, LayoutElement> flowchart, String name, boolean blockScopeVariables) {
        Java instance = new Java();
        return instance.generateSourceCode(flowchart, name, blockScopeVariables);
    }

    private String generateSourceCode(Flowchart<LayoutSegment, LayoutElement> flowchart, String name, boolean blockScopeVariables) {
        this.errored = false;
        this.missingCommandWarning = false;
        this.scannerNeeded = false;
        this.gotoUsage = false;
        Object sourceCode = "public class " + this.normalizeAsVariable(name) + LINE_SEP + "{" + LINE_SEP;
        sourceCode = (String)sourceCode + "\tpublic static void main(String[] args)" + LINE_SEP + "\t{";
        HashSet<String> alreadyDeclaredVariables = new HashSet<String>();
        if (!blockScopeVariables) {
            TreeSet<String> vars = new TreeSet<String>();
            TreeSet<String> arrayVars = new TreeSet<String>();
            this.findAndSetVariables(flowchart, vars, arrayVars);
            sourceCode = this.addVariableDeclarations((String)sourceCode, vars, arrayVars, "\t\t", alreadyDeclaredVariables);
        }
        String mainSourceCode = this.generateSourceCode(flowchart.getMainSegment(), "\t\t", alreadyDeclaredVariables);
        if (this.scannerNeeded.booleanValue()) {
            sourceCode = "import java.util.Scanner;" + LINE_SEP + LINE_SEP + (String)sourceCode;
            sourceCode = (String)sourceCode + LINE_SEP + "\t\tScanner scanner = new Scanner(System.in);" + LINE_SEP + "\t\t";
        }
        sourceCode = (String)sourceCode + mainSourceCode;
        if (this.errored) {
            sourceCode = null;
        } else if (this.missingCommandWarning || this.gotoUsage) {
            Object warnings = "<ul>";
            if (this.missingCommandWarning) {
                warnings = (String)warnings + "<li>N\u011bkter\u00fd symbol nem\u00e1 vypln\u011bnu svou funkci!</li>";
            }
            if (this.gotoUsage) {
                warnings = (String)warnings + "<li>Goto p\u0159\u00edkaz nen\u00ed v Jav\u011b podporov\u00e1n!</li>";
            }
            warnings = (String)warnings + "</ul>";
            JOptionPane.showMessageDialog(null, "<html>Zdrojov\u00fd k\u00f3d byl vygenerov\u00e1n s n\u00e1sleduj\u00edc\u00edm upozorn\u011bn\u00edm:" + (String)warnings + "</html>", "Nevypln\u011bn\u00e1 funkce symbolu", 2);
        }
        sourceCode = (String)sourceCode + LINE_SEP + "}";
        return sourceCode;
    }

    private String addVariableDeclarations(String sourceCode, Set<String> vars, Set<String> arrayVars, String tabsDepth, Set<String> declaredVariables) {
        if (!vars.isEmpty() || !arrayVars.isEmpty()) {
            sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "// zde je nutne doplnit typy promennych (diagramy jsou netypove)";
            if (!vars.isEmpty()) {
                for (String variable : vars) {
                    sourceCode = (String)sourceCode + LINE_SEP + tabsDepth;
                    sourceCode = (String)sourceCode + "{typ_promenne} " + variable + ";";
                    this.addToDeclared(variable, declaredVariables);
                }
            }
            if (!arrayVars.isEmpty()) {
                for (String arrayVar : arrayVars) {
                    sourceCode = (String)sourceCode + LINE_SEP + tabsDepth;
                    sourceCode = (String)sourceCode + "{typ_promenne_pole}[] " + arrayVar + ";";
                    this.addToDeclared(arrayVar, declaredVariables);
                }
            }
            sourceCode = (String)sourceCode + LINE_SEP + tabsDepth;
        }
        return sourceCode;
    }

    private void findAndSetVariables(Flowchart<LayoutSegment, LayoutElement> flowchart, Set<String> vars, Set<String> arrayVars) {
        for (LayoutSegment segment : flowchart) {
            if (segment == null) continue;
            for (FlowchartElement element : segment) {
                Symbol symbol = element.getSymbol();
                if (symbol.getCommands() == null) continue;
                if (symbol instanceof Process || symbol instanceof IO && symbol.getCommands().containsKey("var")) {
                    String variable;
                    if (symbol.getCommands().get("var").contains("[") || symbol.getCommands().containsKey("value") && symbol.getCommands().get("value").startsWith("[")) {
                        variable = symbol.getCommands().get("var");
                        this.addToDeclared(variable, arrayVars);
                        continue;
                    }
                    variable = symbol.getCommands().get("var");
                    this.addToDeclared(variable, vars);
                    continue;
                }
                if (!(symbol instanceof For)) continue;
                this.addToDeclared(symbol.getCommands().get("var"), vars);
                if (!symbol.getCommands().containsKey("array")) continue;
                this.addToDeclared(symbol.getCommands().get("array"), arrayVars);
            }
        }
    }

    private String generateSourceCode(LayoutSegment segment, String tabsDepth, Set<String> alreadyDeclaredVariables) {
        HashSet<String> declaredVariables = new HashSet<String>(alreadyDeclaredVariables);
        String pairedCommentText = null;
        boolean lastWasPairedComment = false;
        Object sourceCode = "";
        int index = -1;
        for (LayoutElement element : segment) {
            ++index;
            Symbol symbol = element.getSymbol();
            try {
                boolean isElseIf = this.isElseIf(segment);
                if (!isElseIf) {
                    sourceCode = (String)sourceCode + LINE_SEP + tabsDepth;
                }
                if (symbol instanceof Process) {
                    if (symbol.getCommands() != null) {
                        String variable = symbol.getCommands().get("var");
                        variable = this.psdToJavaParser.translatePSDToJava(variable, PSDGrammarParser::solo_Expression);
                        String processValue = symbol.getCommands().get("value");
                        processValue = this.psdToJavaParser.translatePSDToJava(processValue, PSDGrammarParser::solo_Expression);
                        if (this.isNotDeclaredYet(variable, declaredVariables)) {
                            sourceCode = (String)sourceCode + "var ";
                            this.addToDeclared(variable, declaredVariables);
                        }
                        sourceCode = (String)sourceCode + variable + " = " + processValue + ";";
                    } else {
                        sourceCode = (String)sourceCode + "{symbol Zpracov\u00e1n\u00ed bez vyplnene funkce!}";
                        this.missingCommandWarning = true;
                    }
                } else if (symbol instanceof IO) {
                    if (symbol.getCommands() != null) {
                        if (symbol.getCommands().containsKey("var")) {
                            this.scannerNeeded = true;
                            String variable = symbol.getCommands().get("var");
                            if (this.isNotDeclaredYet(variable = this.psdToJavaParser.translatePSDToJava(variable, PSDGrammarParser::solo_Expression), declaredVariables)) {
                                sourceCode = (String)sourceCode + "var ";
                                this.addToDeclared(variable, declaredVariables);
                            }
                            sourceCode = (String)sourceCode + variable + " = scanner.next/*{data type}*/();";
                        } else {
                            String value = symbol.getCommands().get("value");
                            value = this.psdToJavaParser.translatePSDToJava(value, PSDGrammarParser::solo_Expression);
                            sourceCode = (String)sourceCode + "System.out.println(" + value + ");";
                        }
                    } else {
                        sourceCode = (String)sourceCode + "{symbol Vstup/Vystup bez vyplnene funkce!}";
                        this.missingCommandWarning = true;
                    }
                } else if (symbol instanceof Switch) {
                    if (symbol.getCommands() != null) {
                        String conditionVar = symbol.getCommands().get("conditionVar");
                        conditionVar = this.psdToJavaParser.translatePSDToJava(conditionVar, PSDGrammarParser::solo_Expression);
                        sourceCode = (String)sourceCode + "switch (" + conditionVar + ") {";
                    } else {
                        sourceCode = (String)sourceCode + "switch ({nevyplnena funkce!}) {";
                        this.missingCommandWarning = true;
                    }
                    if (pairedCommentText != null) {
                        sourceCode = (String)sourceCode + pairedCommentText;
                        pairedCommentText = null;
                    }
                    for (int i = 1; i < element.getInnerSegmentsCount(); ++i) {
                        if (symbol.getCommands() != null) {
                            String switchCase = symbol.getCommands().get(String.valueOf(i));
                            switchCase = this.psdToJavaParser.translatePSDToJava(switchCase, PSDGrammarParser::solo_ListOf_Constants);
                            switchCase = switchCase.replaceAll(LINE_SEP, LINE_SEP + tabsDepth + "\t");
                            sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "\t" + switchCase;
                        } else {
                            sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "\tcase {nevyplnena funkce vetve Switch symbolu!}:";
                        }
                        sourceCode = (String)sourceCode + this.generateSourceCode((LayoutSegment)element.getInnerSegment(i), tabsDepth + "\t\t", declaredVariables);
                        sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "\t\tbreak;";
                    }
                    if (this.containsFunctionalSymbols((LayoutSegment)element.getInnerSegment(0), -1)) {
                        sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "\tdefault:";
                        sourceCode = (String)sourceCode + this.generateSourceCode((LayoutSegment)element.getInnerSegment(0), tabsDepth + "\t\t", declaredVariables);
                        sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "\t\tbreak;";
                    }
                    sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "}";
                } else if (symbol instanceof Decision) {
                    if (symbol.getCommands() != null) {
                        String condition = symbol.getCommands().get("condition");
                        condition = this.psdToJavaParser.translatePSDToJava(condition, PSDGrammarParser::solo_Expression);
                        sourceCode = (String)sourceCode + "if (" + condition + ") {";
                    } else {
                        sourceCode = (String)sourceCode + "if ({nevyplnena funkce!}) {";
                        this.missingCommandWarning = true;
                    }
                    if (pairedCommentText != null) {
                        sourceCode = (String)sourceCode + pairedCommentText;
                        pairedCommentText = null;
                    }
                    sourceCode = (String)sourceCode + this.generateSourceCode((LayoutSegment)element.getInnerSegment(1), tabsDepth + "\t", declaredVariables);
                    sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "}";
                    if (this.containsFunctionalSymbols((LayoutSegment)element.getInnerSegment(0), -1)) {
                        sourceCode = (String)sourceCode + " else ";
                        if (this.isElseIf((LayoutSegment)element.getInnerSegment(0))) {
                            sourceCode = (String)sourceCode + this.generateSourceCode((LayoutSegment)element.getInnerSegment(0), tabsDepth, declaredVariables);
                        } else {
                            sourceCode = (String)sourceCode + "{" + this.generateSourceCode((LayoutSegment)element.getInnerSegment(0), tabsDepth + "\t", declaredVariables);
                            sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "}";
                        }
                    }
                } else if (symbol instanceof For) {
                    if (symbol.getCommands() != null) {
                        String variable = symbol.getCommands().get("var");
                        variable = this.psdToJavaParser.translatePSDToJava(variable, PSDGrammarParser::solo_Expression);
                        if (symbol.getCommands().containsKey("inc")) {
                            String from = symbol.getCommands().get("from");
                            from = this.psdToJavaParser.translatePSDToJava(from, PSDGrammarParser::solo_Expression);
                            String to = symbol.getCommands().get("to");
                            to = this.psdToJavaParser.translatePSDToJava(to, PSDGrammarParser::solo_Expression);
                            String inc = symbol.getCommands().get("inc");
                            sourceCode = this.isNumeric(inc = this.psdToJavaParser.translatePSDToJava(inc, PSDGrammarParser::solo_Expression)) ? (Double.parseDouble(inc) < 0.0 ? (String)sourceCode + this.makeForHeader(variable, from, to, inc, ">=", declaredVariables) : (String)sourceCode + this.makeForHeader(variable, from, to, inc, "<=", declaredVariables)) : (this.isNumeric(from) && this.isNumeric(to) ? (Double.parseDouble(from) > Double.parseDouble(to) ? (String)sourceCode + this.makeForHeader(variable, from, to, inc, ">=", declaredVariables) : (String)sourceCode + this.makeForHeader(variable, from, to, inc, "<=", declaredVariables)) : (String)sourceCode + this.makeForHeader(variable, from, to, inc, "<=", declaredVariables));
                        } else {
                            String array = symbol.getCommands().get("array");
                            array = this.psdToJavaParser.translatePSDToJava(array, PSDGrammarParser::solo_Expression);
                            sourceCode = (String)sourceCode + String.format("for (var %s : %s) {", variable, array);
                        }
                        this.addToDeclared(variable, declaredVariables);
                    } else {
                        sourceCode = (String)sourceCode + "for ({nevyplnena funkce!}) {";
                        this.missingCommandWarning = true;
                    }
                    if (pairedCommentText != null) {
                        sourceCode = (String)sourceCode + pairedCommentText;
                        pairedCommentText = null;
                    }
                    sourceCode = (String)sourceCode + this.generateSourceCode((LayoutSegment)element.getInnerSegment(1), tabsDepth + "\t", declaredVariables);
                    sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "}";
                } else if (symbol instanceof LoopStart) {
                    if (symbol.isOverHang()) {
                        if (symbol.getCommands() != null) {
                            String condition = symbol.getCommands().get("condition");
                            condition = this.psdToJavaParser.translatePSDToJava(condition, PSDGrammarParser::solo_Expression);
                            sourceCode = (String)sourceCode + "while (" + condition + ") { ";
                        } else {
                            sourceCode = (String)sourceCode + "while ({nevyplnena funkce!}) {";
                            this.missingCommandWarning = true;
                        }
                        if (pairedCommentText != null) {
                            sourceCode = (String)sourceCode + pairedCommentText;
                            pairedCommentText = null;
                        }
                        sourceCode = (String)sourceCode + this.generateSourceCode((LayoutSegment)element.getInnerSegment(1), tabsDepth + "\t ", declaredVariables);
                        sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "} ";
                    } else {
                        String condition = null;
                        for (int i = index + 1; i < segment.size(); ++i) {
                            if (!(((LayoutElement)segment.getElement(i)).getSymbol() instanceof LoopEnd)) continue;
                            if (((LayoutElement)segment.getElement(i)).getSymbol().getCommands() != null) {
                                condition = ((LayoutElement)segment.getElement(i)).getSymbol().getCommands().get("condition");
                                condition = this.psdToJavaParser.translatePSDToJava(condition, PSDGrammarParser::solo_Expression);
                                break;
                            }
                            condition = "{nevyplnena funkce!}";
                            this.missingCommandWarning = true;
                            break;
                        }
                        if (condition != null) {
                            sourceCode = (String)sourceCode + "do {";
                            if (pairedCommentText != null) {
                                sourceCode = (String)sourceCode + pairedCommentText;
                                pairedCommentText = null;
                            }
                            sourceCode = (String)sourceCode + this.generateSourceCode((LayoutSegment)element.getInnerSegment(1), tabsDepth + "\t", declaredVariables);
                            sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "} while ( " + condition + ");";
                        }
                    }
                } else if (symbol instanceof Comment) {
                    if (symbol.hasPairSymbol() && !(((LayoutElement)segment.getElement(index + 1)).getSymbol() instanceof StartEnd)) {
                        pairedCommentText = " " + this.getSourceCommentText(symbol.getValue(), tabsDepth, true);
                        lastWasPairedComment = true;
                        if (!isElseIf) {
                            sourceCode = this.removeLastNewLine(tabsDepth, (String)sourceCode);
                        }
                    } else {
                        sourceCode = (String)sourceCode + this.getSourceCommentText(symbol.getValue(), tabsDepth, false);
                    }
                } else if (symbol instanceof Goto) {
                    if (symbol.getCommands() != null) {
                        switch (symbol.getCommands().get("mode")) {
                            case "break": {
                                sourceCode = (String)sourceCode + "break;";
                                break;
                            }
                            case "continue": {
                                sourceCode = (String)sourceCode + "continue;";
                                break;
                            }
                            case "goto": {
                                sourceCode = (String)sourceCode + "// {goto " + symbol.getValue() + "}";
                                this.gotoUsage = true;
                            }
                        }
                    } else {
                        sourceCode = (String)sourceCode + "{symbol Spojka-break/continue/goto bez vyplnene funkce!}";
                        this.missingCommandWarning = true;
                    }
                } else if (symbol instanceof GotoLabel) {
                    sourceCode = (String)sourceCode + "// {label " + symbol.getValue() + "}";
                    this.gotoUsage = true;
                } else if (symbol instanceof SubRoutine) {
                    if (symbol.getValue() != null && !symbol.getValue().isEmpty()) {
                        String subroutine = symbol.getValue();
                        subroutine = this.psdToJavaParser.translatePSDToJava(subroutine, PSDGrammarParser::solo_Expression);
                        sourceCode = (String)sourceCode + subroutine + ";";
                    } else {
                        sourceCode = (String)sourceCode + "{symbol P\u0159eddefinovan\u00e9 zpracov\u00e1n\u00ed bez vyplnene funkce!}";
                        this.missingCommandWarning = true;
                    }
                } else if (symbol instanceof StartEnd) {
                    if (segment.getParentElement() == null && (index == 0 || index == 1 && ((LayoutElement)segment.getElement(0)).getSymbol() instanceof Comment)) {
                        sourceCode = this.removeLastNewLine(tabsDepth, (String)sourceCode);
                    } else if (segment.getParentElement() == null && index == segment.size() - 1) {
                        if (this.scannerNeeded.booleanValue()) {
                            sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "scanner.close();" + LINE_SEP + tabsDepth;
                        }
                        sourceCode = ((String)sourceCode).substring(0, ((String)sourceCode).length() - 1) + "}";
                    } else if (segment.getParentElement() != null || index > 1 || index == 1 && !(((LayoutElement)segment.getElement(0)).getSymbol() instanceof Comment)) {
                        sourceCode = (String)sourceCode + "System.exit(0);";
                    }
                } else {
                    sourceCode = this.removeLastNewLine(tabsDepth, (String)sourceCode);
                }
                if (pairedCommentText != null) {
                    if (!lastWasPairedComment) {
                        sourceCode = (String)sourceCode + pairedCommentText;
                        pairedCommentText = null;
                    } else {
                        lastWasPairedComment = false;
                    }
                }
            }
            catch (HeadlessException | NumberFormatException e) {
                JOptionPane.showMessageDialog(null, "<html>Zdrojov\u00fd k\u00f3d se nepoda\u0159ilo vytvo\u0159it!<br />probl\u00e9mov\u00fd symbol vlastn\u00ed popisek: \"" + symbol.getValue() + "\".</html>", "Chyba p\u0159i generov\u00e1n\u00ed zdrojov\u00e9ho k\u00f3du", 0);
                this.errored = true;
            }
            if (!this.errored) continue;
            break;
        }
        return sourceCode;
    }

    private boolean isNotDeclaredYet(String variable, Set<String> declaredVariables) {
        String variableWithoutArrayIndexing = this.stripVariableOfArrayIndexing(variable);
        return !declaredVariables.contains(variableWithoutArrayIndexing);
    }

    private void addToDeclared(String variable, Set<String> declaredVariables) {
        String variableWithoutArrayIndexing = this.stripVariableOfArrayIndexing(variable);
        declaredVariables.add(this.stripVariableOfArrayIndexing(variableWithoutArrayIndexing));
    }

    private String stripVariableOfArrayIndexing(String variable) {
        if (variable.contains("[")) {
            return variable.substring(0, variable.indexOf(91));
        }
        return variable;
    }

    private String removeLastNewLine(String tabsDepth, String sourceCode) {
        return sourceCode.replaceFirst("\\s*$", "");
    }

    private String makeForHeader(String variable, String from, String to, String inc, String conditionOperator, Set<String> alreadyDeclaredVariables) {
        String result;
        if (this.isNotDeclaredYet(variable, alreadyDeclaredVariables)) {
            result = String.format("for (%s = %s; %s %s %s; %s += %s) {", variable, from, variable, conditionOperator, to, variable, inc);
        } else {
            String initVariableType = this.isNumeric(from) && this.isNumeric(inc) ? (this.isInteger(from) && this.isInteger(inc) ? "int" : "double") : "var";
            result = String.format("for (%s %s = %s; %s %s %s; %s += %s) {", initVariableType, variable, from, variable, conditionOperator, to, variable, inc);
        }
        return result;
    }

    private boolean isElseIf(LayoutSegment segment) {
        return segment.getParentElement() != null && this.isDecisionAndNotSwitch((LayoutElement)segment.getParentElement()) && ((LayoutElement)segment.getParentElement()).indexOfInnerSegment(segment) == 0 && (segment.size() == 1 && this.isDecisionAndNotSwitch((LayoutElement)segment.getElement(0)) || segment.size() == 2 && this.isPairedComment((LayoutElement)segment.getElement(0)) && this.isDecisionAndNotSwitch((LayoutElement)segment.getElement(1)));
    }

    private boolean isDecisionAndNotSwitch(LayoutElement element) {
        return element.getSymbol() instanceof Decision && !(element.getSymbol() instanceof Switch);
    }

    private boolean isPairedComment(LayoutElement element) {
        return element.getSymbol() instanceof Comment && element.getSymbol().hasPairSymbol();
    }

    private boolean containsFunctionalSymbols(LayoutSegment segment, int actualElementIndex) {
        for (int i = actualElementIndex + 1; i < segment.size(); ++i) {
            Symbol symbol = ((LayoutElement)segment.getElement(i)).getSymbol();
            if (!(symbol instanceof Process) && !(symbol instanceof IO) && !(symbol instanceof Decision) && !(symbol instanceof For) && !(symbol instanceof LoopStart) && !(symbol instanceof Comment) && !(symbol instanceof SubRoutine) && !(symbol instanceof Goto) && !(symbol instanceof GotoLabel) && (!(symbol instanceof StartEnd) || segment.getParentElement() == null && i >= segment.size() - 1)) continue;
            return true;
        }
        return false;
    }

    private String getSourceCommentText(String commentText, String tabsDepth, boolean isPaired) {
        String additionalTabs = "";
        if (isPaired) {
            additionalTabs = "\t";
        }
        if ((commentText = commentText.replaceAll("\r?\n", LINE_SEP + tabsDepth + additionalTabs)).contains("\n") || commentText.contains("\r")) {
            if (isPaired) {
                return "/*" + commentText + "*/";
            }
            return "/*" + LINE_SEP + tabsDepth + commentText + LINE_SEP + tabsDepth + "*/";
        }
        return "//" + commentText;
    }

    private boolean isNumeric(String str) {
        return this.isDouble(str);
    }

    private boolean isDouble(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

