/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.codeImportExport;

import cz.miroslavbartyzal.psdiagram.app.flowchart.Flowchart;
import cz.miroslavbartyzal.psdiagram.app.flowchart.FlowchartElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutSegment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Comment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Decision;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.EnumSymbol;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.For;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Goto;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.GotoLabel;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.LoopEnd;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.LoopStart;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.StartEnd;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.SubRoutine;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Switch;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import cz.miroslavbartyzal.psdiagram.app.gui.dialog.MyJOptionPane;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.IO;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.Process;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.documentFilters.BooleanValueFilter;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.documentFilters.ConstantFilter;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.documentFilters.NoArrayVariableFilter;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.documentFilters.NumericValueFilter;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.documentFilters.ValueFilter;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.documentFilters.VariableFilter;
import cz.miroslavbartyzal.psdiagram.app.parser.FlowchartGenerator;
import cz.miroslavbartyzal.psdiagram.app.parser.SourceCodeGenerator;
import java.awt.HeadlessException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Pascal
implements FlowchartGenerator,
SourceCodeGenerator {
    private static final int FLAGS = 10;
    private static final String COMMENT_MARKER = "--koment\u00e1\u0159--";
    private boolean errored = false;
    private boolean missingCommandWarning = false;

    public static Flowchart<LayoutSegment, LayoutElement> getFlowchart(String code) {
        Pascal instance = new Pascal();
        return instance.generateFlowchart(code);
    }

    private Flowchart<LayoutSegment, LayoutElement> generateFlowchart(String code) {
        this.errored = false;
        LayoutSegment actualSegment = new LayoutSegment(null);
        Flowchart<LayoutSegment, LayoutElement> flowchart = new Flowchart<LayoutSegment, LayoutElement>(actualSegment);
        LayoutElement lastElement = actualSegment.addSymbol(null, EnumSymbol.STARTEND.getInstance("Za\u010d\u00e1tek"));
        actualSegment.addSymbol(lastElement, EnumSymbol.STARTEND.getInstance("Konec"));
        this.generateFlowchart(this.parseCommands(code), actualSegment, (LayoutElement)actualSegment.getElement(0), false);
        if (this.errored) {
            return null;
        }
        return flowchart;
    }

    private void generateFlowchart(ArrayList<String> commands, LayoutSegment actualSegment, LayoutElement actualElement, boolean onlyOneCommand) {
        while (!commands.isEmpty() && !this.errored) {
            if (actualSegment.getParentElement() != null && commands.get(0).toLowerCase().startsWith("until") && !(actualElement.getSymbol() instanceof LoopEnd)) {
                return;
            }
            String command = commands.remove(0);
            try {
                LayoutElement actualNoCommentElement = actualElement;
                while (actualNoCommentElement.getSymbol() instanceof Comment) {
                    int index = actualSegment.indexOfElement(actualNoCommentElement);
                    if (index == 0) {
                        actualNoCommentElement = (LayoutElement)actualSegment.getParentElement();
                        continue;
                    }
                    actualNoCommentElement = (LayoutElement)actualSegment.getElement(index - 1);
                }
                if (command.matches("^\\s*[^\\'\\:\\+\\-\\*\\/ ]+ *[\\:\\+\\-\\*\\/]\\=[\\S\\s]+")) {
                    String var;
                    actualElement = actualSegment.addSymbol(actualElement, EnumSymbol.PROCESS.getInstance(""));
                    if (!(command = command.trim()).matches("^[^\\:\\+\\-\\*\\/ ]+ *[\\:]\\=[\\S\\s]+")) {
                        Matcher matcher = Pattern.compile("^[^\\+\\-\\*\\/ ]+", 10).matcher(command);
                        matcher.find();
                        var = matcher.group();
                        command = command.matches("^[^\\:\\+\\-\\*\\/ ]+ *[\\+]\\=[\\S\\s]+") ? command.replaceFirst("\\+\\=\\s*", ":=" + var + "+") : (command.matches("^[^\\:\\+\\-\\*\\/ ]+ *[\\-]\\=[\\S\\s]+") ? command.replaceFirst("\\-\\=\\s*", ":=" + var + "-") : (command.matches("^[^\\:\\+\\-\\*\\/ ]+ *[\\*]\\=[\\S\\s]+") ? command.replaceFirst("\\*\\=\\s*", ":=" + var + "*") : command.replaceFirst("\\/\\=\\s*", ":=" + var + "/")));
                    } else {
                        var = command.substring(0, command.indexOf(":=")).trim();
                    }
                    String value = command.substring(command.indexOf(":=") + 2, command.length()).trim();
                    if (!VariableFilter.isValid(var) || !ValueFilter.isValid(value)) {
                        actualElement.getSymbol().setValueAndSize(INVALID_COMMAND);
                        actualElement = FlowchartGenerator.super.addComment(actualSegment, actualElement, command, true);
                        var = "";
                    }
                    if (!var.equals("")) {
                        Process.generateValues(actualElement.getSymbol(), var, value);
                        actualElement.getSymbol().setValueAndSize(actualElement.getSymbol().getDefaultValue());
                    }
                } else if (Pattern.compile("^\\s*(read(ln)?|write(ln)?)\\s*\\([\\S\\s]+", 10).matcher(command).matches()) {
                    actualElement = actualSegment.addSymbol(actualElement, EnumSymbol.IO.getInstance(""));
                    if ((command = command.trim()).toLowerCase().startsWith("read")) {
                        String var = (command = command.trim()).substring(command.indexOf("(") + 1, command.lastIndexOf(")")).trim();
                        if (!VariableFilter.isValid(var)) {
                            actualElement.getSymbol().setValueAndSize(INVALID_COMMAND);
                            actualElement = FlowchartGenerator.super.addComment(actualSegment, actualElement, command, true);
                            command = "";
                        }
                        if (!command.equals("")) {
                            IO.generateIValues(actualElement.getSymbol(), var);
                            actualElement.getSymbol().setValueAndSize(actualElement.getSymbol().getDefaultValue());
                        }
                    } else {
                        String value = (command = command.replaceAll("\"\\s*\\,", "\"+").replaceAll("\\,\\s*\"", "+\"").trim()).substring(command.indexOf("(") + 1, command.lastIndexOf(")")).trim();
                        if (!ValueFilter.isValid(value)) {
                            actualElement.getSymbol().setValueAndSize(INVALID_COMMAND);
                            actualElement = FlowchartGenerator.super.addComment(actualSegment, actualElement, command, true);
                            command = "";
                        }
                        if (!command.equals("")) {
                            IO.generateOValues(actualElement.getSymbol(), value);
                            actualElement.getSymbol().setValueAndSize(actualElement.getSymbol().getDefaultValue());
                        }
                    }
                } else if (command.toLowerCase().startsWith("for") && command.toLowerCase().endsWith("do")) {
                    actualElement = actualSegment.addSymbol(actualElement, EnumSymbol.FOR.getInstance(""));
                    String myCommand = command.toLowerCase().replaceFirst("for\\s*", "").replaceFirst("\\s*do$", "");
                    if (myCommand.contains(":=")) {
                        String from;
                        String inc;
                        String var = myCommand.substring(0, myCommand.indexOf(":=")).trim();
                        myCommand = myCommand.substring(myCommand.indexOf(":=") + 2).trim();
                        String to = myCommand.substring(myCommand.lastIndexOf("to ") + 3).trim();
                        if ((myCommand = myCommand.substring(0, myCommand.lastIndexOf(to)).trim()).endsWith("downto")) {
                            inc = "-1";
                            from = myCommand.substring(0, myCommand.lastIndexOf("downto")).trim();
                        } else {
                            inc = "1";
                            from = myCommand.substring(0, myCommand.lastIndexOf("to")).trim();
                        }
                        if (!(NoArrayVariableFilter.isValid(var) && NumericValueFilter.isValid(from) && NumericValueFilter.isValid(to) && NumericValueFilter.isValid(inc))) {
                            actualElement.getSymbol().setValueAndSize(INVALID_COMMAND);
                            FlowchartGenerator.super.addComment(actualSegment, actualElement, command, true);
                            command = "";
                        }
                        if (!command.equals("")) {
                            cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.For.generateForValues(actualElement.getSymbol(), var, from, to, inc);
                            actualElement.getSymbol().setValueAndSize(actualElement.getSymbol().getDefaultValue());
                        }
                    } else if (myCommand.contains("in ")) {
                        String var = myCommand.substring(0, myCommand.indexOf("in ")).trim();
                        String array = myCommand.substring(myCommand.indexOf("in ") + 3).trim();
                        if (!NoArrayVariableFilter.isValid(var) || !VariableFilter.isValid(array)) {
                            actualElement.getSymbol().setValueAndSize(INVALID_COMMAND);
                            FlowchartGenerator.super.addComment(actualSegment, actualElement, command, true);
                            command = "";
                        }
                        if (!command.equals("")) {
                            cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.For.generateForeachValues(actualElement.getSymbol(), var, array);
                            actualElement.getSymbol().setValueAndSize(actualElement.getSymbol().getDefaultValue());
                        }
                    }
                    this.generateFlowchart(commands, (LayoutSegment)actualElement.getInnerSegment(1), actualElement, this.oneCommandOnly(commands));
                } else if (command.toLowerCase().equals("repeat") || command.toLowerCase().startsWith("while") && command.toLowerCase().endsWith("do")) {
                    String condition = "";
                    boolean oneCommandOnly = false;
                    if (!command.toLowerCase().equals("repeat")) {
                        oneCommandOnly = this.oneCommandOnly(commands);
                        actualElement = actualSegment.addSymbol(actualElement, EnumSymbol.LOOPCONDITIONUP.getInstance(""));
                        condition = command.toLowerCase().replaceFirst("while\\s*", "").replaceFirst("\\s*do$", "");
                        if (!BooleanValueFilter.isValid(condition)) {
                            actualElement.getSymbol().setValueAndSize(INVALID_COMMAND);
                            FlowchartGenerator.super.addComment(actualSegment, actualElement, command, true);
                            condition = "";
                        }
                    } else {
                        actualElement = actualSegment.addSymbol(actualElement, EnumSymbol.LOOPCONDITIONDOWN.getInstance(""));
                    }
                    if (!condition.equals("")) {
                        cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.LoopStart.generateValues(actualElement.getSymbol(), condition);
                        actualElement.getSymbol().setValueAndSize(actualElement.getSymbol().getDefaultValue());
                    }
                    this.generateFlowchart(commands, (LayoutSegment)actualElement.getInnerSegment(1), actualElement, oneCommandOnly);
                    actualElement = actualSegment.addSymbol(actualElement, new LoopEnd());
                } else if (command.toLowerCase().startsWith("until") && actualNoCommentElement.getSymbol() instanceof LoopEnd) {
                    Object condition = "!(" + command.toLowerCase().replaceFirst("until\\s*", "").trim() + ")";
                    if (!BooleanValueFilter.isValid((String)condition)) {
                        actualNoCommentElement.getSymbol().setValueAndSize(INVALID_COMMAND);
                        if (actualElement.equals(actualNoCommentElement)) {
                            actualElement = FlowchartGenerator.super.addComment(actualSegment, actualElement, (String)condition, true);
                        } else {
                            FlowchartGenerator.super.addComment(actualSegment, actualNoCommentElement, (String)condition, true);
                        }
                        condition = "";
                    }
                    if (!((String)condition).equals("")) {
                        cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.LoopEnd.generateValues(actualNoCommentElement.getSymbol(), (String)condition);
                        actualNoCommentElement.getSymbol().setValueAndSize(actualNoCommentElement.getSymbol().getDefaultValue());
                    }
                } else if (command.toLowerCase().startsWith("case") && command.toLowerCase().endsWith("of")) {
                    actualElement = actualSegment.addSymbol(actualElement, EnumSymbol.SWITCH.getInstance(""), 1);
                    String conditionVar = command.toLowerCase().replaceFirst("case\\s*", "").replaceFirst("\\s*of$", "");
                    if (!VariableFilter.isValid(conditionVar)) {
                        actualElement.getSymbol().setValueAndSize(INVALID_COMMAND);
                        actualElement = this.addComment(actualSegment, actualElement, command, true);
                        conditionVar = "";
                    }
                    if (!conditionVar.equals("")) {
                        cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.Switch.generateValues(actualElement, conditionVar, new String[0]);
                        actualElement.getSymbol().setValueAndSize(actualElement.getSymbol().getDefaultValue());
                    }
                } else if (command.toLowerCase().startsWith("if") && command.toLowerCase().endsWith("then")) {
                    actualElement = actualSegment.addSymbol(actualElement, EnumSymbol.DECISION.getInstance(""));
                    String condition = command.toLowerCase().replaceFirst("if\\s*", "").replaceFirst("\\s*then$", "");
                    if (!BooleanValueFilter.isValid(condition)) {
                        actualElement.getSymbol().setValueAndSize(INVALID_COMMAND);
                        FlowchartGenerator.super.addComment(actualSegment, actualElement, command, true);
                        condition = "";
                    }
                    if (!condition.equals("")) {
                        cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.Decision.generateValues(actualElement.getSymbol(), condition);
                        actualElement.getSymbol().setValueAndSize(actualElement.getSymbol().getDefaultValue());
                    }
                    if (!commands.isEmpty() && !commands.get(0).toLowerCase().equals("else")) {
                        this.generateFlowchart(commands, (LayoutSegment)actualElement.getInnerSegment(1), actualElement, this.oneCommandOnly(commands));
                    }
                } else if (this.isComment(command)) {
                    boolean paired = command.matches("[ \\t]*[^\\s][\\s\\S]+");
                    actualElement = this.addComment(actualSegment, actualElement, this.getCommentCommand(command), paired);
                } else if (Pattern.compile("^\\s*goto [\\S\\s]+", 10).matcher(command).matches() || Pattern.compile("^\\s*break[\\S\\s]*", 10).matcher(command).matches() || Pattern.compile("^\\s*continue[\\S\\s]*", 10).matcher(command).matches()) {
                    actualElement = actualSegment.addSymbol(actualElement, EnumSymbol.GOTO.getInstance(""));
                    command = command.trim();
                    switch (command.toLowerCase()) {
                        case "break": {
                            cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.Goto.generateBreakValues(actualElement.getSymbol());
                            actualElement.getSymbol().setValueAndSize(actualElement.getSymbol().getDefaultValue());
                            break;
                        }
                        case "continue": {
                            cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.Goto.generateContinueValues(actualElement.getSymbol());
                            actualElement.getSymbol().setValueAndSize(actualElement.getSymbol().getDefaultValue());
                            break;
                        }
                        default: {
                            cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.Goto.generateGotoValues(actualElement.getSymbol());
                            actualElement.getSymbol().setValueAndSize(command.substring(5));
                            break;
                        }
                    }
                } else if (command.matches("\\s*[^0-9\\W]\\w+\\s*\\:\\s*")) {
                    actualElement = actualSegment.addSymbol(actualElement, EnumSymbol.GOTOLABEL.getInstance(command.trim().replaceFirst("\\s*\\:\\s*", "")));
                } else if (command.toLowerCase().matches("exit\\s*")) {
                    actualElement = actualSegment.addSymbol(actualElement, EnumSymbol.STARTEND.getInstance("Konec"));
                } else if (command.toLowerCase().equals("else") && actualNoCommentElement.getSymbol().hasElseSegment()) {
                    this.generateFlowchart(commands, (LayoutSegment)actualNoCommentElement.getInnerSegment(0), actualNoCommentElement, this.oneCommandOnly(commands));
                } else if (!command.matches("\\s*[^0-9\\W]\\w+\\s*\\:\\s*") && command.matches("[\\s\\S]+\\:\\s*") && actualNoCommentElement.getSymbol() instanceof Switch) {
                    actualNoCommentElement.addInnerSegment(new LayoutSegment(actualNoCommentElement));
                    command = command.trim();
                    String constant = this.checkConstantForRanges(command.replaceFirst("\\s*\\:$", ""));
                    if (!actualNoCommentElement.getSymbol().getValue().equals(INVALID_COMMAND)) {
                        int i;
                        if (!ConstantFilter.isValid(constant)) {
                            actualNoCommentElement.getSymbol().setValueAndSize(INVALID_COMMAND);
                            if (actualElement.equals(actualNoCommentElement)) {
                                actualElement = FlowchartGenerator.super.addComment(actualSegment, actualElement, command, true);
                            } else {
                                FlowchartGenerator.super.addComment(actualSegment, actualNoCommentElement, command, true);
                            }
                            constant = "";
                        }
                        String[] segmentConstants = new String[actualNoCommentElement.getInnerSegmentsCount() - 1];
                        for (i = 0; i < segmentConstants.length - 1; ++i) {
                            segmentConstants[i] = ((LayoutSegment)actualNoCommentElement.getInnerSegment(i + 1)).getDefaultDescription();
                            if (segmentConstants[i].equals("")) break;
                        }
                        segmentConstants[segmentConstants.length - 1] = constant;
                        cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.Switch.generateValues(actualNoCommentElement, actualNoCommentElement.getSymbol().getCommands().get("conditionVar"), segmentConstants);
                        if (!constant.equals("")) {
                            LayoutSegment lastInnerSegment = (LayoutSegment)actualNoCommentElement.getInnerSegment(actualNoCommentElement.getInnerSegmentsCount() - 1);
                            lastInnerSegment.setDescription(lastInnerSegment.getDefaultDescription());
                        } else {
                            for (i = 0; i < segmentConstants.length - 1; ++i) {
                                ((LayoutSegment)actualNoCommentElement.getInnerSegment(i + 1)).setDescription(null);
                            }
                        }
                    }
                    this.generateFlowchart(commands, (LayoutSegment)actualNoCommentElement.getInnerSegment(actualNoCommentElement.getInnerSegmentsCount() - 1), actualNoCommentElement, this.oneCommandOnly(commands));
                } else if (command.toLowerCase().matches("end\\s*") && actualSegment.getParentElement() != null) {
                    if (!(actualNoCommentElement.getSymbol() instanceof Switch) || ((LayoutElement)actualSegment.getParentElement()).equals(actualNoCommentElement) || onlyOneCommand) {
                        return;
                    }
                    if (!commands.isEmpty()) {
                        for (int i = 0; i < commands.size(); ++i) {
                            if (!this.isComment(commands.get(i))) {
                                if (commands.get(i).toLowerCase().matches("end\\s*")) {
                                    commands.remove(i);
                                    return;
                                }
                                break;
                            }
                            actualElement = FlowchartGenerator.super.addComment(actualSegment, actualElement, this.getCommentCommand(commands.get(i)), commands.get(i).matches("[ \\t]*[^\\s][\\s\\S]+"));
                            commands.remove(i);
                            --i;
                        }
                    }
                } else if (!command.toLowerCase().equals("begin") && !command.toLowerCase().matches("end\\s*")) {
                    actualElement = actualSegment.addSymbol(actualElement, EnumSymbol.SUBROUTINE.getInstance(command.trim()));
                }
                if (!onlyOneCommand || actualElement.getSymbol() instanceof LoopEnd && !commands.isEmpty() && commands.get(0).startsWith("until") || actualElement.getSymbol() instanceof Decision && !(actualElement.getSymbol() instanceof Switch) && !commands.isEmpty() && commands.get(0).equals("else") || this.isComment(command) && ((LayoutElement)actualSegment.getParentElement()).equals(actualNoCommentElement) || !commands.isEmpty() && this.isComment(commands.get(0)) || actualElement.getSymbol() instanceof Switch || actualNoCommentElement.getSymbol() instanceof Switch && !((LayoutElement)actualSegment.getParentElement()).equals(actualNoCommentElement)) continue;
                return;
            }
            catch (Exception e) {
                if (this.errored) continue;
                MyJOptionPane.showMessageDialog(null, "<html>Diagram se nepoda\u0159ilo vytvo\u0159it!<br />Probl\u00e9mov\u00fd prvek:<br />" + command + "</html>", "Chyba p\u0159i generov\u00e1n\u00ed diagramu", 0);
                this.errored = true;
            }
        }
    }

    private boolean isComment(String command) {
        return command.matches("^\\s*\\{[\\S\\s]+") || command.matches("^\\s*\\(\\*[\\S\\s]+") || command.matches("^\\s*\\/\\/[\\S\\s]+");
    }

    private String getCommentCommand(String command) {
        if ((command = command.trim()).startsWith("{")) {
            return command.substring(1, command.length() - 1);
        }
        if (command.startsWith("(*")) {
            return command.substring(2, command.length() - 2);
        }
        if (command.startsWith("//")) {
            return command.substring(2, command.length());
        }
        return null;
    }

    private boolean oneCommandOnly(ArrayList<String> commands) {
        for (int i = 0; i < commands.size(); ++i) {
            String command = commands.get(i);
            if (this.isComment(command)) continue;
            if (command.toLowerCase().equals("begin")) {
                commands.remove(i);
                return false;
            }
            return true;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private String checkConstantForRanges(String constant) {
        String[] split = constant.split(",");
        Object retConst = "";
        for (String string : split) {
            void var7_7;
            int i;
            int h;
            int second;
            int first;
            String string2 = string.trim();
            if (string2.matches("^[0-9]+\\.\\.[0-9]+$")) {
                void var7_11;
                first = Integer.valueOf(string2.substring(0, string2.indexOf(".")));
                if (first > (second = Integer.valueOf(string2.substring(string2.indexOf(".") + 2, string2.length())).intValue())) {
                    h = first;
                    first = second;
                    second = h;
                }
                String string3 = "";
                for (i = first; i <= second; ++i) {
                    String string4 = (String)var7_11 + "," + i;
                }
                String string5 = var7_11.substring(1);
            } else if (string2.matches("^\"[a-z]\"\\.\\.\"[a-z]\"$") || string2.matches("^\"[A-Z]\"\\.\\.\"[A-Z]\"$") || string2.matches("^\"[0-9]\"\\.\\.\"[0-9]\"$")) {
                void var7_15;
                first = string2.charAt(string2.indexOf(".") - 2);
                if (first > (second = string2.charAt(string2.indexOf(".") + 3))) {
                    h = first;
                    first = second;
                    second = h;
                }
                String string6 = "";
                for (i = first; i <= second; i = (int)((char)(i + 1))) {
                    String string7 = (String)var7_15 + ",\"" + Character.toString((char)i) + "\"";
                }
                String string8 = var7_15.substring(1);
            }
            retConst = (String)retConst + "," + (String)var7_7;
        }
        return ((String)retConst).substring(1);
    }

    private String checkForMultidimArray(String sourceCode) {
        ArrayDeque<Boolean> method = new ArrayDeque<Boolean>();
        int noMethodBracket = 0;
        block14: for (int i = 1; i <= ((String)sourceCode).length(); ++i) {
            switch (((String)sourceCode).substring(i - 1, i)) {
                case "(": {
                    if (i > 1 && ((String)sourceCode).substring(i - 2, i - 1).matches("\\w|\\$")) {
                        method.add(true);
                        continue block14;
                    }
                    ++noMethodBracket;
                    continue block14;
                }
                case ")": {
                    if (noMethodBracket > 0) {
                        --noMethodBracket;
                        continue block14;
                    }
                    method.pollLast();
                    continue block14;
                }
                case "[": {
                    method.add(false);
                    continue block14;
                }
                case "]": {
                    method.pollLast();
                    continue block14;
                }
                case ",": {
                    if (method.isEmpty() || ((Boolean)method.peekLast()).booleanValue()) continue block14;
                    sourceCode = ((String)sourceCode).substring(0, i - 1) + "][" + ((String)sourceCode).substring(i, ((String)sourceCode).length());
                    ++i;
                }
            }
        }
        return sourceCode;
    }

    private ArrayList<String> parseCommands(String code) {
        int i;
        ArrayDeque<String> quotes = new ArrayDeque<String>();
        ArrayDeque<String> comments = new ArrayDeque<String>();
        code = this.parseQuotes(code, quotes);
        code = this.parseComments(code, comments);
        code = code.replaceAll("\\t", " ");
        code = code.replaceAll(" {2,}", " ");
        code = code.toLowerCase();
        code = Pattern.compile("(?<![\\w])mod(?![\\w])", 10).matcher(code).replaceAll("%");
        code = Pattern.compile("(?<![\\w])div(?![\\w])", 10).matcher(code).replaceAll("//");
        code = Pattern.compile("(?<![\\w])not\\s+", 10).matcher(code).replaceAll("!");
        code = code.replaceAll("\\<\\>", "!=");
        code = Pattern.compile("(?<![\\w])and(?![\\w])", 10).matcher(code).replaceAll("&&");
        code = Pattern.compile("(?<![\\w])or(?![\\w])", 10).matcher(code).replaceAll("||");
        code = this.checkForMultidimArray(code);
        ArrayList<String> commands = new ArrayList<String>();
        Matcher matcher = Pattern.compile("(?<![\\w])repeat(?![\\w])|(?<![\\w])begin(?![\\w])|(?<![\\w])else(?![\\w])|\\s*--koment\u00e1\u0159--", 10).matcher(code);
        int lastEndIndex = 0;
        if (matcher.find()) {
            do {
                commands.add(code.substring(lastEndIndex, matcher.start()));
                lastEndIndex = matcher.end();
                commands.add(code.substring(matcher.start(), lastEndIndex));
            } while (matcher.find());
            if (lastEndIndex < code.length()) {
                commands.add(code.substring(lastEndIndex, code.length()));
            }
        } else {
            commands.add(code);
        }
        String[] split = commands.toArray(new String[0]);
        commands.clear();
        for (i = 0; i < split.length; ++i) {
            matcher = Pattern.compile("(?<![\\w])if(?![\\w])|(?<![\\w])end(?![\\w])|(?<![\\w])case(?![\\w])|(?<![\\w])for(?![\\w])|(?<![\\w])while(?![\\w])|(?<![\\w])until(?![\\w])|(?<![\\w])exit(?![\\w])", 10).matcher(split[i]);
            lastEndIndex = 0;
            if (matcher.find()) {
                do {
                    commands.add(split[i].substring(lastEndIndex, matcher.start()));
                    lastEndIndex = matcher.start();
                } while (matcher.find());
                if (lastEndIndex >= split[i].length()) continue;
                commands.add(split[i].substring(lastEndIndex, split[i].length()));
                continue;
            }
            commands.add(split[i]);
        }
        split = commands.toArray(new String[0]);
        commands.clear();
        for (i = 0; i < split.length; ++i) {
            matcher = Pattern.compile("\\;|(?<![\\w])then(?![\\w])|(?<![\\w])of(?![\\w])|(?<![\\w])do(?![\\w])|\\:(?![\\=0-9])", 10).matcher(split[i]);
            lastEndIndex = 0;
            if (matcher.find()) {
                do {
                    if (matcher.group().equals(";")) {
                        commands.add(split[i].substring(lastEndIndex, matcher.end() - 1));
                    } else {
                        commands.add(split[i].substring(lastEndIndex, matcher.end()));
                    }
                    lastEndIndex = matcher.end();
                } while (matcher.find());
                if (lastEndIndex >= split[i].length()) continue;
                commands.add(split[i].substring(lastEndIndex, split[i].length()));
                continue;
            }
            commands.add(split[i]);
        }
        for (i = 0; i < commands.size(); ++i) {
            matcher = Pattern.compile(COMMENT_MARKER, 10).matcher((CharSequence)commands.get(i));
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, comments.poll());
            }
            matcher.appendTail(sb);
            commands.set(i, sb.toString());
        }
        for (i = 0; i < commands.size(); ++i) {
            String cmd = commands.get(i);
            if (cmd.matches("\\s*")) {
                commands.remove(i);
                --i;
                continue;
            }
            matcher = Pattern.compile("\\'\\'", 10).matcher(cmd);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, quotes.poll());
            }
            matcher.appendTail(sb);
            commands.set(i, sb.toString());
        }
        return commands;
    }

    private String parseQuotes(String code, ArrayDeque<String> arrayToSaveQuotes) {
        boolean lineStart = false;
        boolean bracketStarStart = false;
        boolean bracketStarEnd = false;
        boolean lineC = false;
        int bracketStarC = 0;
        int bracketC = 0;
        boolean quoteEnabled = false;
        boolean escapedQuoteAhead = false;
        Object newCode = "";
        int lastEndIndex = 0;
        block18: for (int i = 1; i <= code.length(); ++i) {
            if (quoteEnabled && !code.substring(i - 1, i).equals("'")) continue;
            switch (code.substring(i - 1, i)) {
                case "'": {
                    if (lineC || bracketStarC != 0 || bracketC != 0) continue block18;
                    if (quoteEnabled) {
                        if (!escapedQuoteAhead) {
                            if (i + 1 <= code.length() && code.substring(i, i + 1).equals("'")) {
                                escapedQuoteAhead = true;
                                continue block18;
                            }
                        } else {
                            escapedQuoteAhead = false;
                            continue block18;
                        }
                        quoteEnabled = false;
                        String stringInsides = code.substring(lastEndIndex, i - 1);
                        stringInsides = stringInsides.replaceAll("\"", "\\\\\\\\\\\"");
                        stringInsides = stringInsides.replaceAll("''", "'");
                        arrayToSaveQuotes.add("\"" + stringInsides + "\"");
                        lastEndIndex = i - 1;
                    } else {
                        quoteEnabled = true;
                        newCode = (String)newCode + code.substring(lastEndIndex, i);
                        lastEndIndex = i;
                    }
                    lineStart = false;
                    bracketStarStart = false;
                    bracketStarEnd = false;
                    continue block18;
                }
                case "/": {
                    if (lineStart) {
                        lineStart = false;
                        lineC = true;
                    } else if (bracketStarC == 0 && bracketC == 0 && !lineC) {
                        lineStart = true;
                    }
                    bracketStarStart = false;
                    bracketStarEnd = false;
                    continue block18;
                }
                case "(": {
                    if (!lineC && bracketC == 0) {
                        bracketStarStart = true;
                    }
                    lineStart = false;
                    bracketStarEnd = false;
                    continue block18;
                }
                case "*": {
                    if (bracketStarC > 0 && !bracketStarStart) {
                        bracketStarEnd = true;
                    } else if (bracketStarStart && bracketC == 0 && !lineC) {
                        ++bracketStarC;
                    }
                    lineStart = false;
                    bracketStarStart = false;
                    continue block18;
                }
                case ")": {
                    if (bracketStarEnd && bracketStarC > 0) {
                        --bracketStarC;
                    }
                    lineStart = false;
                    bracketStarStart = false;
                    bracketStarEnd = false;
                    continue block18;
                }
                case "{": {
                    if (!lineC && bracketStarC == 0) {
                        ++bracketC;
                    }
                    lineStart = false;
                    bracketStarStart = false;
                    bracketStarEnd = false;
                    continue block18;
                }
                case "}": {
                    if (bracketC > 0) {
                        --bracketC;
                    }
                    lineStart = false;
                    bracketStarStart = false;
                    bracketStarEnd = false;
                    continue block18;
                }
                default: {
                    if (lineC && (code.substring(i - 1, i).matches("\\n") || code.substring(i - 1, i).matches("\\r"))) {
                        lineC = false;
                    }
                    lineStart = false;
                    bracketStarStart = false;
                    bracketStarEnd = false;
                }
            }
        }
        if (lastEndIndex < code.length()) {
            newCode = (String)newCode + code.substring(lastEndIndex, code.length());
        }
        return newCode;
    }

    private String parseComments(String code, ArrayDeque<String> arrayToSaveComments) {
        boolean lineStart = false;
        boolean bracketStarStart = false;
        boolean bracketStarEnd = false;
        boolean lineC = false;
        int bracketStarC = 0;
        int bracketC = 0;
        Object newCode = "";
        int lastEndIndex = 0;
        block16: for (int i = 1; i <= code.length(); ++i) {
            switch (code.substring(i - 1, i)) {
                case "/": {
                    if (lineStart) {
                        lineStart = false;
                        lineC = true;
                        newCode = (String)newCode + code.substring(lastEndIndex, i - 2) + COMMENT_MARKER;
                        lastEndIndex = i - 2;
                    } else if (bracketStarC == 0 && bracketC == 0 && !lineC) {
                        lineStart = true;
                    }
                    bracketStarStart = false;
                    bracketStarEnd = false;
                    continue block16;
                }
                case "(": {
                    if (!lineC && bracketC == 0) {
                        bracketStarStart = true;
                    }
                    lineStart = false;
                    bracketStarEnd = false;
                    continue block16;
                }
                case "*": {
                    if (bracketStarC > 0 && !bracketStarStart) {
                        bracketStarEnd = true;
                    } else if (bracketStarStart && bracketC == 0 && !lineC) {
                        if (bracketStarC == 0) {
                            newCode = (String)newCode + code.substring(lastEndIndex, i - 2) + COMMENT_MARKER;
                            lastEndIndex = i - 2;
                        }
                        ++bracketStarC;
                    }
                    lineStart = false;
                    bracketStarStart = false;
                    continue block16;
                }
                case ")": {
                    if (bracketStarEnd && bracketStarC > 0 && --bracketStarC == 0) {
                        arrayToSaveComments.add(code.substring(lastEndIndex, i).replaceAll("\\$", "\\\\\\$"));
                        lastEndIndex = i;
                    }
                    lineStart = false;
                    bracketStarStart = false;
                    bracketStarEnd = false;
                    continue block16;
                }
                case "{": {
                    if (!lineC && bracketStarC == 0) {
                        if (bracketC == 0) {
                            newCode = (String)newCode + code.substring(lastEndIndex, i - 1) + COMMENT_MARKER;
                            lastEndIndex = i - 1;
                        }
                        ++bracketC;
                    }
                    lineStart = false;
                    bracketStarStart = false;
                    bracketStarEnd = false;
                    continue block16;
                }
                case "}": {
                    if (bracketC > 0 && --bracketC == 0) {
                        arrayToSaveComments.add(code.substring(lastEndIndex, i).replaceAll("\\$", "\\\\\\$"));
                        lastEndIndex = i;
                    }
                    lineStart = false;
                    bracketStarStart = false;
                    bracketStarEnd = false;
                    continue block16;
                }
                default: {
                    if (lineC && (code.substring(i - 1, i).matches("\\n") || code.substring(i - 1, i).matches("\\r"))) {
                        arrayToSaveComments.add(code.substring(lastEndIndex, i - 1).replaceAll("\\$", "\\\\\\$"));
                        lineC = false;
                        lastEndIndex = i - 1;
                    }
                    lineStart = false;
                    bracketStarStart = false;
                    bracketStarEnd = false;
                }
            }
        }
        if (lastEndIndex < code.length()) {
            newCode = (String)newCode + code.substring(lastEndIndex);
        }
        return newCode;
    }

    public static String getSourceCode(Flowchart<LayoutSegment, LayoutElement> flowchart, String name) {
        Pascal instance = new Pascal();
        return instance.generateSourceCode(flowchart, name);
    }

    private String generateSourceCode(Flowchart<LayoutSegment, LayoutElement> flowchart, String name) {
        this.errored = false;
        this.missingCommandWarning = false;
        Object sourceCode = "program " + this.normalizeAsVariable(name) + ";" + LINE_SEP + LINE_SEP;
        TreeSet<String> vars = new TreeSet<String>();
        TreeSet<String> arrayVars = new TreeSet<String>();
        this.findAndSetVariables(flowchart, vars, arrayVars);
        sourceCode = this.addVariableDeclarations((String)sourceCode, vars, arrayVars);
        sourceCode = (String)sourceCode + this.generateSourceCode(flowchart.getMainSegment(), "");
        if (this.errored) {
            sourceCode = null;
        } else if (this.missingCommandWarning) {
            MyJOptionPane.showMessageDialog(null, "<html>Zdrojov\u00fd k\u00f3d byl vygenerov\u00e1n s n\u00e1sleduj\u00edc\u00edm upozorn\u011bn\u00edm:<br />N\u011bkter\u00fd symbol nem\u00e1 vypln\u011bnu svou funkci!</html>", "Nevypln\u011bn\u00e1 funkce symbolu", 2);
        }
        return sourceCode;
    }

    private String addVariableDeclarations(String sourceCode, Set<String> vars, Set<String> arrayVars) {
        if (!vars.isEmpty() || !arrayVars.isEmpty()) {
            sourceCode = (String)sourceCode + "var // zde je nutne doplnit typy promennych (diagramy jsou netypove)";
            if (!vars.isEmpty()) {
                sourceCode = (String)sourceCode + LINE_SEP + "\t";
                for (String variable : vars) {
                    sourceCode = (String)sourceCode + variable + ",";
                }
                sourceCode = ((String)sourceCode).substring(0, ((String)sourceCode).length() - 1) + ": {typ_promenne};";
            }
            if (!arrayVars.isEmpty()) {
                sourceCode = (String)sourceCode + LINE_SEP + "\t";
                for (String arrayVar : arrayVars) {
                    sourceCode = (String)sourceCode + arrayVar + ": array[{x}..{y}] of {typ_promenne};" + LINE_SEP + "\t";
                }
                sourceCode = ((String)sourceCode).substring(0, ((String)sourceCode).length() - (LINE_SEP + "\t").length());
            }
            sourceCode = (String)sourceCode + LINE_SEP;
        }
        return sourceCode;
    }

    private void findAndSetVariables(Flowchart<LayoutSegment, LayoutElement> flowchart, Set<String> vars, Set<String> arrayVars) {
        for (LayoutSegment segment : flowchart) {
            if (segment == null) continue;
            for (FlowchartElement element : segment) {
                Symbol symbol = element.getSymbol();
                if (symbol.getCommands() == null) continue;
                if (symbol instanceof cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Process || symbol instanceof cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.IO && symbol.getCommands().containsKey("var")) {
                    if (symbol.getCommands().get("var").contains("[")) {
                        String var = symbol.getCommands().get("var");
                        arrayVars.add(var.substring(0, var.indexOf("[")));
                        continue;
                    }
                    if (symbol.getCommands().containsKey("value") && symbol.getCommands().get("value").startsWith("[")) {
                        arrayVars.add(symbol.getCommands().get("var"));
                        continue;
                    }
                    vars.add(symbol.getCommands().get("var"));
                    continue;
                }
                if (!(symbol instanceof For)) continue;
                vars.add(symbol.getCommands().get("var"));
                if (!symbol.getCommands().containsKey("array")) continue;
                arrayVars.add(symbol.getCommands().get("array"));
            }
        }
    }

    private String generateSourceCode(LayoutSegment segment, String tabsDepth) {
        String pairedCommentText = null;
        boolean lastWasPairedComment = false;
        Object sourceCode = "";
        int index = -1;
        for (LayoutElement element : segment) {
            ++index;
            Symbol symbol = element.getSymbol();
            try {
                boolean isElseIf = this.isElseIf(segment);
                if (!isElseIf) {
                    sourceCode = (String)sourceCode + LINE_SEP + tabsDepth;
                }
                if (symbol instanceof cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Process) {
                    if (symbol.getCommands() != null) {
                        sourceCode = (String)sourceCode + this.convertCodeToPascal(symbol.getCommands().get("var") + " := " + symbol.getCommands().get("value") + this.maybeInsSemicolon(segment, index));
                    } else {
                        sourceCode = (String)sourceCode + "{symbol Zpracov\u00e1n\u00ed bez vyplnene funkce!}";
                        this.missingCommandWarning = true;
                    }
                } else if (symbol instanceof cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.IO) {
                    if (symbol.getCommands() != null) {
                        sourceCode = symbol.getCommands().containsKey("var") ? (String)sourceCode + this.convertCodeToPascal("readln(" + symbol.getCommands().get("var") + ")" + this.maybeInsSemicolon(segment, index)) : (String)sourceCode + this.convertCodeToPascal("writeln(" + symbol.getCommands().get("value").replaceAll("\"\\s*\\+", "\",").replaceAll("\\+\\s*\"", ",\"") + ")" + this.maybeInsSemicolon(segment, index));
                    } else {
                        sourceCode = (String)sourceCode + "{symbol Vstup/Vystup bez vyplnene funkce!}";
                        this.missingCommandWarning = true;
                    }
                } else if (symbol instanceof Switch) {
                    if (symbol.getCommands() != null) {
                        sourceCode = (String)sourceCode + this.convertCodeToPascal("case " + symbol.getCommands().get("conditionVar") + " of");
                    } else {
                        sourceCode = (String)sourceCode + "case {nevyplnena funkce!} of";
                        this.missingCommandWarning = true;
                    }
                    if (pairedCommentText != null) {
                        sourceCode = (String)sourceCode + pairedCommentText;
                        pairedCommentText = null;
                    }
                    for (int i = 1; i < element.getInnerSegmentsCount(); ++i) {
                        sourceCode = symbol.getCommands() != null ? (String)sourceCode + LINE_SEP + tabsDepth + "\t" + this.convertCodeToPascal(symbol.getCommands().get(String.valueOf(i)) + ":") : (String)sourceCode + LINE_SEP + tabsDepth + "\t{nevyplnena funkce vetve Switch symbolu!}:";
                        sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "\tbegin";
                        sourceCode = (String)sourceCode + this.generateSourceCode((LayoutSegment)element.getInnerSegment(i), tabsDepth + "\t\t");
                        sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "\tend";
                    }
                    if (this.containsFunctionalSymbols((LayoutSegment)element.getInnerSegment(0), -1)) {
                        sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "\telse";
                        sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "\tbegin";
                        sourceCode = (String)sourceCode + this.generateSourceCode((LayoutSegment)element.getInnerSegment(0), tabsDepth + "\t\t");
                        sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "\tend";
                    }
                    sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "end" + this.maybeInsSemicolon(segment, index);
                } else if (symbol instanceof Decision) {
                    if (symbol.getCommands() != null) {
                        sourceCode = (String)sourceCode + this.convertCodeToPascal("if " + symbol.getCommands().get("condition") + " then");
                    } else {
                        sourceCode = (String)sourceCode + "if {nevyplnena funkce!} then";
                        this.missingCommandWarning = true;
                    }
                    if (pairedCommentText != null) {
                        sourceCode = (String)sourceCode + pairedCommentText;
                        pairedCommentText = null;
                    }
                    sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "begin";
                    sourceCode = (String)sourceCode + this.generateSourceCode((LayoutSegment)element.getInnerSegment(1), tabsDepth + "\t");
                    sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "end";
                    if (this.containsFunctionalSymbols((LayoutSegment)element.getInnerSegment(0), -1)) {
                        sourceCode = (String)sourceCode + " else";
                        if (this.isElseIf((LayoutSegment)element.getInnerSegment(0))) {
                            sourceCode = (String)sourceCode + " " + this.generateSourceCode((LayoutSegment)element.getInnerSegment(0), tabsDepth);
                        } else {
                            sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "begin";
                            sourceCode = (String)sourceCode + this.generateSourceCode((LayoutSegment)element.getInnerSegment(0), tabsDepth + "\t");
                            sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "end";
                        }
                    }
                    sourceCode = (String)sourceCode + this.maybeInsSemicolon(segment, index);
                } else if (symbol instanceof For) {
                    if (symbol.getCommands() != null) {
                        if (symbol.getCommands().containsKey("inc")) {
                            int increment = Integer.parseInt(symbol.getCommands().get("inc"));
                            if (increment != 1 && increment != -1) {
                                MyJOptionPane.showMessageDialog(null, "<html>Zdrojov\u00fd k\u00f3d nelze vytvo\u0159it, proto\u017ee programovac\u00ed jazyk Pascal<br />nepodporuje u For cyklu jin\u00fd inkrement ne\u017e 1 nebo -1!</html>", "Chyba p\u0159i generov\u00e1n\u00ed zdrojov\u00e9ho k\u00f3du", 0);
                                this.errored = true;
                            }
                            sourceCode = increment == 1 ? (String)sourceCode + this.convertCodeToPascal("for " + symbol.getCommands().get("var") + " := " + symbol.getCommands().get("from") + " to " + symbol.getCommands().get("to") + " do") : (String)sourceCode + this.convertCodeToPascal("for " + symbol.getCommands().get("var") + " := " + symbol.getCommands().get("from") + " downto " + symbol.getCommands().get("to") + " do");
                        } else {
                            sourceCode = (String)sourceCode + this.convertCodeToPascal("for " + symbol.getCommands().get("var") + " in " + symbol.getCommands().get("array") + " do");
                        }
                    } else {
                        sourceCode = (String)sourceCode + "for {nevyplnena funkce!} do";
                        this.missingCommandWarning = true;
                    }
                    if (pairedCommentText != null) {
                        sourceCode = (String)sourceCode + pairedCommentText;
                        pairedCommentText = null;
                    }
                    sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "begin";
                    sourceCode = (String)sourceCode + this.generateSourceCode((LayoutSegment)element.getInnerSegment(1), tabsDepth + "\t");
                    sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "end" + this.maybeInsSemicolon(segment, index);
                } else if (symbol instanceof LoopStart) {
                    if (symbol.isOverHang()) {
                        if (symbol.getCommands() != null) {
                            sourceCode = (String)sourceCode + this.convertCodeToPascal("while " + symbol.getCommands().get("condition") + " do");
                        } else {
                            sourceCode = (String)sourceCode + "while {nevyplnena funkce!} do";
                            this.missingCommandWarning = true;
                        }
                        if (pairedCommentText != null) {
                            sourceCode = (String)sourceCode + (String)pairedCommentText;
                            pairedCommentText = null;
                        }
                        sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "begin";
                        sourceCode = (String)sourceCode + this.generateSourceCode((LayoutSegment)element.getInnerSegment(1), tabsDepth + "\t");
                        sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + "end" + this.maybeInsSemicolon(segment, index);
                    } else {
                        String condition = null;
                        for (int i = index + 1; i < segment.size(); ++i) {
                            if (!(((LayoutElement)segment.getElement(i)).getSymbol() instanceof LoopEnd)) continue;
                            if (((LayoutElement)segment.getElement(i)).getSymbol().getCommands() != null) {
                                condition = ((LayoutElement)segment.getElement(i)).getSymbol().getCommands().get("condition");
                                break;
                            }
                            condition = "{nevyplnena funkce!}";
                            this.missingCommandWarning = true;
                            break;
                        }
                        if (condition != null) {
                            sourceCode = (String)sourceCode + "repeat";
                            if (pairedCommentText != null) {
                                sourceCode = (String)sourceCode + (String)pairedCommentText;
                                pairedCommentText = null;
                            }
                            sourceCode = (String)sourceCode + this.generateSourceCode((LayoutSegment)element.getInnerSegment(1), tabsDepth + "\t");
                            sourceCode = (String)sourceCode + LINE_SEP + tabsDepth + this.convertCodeToPascal("until " + this.getNegatedCondition(condition) + this.maybeInsSemicolon(segment, index));
                        }
                    }
                } else if (symbol instanceof Comment) {
                    if (symbol.hasPairSymbol()) {
                        pairedCommentText = " " + this.getSourceCommentText(symbol.getValue(), tabsDepth);
                        lastWasPairedComment = true;
                        if (!isElseIf) {
                            sourceCode = this.removeLastNewLine(tabsDepth, (String)sourceCode);
                        }
                    } else {
                        sourceCode = (String)sourceCode + this.getSourceCommentText(symbol.getValue(), tabsDepth);
                    }
                } else if (symbol instanceof Goto) {
                    if (symbol.getCommands() != null) {
                        switch (symbol.getCommands().get("mode")) {
                            case "break": {
                                sourceCode = (String)sourceCode + "break" + this.maybeInsSemicolon(segment, index);
                                break;
                            }
                            case "continue": {
                                sourceCode = (String)sourceCode + "continue" + this.maybeInsSemicolon(segment, index);
                                break;
                            }
                            case "goto": {
                                if (symbol.getValue() != null && !symbol.getValue().isEmpty()) {
                                    sourceCode = (String)sourceCode + "goto " + symbol.getValue() + this.maybeInsSemicolon(segment, index);
                                    break;
                                }
                                sourceCode = (String)sourceCode + "goto {nevyplnena funkce!}" + this.maybeInsSemicolon(segment, index);
                                this.missingCommandWarning = true;
                            }
                        }
                    } else {
                        sourceCode = (String)sourceCode + "{symbol Spojka-break/continue/goto bez vyplnene funkce!}";
                        this.missingCommandWarning = true;
                    }
                } else if (symbol instanceof GotoLabel) {
                    if (symbol.getValue() != null && !symbol.getValue().isEmpty()) {
                        sourceCode = (String)sourceCode + symbol.getValue() + ":";
                    } else {
                        sourceCode = (String)sourceCode + "{symbol Spojka-navesti bez vyplnene funkce!}:";
                        this.missingCommandWarning = true;
                    }
                } else if (symbol instanceof SubRoutine) {
                    if (symbol.getValue() != null && !symbol.getValue().isEmpty()) {
                        sourceCode = (String)sourceCode + this.convertCodeToPascal(symbol.getValue()) + this.maybeInsSemicolon(segment, index);
                    } else {
                        sourceCode = (String)sourceCode + "{symbol P\u0159eddefinovan\u00e9 zpracov\u00e1n\u00ed bez vyplnene funkce!}";
                        this.missingCommandWarning = true;
                    }
                } else if (symbol instanceof StartEnd) {
                    if (segment.getParentElement() == null && (index == 0 || index == 1 && ((LayoutElement)segment.getElement(0)).getSymbol() instanceof Comment)) {
                        sourceCode = (String)sourceCode + "begin";
                        tabsDepth = "\t";
                    } else {
                        sourceCode = segment.getParentElement() == null && index == segment.size() - 1 ? ((String)sourceCode).substring(0, ((String)sourceCode).length() - tabsDepth.length()) + "end." : (String)sourceCode + "exit" + this.maybeInsSemicolon(segment, index);
                    }
                } else {
                    sourceCode = this.removeLastNewLine(tabsDepth, (String)sourceCode);
                }
                if (pairedCommentText != null) {
                    if (!lastWasPairedComment) {
                        sourceCode = (String)sourceCode + pairedCommentText;
                        pairedCommentText = null;
                    } else {
                        lastWasPairedComment = false;
                    }
                }
            }
            catch (HeadlessException | NumberFormatException e) {
                MyJOptionPane.showMessageDialog(null, "<html>Zdrojov\u00fd k\u00f3d se nepoda\u0159ilo vytvo\u0159it!<br />probl\u00e9mov\u00fd symbol vlastn\u00ed popisek: \"" + symbol.getValue() + "\".</html>", "Chyba p\u0159i generov\u00e1n\u00ed zdrojov\u00e9ho k\u00f3du", 0);
                this.errored = true;
            }
            if (!this.errored) continue;
            break;
        }
        return sourceCode;
    }

    private String removeLastNewLine(String tabsDepth, String sourceCode) {
        return sourceCode.replaceFirst("\\s*$", "");
    }

    private boolean isElseIf(LayoutSegment segment) {
        return segment.getParentElement() != null && this.isDecisionAndNotSwitch((LayoutElement)segment.getParentElement()) && ((LayoutElement)segment.getParentElement()).indexOfInnerSegment(segment) == 0 && (segment.size() == 1 && this.isDecisionAndNotSwitch((LayoutElement)segment.getElement(0)) || segment.size() == 2 && this.isPairedComment((LayoutElement)segment.getElement(0)) && this.isDecisionAndNotSwitch((LayoutElement)segment.getElement(1)));
    }

    private boolean isDecisionAndNotSwitch(LayoutElement element) {
        return element.getSymbol() instanceof Decision && !(element.getSymbol() instanceof Switch);
    }

    private boolean isPairedComment(LayoutElement element) {
        return element.getSymbol() instanceof Comment && element.getSymbol().hasPairSymbol();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getNegatedCondition(String condition) {
        if (!(condition = condition.trim()).startsWith("!")) return "!(" + condition + ")";
        if (!condition.startsWith("!(")) {
            if (condition.contains(" ")) return "!(" + condition + ")";
            return condition.substring(1);
        } else {
            int brackets = 1;
            int i = 3;
            while (i <= condition.length()) {
                switch (condition.substring(i - 1, i)) {
                    case "(": {
                        ++brackets;
                        break;
                    }
                    case ")": {
                        if (--brackets != 0) break;
                        if (i != condition.length()) return "!(" + condition + ")";
                        return condition.substring(2, condition.length() - 1);
                    }
                }
                ++i;
            }
        }
        return "!(" + condition + ")";
    }

    private String maybeInsSemicolon(LayoutSegment segment, int actualElementIndex) {
        if (this.containsFunctionalSymbols(segment, actualElementIndex)) {
            return ";";
        }
        return "";
    }

    private boolean containsFunctionalSymbols(LayoutSegment segment, int actualElementIndex) {
        for (int i = actualElementIndex + 1; i < segment.size(); ++i) {
            Symbol symbol = ((LayoutElement)segment.getElement(i)).getSymbol();
            if (!(symbol instanceof cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Process) && !(symbol instanceof cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.IO) && !(symbol instanceof Decision) && !(symbol instanceof For) && !(symbol instanceof LoopStart) && !(symbol instanceof Comment) && !(symbol instanceof SubRoutine) && !(symbol instanceof Goto) && !(symbol instanceof GotoLabel) && (!(symbol instanceof StartEnd) || segment.getParentElement() == null && i >= segment.size() - 1)) continue;
            return true;
        }
        return false;
    }

    private String getSourceCommentText(String commentText, String tabsDepth) {
        if ((commentText = commentText.replaceAll("\r?\n", LINE_SEP + tabsDepth + "\t")).contains("\n") || commentText.contains("\r")) {
            return "{" + commentText + "}";
        }
        return "//" + commentText;
    }

    private String convertCodeToPascal(String code) {
        code = code.replaceAll("\\]\\[", ",");
        code = code.replaceAll("\\\\?\\'", "''").replaceAll("(?<!\\\\)\"", "'").replaceAll("\\\\\"", "\"");
        code = code.replaceAll("\\!\\=", "<>");
        code = code.replaceAll("\\s*\\!\\s*", " not ");
        code = code.replaceAll("\\s*\\%\\s*", " mod ");
        code = code.replaceAll("\\s*\\/\\/\\s*", " div ");
        code = code.replaceAll("\\s*\\&\\&\\s*", " and ");
        code = code.replaceAll("\\s*\\|\\|\\s*", " or ");
        return code;
    }
}

