/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.debug;

import cz.miroslavbartyzal.psdiagram.app.debug.DebugSymbol;
import cz.miroslavbartyzal.psdiagram.app.debug.function.FunctionManager;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.Layout;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutSegment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Comment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.EnumSymbol;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Goto;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.GotoLabel;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.StartEnd;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import cz.miroslavbartyzal.psdiagram.app.global.SettingsHolder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public final class DebugAnimator {
    private final int DROPSCENE_DELAYMS = 500;
    private final int PLAYPATH_DELAYMS_MAX = 3500;
    private final int PLAYPATH_DELAYPIXEL_MAX = 350;
    private final int PLAYPATH_DELAYMS_MIN = 1000;
    private final float SLIDER_DECREASELIMIT = 0.25f;
    private final float SLIDER_INCREASELIMIT = 4.0f;
    private final int AFTERDONE_DELAYMS = 300;
    private final int BACKGROUNDGRAY = 50;
    private final Color PATHCOLOR = new Color(150, 150, 150);
    private final Color PATHBASECOLOR = new Color(50, 106, 169);
    private final Color SHADOWCOLOR = new Color(0, 0, 0, 150);
    private final float PATHMIN_SATURATION_PERCENTAGE = 0.1f;
    private final float PATHMAX_BRIGHTNESS_PERCENTAGE = 1.0f;
    private final int BALLSHINE_SIZE = 50;
    private final float BALLRADIUS = 25.0f;
    private final float BALLSIZE_PERCENTAGE = 0.22f;
    private Ellipse2D ball = null;
    private final float[] BALLDIST = new float[]{0.0f, 0.132f, 0.22f, 0.35f, 1.0f};
    private Color ballColor;
    private Color[] ballGradientColors;
    private RadialGradientPaint ballGradient = null;
    private RadialGradientPaint ballShineGradient = null;
    private Layout layout;
    private JPanel jPanelDiagram;
    private JSlider jSliderSpeed;
    private final PlayTimer playTimer = new PlayTimer();
    private DropSceneTimer dropSceneTimer;
    private FunctionManager functionManager;
    private Symbol activeSymbol = null;
    private Color[] pathColors = new Color[26];
    private final Color[] SEGMENTDESCS_COLORS = new Color[]{new Color(170, 170, 170), new Color(200, 200, 200)};
    private final Color PROGRESSDESCS_COLOR = new Color(207, 190, 255);
    private ArrayList<Color[]> symbolColors = new ArrayList();
    private final Color BREAKPOINT_COLOR = new Color(159, 33, 32);
    private final Color ACTIVESYMBOL_COLOR = new Color(86, 192, 233);
    private final Color ERROR_SYMBOL_COLOR = new Color(141, 46, 48);
    private TreeMap<Integer, ArrayList<Path2D[]>> paths = new TreeMap();
    private HashMap<DebugSymbol, Integer> symbols = new HashMap(30);
    private LinkedHashMap<Integer, HashMap<TextLayout, Point2D>> segmentDescs = new LinkedHashMap();
    private ArrayList<Path2D> commentPaths = new ArrayList();
    private ArrayList<Path2D> gotoPaths = new ArrayList();
    private ArrayList<DebugSymbol> commentSymbols = new ArrayList();
    private BasicStroke mainStroke = new BasicStroke(2.0f);
    private BasicStroke gotoStroke;
    private BasicStroke commentStroke;
    private boolean reinitSymbols = true;

    public DebugAnimator(Layout layout, JPanel jPanelDiagram, JSlider jSliderSpeed, FunctionManager functionManager) {
        this.layout = layout;
        this.jPanelDiagram = jPanelDiagram;
        this.jSliderSpeed = jSliderSpeed;
        this.functionManager = functionManager;
        this.symbolColors.add(new Color[]{new Color(50, 50, 50), new Color(50, 50, 50), this.SEGMENTDESCS_COLORS[0]});
        this.symbolColors.add(new Color[]{new Color(150, 153, 200), new Color(104, 120, 186), new Color(49, 34, 94)});
        this.pathColors[0] = this.PATHCOLOR;
        this.pathColors[1] = this.PATHBASECOLOR;
        float[] hsbVals = Color.RGBtoHSB(this.PATHBASECOLOR.getRed(), this.PATHBASECOLOR.getGreen(), this.PATHBASECOLOR.getBlue(), null);
        hsbVals[1] = hsbVals[1] + (0.1f - hsbVals[1]) / (float)(this.pathColors.length - 2) * (float)(this.pathColors.length / 2);
        hsbVals[2] = hsbVals[2] + (1.0f - hsbVals[2]) / (float)(this.pathColors.length - 2) * (float)(this.pathColors.length / 2);
        float fractionH = 1.0f / (float)(this.pathColors.length - 2);
        float fractionS = (0.1f - hsbVals[1]) / (float)(this.pathColors.length - 2);
        float fractionB = (1.0f - hsbVals[2]) / (float)(this.pathColors.length - 2);
        int i = 1;
        while (i + 1 < this.pathColors.length) {
            this.pathColors[i + 1] = Color.getHSBColor(fractionH * (float)i + hsbVals[0], fractionS * (float)i + hsbVals[1], fractionB * (float)i + hsbVals[2]);
            ++i;
        }
        this.gotoStroke = new BasicStroke(this.mainStroke.getLineWidth(), layout.getGotoStroke().getEndCap(), layout.getGotoStroke().getLineJoin(), layout.getGotoStroke().getMiterLimit(), layout.getGotoStroke().getDashArray(), layout.getGotoStroke().getDashPhase());
        this.commentStroke = new BasicStroke(this.mainStroke.getLineWidth(), layout.getCommentStroke().getEndCap(), layout.getCommentStroke().getLineJoin(), layout.getCommentStroke().getMiterLimit(), layout.getCommentStroke().getDashArray(), layout.getCommentStroke().getDashPhase());
        this.dropSceneTimer = new DropSceneTimer(50, 12);
        this.dropSceneTimer.setDelay(40);
    }

    public void init() {
        this.symbols.clear();
        this.commentSymbols.clear();
        this.paths.clear();
        this.paths.put(0, new ArrayList());
        this.paths.put(1, new ArrayList());
        this.gotoPaths.clear();
        this.commentPaths.clear();
        this.segmentDescs.clear();
        this.segmentDescs.put(0, new HashMap());
        for (LayoutSegment segment : this.layout.getFlowchart()) {
            if (segment == null) continue;
            if (!segment.getPathToThisSegment().getPathIterator(null).isDone()) {
                this.paths.get(0).add(this.layout.shouldBeArrow(segment.getPathToThisSegment()));
            }
            if (segment.getDescriptionLayout() != null) {
                this.segmentDescs.get(0).put(segment.getDescriptionLayout(), segment.getDescriptionLocation());
            }
            boolean lastGoto = false;
            for (LayoutElement element : segment) {
                boolean EndStartEnd;
                if (!(element.getSymbol() instanceof Comment)) {
                    this.symbols.put(this.initAnimSymbol(new DebugSymbol(element.getSymbol()), this.symbolColors.get(0)[0], this.symbolColors.get(0)[1]), 0);
                }
                boolean bl = EndStartEnd = element.getSymbol() instanceof StartEnd && (((LayoutSegment)element.getParentSegment()).getParentElement() != null || ((LayoutSegment)element.getParentSegment()).indexOfElement(element) > 1 || ((LayoutSegment)element.getParentSegment()).indexOfElement(element) == 1 && !(((LayoutElement)((LayoutSegment)element.getParentSegment()).getElement(0)).getSymbol() instanceof Comment));
                if (!(element.getSymbol() instanceof Comment || element.getSymbol() instanceof Goto || EndStartEnd)) {
                    if (!element.getPathToNextSymbol().getPathIterator(null).isDone()) {
                        this.paths.get(0).add(this.layout.shouldBeArrow(element.getPathToNextSymbol()));
                    }
                    lastGoto = false;
                    if (!(element.getSymbol() instanceof GotoLabel)) continue;
                    GotoLabel gotoLabel = (GotoLabel)element.getSymbol();
                    Path2D.Double gotoLabelPath = new Path2D.Double();
                    ((Path2D)gotoLabelPath).moveTo(gotoLabel.getCenterX() - (double)gotoLabel.getMyHair(), gotoLabel.getCenterY());
                    ((Path2D)gotoLabelPath).lineTo(gotoLabel.getCenterX(), gotoLabel.getCenterY());
                    this.paths.get(0).add(new Path2D[]{gotoLabelPath, null});
                    continue;
                }
                if (element.getSymbol() instanceof Goto || EndStartEnd) {
                    this.gotoPaths.add(element.getPathToNextSymbol());
                    lastGoto = true;
                    continue;
                }
                this.commentSymbols.add(this.initAnimSymbol(new DebugSymbol(element.getSymbol()), this.symbolColors.get(0)[0], this.symbolColors.get(0)[0]));
                this.commentPaths.add(element.getPathToNextSymbol());
            }
            if (!lastGoto) {
                this.paths.get(0).add(this.layout.shouldBeArrow(segment.getPathFromThisSegment()));
                continue;
            }
            if (segment.getPathFromThisSegment().getPathIterator(null).isDone()) continue;
            this.gotoPaths.add(segment.getPathFromThisSegment());
        }
        this.reinitSymbols = true;
        this.jPanelDiagram.repaint();
        this.dropSceneTimer.start();
    }

    public boolean isPlaying() {
        return this.playTimer.isRunning();
    }

    public void setBallToPos(double x, double y) {
        if (this.ball != null && !this.playTimer.isRunning()) {
            this.playTimer.setBall(x, y);
            this.jPanelDiagram.repaint();
        }
    }

    public Point2D getBallCoordenates() {
        if (this.ball != null) {
            return new Point2D.Double(this.ball.getCenterX(), this.ball.getCenterY());
        }
        return null;
    }

    public boolean ballContains(double x, double y) {
        if (this.ball != null) {
            return new Point2D.Double(this.ball.getCenterX(), this.ball.getCenterY()).distance(x, y) <= 5.5;
        }
        return false;
    }

    public void play() {
        this.playTimer.start();
    }

    public boolean isPlayBuffered() {
        return this.playTimer.isBuffered();
    }

    public void pause() {
        this.playTimer.pause();
        this.jPanelDiagram.repaint();
    }

    public void stop() {
        this.dropSceneTimer.stop();
        this.playTimer.stop();
        for (DebugSymbol animSymbol : this.symbols.keySet()) {
            animSymbol.setProgressDesc(null);
            animSymbol.setProgressString(null);
            this.symbols.put(animSymbol, 0);
        }
        Iterator<Integer> it = this.paths.keySet().iterator();
        while (it.hasNext()) {
            int i = it.next();
            if (i == 0) continue;
            this.paths.get(0).addAll((Collection<Path2D[]>)this.paths.get(i));
            it.remove();
        }
        it = this.segmentDescs.keySet().iterator();
        while (it.hasNext()) {
            int i = it.next();
            if (i == 0) continue;
            this.segmentDescs.get(0).putAll((Map<TextLayout, Point2D>)this.segmentDescs.get(i));
            it.remove();
        }
        this.reinitSymbols = true;
        this.jPanelDiagram.repaint();
    }

    public void paintFlowchart(Graphics2D g2d) {
        Stroke prevStroke = g2d.getStroke();
        g2d.setStroke(this.mainStroke);
        for (int i : this.paths.keySet()) {
            int colorIndex = i;
            if (colorIndex >= this.pathColors.length) {
                colorIndex = this.pathColors.length - 1;
            }
            g2d.setColor(this.pathColors[colorIndex]);
            for (Path2D[] path : this.paths.get(i)) {
                g2d.draw(path[0]);
                if (path[1] == null) continue;
                g2d.fill(path[1]);
            }
        }
        if (!this.playTimer.completedLines.isEmpty()) {
            int colorIndex = this.playTimer.processElevation;
            if (colorIndex >= this.pathColors.length) {
                colorIndex = this.pathColors.length - 1;
            }
            g2d.setColor(this.pathColors[colorIndex]);
            for (Line2D line : this.playTimer.completedLines) {
                g2d.draw(line);
            }
        }
        if (this.playTimer.lineInProcess != null) {
            int colorIndex = this.playTimer.processElevation;
            if (colorIndex >= this.pathColors.length) {
                colorIndex = this.pathColors.length - 1;
            }
            g2d.setColor(this.pathColors[colorIndex]);
            g2d.draw(this.playTimer.lineInProcess);
        }
        if (this.gotoPaths.size() > 0) {
            g2d.setColor(this.pathColors[0]);
            g2d.setStroke(this.gotoStroke);
            for (Path2D path : this.gotoPaths) {
                g2d.draw(path);
            }
            g2d.setStroke(this.mainStroke);
        }
        for (DebugSymbol debugSymbol : this.symbols.keySet()) {
            if (this.reinitSymbols) {
                int colorSchemeIndex = this.symbols.get(debugSymbol);
                if (colorSchemeIndex >= this.symbolColors.size()) {
                    colorSchemeIndex = this.symbolColors.size() - 1;
                }
                this.initAnimSymbol(debugSymbol, this.symbolColors.get(colorSchemeIndex)[0], this.symbolColors.get(colorSchemeIndex)[1]);
            }
            this.drawAnimSymbolShade(g2d, debugSymbol);
        }
        this.reinitSymbols = false;
        if (this.ball != null) {
            g2d.setPaint(this.ballGradient);
            g2d.fill(this.ball);
        }
        for (DebugSymbol debugSymbol : this.symbols.keySet()) {
            this.drawAnimSymbolSymbol(g2d, debugSymbol, this.symbols.get(debugSymbol));
        }
        Iterator<Object> colorIndex = this.segmentDescs.keySet().iterator();
        while (colorIndex.hasNext()) {
            int i = (Integer)colorIndex.next();
            int colorIndex2 = i;
            if (colorIndex2 >= this.SEGMENTDESCS_COLORS.length) {
                colorIndex2 = this.SEGMENTDESCS_COLORS.length - 1;
            }
            g2d.setColor(this.SEGMENTDESCS_COLORS[colorIndex2]);
            HashMap<TextLayout, Point2D> descs = this.segmentDescs.get(i);
            for (Map.Entry<TextLayout, Point2D> entry : descs.entrySet()) {
                entry.getKey().draw(g2d, (float)entry.getValue().getX(), (float)entry.getValue().getY());
            }
        }
        if (this.commentPaths.size() > 0) {
            g2d.setColor(this.PATHCOLOR);
            g2d.setStroke(this.commentStroke);
            for (Path2D path : this.commentPaths) {
                g2d.draw(path);
            }
            g2d.setStroke(this.mainStroke);
        }
        if (this.commentSymbols.size() > 0) {
            for (DebugSymbol animCommentSymbol : this.commentSymbols) {
                this.drawAnimSymbolSymbol(g2d, animCommentSymbol, 0);
            }
        }
        g2d.setColor(this.BREAKPOINT_COLOR);
        g2d.setStroke(this.gotoStroke);
        for (Symbol breakSymbol : this.functionManager.getBreakpointSymbols()) {
            double focusedWidth = breakSymbol.getWidth();
            if (breakSymbol instanceof GotoLabel) {
                focusedWidth /= 2.0;
            }
            g2d.draw(new Rectangle2D.Double(breakSymbol.getX() - 5.0, breakSymbol.getY() - 4.0, focusedWidth + 10.0 - (double)(this.gotoStroke.getLineWidth() / 2.0f), breakSymbol.getHeight() + 8.0));
        }
        g2d.setStroke(this.mainStroke);
        if (!this.playTimer.isRunning() && this.activeSymbol != null) {
            g2d.setColor(this.ACTIVESYMBOL_COLOR);
            g2d.setStroke(this.gotoStroke);
            double focusedWidth = this.activeSymbol.getWidth();
            if (this.activeSymbol instanceof GotoLabel) {
                focusedWidth /= 2.0;
            }
            g2d.draw(new Rectangle2D.Double(this.activeSymbol.getX() - 3.0, this.activeSymbol.getY() - 2.0, focusedWidth + 6.0 - (double)(this.gotoStroke.getLineWidth() / 2.0f), this.activeSymbol.getHeight() + 4.0));
            g2d.setStroke(this.mainStroke);
        }
        for (DebugSymbol animSymbol : this.symbols.keySet()) {
            if (animSymbol.getProgressDesc() == null) continue;
            g2d.setColor(new Color(0, 0, 0, 100));
            animSymbol.getProgressDesc().draw(g2d, (float)animSymbol.getProgressDescPoint().getX() + 0.5f, (float)animSymbol.getProgressDescPoint().getY() + 0.5f);
            g2d.setColor(this.PROGRESSDESCS_COLOR);
            animSymbol.getProgressDesc().draw(g2d, (float)animSymbol.getProgressDescPoint().getX(), (float)animSymbol.getProgressDescPoint().getY());
        }
        g2d.setStroke(prevStroke);
    }

    public String getSymbolProgressDesc(Symbol symbol) {
        return this.findAnimSymbol(symbol).getProgressString();
    }

    public void animPath(Symbol fromSymbol, String progressDesc, Path2D[] throughPaths, TextLayout segmentDesc) {
        this.playTimer.animPath(fromSymbol, progressDesc, throughPaths, segmentDesc);
    }

    public void doPath(Symbol fromSymbol, String progressDesc, Path2D[] throughPaths, TextLayout segmentDesc, boolean elevate) {
        if (this.playTimer.isRunning() || this.playTimer.isBuffered()) {
            if (elevate) {
                this.playTimer.finalizeIt();
            }
            this.playTimer.stop();
        }
        this.elevateSymbolProgressSdescs(fromSymbol, progressDesc, throughPaths, segmentDesc, elevate);
        this.elevateAnalyzedPaths(this.getAnalyzedPaths(throughPaths), elevate);
        this.jPanelDiagram.repaint();
    }

    private void elevateSymbolProgressSdescs(Symbol fromSymbol, String progressDesc, Path2D[] throughPaths, TextLayout segmentDesc, boolean elevate) {
        int symbolElevation;
        DebugSymbol animSymbol = this.findAnimSymbol(fromSymbol);
        if (progressDesc == null || progressDesc.equals("")) {
            animSymbol.setProgressDesc(null);
        } else {
            animSymbol.setProgressDesc(new TextLayout(progressDesc, SettingsHolder.CODEFONT, SettingsHolder.FONTRENDERCONTEXT));
        }
        animSymbol.setProgressString(progressDesc);
        boolean doSymbol = true;
        if (fromSymbol instanceof GotoLabel) {
            if (throughPaths != null) {
                GotoLabel gotoLabel = (GotoLabel)fromSymbol;
                Path2D.Double gotoLabelPath = new Path2D.Double();
                ((Path2D)gotoLabelPath).moveTo(gotoLabel.getCenterX() - (double)gotoLabel.getMyHair(), gotoLabel.getCenterY());
                ((Path2D)gotoLabelPath).lineTo(gotoLabel.getCenterX(), gotoLabel.getCenterY());
                doSymbol = this.equalPath(throughPaths[0], gotoLabelPath);
            } else {
                doSymbol = false;
            }
        }
        if (doSymbol && (symbolElevation = elevate ? this.symbols.get(animSymbol) + 1 : this.symbols.get(animSymbol) - 1) >= 0) {
            if (symbolElevation >= this.symbolColors.size()) {
                this.symbols.put(animSymbol, symbolElevation);
            } else {
                this.symbols.put(this.initAnimSymbol(animSymbol, this.symbolColors.get(symbolElevation)[0], this.symbolColors.get(symbolElevation)[1]), symbolElevation);
            }
        }
        if (segmentDesc != null) {
            block0: for (int i : this.segmentDescs.keySet()) {
                for (TextLayout textLayout : this.segmentDescs.get(i).keySet()) {
                    if (!textLayout.equals(segmentDesc)) continue;
                    if (elevate) {
                        if (this.segmentDescs.get(i + 1) == null) {
                            this.segmentDescs.put(i + 1, new HashMap());
                        }
                        this.segmentDescs.get(i + 1).put(textLayout, this.segmentDescs.get(i).remove(textLayout));
                        break block0;
                    }
                    if (i <= 0) break block0;
                    this.segmentDescs.get(i - 1).put(textLayout, this.segmentDescs.get(i).remove(textLayout));
                    break block0;
                }
            }
        }
    }

    private void elevateAnalyzedPaths(ArrayList<Map.Entry<Path2D[], Integer>> analyzedPaths, boolean elevate) {
        for (Map.Entry<Path2D[], Integer> entry : analyzedPaths) {
            if (entry == null) continue;
            if (elevate) {
                if (this.paths.get(entry.getValue() + 1) == null) {
                    this.paths.put(entry.getValue() + 1, new ArrayList());
                }
                this.paths.get(entry.getValue() + 1).add(this.paths.get(entry.getValue()).remove(this.paths.get(entry.getValue()).indexOf(entry.getKey())));
                continue;
            }
            if (entry.getValue() <= 0) continue;
            this.paths.get(entry.getValue() - 1).add(this.paths.get(entry.getValue()).remove(this.paths.get(entry.getValue()).indexOf(entry.getKey())));
        }
    }

    private ArrayList<Map.Entry<Path2D[], Integer>> getAnalyzedPaths(Path2D[] throughPaths) {
        ArrayList<Map.Entry<Path2D[], Integer>> analyzedPaths = new ArrayList<Map.Entry<Path2D[], Integer>>();
        if (throughPaths != null && throughPaths.length > 0) {
            block0: for (int i = 0; i < throughPaths.length; ++i) {
                Path2D continualP;
                Path2D[] pth = this.layout.shouldBeArrow(throughPaths[i]);
                boolean createIt = false;
                if (i > 0 && !this.equalPath(throughPaths[i], continualP = this.getContinualCurrentPath(throughPaths[i - 1], throughPaths[i]))) {
                    createIt = true;
                    pth = this.layout.shouldBeArrow(continualP);
                }
                for (int j : this.paths.keySet()) {
                    for (Path2D[] path : this.paths.get(j)) {
                        if (!this.equalPath(path[0], pth[0])) continue;
                        analyzedPaths.add(new AbstractMap.SimpleEntry<Path2D[], Integer>(path, j));
                        continue block0;
                    }
                }
                if (createIt) {
                    this.paths.get(0).add(pth);
                    analyzedPaths.add(new AbstractMap.SimpleEntry<Path2D[], Integer>(pth, 0));
                    continue;
                }
                analyzedPaths.add(null);
            }
        }
        return analyzedPaths;
    }

    private Path2D getContinualCurrentPath(Path2D prevPath, Path2D currentPath) {
        double[] coordinates = new double[2];
        PathIterator pathIterator = currentPath.getPathIterator(null);
        pathIterator.currentSegment(coordinates);
        Point2D.Double beginPoint = new Point2D.Double(coordinates[0], coordinates[1]);
        pathIterator.next();
        pathIterator.currentSegment(coordinates);
        Point2D.Double nextPoint = new Point2D.Double(coordinates[0], coordinates[1]);
        Point2D prevEndPoint = prevPath.getCurrentPoint();
        if (!beginPoint.equals(prevEndPoint) && Line2D.ptSegDist(((Point2D)beginPoint).getX(), ((Point2D)beginPoint).getY(), ((Point2D)nextPoint).getX(), ((Point2D)nextPoint).getY(), prevEndPoint.getX(), prevEndPoint.getY()) == 0.0) {
            Path2D.Double path = new Path2D.Double(1);
            ((Path2D)path).moveTo(prevEndPoint.getX(), prevEndPoint.getY());
            ((Path2D)path).lineTo(((Point2D)nextPoint).getX(), ((Point2D)nextPoint).getY());
            pathIterator.next();
            while (!pathIterator.isDone()) {
                int type = pathIterator.currentSegment(coordinates);
                switch (type) {
                    case 1: {
                        ((Path2D)path).lineTo(coordinates[0], coordinates[1]);
                        break;
                    }
                    default: {
                        throw new Error("Unexpected currentSegment!");
                    }
                }
                pathIterator.next();
            }
            return path;
        }
        return currentPath;
    }

    public void setActiveSymbol(Symbol activeSymbol) {
        this.activeSymbol = activeSymbol;
        this.jPanelDiagram.repaint();
    }

    private boolean equalPath(Path2D path1, Path2D path2) {
        return path1.getBounds2D().equals(path2.getBounds2D());
    }

    private DebugSymbol findAnimSymbol(Symbol symbol) {
        for (DebugSymbol animSymbol : this.symbols.keySet()) {
            if (!animSymbol.getSymbol().equals(symbol)) continue;
            return animSymbol;
        }
        return null;
    }

    private void drawAnimSymbolSymbol(Graphics2D g2d, DebugSymbol animSymbol, int colorSchemeIndex) {
        Color col = g2d.getColor();
        if (animSymbol.getSymbolGradient() != null) {
            g2d.setPaint(animSymbol.getSymbolGradient());
            g2d.fill(animSymbol.getSymbol().getShape());
        } else if (animSymbol.getSymbolColor() != null) {
            g2d.setPaint(animSymbol.getSymbolColor());
            g2d.fill(animSymbol.getSymbol().getShape());
        }
        if (animSymbol.getBallShineGradient() != null) {
            g2d.setPaint(animSymbol.getBallShineGradient());
            g2d.fill(animSymbol.getSymbol().getShape());
        }
        if (colorSchemeIndex < this.pathColors.length) {
            g2d.setColor(this.pathColors[colorSchemeIndex]);
        } else {
            g2d.setColor(this.pathColors[this.pathColors.length - 1]);
        }
        if (animSymbol.getSymbol() instanceof GotoLabel) {
            GotoLabel gotoLabel = (GotoLabel)animSymbol.getSymbol();
            g2d.draw(gotoLabel.getMyCircle());
        } else if (colorSchemeIndex == 0 && !animSymbol.getSymbol().areCommandsValid() && EnumSymbol.getEnumSymbol(animSymbol.getSymbol().getClass()).areAllCommandsPresent(this.layout.findMyElement(animSymbol.getSymbol()))) {
            g2d.setColor(this.ERROR_SYMBOL_COLOR);
            g2d.draw(animSymbol.getSymbol().getShape());
        } else {
            g2d.draw(animSymbol.getSymbol().getShape());
        }
        if (colorSchemeIndex < this.symbolColors.size()) {
            g2d.setColor(this.symbolColors.get(colorSchemeIndex)[2]);
        } else {
            g2d.setColor(this.symbolColors.get(this.symbolColors.size() - 1)[2]);
        }
        for (int i = 0; i < animSymbol.getSymbol().getTextLayoutLines().size(); ++i) {
            Point2D p = animSymbol.getSymbol().getTextLayoutOrigins().get(i);
            animSymbol.getSymbol().getTextLayoutLines().get(i).draw(g2d, (float)p.getX(), (float)p.getY());
        }
        g2d.setColor(col);
    }

    private void drawAnimSymbolShade(Graphics2D g2d, DebugSymbol animSymbol) {
        AffineTransform af = g2d.getTransform();
        Color col = g2d.getColor();
        if (animSymbol.getShadeColor() != null) {
            g2d.translate(animSymbol.getShadeTransX(), animSymbol.getShadeTransY());
            g2d.setColor(animSymbol.getShadeColor());
            if (!(animSymbol.getSymbol() instanceof Comment)) {
                g2d.fill(animSymbol.getSymbol().getShape());
            } else {
                g2d.draw(animSymbol.getSymbol().getShape());
            }
        }
        g2d.setColor(col);
        g2d.setTransform(af);
    }

    private DebugSymbol initAnimSymbol(DebugSymbol animSymbol, Color shapeFirstColor, Color shapeSecondColor) {
        double symbolWidth;
        double symbolCenterX;
        Symbol symbol = animSymbol.getSymbol();
        if (!(symbol instanceof GotoLabel)) {
            symbolCenterX = symbol.getCenterX();
            symbolWidth = symbol.getWidth();
        } else {
            GotoLabel gotoLabel = (GotoLabel)symbol;
            symbolWidth = gotoLabel.getWidth() / 2.0 - (double)gotoLabel.getMyHair();
            symbolCenterX = gotoLabel.getX() + symbolWidth / 2.0;
        }
        if (SettingsHolder.settings.isBallShine() && this.ballShineGradient != null && symbol.getShapeUpColor() != null && !symbol.contains(this.ballShineGradient.getCenterPoint())) {
            Point2D.Double symbolCenterPoint = new Point2D.Double(symbolCenterX, symbol.getCenterY());
            Point2D ballShineCenterPoint = this.ballShineGradient.getCenterPoint();
            float ballShineRad = this.ballShineGradient.getRadius();
            if (ballShineCenterPoint.distance(symbolCenterPoint) < (double)ballShineRad + symbolCenterPoint.distance(symbol.getX(), symbol.getY())) {
                Point2D interNearPoint = symbol.getIntersectionPoint(ballShineCenterPoint.getX(), ballShineCenterPoint.getY());
                if (interNearPoint == null) {
                    interNearPoint = symbolCenterPoint;
                }
                if (ballShineCenterPoint.distance(interNearPoint) < (double)ballShineRad) {
                    double SHADOWMAXTRANSX = symbolWidth / 2.0;
                    double SHADOWMAXTRANSY = symbol.getHeight() / 2.0;
                    Point2D interFarPoint = symbol.getIntersectionPoint(symbolCenterX - ballShineCenterPoint.getX() + symbolCenterX, symbol.getCenterY() - ballShineCenterPoint.getY() + symbol.getCenterY());
                    if (interFarPoint == null) {
                        interFarPoint = symbolCenterPoint;
                    }
                    double shineDist = interFarPoint.distance(ballShineCenterPoint);
                    Color[] colors = this.ballShineGradient.getColors();
                    if (shineDist > (double)ballShineRad) {
                        shineDist = ballShineRad;
                    } else if (shineDist == 0.0) {
                        shineDist = symbol.getHeight();
                    }
                    if (shapeFirstColor.equals(shapeSecondColor) && colors.length == 2) {
                        colors = new Color[]{colors[0], shapeFirstColor};
                    }
                    animSymbol.setBallShineGradient(new RadialGradientPaint(ballShineCenterPoint, (float)shineDist, this.ballShineGradient.getFocusPoint(), this.ballShineGradient.getFractions(), colors, this.ballShineGradient.getCycleMethod()));
                    shineDist = interNearPoint.distance(ballShineCenterPoint);
                    double transX = SHADOWMAXTRANSX * (interNearPoint.getX() - ballShineCenterPoint.getX()) / (double)ballShineRad;
                    double transY = SHADOWMAXTRANSY * (interNearPoint.getY() - ballShineCenterPoint.getY()) / (double)ballShineRad;
                    animSymbol.setShadeColor(new Color(0, 0, 0, (int)((double)this.SHADOWCOLOR.getAlpha() * (1.0 - shineDist / (double)ballShineRad))));
                    animSymbol.setShadeTransX(transX);
                    animSymbol.setShadeTransY(transY);
                } else {
                    this.setNoShine(animSymbol);
                }
            } else {
                this.setNoShine(animSymbol);
            }
        } else {
            this.setNoShine(animSymbol);
        }
        if (symbol.getShapeUpColor() != null) {
            if (shapeFirstColor.equals(shapeSecondColor)) {
                animSymbol.setSymbolGradient(null);
                animSymbol.setSymbolColor(shapeFirstColor);
            } else {
                animSymbol.setSymbolColor(null);
                animSymbol.setSymbolGradient(new GradientPaint((float)(symbol.getX() + symbolWidth * 0.25), (float)symbol.getY(), shapeFirstColor, (float)(symbol.getX() + symbolWidth * 0.75), (float)(symbol.getY() + symbol.getHeight()), shapeSecondColor));
            }
        } else {
            animSymbol.setSymbolGradient(null);
            animSymbol.setSymbolColor(null);
        }
        return animSymbol;
    }

    private void setNoShine(DebugSymbol animSymbol) {
        animSymbol.setBallShineGradient(null);
        animSymbol.setShadeColor(null);
        animSymbol.setShadeTransX(0.0);
        animSymbol.setShadeTransY(0.0);
    }

    private void changeBallColor(Color color) {
        this.ballColor = color;
        this.ballGradientColors = new Color[]{color, color.darker(), color.darker().darker(), new Color(color.getRed(), color.getGreen(), color.getBlue(), 80), new Color(color.getRed(), color.getGreen(), color.getBlue(), 0)};
    }

    private double functionHalfCosinPercentage(double fragment, double count) {
        return 0.5 - Math.cos(fragment / count * Math.PI) / 2.0;
    }

    private double functionPower3Percentage(double fragment, double count) {
        return Math.pow(fragment / count - 1.0, 3.0) + 1.0;
    }

    private final class PlayTimer
    extends Timer {
        private ArrayList<Map.Entry<Path2D[], Integer>> analyzedPaths;
        private ArrayList<Line2D> completedLines;
        private Line2D lineInProcess;
        private int processElevation;
        private ArrayDeque<ArrayDeque<Line2D>> ballPaths;
        private ArrayDeque<Point2D> arrows;
        private double currentPathLength;
        private double currentLineStartPointDist;
        private double currentLineLength;
        private int timePased;
        private int timeToPassWholePath;
        private boolean completeBegining;

        public PlayTimer() {
            super(0, null);
            this.analyzedPaths = new ArrayList();
            this.completedLines = new ArrayList();
            this.processElevation = 0;
            this.ballPaths = new ArrayDeque();
            this.arrows = new ArrayDeque();
            this.currentPathLength = 0.0;
            this.currentLineStartPointDist = 0.0;
            this.currentLineLength = 0.0;
            this.timePased = 0;
            this.timeToPassWholePath = 0;
            this.completeBegining = true;
            super.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PlayTimer.this.myActionPerformed();
                }
            });
        }

        public void setBall(double x, double y) {
            double endDist;
            Point2D.Double centerP;
            int colorIndex;
            if (DebugAnimator.this.ball == null) {
                DebugAnimator.this.ball = new Ellipse2D.Double(0.0, 0.0, 50.0, 50.0);
            }
            if ((colorIndex = this.processElevation) >= DebugAnimator.this.pathColors.length) {
                colorIndex = DebugAnimator.this.pathColors.length - 1;
            }
            if (DebugAnimator.this.ballColor == null || !DebugAnimator.this.ballColor.equals(DebugAnimator.this.pathColors[colorIndex])) {
                DebugAnimator.this.changeBallColor(DebugAnimator.this.pathColors[colorIndex]);
            }
            Point2D.Double focusP = centerP = new Point2D.Double(x, y);
            float sizePerc = 1.0f;
            if (this.completeBegining && this.completedLines.isEmpty()) {
                double startDist = Point2D.distance(this.lineInProcess.getP1().getX(), this.lineInProcess.getP1().getY(), x, y);
                if (startDist < 5.5) {
                    double space = 5.5;
                    if (this.currentPathLength == this.currentLineLength && this.currentPathLength < 11.0 && (DebugAnimator.this.activeSymbol == null || !(DebugAnimator.this.activeSymbol instanceof GotoLabel))) {
                        if (startDist > this.currentLineLength / 2.0) {
                            startDist = this.currentLineLength - startDist;
                        }
                        space = this.currentLineLength / 2.0;
                    } else if (this.currentLineLength < space) {
                        space = this.currentLineLength;
                    }
                    sizePerc = (float)(startDist / space);
                } else {
                    this.completeBegining = false;
                }
            } else if (this.ballPaths.size() == 1 && this.ballPaths.peek().size() == 1 && (DebugAnimator.this.activeSymbol == null || !(DebugAnimator.this.activeSymbol instanceof GotoLabel)) && (endDist = Point2D.distance(x, y, this.ballPaths.peek().peek().getX2(), this.ballPaths.peek().peek().getY2())) < 5.5) {
                double space = 5.5;
                if (this.currentLineLength < endDist) {
                    space = this.currentLineLength;
                }
                sizePerc = (float)(endDist / space);
            }
            DebugAnimator.this.ball.setFrame(x - (double)(25.0f * sizePerc), y - (double)(25.0f * sizePerc), 50.0f * sizePerc, 50.0f * sizePerc);
            if (sizePerc <= 0.0f) {
                DebugAnimator.this.ballGradient = null;
                DebugAnimator.this.ballShineGradient = null;
            } else {
                DebugAnimator.this.ballGradient = new RadialGradientPaint(centerP, 25.0f * sizePerc, focusP, DebugAnimator.this.BALLDIST, DebugAnimator.this.ballGradientColors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
                if (SettingsHolder.settings.isBallShine()) {
                    DebugAnimator.this.ballShineGradient = new RadialGradientPaint(centerP, (float)SettingsHolder.settings.getBallShineRadius() * sizePerc, new float[]{0.0f, 1.0f}, new Color[]{DebugAnimator.this.ballColor, new Color(DebugAnimator.this.ballColor.getRed(), DebugAnimator.this.ballColor.getGreen(), DebugAnimator.this.ballColor.getBlue(), 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE);
                }
            }
            DebugAnimator.this.reinitSymbols = true;
        }

        private float getSliderModif() {
            float half = (DebugAnimator.this.jSliderSpeed.getMaximum() + DebugAnimator.this.jSliderSpeed.getMinimum()) / 2;
            if ((float)DebugAnimator.this.jSliderSpeed.getValue() > half) {
                return 1.0f + ((float)DebugAnimator.this.jSliderSpeed.getValue() - half) / ((float)DebugAnimator.this.jSliderSpeed.getMaximum() - half) * 3.0f;
            }
            if ((float)DebugAnimator.this.jSliderSpeed.getValue() < half) {
                return 0.25f + (1.0f - ((float)DebugAnimator.this.jSliderSpeed.getValue() - half) / ((float)DebugAnimator.this.jSliderSpeed.getMinimum() - half)) * 0.75f;
            }
            return 1.0f;
        }

        private int getTimeToPassWholePath() {
            float modif = this.getSliderModif();
            float msMax = 3500.0f * modif;
            float msMin = 1000.0f * modif;
            if (this.currentPathLength >= 350.0) {
                return (int)msMax;
            }
            int ret = (int)(this.currentPathLength / 350.0 * (double)msMax);
            if ((float)ret < msMin) {
                return (int)msMin;
            }
            return ret;
        }

        private boolean setNextPath() {
            ArrayList<Map.Entry<Path2D[], Integer>> analyzedPath = new ArrayList<Map.Entry<Path2D[], Integer>>();
            analyzedPath.add(this.analyzedPaths.remove(0));
            DebugAnimator.this.elevateAnalyzedPaths(analyzedPath, true);
            this.completedLines.clear();
            this.lineInProcess = null;
            this.ballPaths.poll();
            this.arrows.poll();
            this.completeBegining = false;
            if (this.ballPaths.isEmpty()) {
                return false;
            }
            this.initNextPath();
            return true;
        }

        private void initNextPath() {
            this.currentPathLength = 0.0;
            int i = 0;
            for (Line2D line : this.ballPaths.peek()) {
                if (i == 0) {
                    this.currentLineLength = Point2D.distance(line.getX1(), line.getY1(), line.getX2(), line.getY2());
                }
                this.currentPathLength += Point2D.distance(line.getX1(), line.getY1(), line.getX2(), line.getY2());
                ++i;
            }
            this.processElevation = this.analyzedPaths.get(0).getValue() + 1;
            this.timeToPassWholePath = this.getTimeToPassWholePath();
            this.currentLineStartPointDist = 0.0;
            this.timePased = 0;
        }

        private void myActionPerformed() {
            int nextDelay = 1000 / SettingsHolder.settings.getFps();
            if (this.isBuffered()) {
                int timeRemaining;
                int updatedTimeToPassWholePath = this.getTimeToPassWholePath();
                if (this.timeToPassWholePath != updatedTimeToPassWholePath) {
                    this.timePased = (int)((double)this.timePased / (double)this.timeToPassWholePath * (double)updatedTimeToPassWholePath);
                    this.timeToPassWholePath = updatedTimeToPassWholePath;
                }
                if ((timeRemaining = this.timeToPassWholePath - this.timePased) <= 0) {
                    if (this.setNextPath()) {
                        this.timePased = Math.abs(timeRemaining);
                        this.myActionPerformed();
                        return;
                    }
                    if (DebugAnimator.this.activeSymbol == null || !(DebugAnimator.this.activeSymbol instanceof GotoLabel)) {
                        this.resetVariables();
                    }
                    DebugAnimator.this.jPanelDiagram.repaint();
                    this.callManagersNext();
                    return;
                }
                double targetPathProgress = this.currentPathLength * DebugAnimator.this.functionHalfCosinPercentage(this.timePased, this.timeToPassWholePath);
                this.lineInProcess = this.ballPaths.peek().peek();
                while (this.currentLineStartPointDist + this.currentLineLength <= targetPathProgress) {
                    this.completedLines.add(this.ballPaths.peek().poll());
                    this.currentLineStartPointDist += this.currentLineLength;
                    this.lineInProcess = this.ballPaths.peek().peek();
                    this.currentLineLength = Point2D.distance(this.lineInProcess.getX1(), this.lineInProcess.getY1(), this.lineInProcess.getX2(), this.lineInProcess.getY2());
                }
                double targetLinePerc = (targetPathProgress - this.currentLineStartPointDist) / this.currentLineLength;
                double newX = this.lineInProcess.getX1() + (this.lineInProcess.getX2() - this.lineInProcess.getX1()) * targetLinePerc;
                double newY = this.lineInProcess.getY1() + (this.lineInProcess.getY2() - this.lineInProcess.getY1()) * targetLinePerc;
                this.lineInProcess = new Line2D.Double(this.lineInProcess.getX1(), this.lineInProcess.getY1(), newX, newY);
                this.setBall(newX, newY);
                DebugAnimator.this.jPanelDiagram.repaint();
                this.timePased += nextDelay;
            }
            if (nextDelay != super.getDelay()) {
                super.setDelay(nextDelay);
            }
        }

        private void callManagersNext() {
            new Thread(() -> {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(() -> {
                    if (DebugAnimator.this.playTimer.isRunning() && (DebugAnimator.this.functionManager.isBreakPointReached() || DebugAnimator.this.functionManager.next().debugShouldBeHalted)) {
                        DebugAnimator.this.functionManager.globalPause();
                    }
                });
            }).start();
        }

        public void animPath(Symbol fromSymbol, String progressDesc, Path2D[] throughPaths, TextLayout segmentDesc) {
            super.stop();
            if (this.isBuffered()) {
                this.finalizeIt();
            }
            DebugAnimator.this.elevateSymbolProgressSdescs(fromSymbol, progressDesc, throughPaths, segmentDesc, true);
            DebugAnimator.this.jPanelDiagram.repaint();
            if (throughPaths != null) {
                this.analyzedPaths = DebugAnimator.this.getAnalyzedPaths(throughPaths);
                int i = 0;
                Iterator<Map.Entry<Path2D[], Integer>> it = this.analyzedPaths.iterator();
                while (it.hasNext()) {
                    Map.Entry<Path2D[], Integer> entry = it.next();
                    if (entry == null) {
                        it.remove();
                    } else {
                        this.ballPaths.add(new ArrayDeque());
                        Path2D ballPath = i > 0 ? DebugAnimator.this.getContinualCurrentPath(throughPaths[i - 1], throughPaths[i]) : throughPaths[i];
                        Path2D animPath = entry.getKey()[0];
                        double[] prevCoordinates = new double[2];
                        PathIterator ballPathIterator = ballPath.getPathIterator(null);
                        PathIterator animPathIterator = animPath.getPathIterator(null);
                        ballPathIterator.currentSegment(prevCoordinates);
                        ballPathIterator.next();
                        animPathIterator.next();
                        block4: while (!ballPathIterator.isDone()) {
                            double[] coordinates = new double[2];
                            int type = ballPathIterator.currentSegment(coordinates);
                            switch (type) {
                                case 1: {
                                    this.ballPaths.getLast().add(new Line2D.Double(prevCoordinates[0], prevCoordinates[1], coordinates[0], coordinates[1]));
                                    prevCoordinates = coordinates;
                                    ballPathIterator.next();
                                    if (ballPathIterator.isDone()) {
                                        animPathIterator.currentSegment(coordinates);
                                        this.arrows.add(new Point2D.Double(coordinates[0], coordinates[1]));
                                        continue block4;
                                    }
                                    animPathIterator.next();
                                    continue block4;
                                }
                            }
                            throw new Error("Unexpected currentSegment!");
                        }
                    }
                    ++i;
                }
                this.initNextPath();
                super.start();
            } else {
                super.start();
                this.callManagersNext();
            }
        }

        public void pause() {
            super.stop();
        }

        public boolean isBuffered() {
            return !this.analyzedPaths.isEmpty();
        }

        public void finalizeIt() {
            if (this.isBuffered()) {
                DebugAnimator.this.elevateAnalyzedPaths(this.analyzedPaths, true);
                this.resetVariables();
                DebugAnimator.this.jPanelDiagram.repaint();
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.resetVariables();
        }

        private void resetVariables() {
            this.analyzedPaths.clear();
            this.completedLines.clear();
            this.lineInProcess = null;
            this.processElevation = 0;
            this.ballPaths.clear();
            this.arrows.clear();
            this.currentPathLength = 0.0;
            this.currentLineStartPointDist = 0.0;
            this.currentLineLength = 0.0;
            this.timePased = 0;
            this.timeToPassWholePath = 0;
            this.completeBegining = true;
            DebugAnimator.this.ball = null;
            if (DebugAnimator.this.ballShineGradient != null) {
                DebugAnimator.this.ballShineGradient = null;
                DebugAnimator.this.reinitSymbols = true;
            }
        }
    }

    private final class DropSceneTimer
    extends Timer {
        private int loopcount;
        private int[] lColorsRow;

        public DropSceneTimer(int targetGrayColor, int loopsCount) {
            super(0, null);
            super.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    DropSceneTimer.this.myActionPerformed();
                }
            });
            this.lColorsRow = new int[loopsCount];
            int backgroundColor = DebugAnimator.this.jPanelDiagram.getBackground().getRed();
            targetGrayColor = backgroundColor - targetGrayColor;
            for (int i = 0; i < loopsCount; ++i) {
                this.lColorsRow[i] = (int)((double)backgroundColor - (double)targetGrayColor * DebugAnimator.this.functionPower3Percentage(i + 1, loopsCount));
            }
        }

        @Override
        public void start() {
            this.loopcount = 0;
            super.start();
        }

        private void myActionPerformed() {
            if (this.loopcount + 1 > this.lColorsRow.length) {
                super.stop();
                return;
            }
            DebugAnimator.this.jPanelDiagram.setBackground(new Color(this.lColorsRow[this.loopcount], this.lColorsRow[this.loopcount], this.lColorsRow[this.loopcount]));
            ++this.loopcount;
        }
    }
}

