/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.debug;

import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public final class DebugSymbol {
    private Symbol symbol;
    private GradientPaint symbolGradient;
    private Color symbolColor;
    private RadialGradientPaint ballShineGradient;
    private double shadeTransX;
    private double shadeTransY;
    private Color shadeColor;
    private TextLayout progressDesc;
    private String progressString;
    private Point2D progressDescPoint;

    public DebugSymbol(Symbol symbol) {
        this(symbol, null, null, 0.0, 0.0, null);
    }

    public DebugSymbol(Symbol symbol, GradientPaint symbolGradient, GradientPaint ballShineGradient) {
        this(symbol, symbolGradient, ballShineGradient, 0.0, 0.0, null);
    }

    public DebugSymbol(Symbol symbol, GradientPaint symbolGradient, GradientPaint ballShineGradient, double shadeTransX, double shadeTransY, Color shadeColor) {
        this.symbol = symbol;
        this.symbolGradient = symbolGradient;
        this.shadeTransX = shadeTransX;
        this.shadeTransY = shadeTransY;
        this.shadeColor = shadeColor;
    }

    public Color getShadeColor() {
        return this.shadeColor;
    }

    public GradientPaint getSymbolGradient() {
        return this.symbolGradient;
    }

    public RadialGradientPaint getBallShineGradient() {
        return this.ballShineGradient;
    }

    public double getShadeTransX() {
        return this.shadeTransX;
    }

    public double getShadeTransY() {
        return this.shadeTransY;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public Color getSymbolColor() {
        return this.symbolColor;
    }

    public TextLayout getProgressDesc() {
        return this.progressDesc;
    }

    public Point2D getProgressDescPoint() {
        return this.progressDescPoint;
    }

    public String getProgressString() {
        return this.progressString;
    }

    public void setProgressString(String progressString) {
        this.progressString = progressString;
    }

    public void setShadeColor(Color shadeColor) {
        this.shadeColor = shadeColor;
    }

    public void setSymbolGradient(GradientPaint symbolGradient) {
        this.symbolGradient = symbolGradient;
    }

    public void setBallShineGradient(RadialGradientPaint ballShineGradient) {
        this.ballShineGradient = ballShineGradient;
    }

    public void setShadeTransX(double shadeTransX) {
        this.shadeTransX = shadeTransX;
    }

    public void setShadeTransY(double shadeTransY) {
        this.shadeTransY = shadeTransY;
    }

    public void setSymbolColor(Color symbolColor) {
        this.symbolColor = symbolColor;
    }

    public void setProgressDesc(TextLayout progressDesc) {
        this.progressDesc = progressDesc;
        if (progressDesc != null) {
            Rectangle2D bounds = progressDesc.getBounds();
            this.progressDescPoint = new Point2D.Double(this.symbol.getCenterX() - bounds.getCenterX(), this.symbol.getY() - bounds.getMaxY() - 1.0);
        } else {
            this.progressDescPoint = null;
        }
    }
}

