/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.debug.function;

import cz.miroslavbartyzal.psdiagram.app.debug.DebugAnimator;
import cz.miroslavbartyzal.psdiagram.app.debug.function.ElementFunctionBed;
import cz.miroslavbartyzal.psdiagram.app.debug.function.FunctionResult;
import cz.miroslavbartyzal.psdiagram.app.debug.function.StepBack;
import cz.miroslavbartyzal.psdiagram.app.debug.function.variables.variableScopes.BlockScopeVariables;
import cz.miroslavbartyzal.psdiagram.app.debug.function.variables.variableScopes.GlobalScopeVariables;
import cz.miroslavbartyzal.psdiagram.app.debug.function.variables.variableScopes.VariablesScope;
import cz.miroslavbartyzal.psdiagram.app.flowchart.FlowchartElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.FlowchartSegment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.Layout;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutSegment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Comment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.For;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Goto;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.GotoLabel;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.StartEnd;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import cz.miroslavbartyzal.psdiagram.app.global.SettingsHolder;
import cz.miroslavbartyzal.psdiagram.app.gui.managers.FlowchartDebugManager;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.geom.Path2D;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingDeque;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;

public final class FunctionManager {
    private final int STACKLIMIT = 1000;
    private Thread launchThread;
    private final FlowchartDebugManager flowchartDebugManager;
    private final JPanel jPanelDiagram;
    private final DebugAnimator animator;
    private final Layout layout;
    private VariablesScope variables;
    private LinkedBlockingDeque<StepBack> stepBacks = new LinkedBlockingDeque(1000);
    private final ArrayList<Symbol> breakpointSymbols = new ArrayList();
    private LayoutElement nextElement = null;
    private LayoutElement actualElement = null;
    private HashMap<Symbol, String> forVarValue = new HashMap();
    private boolean deleteForVar = false;

    public FunctionManager(Layout layout, JPanel jPanelDiagram, JSlider jSliderSpeed, FlowchartDebugManager flowchartDebugManager) {
        this.jPanelDiagram = jPanelDiagram;
        this.layout = layout;
        this.animator = new DebugAnimator(layout, jPanelDiagram, jSliderSpeed, this);
        this.flowchartDebugManager = flowchartDebugManager;
    }

    public void entryAnimMode() {
        this.animator.init();
    }

    public void exitAnimMode() {
        this.stop();
        this.breakpointSymbols.clear();
        this.jPanelDiagram.setBackground(Color.WHITE);
    }

    public void play() {
        this.animator.play();
        if (!this.animator.isPlayBuffered()) {
            this.next();
        }
    }

    public void globalPause() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FunctionManager.this.flowchartDebugManager.actionPerformed(new ActionEvent(this, this.hashCode(), "animation/pause"));
                FunctionManager.this.jPanelDiagram.repaint();
            }
        });
    }

    public boolean pause() {
        if (this.launchThread != null && this.launchThread.isAlive()) {
            this.launchThread.interrupt();
            try {
                this.launchThread.join();
            }
            catch (InterruptedException interruptedException) {}
        } else if (this.animator.isPlaying()) {
            this.animator.pause();
        }
        return !this.stepBacks.isEmpty();
    }

    public void launch() {
        this.launchThread = new Thread(() -> {
            Runnable runnable = new Runnable(){
                private boolean paused = false;

                @Override
                public void run() {
                    if (!this.paused) {
                        this.paused = FunctionManager.this.next().debugShouldBeHalted;
                        if (this.paused) {
                            FunctionManager.this.globalPause();
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            };
            do {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    return;
                }
            } while (this.nextElement != null && !this.isBreakPointReached());
            if (this.isBreakPointReached()) {
                this.globalPause();
            }
        });
        this.launchThread.start();
    }

    public boolean isBreakPointReached() {
        return this.nextElement != null && this.breakpointSymbols.contains(this.nextElement.getSymbol());
    }

    public boolean previous() {
        StepBack stepBack = this.stepBacks.pop();
        this.nextElement = this.actualElement;
        this.actualElement = stepBack.prevElement;
        this.variables.setActualSegment((FlowchartSegment)this.nextElement.getParentSegment());
        this.variables.hackupdateVariables(stepBack.prevVariables);
        this.flowchartDebugManager.updateVariables(stepBack.prevDisplayVariables);
        this.flowchartDebugManager.updateVariables(stepBack.prevPrevDisplayVariables);
        for (Symbol forSymbol : stepBack.prevForValues.keySet()) {
            if (stepBack.prevForValues.get(forSymbol) == null) {
                this.forVarValue.remove(forSymbol);
                continue;
            }
            this.forVarValue.put(forSymbol, stepBack.prevForValues.get(forSymbol));
        }
        this.animator.doPath(this.nextElement.getSymbol(), stepBack.prevProgressDesc, stepBack.paths, stepBack.segmentDesc, false);
        if (!((LayoutElement)this.layout.getFlowchart().getMainSegment().getElement(0)).equals(this.nextElement)) {
            this.animator.setActiveSymbol(this.nextElement.getSymbol());
        } else {
            this.animator.setActiveSymbol(null);
        }
        return !this.stepBacks.isEmpty();
    }

    public NextOutput next() {
        StepBack stepBack = new StepBack();
        Path2D.Double gotoLabelPath = null;
        stepBack.prevElement = this.actualElement;
        if (this.actualElement != null) {
            if (this.actualElement.getSymbol() instanceof Goto && this.nextElement.getSymbol() instanceof GotoLabel) {
                GotoLabel gotoLabel = (GotoLabel)this.nextElement.getSymbol();
                gotoLabelPath = new Path2D.Double();
                ((Path2D)gotoLabelPath).moveTo(gotoLabel.getCenterX() - (double)gotoLabel.getMyHair(), gotoLabel.getCenterY());
                ((Path2D)gotoLabelPath).lineTo(gotoLabel.getCenterX(), gotoLabel.getCenterY());
            }
            this.actualElement = this.nextElement;
        } else {
            this.initVariablesScope();
            this.actualElement = (LayoutElement)this.layout.getFlowchart().getMainSegment().getElement(0);
            if (this.actualElement.getSymbol() instanceof Comment) {
                this.actualElement = (LayoutElement)this.layout.getFlowchart().getMainSegment().getElement(1);
            }
            this.variables.setActualSegment((FlowchartSegment)this.actualElement.getParentSegment());
        }
        HashMap<String, String> allVars = this.variables.getAllVariables();
        if (this.actualElement.getSymbol() instanceof For && this.actualElement.getSymbol().getCommands() != null) {
            if (!this.forVarValue.containsKey(this.actualElement.getSymbol())) {
                if (allVars.containsKey(this.actualElement.getSymbol().getCommands().get("var"))) {
                    allVars.put("0" + this.actualElement.getSymbol().getCommands().get("var"), allVars.remove(this.actualElement.getSymbol().getCommands().get("var")));
                }
                stepBack.prevForValues.put(this.actualElement.getSymbol(), null);
                this.forVarValue.put(this.actualElement.getSymbol(), "");
            } else {
                allVars.put(this.actualElement.getSymbol().getCommands().get("var"), this.forVarValue.get(this.actualElement.getSymbol()));
            }
        }
        FunctionResult functionResult = ElementFunctionBed.getResult(this.actualElement, allVars);
        this.nextElement = functionResult.nextElement;
        if (this.nextElement == null) {
            if (this.actualElement.getSymbol() instanceof StartEnd) {
                this.animator.doPath(this.actualElement.getSymbol(), functionResult.progressDesc, null, null, true);
            }
            this.animator.setActiveSymbol(null);
            this.flowchartDebugManager.animationDone(!this.stepBacks.isEmpty());
            this.stepBacks.addFirst(stepBack);
            return new NextOutput(!this.stepBacks.isEmpty(), functionResult.haltDebug);
        }
        Object updateSegment = this.nextElement.getParentSegment();
        HashMap<String, String> updateDisplayVars = new HashMap<String, String>();
        HashMap<FlowchartSegment, HashMap<String, String>> prevVariables = new HashMap<FlowchartSegment, HashMap<String, String>>();
        if (!functionResult.updatedVariables.isEmpty()) {
            updateDisplayVars.putAll(functionResult.updatedVariables);
            if (this.actualElement.getSymbol() instanceof For) {
                this.variables.setActualSegment((FlowchartSegment)this.actualElement.getInnerSegment(1));
                if (!this.actualElement.equals(this.nextElement) && !((LayoutSegment)this.actualElement.getInnerSegment(1)).equals(updateSegment)) {
                    stepBack.prevForValues.put(this.actualElement.getSymbol(), this.forVarValue.get(this.actualElement.getSymbol()));
                    this.forVarValue.remove(this.actualElement.getSymbol());
                    if (this.deleteForVar) {
                        updateDisplayVars.put(this.actualElement.getSymbol().getCommands().get("var"), "");
                    }
                }
                this.deleteForVar = false;
            }
            prevVariables.putAll(this.variables.updateVariables(functionResult.updatedVariables));
        }
        String forVar = null;
        String forValue = null;
        if (this.nextElement.getSymbol() instanceof For && this.forVarValue.containsKey(this.nextElement.getSymbol()) && !((LayoutSegment)this.nextElement.getInnerSegment(1)).equals(updateSegment)) {
            if (!this.isWithinMe(this.nextElement, this.variables.getActualSegment())) {
                stepBack.prevForValues.put(this.nextElement.getSymbol(), this.forVarValue.get(this.nextElement.getSymbol()));
                this.forVarValue.remove(this.nextElement.getSymbol());
            } else {
                forVar = this.nextElement.getSymbol().getCommands().get("var");
                forValue = this.variables.getSegmentVariables((FlowchartSegment)this.nextElement.getInnerSegment(1)).get(forVar);
                if (forValue == null) {
                    forValue = this.variables.getAllVariables().get(forVar);
                }
                if (!this.actualElement.equals(this.nextElement) || !this.forVarValue.get(this.nextElement.getSymbol()).equals("")) {
                    stepBack.prevForValues.put(this.nextElement.getSymbol(), this.forVarValue.get(this.nextElement.getSymbol()));
                }
                this.forVarValue.put(this.nextElement.getSymbol(), forValue);
            }
        }
        HashMap<FlowchartSegment, HashMap<String, String>> ErasedVars = this.variables.setActualSegment((FlowchartSegment)updateSegment);
        prevVariables.putAll(ErasedVars);
        for (HashMap<String, String> vars : ErasedVars.values()) {
            for (String var : vars.keySet()) {
                updateDisplayVars.put(var, "");
            }
        }
        if (forVar != null && forValue != null && updateDisplayVars.get(forVar) != null && ((String)updateDisplayVars.get(forVar)).equals("")) {
            if (!this.actualElement.equals(this.nextElement)) {
                this.deleteForVar = true;
                updateDisplayVars.remove(forVar);
            } else {
                updateDisplayVars.put(forVar, forValue);
            }
        }
        stepBack.prevPrevDisplayVariables = this.flowchartDebugManager.getLastUpdateVars();
        stepBack.prevDisplayVariables = this.flowchartDebugManager.updateVariables(updateDisplayVars);
        stepBack.prevVariables = prevVariables;
        Path2D[] paths = null;
        if (functionResult.paths != null) {
            if (gotoLabelPath == null) {
                paths = functionResult.paths;
            } else {
                paths = new Path2D[functionResult.paths.length + 1];
                paths[0] = gotoLabelPath;
                for (int i = 1; i < paths.length; ++i) {
                    paths[i] = functionResult.paths[i - 1];
                }
            }
        }
        stepBack.paths = paths;
        stepBack.prevProgressDesc = this.animator.getSymbolProgressDesc(this.actualElement.getSymbol());
        stepBack.segmentDesc = functionResult.segmentDesc;
        if (this.animator.isPlaying()) {
            this.animator.animPath(this.actualElement.getSymbol(), functionResult.progressDesc, paths, functionResult.segmentDesc);
        } else {
            this.animator.doPath(this.actualElement.getSymbol(), functionResult.progressDesc, paths, functionResult.segmentDesc, true);
        }
        this.animator.setActiveSymbol(this.nextElement.getSymbol());
        if (this.stepBacks.size() == 1000) {
            this.stepBacks.removeLast();
        }
        this.stepBacks.addFirst(stepBack);
        return new NextOutput(!this.stepBacks.isEmpty(), functionResult.haltDebug);
    }

    public void stop() {
        if (this.launchThread != null && this.launchThread.isAlive()) {
            this.launchThread.interrupt();
            try {
                this.launchThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SwingUtilities.invokeLater(() -> this.myStop());
        } else {
            this.myStop();
        }
    }

    private void myStop() {
        this.animator.stop();
        this.animator.setActiveSymbol(null);
        this.nextElement = null;
        this.actualElement = null;
        this.forVarValue = new HashMap();
        this.stepBacks = new LinkedBlockingDeque(1000);
    }

    public void toggleBreakpoint(Symbol symbol) {
        if (symbol != null) {
            if (this.breakpointSymbols.contains(symbol)) {
                this.breakpointSymbols.remove(symbol);
            } else {
                this.breakpointSymbols.add(symbol);
            }
            this.jPanelDiagram.repaint();
        }
    }

    public ArrayList<Symbol> getBreakpointSymbols() {
        return this.breakpointSymbols;
    }

    public DebugAnimator getAnimator() {
        return this.animator;
    }

    private boolean isWithinMe(FlowchartElement me, FlowchartSegment segment) {
        if (segment.getParentElement() != null) {
            if (segment.getParentElement().equals(me)) {
                return true;
            }
            return this.isWithinMe(me, (FlowchartSegment)((FlowchartElement)segment.getParentElement()).getParentSegment());
        }
        return false;
    }

    private void initVariablesScope() {
        this.variables = SettingsHolder.settings.isBlockScopeVariables() ? new BlockScopeVariables() : new GlobalScopeVariables();
    }

    public final class NextOutput {
        public boolean stepBacksNotEmpty;
        public boolean debugShouldBeHalted;

        public NextOutput(boolean stepBacksNotEmpty, boolean debugShouldBeHalted) {
            this.stepBacksNotEmpty = stepBacksNotEmpty;
            this.debugShouldBeHalted = debugShouldBeHalted;
        }
    }
}

