/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.debug.function.variables;

import cz.miroslavbartyzal.psdiagram.app.global.AlphanumComparator;
import cz.miroslavbartyzal.psdiagram.app.global.RegexFunctions;
import cz.miroslavbartyzal.psdiagram.app.gui.treeTable.AbstractTreeTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;

public final class VariableNode
implements Comparable<VariableNode> {
    private static final String highlightStart = "<html><span style=\"font-weight:bold;\">";
    private static final String highlightEnd = "</span></html>";
    private String name;
    private String value;
    private VariableNode[] path;
    private TreeSet<VariableNode> children = new TreeSet<VariableNode>(new AlphanumComparator());
    private boolean highlighted = true;

    protected VariableNode(VariableNode[] path, String name, String value) {
        this.path = path;
        this.name = name;
        this.value = value;
        if (path.length == 0) {
            this.highlighted = false;
        }
        this.setArrayChildren(null);
    }

    private void setArrayChildren(AbstractTreeTableModel ttm) {
        String[] childrenValues = RegexFunctions.getBracketElements(this.value);
        Object[] pathForChild = this.getPathForChild();
        TreeMap<Integer, Object> removedNodes = new TreeMap<Integer, Object>();
        int i = 0;
        Iterator<VariableNode> it = this.children.iterator();
        while (it.hasNext()) {
            VariableNode child = it.next();
            if (Integer.valueOf(child.getName().substring(1, child.getName().length() - 1)) > childrenValues.length - 1) {
                removedNodes.put(i, child);
                it.remove();
            }
            ++i;
        }
        if (ttm != null && !removedNodes.isEmpty()) {
            ttm.fireTreeNodesRemoved(this, pathForChild, VariableNode.convertIntegers(removedNodes.keySet()), removedNodes.values().toArray(new VariableNode[0]));
        }
        ArrayList<VariableNode> insertedNodes = new ArrayList<VariableNode>();
        block1: for (i = 0; i < childrenValues.length; ++i) {
            for (VariableNode child : this.children) {
                if (!child.getName().equals("[" + i + "]")) continue;
                if (child.getValue().equals(childrenValues[i])) continue block1;
                child.setValue(childrenValues[i], ttm);
                continue block1;
            }
            VariableNode vn = new VariableNode((VariableNode[])pathForChild, "[" + i + "]", childrenValues[i]);
            this.children.add(vn);
            insertedNodes.add(vn);
        }
        if (ttm != null && !insertedNodes.isEmpty()) {
            int[] insertedChildrenIndexes = new int[insertedNodes.size()];
            int lastIndex = 0;
            i = 0;
            Iterator<VariableNode> it2 = this.children.iterator();
            while (it2.hasNext()) {
                if (insertedNodes.contains(it2.next())) {
                    insertedChildrenIndexes[lastIndex] = i;
                    ++lastIndex;
                }
                ++i;
            }
            ttm.fireTreeNodesInserted(this, pathForChild, insertedChildrenIndexes, insertedNodes.toArray(new VariableNode[0]));
        }
    }

    private VariableNode[] getPathForChild() {
        VariableNode[] pathForChild = new VariableNode[this.path.length + 1];
        System.arraycopy(this.path, 0, pathForChild, 0, this.path.length);
        pathForChild[this.path.length] = this;
        return pathForChild;
    }

    private String setValue(String value, AbstractTreeTableModel ttm) {
        String prevValue = this.value;
        this.value = value;
        this.highlighted = true;
        ttm.fireTreeNodesChanged(this, this.path, new int[]{this.path[this.path.length - 1].getChildIndex(this)}, new VariableNode[]{this});
        this.setArrayChildren(ttm);
        return prevValue;
    }

    private boolean isHighlighted() {
        return this.highlighted;
    }

    private int getChildIndex(VariableNode child) {
        int i = 0;
        Iterator<VariableNode> it = this.children.iterator();
        while (it.hasNext()) {
            if (it.next().equals(child)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int[] convertIntegers(Collection<Integer> integers) {
        int[] ret = new int[integers.size()];
        Iterator<Integer> iterator = integers.iterator();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = iterator.next();
        }
        return ret;
    }

    protected HashMap<String, String> updateVariables(HashMap<String, String> variablesToUpdate, AbstractTreeTableModel ttm) {
        int i;
        HashMap<String, String> previousValues = new HashMap<String, String>();
        TreeMap<Integer, VariableNode> nodesToRemove = new TreeMap<Integer, VariableNode>();
        ArrayList<VariableNode> nodesToInsert = new ArrayList<VariableNode>();
        Object[] pathForChild = this.getPathForChild();
        block0: for (String varName : variablesToUpdate.keySet()) {
            i = 0;
            for (VariableNode child : this.children) {
                if (child.getName().equals(varName)) {
                    if (variablesToUpdate.get(varName).equals("")) {
                        previousValues.put(varName, child.getValue());
                        nodesToRemove.put(i, child);
                        continue block0;
                    }
                    previousValues.put(varName, child.setValue(variablesToUpdate.get(varName), ttm));
                    continue block0;
                }
                ++i;
            }
            if (variablesToUpdate.get(varName).equals("")) continue;
            previousValues.put(varName, "");
            nodesToInsert.add(new VariableNode((VariableNode[])pathForChild, varName, variablesToUpdate.get(varName)));
        }
        if (!nodesToRemove.isEmpty()) {
            for (VariableNode vn : nodesToRemove.values()) {
                this.children.remove(vn);
            }
            ttm.fireTreeNodesRemoved(this, pathForChild, VariableNode.convertIntegers(nodesToRemove.keySet()), nodesToRemove.values().toArray(new VariableNode[0]));
        }
        if (!nodesToInsert.isEmpty()) {
            this.children.addAll(nodesToInsert);
            int[] insertedChildrenIndexes = new int[nodesToInsert.size()];
            int lastIndex = 0;
            i = 0;
            Iterator<VariableNode> it = this.children.iterator();
            while (it.hasNext()) {
                if (nodesToInsert.contains(it.next())) {
                    insertedChildrenIndexes[lastIndex] = i;
                    ++lastIndex;
                }
                ++i;
            }
            ttm.fireTreeNodesInserted(this, pathForChild, insertedChildrenIndexes, nodesToInsert.toArray(new VariableNode[0]));
        }
        return previousValues;
    }

    protected void setHighlightFalse(AbstractTreeTableModel ttm) {
        if (this.highlighted) {
            this.highlighted = false;
            ttm.fireTreeNodesChanged(this, this.path, new int[]{this.path[this.path.length - 1].getChildIndex(this)}, new VariableNode[]{this});
        }
        for (VariableNode child : this.children) {
            if (!child.isHighlighted()) continue;
            child.setHighlightFalse(ttm);
        }
    }

    protected void clearChildren() {
        this.children.clear();
    }

    public VariableNode getChild(int index) {
        Iterator<VariableNode> it = this.children.iterator();
        for (int i = 0; i < index; ++i) {
            it.next();
        }
        return it.next();
    }

    public int getChildCount() {
        return this.children.size();
    }

    public String getNameFormated() {
        if (this.highlighted) {
            return highlightStart + this.name + highlightEnd;
        }
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        if (this.highlighted) {
            return highlightStart + this.value + highlightEnd;
        }
        return this.value;
    }

    public String toString() {
        return this.getNameFormated();
    }

    @Override
    public int compareTo(VariableNode t) {
        return this.name.compareTo(t.name);
    }
}

