/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.flowchart;

import cz.miroslavbartyzal.psdiagram.app.flowchart.FlowchartSegment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.TreeSet;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="flowchartElement")
public abstract class FlowchartElement<S extends FlowchartSegment<S, E>, E extends FlowchartElement<S, E>> {
    @XmlAttribute(name="xmlID", required=true)
    @XmlID
    private String xmlID;
    @XmlAttribute(name="parentSegment", required=true)
    @XmlIDREF
    private S parentSegment;
    @XmlAnyElement(lax=true)
    private Symbol symbol;
    @XmlElement(name="segment", nillable=true)
    private ArrayList<S> lInnerSegments;

    protected FlowchartElement() {
    }

    protected FlowchartElement(S parentSegment, Symbol symbol, int innerOutCount) {
        this.parentSegment = parentSegment;
        this.symbol = symbol;
        if (symbol.getInnerOutsCount() != 0) {
            if (symbol.getInnerOutsCount() != -1) {
                if (symbol.hasElseSegment()) {
                    this.lInnerSegments = new ArrayList(symbol.getInnerOutsCount());
                    for (int i = 0; i < symbol.getInnerOutsCount(); ++i) {
                        this.lInnerSegments.add(null);
                    }
                } else {
                    this.lInnerSegments = new ArrayList(symbol.getInnerOutsCount() + 1);
                    for (int i = 0; i < symbol.getInnerOutsCount() + 1; ++i) {
                        this.lInnerSegments.add(null);
                    }
                }
            } else if (symbol.hasElseSegment() && innerOutCount > 0) {
                this.lInnerSegments = new ArrayList(innerOutCount);
                for (int i = 0; i < innerOutCount; ++i) {
                    this.lInnerSegments.add(null);
                }
            } else if (!symbol.hasElseSegment() && innerOutCount > 0) {
                this.lInnerSegments = new ArrayList(innerOutCount + 1);
                for (int i = 0; i < innerOutCount + 1; ++i) {
                    this.lInnerSegments.add(null);
                }
            } else {
                if (innerOutCount == 0) {
                    throw new Error("You must specify number of inner outs for this symbol!");
                }
                throw new Error("Specified number of inner outs is incorrect!");
            }
        }
    }

    public void addInnerSegment(S segment) {
        if (this.symbol.getInnerOutsCount() != -1) {
            throw new Error("You can not add inner outs for this symbol!");
        }
        this.lInnerSegments.ensureCapacity(this.lInnerSegments.size() + 1);
        this.lInnerSegments.add(segment);
        ((FlowchartSegment)segment).checkIDUniqueness();
    }

    public void setInnerSegment(int index, S segment) {
        if (index > this.lInnerSegments.size() - 1 || index < 0) {
            throw new Error("Specified index is out of innerSegments range!");
        }
        this.lInnerSegments.set(index, segment);
        ((FlowchartSegment)segment).checkIDUniqueness();
    }

    public void removeInnerSegment(S segment) {
        if (this.symbol.getInnerOutsCount() != -1) {
            throw new Error("You can not remove inner outs for this symbol!");
        }
        if (!this.symbol.hasElseSegment() && this.getInnerSegmentsCount() < 2 || this.symbol.hasElseSegment() && this.getInnerSegmentsCount() < 3) {
            throw new Error("You can not remove any more inner outs for this symbol!");
        }
        this.lInnerSegments.remove(segment);
        this.lInnerSegments.trimToSize();
    }

    public S getInnerSegment(int index) {
        return (S)((FlowchartSegment)this.lInnerSegments.get(index));
    }

    public ArrayList<S> getInnerSegments() {
        return this.lInnerSegments;
    }

    public int indexOfInnerSegment(S segment) {
        return this.lInnerSegments.indexOf(segment);
    }

    public int getInnerSegmentsCount() {
        if (this.lInnerSegments == null) {
            return 0;
        }
        return this.lInnerSegments.size();
    }

    public boolean containsInnerSegment(S segment) {
        return this.lInnerSegments.contains(segment);
    }

    void setParentSegment(S parentSegment) {
        this.parentSegment = parentSegment;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public S getParentSegment() {
        return this.parentSegment;
    }

    public void checkIDUniqueness() {
        S mainSegment = this.parentSegment;
        while (((FlowchartSegment)mainSegment).getParentElement() != null) {
            mainSegment = ((FlowchartElement)((FlowchartSegment)mainSegment).getParentElement()).getParentSegment();
        }
        TreeSet<Integer> bookedIDs = new TreeSet<Integer>();
        ((FlowchartSegment)this.parentSegment).getBookedIDs(this, mainSegment, bookedIDs);
        this.checkIDUniqueness(bookedIDs);
    }

    protected final void checkIDUniqueness(TreeSet<Integer> bookedIDs) {
        if (this.xmlID == null || bookedIDs.contains(Integer.valueOf(this.xmlID))) {
            this.xmlID = ((FlowchartSegment)this.parentSegment).getUniqueID(bookedIDs);
        }
        bookedIDs.add(Integer.valueOf(this.xmlID));
        if (this.lInnerSegments != null) {
            for (FlowchartSegment segment : this.lInnerSegments) {
                if (segment == null) continue;
                segment.checkIDUniqueness(bookedIDs);
            }
        }
    }

    protected String getXmlID() {
        return this.xmlID;
    }
}

