/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.flowchart;

import cz.miroslavbartyzal.psdiagram.app.flowchart.FlowchartElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Comment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import cz.miroslavbartyzal.psdiagram.app.global.SettingsHolder;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlType;
import java.awt.font.TextLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="flowchartSegment")
public abstract class FlowchartSegment<S extends FlowchartSegment<S, E>, E extends FlowchartElement<S, E>>
implements Iterable<E> {
    @XmlAttribute(name="xmlID", required=true)
    @XmlID
    private String xmlID;
    @XmlAttribute(name="parentElement", required=true)
    @XmlIDREF
    private E parentElement;
    @XmlElement(name="element")
    private ArrayList<E> lElements = new ArrayList(20);
    private TextLayout descriptionLayout = null;
    private String description = null;
    @XmlElement(name="defaultDescription")
    private String defaultDescription = null;
    @XmlElement(name="customDescription")
    private String customDescription = null;

    protected FlowchartSegment() {
    }

    protected FlowchartSegment(E parentElement) {
        if (parentElement == null) {
            this.xmlID = "0";
        }
        this.parentElement = parentElement;
    }

    protected abstract S getThis();

    public E addElement(E beforeElement, E element) {
        if (beforeElement == null && this.lElements.isEmpty()) {
            this.lElements.add(element);
            ((FlowchartElement)element).setParentSegment(this.getThis());
            ((FlowchartElement)element).checkIDUniqueness();
            return (E)((FlowchartElement)this.lElements.get(0));
        }
        int destIndex = this.lElements.indexOf(beforeElement) + 1;
        if (destIndex < this.lElements.size()) {
            this.offsetPairedCommentIfAdded((FlowchartElement)this.lElements.get(destIndex), element);
        }
        this.lElements.add(destIndex, element);
        ((FlowchartElement)element).setParentSegment(this.getThis());
        ((FlowchartElement)element).checkIDUniqueness();
        return (E)((FlowchartElement)this.lElements.get(destIndex));
    }

    public void moveElement(E elementToMove, E destinationBeforeElement) {
        this.lElements.remove(elementToMove);
        ((FlowchartSegment)((FlowchartElement)destinationBeforeElement).getParentSegment()).addElement(destinationBeforeElement, elementToMove);
    }

    public void removeElement(E element) {
        this.lElements.remove(element);
    }

    public E getElement(int index) {
        return (E)((FlowchartElement)this.lElements.get(index));
    }

    public int indexOfElement(E element) {
        return this.lElements.indexOf(element);
    }

    public int size() {
        return this.lElements.size();
    }

    public boolean isEmpty() {
        return this.lElements.isEmpty();
    }

    public boolean containsElement(E element) {
        return this.lElements.contains(element);
    }

    public E getParentElement() {
        return this.parentElement;
    }

    @XmlElement(name="description")
    public void setDescription(String description) {
        if (description == null || description.equals("")) {
            this.descriptionLayout = null;
            this.description = null;
        } else {
            TextLayout desc;
            this.descriptionLayout = desc = new TextLayout(description, SettingsHolder.SMALL_CODEFONT, SettingsHolder.FONTRENDERCONTEXT);
            this.description = description;
        }
    }

    public TextLayout getDescriptionLayout() {
        return this.descriptionLayout;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCustomDescription() {
        return this.customDescription;
    }

    public String getDefaultDescription() {
        return this.defaultDescription;
    }

    public void setCustomDescription(String customDescription) {
        this.customDescription = customDescription;
    }

    public void setDefaultDescripton(String defaultDescripton) {
        this.defaultDescription = defaultDescripton;
    }

    @Override
    public Iterator<E> iterator() {
        return this.lElements.iterator();
    }

    public void checkIDUniqueness() {
        S mainSegment = this.getThis();
        while (((FlowchartSegment)mainSegment).getParentElement() != null) {
            mainSegment = ((FlowchartElement)((FlowchartSegment)mainSegment).getParentElement()).getParentSegment();
        }
        TreeSet<Integer> bookedIDs = new TreeSet<Integer>();
        this.getBookedIDs(this, mainSegment, bookedIDs);
        this.checkIDUniqueness(bookedIDs);
    }

    protected final void checkIDUniqueness(TreeSet<Integer> bookedIDs) {
        if (this.xmlID == null || bookedIDs.contains(Integer.valueOf(this.xmlID))) {
            this.xmlID = this.getUniqueID(bookedIDs);
        }
        bookedIDs.add(Integer.valueOf(this.xmlID));
        for (FlowchartElement element : this.lElements) {
            element.checkIDUniqueness(bookedIDs);
        }
    }

    protected final void getBookedIDs(Object exception, S segment, TreeSet<Integer> bookedSetToSave) {
        if (((FlowchartSegment)segment).getXmlID() == null || exception != null && segment.equals(exception)) {
            return;
        }
        bookedSetToSave.add(Integer.valueOf(((FlowchartSegment)segment).getXmlID()));
        for (FlowchartElement element : segment) {
            if (exception != null && element.equals(exception)) continue;
            bookedSetToSave.add(Integer.valueOf(element.getXmlID()));
            if (element.getInnerSegments() == null) continue;
            for (FlowchartSegment innerSegment : element.getInnerSegments()) {
                if (innerSegment == null) continue;
                this.getBookedIDs(exception, innerSegment, bookedSetToSave);
            }
        }
    }

    protected final String getUniqueID(TreeSet<Integer> bookedIDs) {
        for (int i = 0; i <= Integer.MAX_VALUE; ++i) {
            if (bookedIDs.contains(i)) continue;
            return String.valueOf(i);
        }
        return null;
    }

    protected String getXmlID() {
        return this.xmlID;
    }

    private void offsetPairedCommentIfAdded(E afterElement, E element) {
        Symbol symbol = ((FlowchartElement)element).getSymbol();
        if (symbol.hasPairSymbol() && symbol instanceof Comment) {
            double afterElementWidth = ((FlowchartElement)afterElement).getSymbol().getWidth();
            afterElementWidth = Math.floor(afterElementWidth / 2.0);
            Comment comment = (Comment)symbol;
            comment.setCenterX(comment.getCenterX() + afterElementWidth);
            comment.setRelativeX(comment.getRelativeX() + afterElementWidth);
        }
    }
}

