/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.flowchart.layouts;

import cz.miroslavbartyzal.psdiagram.app.flowchart.Flowchart;
import cz.miroslavbartyzal.psdiagram.app.flowchart.FlowchartSegment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.Layout;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutSegment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Comment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.EnumSymbol;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Goto;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.GotoLabel;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Joint;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.LoopEnd;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.StartEnd;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public abstract class AbstractLayout
implements Layout {
    public static int flowchartPadding = 15;
    private int symbolPadding = 14;
    private int arrowLength = 12;
    private boolean editMode = true;
    private final Color pathColor = Color.BLACK;
    private final Color shadowColor = new Color(0, 0, 0, 100);
    private final BasicStroke commentStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{10.0f, 5.0f}, 0.0f);
    private final BasicStroke commentBoldStroke = new BasicStroke(4.0f, 0, 1, 10.0f, new float[]{10.0f, 5.0f}, 0.0f);
    private final BasicStroke highlightStroke;
    private final BasicStroke gotoStroke = this.highlightStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{4.0f, 4.0f}, 0.0f);
    private Flowchart<LayoutSegment, LayoutElement> flowchart;
    private JComponent canvas;
    private ArrayList<Joint> lJoints = new ArrayList(30);
    private LayoutElement focusedElement = null;
    private Joint focusedJoint = null;
    private Comment boldPathComment = null;
    private boolean focusJointOnly = false;
    private boolean noFocusPaint = false;

    public AbstractLayout(JComponent canvas) {
        this(canvas, null);
    }

    public AbstractLayout(JComponent canvas, Flowchart<LayoutSegment, LayoutElement> flowchart) {
        this.canvas = canvas;
        if (flowchart != null) {
            this.flowchart = flowchart;
        } else {
            this.flowchart = new Flowchart(new LayoutSegment(null));
            this.focusedElement = this.flowchart.getMainSegment().addSymbol(null, EnumSymbol.STARTEND.getInstance("Za\u010d\u00e1tek"));
            this.flowchart.getMainSegment().addSymbol(this.focusedElement, EnumSymbol.STARTEND.getInstance("Konec"));
        }
        this.focusedElement = null;
    }

    @Override
    public abstract ArrayList<JMenuItem> getSettings();

    @Override
    public abstract double getHeight();

    @Override
    public abstract double getWidth();

    public abstract void prepareMyFlowchart();

    @Override
    public void prepareFlowchart() {
        this.prepareMyFlowchart();
        for (Joint joint : this.lJoints) {
            if (!joint.getParentElement().equals(this.focusedJoint.getParentElement()) || !joint.getParentSegment().equals(this.focusedJoint.getParentSegment())) continue;
            this.focusedJoint = joint;
            return;
        }
    }

    @Override
    public abstract Path2D getCommentPathFromRelative(Comment var1, Symbol var2);

    @Override
    public abstract ArrayList<Comment> getlCommentSymbols();

    @Override
    public void paintFlowchart(Graphics2D g2d, boolean clipShadow) {
        ArrayList<Path2D> lCommentsPaths = new ArrayList<Path2D>();
        ArrayList<Path2D> lGotoPaths = new ArrayList<Path2D>();
        ArrayList<LayoutElement> lCommentElements = new ArrayList<LayoutElement>();
        g2d.setColor(this.pathColor);
        for (Object segment : this.getFlowchart()) {
            if (segment == null) continue;
            this.drawPath(g2d, ((LayoutSegment)segment).getPathToThisSegment());
            if (((FlowchartSegment)segment).getDescriptionLayout() != null) {
                ((FlowchartSegment)segment).getDescriptionLayout().draw(g2d, (float)((LayoutSegment)segment).getDescriptionLocation().getX(), (float)((LayoutSegment)segment).getDescriptionLocation().getY());
            }
            boolean lastGoto = false;
            Iterator iterator = ((FlowchartSegment)segment).iterator();
            while (iterator.hasNext()) {
                boolean EndStartEnd;
                LayoutElement element = (LayoutElement)iterator.next();
                if (element.getSymbol() instanceof Comment) {
                    lCommentElements.add(element);
                } else {
                    this.drawSymbol(g2d, element.getSymbol(), element, clipShadow);
                }
                boolean bl = EndStartEnd = element.getSymbol() instanceof StartEnd && (((LayoutSegment)element.getParentSegment()).getParentElement() != null || ((LayoutSegment)element.getParentSegment()).indexOfElement(element) > 1 || ((LayoutSegment)element.getParentSegment()).indexOfElement(element) == 1 && !(((LayoutElement)((LayoutSegment)element.getParentSegment()).getElement(0)).getSymbol() instanceof Comment));
                if (!(element.getSymbol() instanceof Comment || element.getSymbol() instanceof Goto || EndStartEnd)) {
                    this.drawPath(g2d, element.getPathToNextSymbol());
                    lastGoto = false;
                    continue;
                }
                if (element.getSymbol() instanceof Goto || EndStartEnd) {
                    lGotoPaths.add(element.getPathToNextSymbol());
                    lastGoto = true;
                    continue;
                }
                if (element.getSymbol().equals(this.boldPathComment)) continue;
                lCommentsPaths.add(element.getPathToNextSymbol());
            }
            if (!lastGoto) {
                this.drawPath(g2d, ((LayoutSegment)segment).getPathFromThisSegment());
                continue;
            }
            lGotoPaths.add(((LayoutSegment)segment).getPathFromThisSegment());
        }
        if (lGotoPaths.size() > 0) {
            Iterator stroke = g2d.getStroke();
            g2d.setColor(new Color(200, 200, 200));
            g2d.setStroke(this.gotoStroke);
            for (Path2D path : lGotoPaths) {
                g2d.draw(path);
            }
            g2d.setColor(this.pathColor);
            g2d.setStroke((Stroke)((Object)stroke));
        }
        if (this.editMode) {
            for (Joint joint : this.lJoints) {
                this.drawSymbol(g2d, joint, null, clipShadow);
            }
        }
        if (lCommentsPaths.size() > 0) {
            g2d.setStroke(this.commentStroke);
            for (Path2D path : lCommentsPaths) {
                g2d.draw(path);
            }
        }
        if (lCommentElements.size() > 0) {
            g2d.setStroke(new BasicStroke(1.0f));
            for (LayoutElement commentElement : lCommentElements) {
                if (commentElement.getSymbol().equals(this.boldPathComment)) {
                    g2d.setStroke(this.commentBoldStroke);
                    g2d.draw(commentElement.getPathToNextSymbol());
                    g2d.setStroke(new BasicStroke(1.0f));
                }
                this.drawSymbol(g2d, commentElement.getSymbol(), commentElement, clipShadow);
            }
        }
        if (this.editMode && !this.focusJointOnly && !this.noFocusPaint) {
            Symbol focused = this.focusedElement != null ? this.focusedElement.getSymbol() : this.focusedJoint;
            double focusedWidth = focused.getWidth();
            if (focused instanceof GotoLabel) {
                focusedWidth /= 2.0;
            }
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.setStroke(this.highlightStroke);
            g2d.draw(new Rectangle2D.Double(focused.getX() - 5.0, focused.getY() - 4.0, focusedWidth + 10.0, focused.getHeight() + 8.0));
            g2d.setColor(this.pathColor);
        }
    }

    void drawSymbol(Graphics2D g2d, Symbol symbol, LayoutElement element, boolean clipShadow) {
        Color borderColor;
        Color shapeDownColor;
        Color shapeUpColor;
        AffineTransform af = g2d.getTransform();
        if (!symbol.areCommandsValid() && EnumSymbol.getEnumSymbol(symbol.getClass()).areAllCommandsPresent(element)) {
            shapeUpColor = symbol.getErrorShapeUpColor();
            shapeDownColor = symbol.getErrorShapeDownColor();
            borderColor = symbol.getErrorBorderColor();
        } else {
            shapeUpColor = symbol.getShapeUpColor();
            shapeDownColor = symbol.getShapeDownColor();
            borderColor = symbol.getBorderColor();
        }
        if (this.editMode && element != null && !this.focusJointOnly && !this.noFocusPaint && !(symbol instanceof Comment) && (element.equals(this.focusedElement) || this.focusedElement == null && this.focusedJoint != null && element.equals(this.focusedJoint.getParentElement())) || symbol.equals(this.focusedJoint) && !this.noFocusPaint) {
            if (symbol.areCommandsValid() || !EnumSymbol.getEnumSymbol(symbol.getClass()).areAllCommandsPresent(element)) {
                shapeUpColor = Layout.FOCUSED_UP_COLOR;
                shapeDownColor = Layout.FOCUSED_DOWN_COLOR;
            }
            if (symbol.getShapeUpColor() == null) {
                borderColor = Layout.FOCUSED_UP_COLOR;
            }
        }
        if (symbol.getShapeUpColor() != null) {
            if (symbol.hasShadow()) {
                g2d.setColor(this.shadowColor);
                if (clipShadow) {
                    Area outside = new Area(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
                    outside.subtract(new Area(symbol.getShape()));
                    g2d.setClip(outside);
                }
                g2d.translate(2, 2);
                g2d.fill(symbol.getShape());
                if (clipShadow) {
                    g2d.setClip(null);
                }
                g2d.setTransform(af);
            }
            if (symbol.getShapeUpColor().equals(symbol.getShapeDownColor())) {
                g2d.setColor(shapeUpColor);
            } else if (!(symbol instanceof GotoLabel)) {
                g2d.setPaint(new GradientPaint((float)(symbol.getX() + symbol.getWidth() * 0.25), (float)symbol.getY(), shapeUpColor, (float)(symbol.getX() + symbol.getWidth() * 0.75), (float)(symbol.getY() + symbol.getHeight()), shapeDownColor));
            } else {
                GotoLabel gotoLabel = (GotoLabel)symbol;
                g2d.setPaint(new GradientPaint((float)(gotoLabel.getX() + (gotoLabel.getWidth() / 2.0 - (double)gotoLabel.getMyHair()) * 0.25), (float)gotoLabel.getY(), shapeUpColor, (float)(gotoLabel.getX() + (gotoLabel.getWidth() / 2.0 - (double)gotoLabel.getMyHair()) * 0.75), (float)(gotoLabel.getY() + gotoLabel.getHeight()), shapeDownColor));
            }
            g2d.fill(symbol.getShape());
        } else if (symbol.hasShadow()) {
            g2d.setColor(this.shadowColor);
            g2d.translate(1, 1);
            g2d.draw(symbol.getShape());
            g2d.setTransform(af);
        }
        g2d.setColor(borderColor);
        g2d.draw(symbol.getShape());
        for (int i = 0; i < symbol.getTextLayoutLines().size(); ++i) {
            Point2D p = symbol.getTextLayoutOrigins().get(i);
            symbol.getTextLayoutLines().get(i).draw(g2d, (float)p.getX(), (float)p.getY());
        }
        g2d.setColor(this.pathColor);
    }

    private void drawPath(Graphics2D g2d, Path2D path) {
        Path2D[] newPath = this.shouldBeArrow(path);
        g2d.draw(newPath[0]);
        if (newPath[1] != null) {
            g2d.fill(newPath[1]);
        }
    }

    @Override
    public Path2D[] shouldBeArrow(Path2D path) {
        Path2D.Double newPath = new Path2D.Double(path.getWindingRule());
        Path2D[] retPath = new Path2D[]{newPath, null};
        PathIterator pathIterator = path.getPathIterator(null);
        double resultX = 0.0;
        double resultY = 0.0;
        double[] previousCoordinates = new double[2];
        while (!pathIterator.isDone()) {
            double[] coordinates = new double[2];
            int type = pathIterator.currentSegment(coordinates);
            pathIterator.next();
            switch (type) {
                case 0: {
                    ((Path2D)newPath).moveTo(coordinates[0], coordinates[1]);
                    break;
                }
                case 1: {
                    try {
                        resultX += coordinates[0] - previousCoordinates[0];
                        resultY += coordinates[1] - previousCoordinates[1];
                        if (pathIterator.isDone() && (resultX < -1.0E-4 || resultY < -1.0E-4)) {
                            double lengthX = coordinates[0] - previousCoordinates[0];
                            double lengthY = coordinates[1] - previousCoordinates[1];
                            double length = Math.sqrt(Math.pow(lengthX, 2.0) + Math.pow(lengthY, 2.0));
                            ((Path2D)newPath).lineTo(coordinates[0] - lengthX / length * (double)(this.arrowLength - 1), coordinates[1] - lengthY / length * (double)(this.arrowLength - 1));
                            double angleL = Math.atan2(previousCoordinates[0] - coordinates[0], previousCoordinates[1] - coordinates[1]);
                            Path2D.Double arrow = new Path2D.Double();
                            ((Path2D)arrow).moveTo(coordinates[0] + Math.sin(angleL + 0.3) * (double)this.arrowLength, coordinates[1] + Math.cos(angleL + 0.3) * (double)this.arrowLength);
                            ((Path2D)arrow).lineTo(coordinates[0], coordinates[1]);
                            ((Path2D)arrow).lineTo(coordinates[0] + Math.sin(angleL - 0.3) * (double)this.arrowLength, coordinates[1] + Math.cos(angleL - 0.3) * (double)this.arrowLength);
                            retPath[1] = arrow;
                            break;
                        }
                        ((Path2D)newPath).lineTo(coordinates[0], coordinates[1]);
                        break;
                    }
                    catch (NullPointerException e) {
                        throw new Error("NullPointerException: " + e.getMessage());
                    }
                }
                default: {
                    throw new Error("Unexpected currentSegment!");
                }
            }
            if (pathIterator.isDone()) continue;
            previousCoordinates = coordinates;
        }
        return retPath;
    }

    @Override
    public LayoutElement addNewSymbol(Symbol symbol, int innerOutCount) {
        LayoutElement element;
        this.setFocusPaintToDefault();
        if (symbol instanceof Comment) {
            if (symbol.hasPairSymbol() && this.focusedElement != null) {
                int indexOfFocusedElement = ((LayoutSegment)this.focusedElement.getParentSegment()).indexOfElement(this.focusedElement);
                if (this.focusedElement.getSymbol() instanceof Comment || indexOfFocusedElement - 1 >= 0 && ((LayoutElement)((LayoutSegment)this.focusedElement.getParentSegment()).getElement(indexOfFocusedElement - 1)).getSymbol() instanceof Comment && ((LayoutElement)((LayoutSegment)this.focusedElement.getParentSegment()).getElement(indexOfFocusedElement - 1)).getSymbol().hasPairSymbol()) {
                    symbol.setHasPairSymbol(false);
                    element = this.focusedJoint.getParentSegment().addSymbol(this.focusedJoint.getParentElement(), symbol, innerOutCount);
                } else {
                    element = indexOfFocusedElement - 1 >= 0 ? ((LayoutSegment)this.focusedElement.getParentSegment()).addSymbol((LayoutElement)((LayoutSegment)this.focusedElement.getParentSegment()).getElement(indexOfFocusedElement - 1), symbol, innerOutCount) : ((LayoutSegment)this.focusedElement.getParentSegment()).addSymbol((LayoutElement)((LayoutSegment)this.focusedElement.getParentSegment()).getParentElement(), symbol, innerOutCount);
                }
            } else {
                symbol.setHasPairSymbol(false);
                element = this.focusedJoint.getParentSegment().addSymbol(this.focusedJoint.getParentElement(), symbol, innerOutCount);
            }
        } else {
            if (symbol instanceof LoopEnd) {
                return this.focusedJoint.getParentSegment().addSymbol(this.focusedJoint.getParentElement(), symbol, innerOutCount);
            }
            element = this.focusedJoint.getParentSegment().addSymbol(this.focusedJoint.getParentElement(), symbol, innerOutCount);
        }
        this.prepareMyFlowchart();
        this.setFocusedElement(element);
        return element;
    }

    @Override
    public LayoutElement addNewSymbol(Symbol symbol) {
        return this.addNewSymbol(symbol, 0);
    }

    @Override
    public void addElements(ArrayList<LayoutElement> elements) {
        this.setFocusPaintToDefault();
        if (elements.size() == 1 && elements.get(0).getSymbol() instanceof Comment) {
            if (this.focusedElement != null) {
                elements.get(0).getSymbol().setHasPairSymbol(true);
            } else {
                elements.get(0).getSymbol().setHasPairSymbol(false);
            }
            this.addNewSymbol(elements.get(0).getSymbol(), 0);
            return;
        }
        LayoutElement parentElement = this.focusedJoint.getParentElement();
        LayoutSegment segment = this.focusedJoint.getParentSegment();
        for (int i = 0; i < elements.size(); ++i) {
            parentElement = segment.addElement(parentElement, elements.get(i));
        }
        this.prepareMyFlowchart();
        this.setFocusedElement(elements.get(elements.size() - 1));
    }

    @Override
    public void moveElement(LayoutElement elementToMove, LayoutElement destinationBeforeElement) {
        ((LayoutSegment)elementToMove.getParentSegment()).moveElement(elementToMove, destinationBeforeElement);
        this.prepareMyFlowchart();
        this.setFocusedElement(elementToMove);
    }

    @Override
    public void removeElement(LayoutElement element) {
        int elementIndex = this.myRemoveElement(element);
        if (elementIndex < 0) {
            return;
        }
        LayoutSegment parentSegment = (LayoutSegment)element.getParentSegment();
        LayoutElement elmet = parentSegment.isEmpty() ? (LayoutElement)parentSegment.getParentElement() : (elementIndex < parentSegment.size() ? (LayoutElement)parentSegment.getElement(elementIndex) : (LayoutElement)parentSegment.getElement(elementIndex - 1));
        this.setFocusedElement(elmet);
    }

    @Override
    public void removeElementFocusItsJoint(LayoutElement element) {
        int elementIndex = this.myRemoveElement(element);
        if (elementIndex < 0) {
            return;
        }
        LayoutSegment parentSegment = (LayoutSegment)element.getParentSegment();
        LayoutElement elmet = parentSegment.isEmpty() || elementIndex == 0 ? (LayoutElement)parentSegment.getParentElement() : (LayoutElement)parentSegment.getElement(elementIndex - 1);
        for (Joint joint : this.lJoints) {
            if (!joint.getParentElement().equals(elmet) || !joint.getParentSegment().equals(parentSegment)) continue;
            this.setFocusedJoint(joint);
        }
    }

    @Override
    public void setFocusJointOnly() {
        this.focusedElement = null;
        this.focusJointOnly = true;
        this.noFocusPaint = false;
    }

    @Override
    public void setNoFocusPaint() {
        this.noFocusPaint = true;
    }

    @Override
    public void setFocusPaintToDefault() {
        this.focusJointOnly = false;
        this.noFocusPaint = false;
    }

    private int myRemoveElement(LayoutElement element) {
        if (((LayoutSegment)element.getParentSegment()).getParentElement() == null && (((LayoutSegment)element.getParentSegment()).indexOfElement(element) + 1 == ((LayoutSegment)element.getParentSegment()).size() || ((LayoutSegment)element.getParentSegment()).indexOfElement(element) == 0 && element.getSymbol() instanceof StartEnd)) {
            return -1;
        }
        LayoutSegment parentSegment = (LayoutSegment)element.getParentSegment();
        ArrayList<LayoutElement> arrElementToDelete = this.getMeAndMyDependants(element);
        int elementIndex = parentSegment.indexOfElement(arrElementToDelete.get(0));
        for (int i = elementIndex - 1; i >= 0 && arrElementToDelete.contains(parentSegment.getElement(i)); --i) {
        }
        for (LayoutElement elm : arrElementToDelete) {
            parentSegment.removeElement(elm);
        }
        this.prepareMyFlowchart();
        return elementIndex;
    }

    @Override
    public ArrayList<LayoutElement> getMeAndMyDependants(LayoutElement element) {
        ArrayList<LayoutElement> arr = new ArrayList<LayoutElement>();
        LayoutSegment parentSegment = (LayoutSegment)element.getParentSegment();
        int elementIndex = parentSegment.indexOfElement(element);
        if (!(element.getSymbol() instanceof Comment)) {
            int i;
            for (i = elementIndex - 1; i >= 0 && ((LayoutElement)parentSegment.getElement(i)).getSymbol().hasPairSymbol(); --i) {
                arr.add(0, (LayoutElement)parentSegment.getElement(i));
            }
            arr.add(element);
            if (element.getSymbol().hasPairSymbol()) {
                for (i = elementIndex + 1; i < parentSegment.size() && ((LayoutElement)parentSegment.getElement(i)).getSymbol().hasPairSymbol(); ++i) {
                    arr.add((LayoutElement)parentSegment.getElement(i));
                }
                arr.add((LayoutElement)parentSegment.getElement(i));
            }
        } else {
            arr.add(element);
        }
        return arr;
    }

    @Override
    public void setBoldPathComment(Comment boldPathComment) {
        this.boldPathComment = boldPathComment;
    }

    @Override
    public Comment getBoldPathComment() {
        return this.boldPathComment;
    }

    @Override
    public LayoutElement findMyPairedElement(LayoutElement element) {
        if (element.getSymbol().hasPairSymbol()) {
            for (int i = ((LayoutSegment)element.getParentSegment()).indexOfElement(element) + 1; i < ((LayoutSegment)element.getParentSegment()).size(); ++i) {
                LayoutElement pairedElement = (LayoutElement)((LayoutSegment)element.getParentSegment()).getElement(i);
                if (!(element.getSymbol() instanceof Comment) && pairedElement.getSymbol().hasPairSymbol()) continue;
                return pairedElement;
            }
        } else {
            for (int i = ((LayoutSegment)element.getParentSegment()).indexOfElement(element) - 1; i >= 0; --i) {
                LayoutElement pairedElement = (LayoutElement)((LayoutSegment)element.getParentSegment()).getElement(i);
                if (pairedElement.getSymbol() instanceof Comment || !pairedElement.getSymbol().hasPairSymbol()) continue;
                return pairedElement;
            }
        }
        return null;
    }

    @Override
    public Symbol findMyPairedSymbol(Symbol symbol) {
        LayoutElement element = this.findMyElement(symbol);
        if (element != null) {
            return this.findMyPairedElement(element).getSymbol();
        }
        return null;
    }

    @Override
    public LayoutElement findMyElement(Symbol symbol) {
        for (LayoutSegment segment : this.flowchart) {
            if (segment == null) continue;
            for (LayoutElement element : segment) {
                if (!element.getSymbol().equals(symbol)) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    public Flowchart<LayoutSegment, LayoutElement> getFlowchart() {
        return this.flowchart;
    }

    @Override
    public void setFlowchart(Flowchart<LayoutSegment, LayoutElement> flowchart) {
        if (flowchart != null) {
            this.flowchart = flowchart;
        } else {
            this.flowchart = new Flowchart(new LayoutSegment(null));
            this.focusedElement = this.flowchart.getMainSegment().addSymbol(null, EnumSymbol.STARTEND.getInstance("Za\u010d\u00e1tek"));
            this.flowchart.getMainSegment().addSymbol(this.focusedElement, EnumSymbol.STARTEND.getInstance("Konec"));
        }
        this.focusedElement = null;
        this.prepareMyFlowchart();
        this.setFocusedJoint(this.getlJoints().get(0));
    }

    @Override
    public int getArrowLength() {
        return this.arrowLength;
    }

    @Override
    public void setArrowLength(int arrowLength) {
        this.arrowLength = arrowLength;
    }

    @Override
    public int getFlowchartPadding() {
        return flowchartPadding;
    }

    @Override
    public int getSymbolPadding() {
        return this.symbolPadding;
    }

    JComponent getCanvas() {
        return this.canvas;
    }

    @Override
    public ArrayList<Joint> getlJoints() {
        return this.lJoints;
    }

    @Override
    public boolean getEditMode() {
        return this.editMode;
    }

    @Override
    public void setFlowchartPadding(int flowchartPadding) {
        AbstractLayout.flowchartPadding = flowchartPadding;
        this.prepareFlowchart();
    }

    @Override
    public void setSymbolPadding(int symbolPadding) {
        this.symbolPadding = symbolPadding;
        this.prepareFlowchart();
    }

    void setlJoints(ArrayList<Joint> lJoints) {
        this.lJoints = lJoints;
    }

    private Joint findMeJoint(LayoutElement element) {
        return this.findMeJoint(element, false, false, true);
    }

    private Joint findMeJoint(LayoutElement element, boolean reverse, boolean upDirection, boolean firstDirection) {
        Joint j = null;
        for (Joint joint : this.lJoints) {
            if (joint.getParentElement() != element) continue;
            if (!(reverse || element.getInnerSegmentsCount() >= 2 && element.getInnerSegment(0) != null && ((LayoutSegment)element.getInnerSegment(0)).equals(joint.getParentSegment()))) {
                return joint;
            }
            j = joint;
        }
        if (j != null) {
            return j;
        }
        if (((LayoutSegment)element.getParentSegment()).size() > 1) {
            int elementIndex = ((LayoutSegment)element.getParentSegment()).indexOfElement(element);
            if (!upDirection) {
                if (elementIndex + 1 < ((LayoutSegment)element.getParentSegment()).size()) {
                    return this.findMeJoint((LayoutElement)((LayoutSegment)element.getParentSegment()).getElement(elementIndex + 1), true, upDirection, firstDirection);
                }
                if (firstDirection && elementIndex - 1 >= 0) {
                    return this.findMeJoint((LayoutElement)((LayoutSegment)element.getParentSegment()).getElement(elementIndex - 1), true, !upDirection, !firstDirection);
                }
            } else {
                if (elementIndex - 1 >= 0) {
                    return this.findMeJoint((LayoutElement)((LayoutSegment)element.getParentSegment()).getElement(elementIndex - 1), true, upDirection, firstDirection);
                }
                if (firstDirection && elementIndex + 1 < ((LayoutSegment)element.getParentSegment()).size()) {
                    return this.findMeJoint((LayoutElement)((LayoutSegment)element.getParentSegment()).getElement(elementIndex + 1), true, !upDirection, !firstDirection);
                }
            }
        }
        return this.findMeJoint((LayoutElement)((LayoutSegment)element.getParentSegment()).getParentElement());
    }

    @Override
    public void setFocusedElement(LayoutElement focusedElement) {
        this.focusedElement = focusedElement;
        this.focusedJoint = this.findMeJoint(focusedElement);
    }

    @Override
    public LayoutElement getFocusedElement() {
        return this.focusedElement;
    }

    @Override
    public void setFocusedJoint(Joint focusedJoint) {
        if (this.lJoints.contains(focusedJoint)) {
            this.focusedJoint = focusedJoint;
        } else {
            for (Joint joint : this.lJoints) {
                if (!joint.getParentElement().equals(focusedJoint.getParentElement()) || !joint.getParentSegment().equals(focusedJoint.getParentSegment())) continue;
                this.focusedJoint = joint;
                break;
            }
        }
        this.focusedElement = null;
    }

    @Override
    public Joint getFocusedJoint() {
        if (this.focusedElement == null) {
            return this.focusedJoint;
        }
        return null;
    }

    @Override
    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    @Override
    public BasicStroke getGotoStroke() {
        return this.gotoStroke;
    }

    @Override
    public BasicStroke getCommentStroke() {
        return this.commentStroke;
    }
}

