/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.flowchart.layouts;

import cz.miroslavbartyzal.psdiagram.app.flowchart.FlowchartElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutSegment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;

@XmlRootElement(name="layoutElement")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="layoutElement")
public final class LayoutElement
extends FlowchartElement<LayoutSegment, LayoutElement> {
    private ArrayList<Integer> extraLayoutData = new ArrayList(1);
    private Path2D pathToNextSymbol = new Path2D.Double(1, 4);

    private LayoutElement() {
    }

    public LayoutElement(LayoutSegment parentSegment, Symbol symbol) {
        this(parentSegment, symbol, 0);
    }

    public LayoutElement(LayoutSegment parentSegment, Symbol symbol, int innerOutCount) {
        super(parentSegment, symbol, innerOutCount);
        if (symbol.getInnerOutsCount() != 0) {
            int i;
            if (symbol.getInnerOutsCount() != -1) {
                if (symbol.hasElseSegment()) {
                    for (i = 0; i < symbol.getInnerOutsCount(); ++i) {
                        super.setInnerSegment(i, new LayoutSegment(this));
                    }
                } else {
                    for (i = 1; i < symbol.getInnerOutsCount() + 1; ++i) {
                        super.setInnerSegment(i, new LayoutSegment(this));
                    }
                }
            } else if (symbol.hasElseSegment() && innerOutCount > 0) {
                for (i = 0; i < innerOutCount; ++i) {
                    super.setInnerSegment(i, new LayoutSegment(this));
                }
            } else if (!symbol.hasElseSegment() && innerOutCount > 0) {
                for (i = 1; i < innerOutCount + 1; ++i) {
                    super.setInnerSegment(i, new LayoutSegment(this));
                }
            } else {
                if (innerOutCount == 0) {
                    throw new Error("You must specify number of inner outs for this symbol!");
                }
                throw new Error("Specified number of inner outs is incorrect!");
            }
            for (i = 0; i < symbol.getDefaultSegmentDescriptions().length; ++i) {
                ((LayoutSegment)this.getInnerSegment(i)).setDescription(symbol.getDefaultSegmentDescriptions()[i]);
            }
        }
    }

    public int getExtraLayoutData(int index) {
        return this.extraLayoutData.get(index);
    }

    public void setExtraLayoutData(int index, int data) {
        while (index >= this.extraLayoutData.size()) {
            this.extraLayoutData.add(0);
        }
        this.extraLayoutData.set(index, data);
    }

    public void clearExtraData() {
        this.extraLayoutData.clear();
    }

    public void setPathToNextSymbol(Path2D path) {
        this.pathToNextSymbol = path;
    }

    public Path2D getPathToNextSymbol() {
        return this.pathToNextSymbol;
    }

    public int SizeOfPathToNextSymbol() {
        PathIterator pathIterator = this.pathToNextSymbol.getPathIterator(null);
        int i = 0;
        while (!pathIterator.isDone()) {
            pathIterator.next();
            ++i;
        }
        return i;
    }

    public int[] getPathFromMainSegment() {
        return this.getPathFromMainSegment(new int[1], 1);
    }

    protected int[] getPathFromMainSegment(int[] path, int depth) {
        if (depth == 0) {
            depth = 1;
        }
        int[] retPath = ((LayoutSegment)super.getParentSegment()).getPathFromMainSegment(new int[path.length + 1], depth + 1);
        retPath[retPath.length - depth] = ((LayoutSegment)super.getParentSegment()).indexOfElement(this);
        return retPath;
    }
}

