/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.flowchart.layouts;

import cz.miroslavbartyzal.psdiagram.app.flowchart.FlowchartSegment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Comment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlType;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="layoutSegment")
public final class LayoutSegment
extends FlowchartSegment<LayoutSegment, LayoutElement> {
    private ArrayList<Integer> extraLayoutData = new ArrayList(2);
    private Path2D pathToThisSegment = new Path2D.Double(1, 2);
    private Path2D pathFromThisSegment = new Path2D.Double(1, 5);
    private Point2D descriptionLocation = null;

    private LayoutSegment() {
    }

    public LayoutSegment(LayoutElement parentElement) {
        super(parentElement);
    }

    @Override
    protected LayoutSegment getThis() {
        return this;
    }

    public int getExtraLayoutData(int index) {
        return this.extraLayoutData.get(index);
    }

    public void setExtraLayoutData(int index, int data) {
        while (index >= this.extraLayoutData.size()) {
            this.extraLayoutData.add(0);
        }
        this.extraLayoutData.set(index, data);
    }

    public void clearExtraData() {
        this.extraLayoutData.clear();
    }

    public LayoutElement addSymbol(LayoutElement parentElement, Symbol symbol) {
        return this.addSymbol(parentElement, symbol, 0);
    }

    public LayoutElement addSymbol(LayoutElement parentElement, Symbol symbol, int innerOutCount) {
        return super.addElement(parentElement, new LayoutElement(this, symbol, innerOutCount));
    }

    public void setPathToThisSegment(Path2D path) {
        this.pathToThisSegment = path;
    }

    public void setPathFromThisSegment(Path2D path) {
        this.pathFromThisSegment = path;
    }

    public Path2D getPathToThisSegment() {
        return this.pathToThisSegment;
    }

    public Path2D getPathFromThisSegment() {
        return this.pathFromThisSegment;
    }

    @Override
    public void removeElement(LayoutElement element) {
        super.removeElement(element);
        for (LayoutElement elmnt : this) {
            if (elmnt.getSymbol() instanceof Comment) continue;
            return;
        }
        this.pathToThisSegment = new Path2D.Double(1, 2);
    }

    public void setDescriptionLocation(Point2D descriptionLocation) {
        this.descriptionLocation = descriptionLocation;
    }

    public Point2D getDescriptionLocation() {
        return this.descriptionLocation;
    }

    public int[] getPathFromMainSegment() {
        return this.getPathFromMainSegment(new int[1], 1);
    }

    protected int[] getPathFromMainSegment(int[] path, int depth) {
        if (depth == 0) {
            depth = 1;
        }
        if (super.getParentElement() == null) {
            return new int[path.length - 1];
        }
        int[] retPath = ((LayoutElement)super.getParentElement()).getPathFromMainSegment(new int[path.length + 1], depth + 1);
        retPath[retPath.length - depth] = ((LayoutElement)super.getParentElement()).indexOfInnerSegment(this);
        return retPath;
    }
}

