/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.flowchart.layouts;

import cz.miroslavbartyzal.psdiagram.app.flowchart.Flowchart;
import cz.miroslavbartyzal.psdiagram.app.flowchart.FlowchartElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.AbstractLayout;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutSegment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Comment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.GotoLabel;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Joint;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.LoopEnd;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public class TBLRLayout
extends AbstractLayout {
    private ArrayList<Double> lColumnWidth = new ArrayList(10);
    private ArrayList<Double> lRowWidth = new ArrayList(20);
    private ArrayList<Double> lColumnPos = new ArrayList(10);
    private ArrayList<Double> lRowPos = new ArrayList(20);
    ArrayList<Line2D> lGrid = new ArrayList(20);
    private ArrayList<Joint> lJoints = super.getlJoints();
    private ArrayList<Comment> lCommentSymbols = new ArrayList(9);
    private double width = 0.0;
    private double height = 0.0;
    private int incrementXSymbol = 0;
    private int incrementYSymbol = 0;
    private int incrementXCanvas = 0;
    private int incrementYCanvas = 0;
    private Integer lastIncrementXSymbol = null;
    private Integer lastIncrementYSymbol = null;
    private Integer lastIncrementXCanvas = null;
    private Integer lastIncrementYCanvas = null;
    private int descElseSegmentX = -9;
    private int descElseSegmentY = 4;
    private int descFirstSegmentX = -3;
    private int descFirstSegmentY = -4;
    private int descPadding = 4;
    private boolean sizeTrimming = false;
    private boolean expandMultiSegment = false;

    public TBLRLayout(JComponent canvas) {
        this(canvas, null);
    }

    public TBLRLayout(JComponent canvas, Flowchart<LayoutSegment, LayoutElement> flowchart) {
        super(canvas, flowchart);
        this.prepareMyFlowchart();
        this.setFocusedJoint(this.getlJoints().get(0));
    }

    @Override
    public ArrayList<JMenuItem> getSettings() {
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        JCheckBoxMenuItem cbMenuItemSizeTrimming = new JCheckBoxMenuItem("Smr\u0161\u0165ov\u00e1n\u00ed", this.sizeTrimming);
        cbMenuItemSizeTrimming.setSelected(this.sizeTrimming);
        cbMenuItemSizeTrimming.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JCheckBoxMenuItem cbMenuItem = (JCheckBoxMenuItem)ae.getSource();
                TBLRLayout.this.sizeTrimming = cbMenuItem.isSelected();
                TBLRLayout.this.prepareFlowchart();
                TBLRLayout.this.getCanvas().repaint();
            }
        });
        menuItems.add(cbMenuItemSizeTrimming);
        JCheckBoxMenuItem cbMenuItemExpandMultiSegment = new JCheckBoxMenuItem("Expanze Switch symbolu", this.expandMultiSegment);
        cbMenuItemExpandMultiSegment.setSelected(this.expandMultiSegment);
        cbMenuItemExpandMultiSegment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JCheckBoxMenuItem cbMenuItem = (JCheckBoxMenuItem)ae.getSource();
                TBLRLayout.this.expandMultiSegment = cbMenuItem.isSelected();
                TBLRLayout.this.prepareFlowchart();
                TBLRLayout.this.getCanvas().repaint();
            }
        });
        menuItems.add(cbMenuItemExpandMultiSegment);
        return menuItems;
    }

    @Override
    public void paintFlowchart(Graphics2D g2d, boolean clipShadow) {
        if (super.getEditMode()) {
            g2d.setColor(new Color(245, 245, 245));
            for (Line2D line : this.lGrid) {
                g2d.draw(line);
            }
        }
        super.paintFlowchart(g2d, clipShadow);
    }

    @Override
    public void prepareMyFlowchart() {
        int i;
        this.lColumnWidth.clear();
        this.lRowWidth.clear();
        this.analyzeFlowchartGrid(super.getFlowchart().getMainSegment(), 0, 0);
        this.lColumnPos = new ArrayList<Double>(this.lColumnWidth);
        this.lRowPos = new ArrayList<Double>(this.lRowWidth);
        double overHangInc = this.getOverHangInc(super.getFlowchart().getMainSegment());
        this.defineGrid(this.lColumnPos, overHangInc + (double)this.incrementXSymbol);
        this.defineGrid(this.lRowPos, this.incrementYSymbol);
        this.lCommentSymbols = new ArrayList(this.lCommentSymbols.size() + 1);
        this.lJoints = new ArrayList(super.getlJoints().size() + 10);
        this.deploySymbolsAndArrows(super.getFlowchart().getMainSegment(), 0, 0);
        this.width = this.lColumnPos.get(this.lColumnPos.size() - 1) + this.lColumnWidth.get(this.lColumnWidth.size() - 1) / 2.0 + (double)super.getFlowchartPadding() + 0.5 + 2.0 + (double)this.incrementXCanvas;
        this.height = this.lRowPos.get(this.lRowPos.size() - 1) + this.lRowWidth.get(this.lRowWidth.size() - 1) / 2.0 + (double)super.getFlowchartPadding() + 0.5 + 2.0 + (double)this.incrementYCanvas;
        double minX = super.getFlowchartPadding() + this.incrementXSymbol;
        double maxX = this.width - (double)super.getFlowchartPadding() - (double)this.incrementXCanvas - 2.0;
        double minY = super.getFlowchartPadding() + this.incrementYSymbol;
        double maxY = this.height - (double)super.getFlowchartPadding() - (double)this.incrementYCanvas - 2.0;
        double myIncrementXSymbol = 0.0;
        double myIncrementYSymbol = 0.0;
        double myIncrementXCanvas = 0.0;
        double myIncrementYCanvas = 0.0;
        for (Comment comment : this.lCommentSymbols) {
            ArrayList<Point2D> relativeMiddlePointsToSymbol = comment.getRelativeMiddlePointsToSymbol();
            for (int i2 = -1; i2 < relativeMiddlePointsToSymbol.size(); ++i2) {
                double cMaxY;
                double cY;
                double cX;
                if (i2 == -1) {
                    cX = comment.getX();
                    cY = comment.getY();
                    cMaxY = cY + comment.getHeight();
                } else {
                    cX = comment.getX() - comment.getRelativeX() + relativeMiddlePointsToSymbol.get(i2).getX();
                    cMaxY = cY = comment.getY() + comment.getHeight() / 2.0 - comment.getRelativeY() + relativeMiddlePointsToSymbol.get(i2).getY();
                }
                double cMaxX = cX + comment.getWidth();
                if (cX < minX - myIncrementXSymbol) {
                    myIncrementXSymbol = minX - cX;
                }
                if (cMaxX > maxX + myIncrementXCanvas) {
                    myIncrementXCanvas = cMaxX - maxX;
                }
                if (cY < minY - myIncrementYSymbol) {
                    myIncrementYSymbol = minY - cY;
                }
                if (!(cMaxY > maxY + myIncrementYCanvas)) continue;
                myIncrementYCanvas = cMaxY - maxY;
            }
        }
        if (!((int)Math.round(myIncrementXSymbol) == this.incrementXSymbol && (int)myIncrementYSymbol == this.incrementYSymbol && (int)myIncrementXCanvas == this.incrementXCanvas && (int)myIncrementYCanvas == this.incrementYCanvas || this.isStackFilling((int)myIncrementXSymbol, (int)myIncrementYSymbol, (int)myIncrementXCanvas, (int)myIncrementYCanvas))) {
            this.lastIncrementXSymbol = this.incrementXSymbol;
            this.lastIncrementYSymbol = this.incrementYSymbol;
            this.lastIncrementXCanvas = this.incrementXCanvas;
            this.lastIncrementYCanvas = this.incrementYCanvas;
            this.incrementXSymbol = (int)myIncrementXSymbol;
            this.incrementYSymbol = (int)myIncrementYSymbol;
            this.incrementXCanvas = (int)myIncrementXCanvas;
            this.incrementYCanvas = (int)myIncrementYCanvas;
            this.prepareMyFlowchart();
            return;
        }
        this.lastIncrementXSymbol = null;
        this.lastIncrementYSymbol = null;
        this.lastIncrementXCanvas = null;
        this.lastIncrementYCanvas = null;
        JComponent canvas = super.getCanvas();
        canvas.setPreferredSize(new Dimension((int)this.width, (int)this.height));
        super.setlJoints(this.lJoints);
        this.lJoints = null;
        this.lGrid.clear();
        for (i = 0; i < this.lColumnPos.size(); ++i) {
            this.lGrid.add(new Line2D.Double(this.lColumnPos.get(i), this.lRowPos.get(0), this.lColumnPos.get(i), this.lRowPos.get(this.lRowPos.size() - 1)));
        }
        for (i = 0; i < this.lRowPos.size(); ++i) {
            this.lGrid.add(new Line2D.Double(this.lColumnPos.get(0), this.lRowPos.get(i), this.lColumnPos.get(this.lColumnPos.size() - 1), this.lRowPos.get(i)));
        }
    }

    private boolean isStackFilling(int myIncrementXSymbol, int myIncrementYSymbol, int myIncrementXCanvas, int myIncrementYCanvas) {
        if (this.lastIncrementXSymbol == null || this.lastIncrementYSymbol == null || this.lastIncrementXCanvas == null || this.lastIncrementYCanvas == null) {
            return false;
        }
        return this.lastIncrementXSymbol == myIncrementXSymbol && this.lastIncrementYSymbol == myIncrementYSymbol && this.lastIncrementXCanvas == myIncrementXCanvas && this.lastIncrementYCanvas == myIncrementYCanvas;
    }

    @Override
    public ArrayList<Comment> getlCommentSymbols() {
        return this.lCommentSymbols;
    }

    private double getOverHangInc(LayoutSegment segment) {
        for (LayoutElement element : segment) {
            if (!element.getSymbol().isOverHang() && (!element.getSymbol().hasElseSegment() || !(this.getOverHangInc((LayoutSegment)element.getInnerSegment(0)) > 0.0))) continue;
            return super.getSymbolPadding() / 2;
        }
        return 0.0;
    }

    private void deploySymbolsAndArrows(LayoutSegment segment, int inputColumn, int inputRow) {
        Path2D.Double path;
        int actualRow = inputRow;
        FlowchartElement previousElement = null;
        LayoutElement overHangElement = null;
        FlowchartElement firstPairElement = null;
        LayoutElement commentToInitialize = null;
        int decrease = 1;
        boolean isLastOverHanged = false;
        boolean isLastPaired = false;
        boolean forFirstTime = true;
        int noPairCommentCount = 0;
        if (segment.getDescriptionLayout() != null && segment.getParentElement() != null && ((LayoutElement)segment.getParentElement()).getInnerSegmentsCount() > 0) {
            double y;
            double x;
            TextLayout description = segment.getDescriptionLayout();
            if (((LayoutElement)segment.getParentElement()).indexOfInnerSegment(segment) == 0) {
                x = this.lColumnPos.get(inputColumn) - description.getBounds().getWidth() + (double)this.descElseSegmentX - description.getBounds().getX();
                y = this.lRowPos.get(actualRow - segment.getExtraLayoutData(1)) + ((LayoutElement)segment.getParentElement()).getSymbol().getHeight() / 2.0 - description.getBounds().getHeight() + (double)this.descElseSegmentY - description.getBounds().getY();
                segment.setDescriptionLocation(new Point2D.Double(x, y));
            } else if (((LayoutElement)segment.getParentElement()).getInnerSegmentsCount() > 2 && ((LayoutElement)segment.getParentElement()).indexOfInnerSegment(segment) > 0) {
                x = this.lColumnPos.get(inputColumn) - description.getBounds().getWidth() / 2.0 - description.getBounds().getX();
                y = this.lRowPos.get(actualRow - segment.getExtraLayoutData(1)) - description.getBounds().getHeight() - (double)this.descPadding - description.getBounds().getY();
                segment.setDescriptionLocation(new Point2D.Double(x, y));
            } else if (((LayoutElement)segment.getParentElement()).indexOfInnerSegment(segment) == 1) {
                x = this.lColumnPos.get(inputColumn - segment.getExtraLayoutData(0) - 1) + ((LayoutElement)segment.getParentElement()).getSymbol().getWidth() / 2.0 + (double)this.descFirstSegmentX - description.getBounds().getX();
                y = this.lRowPos.get(actualRow - segment.getExtraLayoutData(1)) - description.getBounds().getHeight() + (double)this.descFirstSegmentY - description.getBounds().getY();
                segment.setDescriptionLocation(new Point2D.Double(x, y));
            }
        }
        int i = 0;
        Iterator it = segment.iterator();
        while (it.hasNext()) {
            LayoutElement element = (LayoutElement)it.next();
            if (element.getSymbol() instanceof Comment) {
                this.lCommentSymbols.add((Comment)element.getSymbol());
                if (!element.getSymbol().hasPairSymbol()) {
                    if (!this.sizeTrimming && isLastOverHanged && !isLastPaired && noPairCommentCount == 0) {
                        ++actualRow;
                    }
                    Comment comment = (Comment)element.getSymbol();
                    comment.setCenterX(this.lColumnPos.get(inputColumn) + comment.getRelativeX());
                    comment.setCenterY(this.lRowPos.get(actualRow) + comment.getRelativeY());
                    element.setPathToNextSymbol(this.getCommentPathFromRelative(comment, null));
                    if (noPairCommentCount > 0) {
                        Joint joint = new Joint((LayoutElement)segment.getElement(segment.indexOfElement(element) - 1), segment);
                        joint.setCenterX(this.lColumnPos.get(inputColumn));
                        joint.setCenterY((this.lRowPos.get(actualRow - 1) - this.lRowPos.get(actualRow)) / 2.0 + this.lRowPos.get(actualRow));
                        this.lJoints.add(joint);
                    }
                    if (it.hasNext()) {
                        ++actualRow;
                    }
                    ++noPairCommentCount;
                } else {
                    commentToInitialize = element;
                }
            } else {
                Point2D p1;
                if (element.getSymbol().isOverHang() && isLastOverHanged || !this.sizeTrimming && isLastOverHanged && !isLastPaired || this.sizeTrimming && isLastOverHanged && element.getSymbol().isPadded()) {
                    if (noPairCommentCount == 0) {
                        ++actualRow;
                    }
                    ++decrease;
                }
                element.getSymbol().setCenterX(this.lColumnPos.get(inputColumn));
                element.getSymbol().setCenterY(this.lRowPos.get(actualRow));
                if (segment.getParentElement() != null && forFirstTime) {
                    forFirstTime = false;
                    Path2D.Double path2 = new Path2D.Double(1, 2);
                    int segmentRowIncrease = 0;
                    if (((LayoutElement)segment.getParentElement()).indexOfInnerSegment(segment) != 0) {
                        segmentRowIncrease = segment.getExtraLayoutData(1);
                    }
                    p1 = this.getSymbolIntersectionPoint(((LayoutElement)segment.getParentElement()).getSymbol(), this.lColumnPos.get(inputColumn), this.lRowPos.get(inputRow - segmentRowIncrease));
                    ((Path2D)path2).moveTo(p1.getX(), p1.getY());
                    if (segmentRowIncrease != 0 || inputRow != actualRow && ((LayoutElement)segment.getParentElement()).indexOfInnerSegment(segment) != 0) {
                        p1 = new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(inputRow - segmentRowIncrease));
                        ((Path2D)path2).lineTo(p1.getX(), p1.getY());
                    } else if (((LayoutElement)segment.getParentElement()).indexOfInnerSegment(segment) != 0 && this.lColumnPos.get(inputColumn - 1) > p1.getX()) {
                        p1 = new Point2D.Double(this.lColumnPos.get(inputColumn - 1), p1.getY());
                    }
                    Point2D p2 = this.getSymbolIntersectionPoint(element.getSymbol(), p1.getX(), p1.getY());
                    ((Path2D)path2).lineTo(p2.getX(), p2.getY());
                    segment.setPathToThisSegment(path2);
                    this.addJoint((LayoutElement)previousElement, segment, commentToInitialize, p1, p2, null, inputColumn, inputRow, actualRow, segmentRowIncrease, i, noPairCommentCount, 0.0, 0.0);
                }
                if (overHangElement != null && !isLastPaired) {
                    Point2D p2;
                    decrease = this.sizeTrimming ? (noPairCommentCount > 0 ? (decrease -= 2 - noPairCommentCount) : --decrease) : (decrease -= 1 - noPairCommentCount);
                    Path2D.Double path3 = new Path2D.Double(1, 4);
                    double overHangX = this.lColumnPos.get(inputColumn) - this.lColumnWidth.get(inputColumn) / 2.0 - (double)(super.getSymbolPadding() / 2);
                    Point2D p12 = this.getSymbolIntersectionPoint(overHangElement.getSymbol(), overHangX, overHangElement.getSymbol().getCenterY());
                    ((Path2D)path3).moveTo(p12.getX(), p12.getY());
                    ((Path2D)path3).lineTo(overHangX, overHangElement.getSymbol().getCenterY());
                    p12 = new Point2D.Double(overHangX, this.lRowPos.get(actualRow - decrease));
                    ((Path2D)path3).lineTo(p12.getX(), p12.getY());
                    if (actualRow - decrease != actualRow) {
                        p12 = new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(actualRow - decrease));
                        ((Path2D)path3).lineTo(p12.getX(), p12.getY());
                        p2 = this.getSymbolIntersectionPoint(element.getSymbol(), this.lColumnPos.get(inputColumn), this.lRowPos.get(actualRow - decrease));
                        ((Path2D)path3).lineTo(p2.getX(), p2.getY());
                    } else {
                        p2 = this.getSymbolIntersectionPoint(element.getSymbol(), overHangX, this.lRowPos.get(actualRow - decrease));
                        ((Path2D)path3).lineTo(p2.getX(), p2.getY());
                    }
                    overHangElement.setPathToNextSymbol(path3);
                    overHangElement = null;
                    this.addJoint((LayoutElement)previousElement, segment, commentToInitialize, p12, p2, null, inputColumn, inputRow, actualRow, 0, i, noPairCommentCount, 0.0, overHangX);
                } else if (previousElement != null && isLastPaired) {
                    Path2D.Double path4 = new Path2D.Double(1, 1);
                    Point2D p = this.getSymbolIntersectionPoint(element.getSymbol(), previousElement.getSymbol().getCenterX(), previousElement.getSymbol().getCenterY());
                    ((Path2D)path4).moveTo(p.getX(), p.getY());
                    p = this.getSymbolIntersectionPoint(previousElement.getSymbol(), p.getX(), p.getY());
                    ((Path2D)path4).lineTo(p.getX(), p.getY());
                    element.setPathToNextSymbol(path4);
                } else if (previousElement != null && previousElement.getInnerSegmentsCount() == 0) {
                    path = new Path2D.Double(1, 1);
                    Point2D p13 = this.getSymbolIntersectionPoint(previousElement.getSymbol(), element.getSymbol().getCenterX(), element.getSymbol().getCenterY());
                    ((Path2D)path).moveTo(p13.getX(), p13.getY());
                    Point2D p2 = this.getSymbolIntersectionPoint(element.getSymbol(), p13.getX(), p13.getY());
                    ((Path2D)path).lineTo(p2.getX(), p2.getY());
                    if (firstPairElement == null) {
                        ((LayoutElement)previousElement).setPathToNextSymbol(path);
                    } else {
                        ((LayoutElement)firstPairElement).setPathToNextSymbol(path);
                        firstPairElement = null;
                    }
                    this.addJoint((LayoutElement)previousElement, segment, commentToInitialize, p13, p2, null, inputColumn, inputRow, actualRow, 0, i, noPairCommentCount, 0.0, 0.0);
                } else if (previousElement != null && previousElement.getSymbol().hasElseSegment()) {
                    Path2D.Double path5 = new Path2D.Double(1, 1);
                    Point2D p2 = this.expandMultiSegment && previousElement.getInnerSegmentsCount() > 1 ? new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(((LayoutElement)previousElement).getExtraLayoutData(0) - previousElement.getInnerSegmentsCount() + 1)) : new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(((LayoutElement)previousElement).getExtraLayoutData(0) - 1));
                    ((Path2D)path5).moveTo(p2.getX(), p2.getY());
                    p2 = this.getSymbolIntersectionPoint(element.getSymbol(), p2.getX(), p2.getY());
                    ((Path2D)path5).lineTo(p2.getX(), p2.getY());
                    ((LayoutElement)previousElement).setPathToNextSymbol(path5);
                    p1 = new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(((LayoutElement)previousElement).getExtraLayoutData(0) - 1));
                    this.addJoint((LayoutElement)previousElement, segment, commentToInitialize, p1, p2, null, inputColumn, inputRow, actualRow, 0, i, noPairCommentCount, 0.0, 0.0);
                }
                if (commentToInitialize != null) {
                    Comment comment = (Comment)commentToInitialize.getSymbol();
                    if (element.getSymbol() instanceof GotoLabel) {
                        GotoLabel gotoLabel = (GotoLabel)element.getSymbol();
                        comment.setCenterX(this.lColumnPos.get(inputColumn) - (double)gotoLabel.getMyHair() - (gotoLabel.getWidth() - (double)(gotoLabel.getMyHair() * 2)) * 0.25 + comment.getRelativeX());
                    } else {
                        comment.setCenterX(this.lColumnPos.get(inputColumn) + comment.getRelativeX());
                    }
                    comment.setCenterY(this.lRowPos.get(actualRow) + comment.getRelativeY());
                    commentToInitialize.setPathToNextSymbol(this.getCommentPathFromRelative(comment, element.getSymbol()));
                    commentToInitialize = null;
                }
                if (element.getSymbol().isOverHang()) {
                    isLastOverHanged = true;
                } else if (!isLastPaired) {
                    isLastOverHanged = false;
                } else if (!isLastOverHanged) {
                    firstPairElement = previousElement;
                }
                if (element.getSymbol().hasPairSymbol()) {
                    isLastPaired = true;
                    decrease = 0;
                    LayoutElement e = (LayoutElement)segment.getElement(i + 1);
                    int j = 2;
                    while (e.getSymbol() instanceof Comment) {
                        e = (LayoutElement)segment.getElement(i + j);
                        ++j;
                    }
                    e.getSymbol().setCenterX(this.lColumnPos.get(inputColumn));
                    e.getSymbol().setCenterY(this.lRowPos.get(element.getExtraLayoutData(0)));
                } else {
                    isLastPaired = false;
                    decrease = 1;
                }
                if (element.getInnerSegmentsCount() > 0) {
                    if (element.getSymbol().isOverHang()) {
                        overHangElement = element;
                    }
                    for (int j = 0; j < element.getInnerSegmentsCount(); ++j) {
                        LayoutSegment innerSegment = (LayoutSegment)element.getInnerSegment(j);
                        if (innerSegment == null) continue;
                        this.deploySymbolsAndArrows(innerSegment, inputColumn + j + innerSegment.getExtraLayoutData(0), actualRow + innerSegment.getExtraLayoutData(1));
                    }
                    actualRow = element.getExtraLayoutData(0);
                } else {
                    ++actualRow;
                }
                previousElement = element;
                noPairCommentCount = 0;
            }
            ++i;
        }
        if (commentToInitialize != null) {
            segment.removeElement(commentToInitialize);
        }
        if (segment.getParentElement() != null) {
            Point2D p1;
            LayoutElement parentElement = (LayoutElement)segment.getParentElement();
            int indexOfSegment = parentElement.indexOfInnerSegment(segment);
            decrease = parentElement.getSymbol().hasPairSymbol() || indexOfSegment == 0 ? 0 : 1;
            double targetY = this.expandMultiSegment && parentElement.getInnerSegmentsCount() > 1 ? this.lRowPos.get(parentElement.getExtraLayoutData(0) - decrease - (parentElement.getInnerSegmentsCount() - (indexOfSegment + 1))) : (indexOfSegment == 0 ? this.lRowPos.get(parentElement.getExtraLayoutData(0) - decrease - 1).doubleValue() : this.lRowPos.get(parentElement.getExtraLayoutData(0) - decrease).doubleValue());
            if (previousElement != null) {
                Path2D.Double path6;
                FlowchartElement lastElement = previousElement;
                if (previousElement.getSymbol() instanceof LoopEnd) {
                    lastElement = this.findMyPairedElement((LayoutElement)previousElement);
                }
                if (!((LayoutElement)lastElement).getPathToNextSymbol().getPathIterator(null).isDone()) {
                    ((LayoutElement)lastElement).setPathToNextSymbol(new Path2D.Double(1, 4));
                }
                if (indexOfSegment != 0) {
                    if (this.lRowPos.get(actualRow - 1) < targetY && (noPairCommentCount > 0 || overHangElement == null || this.lRowPos.get(actualRow) < targetY)) {
                        Point2D p3;
                        Point2D.Double p2;
                        Point2D p;
                        path6 = new Path2D.Double(1, 5);
                        double overHangX = 0.0;
                        if (overHangElement != null) {
                            overHangX = this.lColumnPos.get(inputColumn) - this.lColumnWidth.get(inputColumn) / 2.0 - (double)(super.getSymbolPadding() / 2);
                            p = this.getSymbolIntersectionPoint(overHangElement.getSymbol(), overHangX, overHangElement.getSymbol().getCenterY());
                            ((Path2D)path6).moveTo(p.getX(), p.getY());
                            ((Path2D)path6).lineTo(overHangX, overHangElement.getSymbol().getCenterY());
                            ((Path2D)path6).lineTo(overHangX, this.lRowPos.get(((LayoutElement)previousElement).getExtraLayoutData(0)));
                            p1 = new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(((LayoutElement)previousElement).getExtraLayoutData(0)));
                            ((Path2D)path6).lineTo(p1.getX(), p1.getY());
                            p2 = new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(((LayoutElement)previousElement).getExtraLayoutData(0) + 1));
                        } else {
                            p1 = this.expandMultiSegment && previousElement.getSymbol().hasElseSegment() && previousElement.getInnerSegmentsCount() > 1 ? new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(((LayoutElement)previousElement).getExtraLayoutData(0) - previousElement.getInnerSegmentsCount() + 1)) : (previousElement.getSymbol().hasElseSegment() ? new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(((LayoutElement)previousElement).getExtraLayoutData(0) - 1)) : this.getSymbolIntersectionPoint(previousElement.getSymbol(), this.lColumnPos.get(inputColumn), targetY));
                            ((Path2D)path6).moveTo(p1.getX(), p1.getY());
                            if (previousElement.getSymbol().hasElseSegment()) {
                                p1 = new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(((LayoutElement)previousElement).getExtraLayoutData(0) - 1));
                            }
                            p2 = new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(actualRow));
                        }
                        ((Path2D)path6).lineTo(this.lColumnPos.get(inputColumn), targetY);
                        if (!parentElement.getSymbol().hasPairSymbol()) {
                            p3 = new Point2D.Double(this.lColumnPos.get(inputColumn - indexOfSegment - segment.getExtraLayoutData(0)), targetY);
                            ((Path2D)path6).lineTo(p3.getX(), p3.getY());
                            if (parentElement.getSymbol().isOverHang()) {
                                p = this.getSymbolIntersectionPoint(parentElement.getSymbol(), this.lColumnPos.get(inputColumn - indexOfSegment - segment.getExtraLayoutData(0)), targetY);
                                ((Path2D)path6).lineTo(p.getX(), p.getY());
                            }
                        } else {
                            p3 = this.getSymbolIntersectionPoint(this.getPairElement(parentElement).getSymbol(), this.lColumnPos.get(inputColumn), targetY);
                            ((Path2D)path6).lineTo(p3.getX(), p3.getY());
                        }
                        segment.setPathFromThisSegment(path6);
                        this.addJoint((LayoutElement)previousElement, segment, commentToInitialize, p1, p2, p3, inputColumn, inputRow, actualRow, 0, i, noPairCommentCount, targetY, overHangX);
                    } else {
                        Point2D p2;
                        path6 = new Path2D.Double(1, 5);
                        if (overHangElement != null) {
                            double overHangX = this.lColumnPos.get(inputColumn) - this.lColumnWidth.get(inputColumn) / 2.0 - (double)(super.getSymbolPadding() / 2);
                            Point2D p = this.getSymbolIntersectionPoint(overHangElement.getSymbol(), overHangX, overHangElement.getSymbol().getCenterY());
                            ((Path2D)path6).moveTo(p.getX(), p.getY());
                            int inc = 0;
                            if (this.lRowPos.get(actualRow - 1) < targetY) {
                                ++inc;
                            }
                            p1 = overHangElement.getSymbol().hasPairSymbol() ? new Point2D.Double(overHangX, this.lRowPos.get(overHangElement.getExtraLayoutData(0) + inc)) : new Point2D.Double(overHangX, this.lRowPos.get(overHangElement.getExtraLayoutData(0) - 1 + inc));
                            ((Path2D)path6).lineTo(overHangX, overHangElement.getSymbol().getCenterY());
                            ((Path2D)path6).lineTo(overHangX, targetY);
                        } else {
                            p1 = this.getSymbolIntersectionPoint(previousElement.getSymbol(), this.lColumnPos.get(inputColumn - 1), targetY);
                            ((Path2D)path6).moveTo(p1.getX(), p1.getY());
                        }
                        if (!parentElement.getSymbol().hasPairSymbol()) {
                            p2 = new Point2D.Double(this.lColumnPos.get(inputColumn - 1), targetY);
                            ((Path2D)path6).lineTo(this.lColumnPos.get(inputColumn - indexOfSegment - segment.getExtraLayoutData(0)), targetY);
                            if (parentElement.getSymbol().isOverHang()) {
                                Point2D p = this.getSymbolIntersectionPoint(parentElement.getSymbol(), this.lColumnPos.get(inputColumn - indexOfSegment - segment.getExtraLayoutData(0)), targetY);
                                ((Path2D)path6).lineTo(p.getX(), p.getY());
                            }
                        } else {
                            p2 = this.getSymbolIntersectionPoint(this.getPairElement(parentElement).getSymbol(), this.lColumnPos.get(inputColumn), targetY);
                            ((Path2D)path6).lineTo(p2.getX(), p2.getY());
                        }
                        segment.setPathFromThisSegment(path6);
                        this.addJoint((LayoutElement)previousElement, segment, commentToInitialize, p1, p2, null, inputColumn, inputRow, actualRow, 0, i, noPairCommentCount, targetY, 0.0);
                    }
                } else {
                    Point2D.Double p2;
                    Point2D p;
                    path6 = new Path2D.Double(1, 5);
                    double overHangX = 0.0;
                    if (overHangElement != null) {
                        overHangX = this.lColumnPos.get(inputColumn) - this.lColumnWidth.get(inputColumn) / 2.0 - (double)(super.getSymbolPadding() / 2);
                        p = this.getSymbolIntersectionPoint(overHangElement.getSymbol(), overHangX, overHangElement.getSymbol().getCenterY());
                        ((Path2D)path6).moveTo(p.getX(), p.getY());
                        ((Path2D)path6).lineTo(overHangX, overHangElement.getSymbol().getCenterY());
                        ((Path2D)path6).lineTo(overHangX, this.lRowPos.get(((LayoutElement)previousElement).getExtraLayoutData(0)));
                        p1 = new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(((LayoutElement)previousElement).getExtraLayoutData(0)));
                        ((Path2D)path6).lineTo(p1.getX(), p1.getY());
                        p2 = new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(((LayoutElement)previousElement).getExtraLayoutData(0) + 1));
                    } else {
                        p1 = this.expandMultiSegment && previousElement.getSymbol().hasElseSegment() && previousElement.getInnerSegmentsCount() > 1 ? new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(((LayoutElement)previousElement).getExtraLayoutData(0) - previousElement.getInnerSegmentsCount() + 1)) : (previousElement.getSymbol().hasElseSegment() ? new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(((LayoutElement)previousElement).getExtraLayoutData(0) - 1)) : this.getSymbolIntersectionPoint(previousElement.getSymbol(), this.lColumnPos.get(inputColumn), targetY));
                        ((Path2D)path6).moveTo(p1.getX(), p1.getY());
                        if (previousElement.getSymbol().hasElseSegment()) {
                            p1 = new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(((LayoutElement)previousElement).getExtraLayoutData(0) - 1));
                        }
                        p2 = new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(actualRow));
                    }
                    ((Path2D)path6).lineTo(this.lColumnPos.get(inputColumn), targetY);
                    Point2D.Double p3 = new Point2D.Double(this.lColumnPos.get(inputColumn - indexOfSegment - segment.getExtraLayoutData(0)), targetY);
                    ((Path2D)path6).lineTo(((Point2D)p3).getX(), ((Point2D)p3).getY());
                    if (parentElement.getSymbol().isOverHang()) {
                        p = this.getSymbolIntersectionPoint(parentElement.getSymbol(), this.lColumnPos.get(inputColumn - indexOfSegment - segment.getExtraLayoutData(0)), targetY);
                        ((Path2D)path6).lineTo(p.getX(), p.getY());
                    }
                    segment.setPathFromThisSegment(path6);
                    this.addJoint((LayoutElement)previousElement, segment, commentToInitialize, p1, p2, p3, inputColumn, inputRow, actualRow, 0, i, noPairCommentCount, targetY, overHangX);
                }
            } else {
                path = new Path2D.Double(1, 4);
                int segmentRowIncrease = 0;
                if (indexOfSegment != 0) {
                    segmentRowIncrease = segment.getExtraLayoutData(1);
                }
                p1 = this.getSymbolIntersectionPoint(parentElement.getSymbol(), this.lColumnPos.get(inputColumn), this.lRowPos.get(inputRow - segmentRowIncrease));
                ((Path2D)path).moveTo(p1.getX(), p1.getY());
                if (indexOfSegment > 0) {
                    p1 = new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(inputRow - segmentRowIncrease));
                    ((Path2D)path).lineTo(p1.getX(), p1.getY());
                }
                Point2D p3 = new Point2D.Double(this.lColumnPos.get(inputColumn), targetY);
                ((Path2D)path).lineTo(p3.getX(), p3.getY());
                if (indexOfSegment > 0) {
                    if (parentElement.getSymbol().hasPairSymbol()) {
                        p3 = this.getSymbolIntersectionPoint(this.getPairElement(parentElement).getSymbol(), p3.getX(), p3.getY());
                        ((Path2D)path).lineTo(p3.getX(), p3.getY());
                    } else {
                        p3 = new Point2D.Double(this.lColumnPos.get(inputColumn - indexOfSegment - segment.getExtraLayoutData(0)), p3.getY());
                        ((Path2D)path).lineTo(p3.getX(), p3.getY());
                        if (parentElement.getSymbol().isOverHang()) {
                            Point2D p = this.getSymbolIntersectionPoint(parentElement.getSymbol(), p3.getX(), p3.getY());
                            ((Path2D)path).lineTo(p.getX(), p.getY());
                        }
                    }
                }
                segment.setPathFromThisSegment(path);
                Point2D.Double p2 = indexOfSegment != 0 && segmentRowIncrease == 0 && noPairCommentCount == 0 ? new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(actualRow + 1)) : new Point2D.Double(this.lColumnPos.get(inputColumn), this.lRowPos.get(actualRow));
                this.addJoint((LayoutElement)previousElement, segment, commentToInitialize, p1, p2, p3, inputColumn, inputRow, actualRow, segmentRowIncrease, i, noPairCommentCount, targetY, 0.0);
            }
        }
    }

    private Point2D getSymbolIntersectionPoint(Symbol symbol, double sourceX, double sourceY) {
        if (symbol instanceof GotoLabel) {
            return new Point2D.Double(symbol.getCenterX(), symbol.getCenterY());
        }
        return symbol.getIntersectionPoint(sourceX, sourceY);
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    private void addJoint(LayoutElement previousElement, LayoutSegment segment, LayoutElement commentToInitialize, Point2D p1, Point2D p2, Point2D p3, int inputColumn, int inputRow, int actualRow, int segmentRowIncrease, int i, int noPairCommentCount, double targetY, double overHangX) {
        Joint joint;
        if (commentToInitialize != null) {
            --i;
        }
        if (noPairCommentCount == 0) {
            joint = previousElement == null ? new Joint((LayoutElement)segment.getParentElement(), segment) : new Joint((LayoutElement)segment.getElement(i - 1), segment);
            joint.setCenterX((p1.getX() - p2.getX()) / 2.0 + p2.getX());
            joint.setCenterY((p1.getY() - p2.getY()) / 2.0 + p2.getY());
        } else {
            joint = new Joint((LayoutElement)segment.getElement(i - 1), segment);
            if (this.lRowPos.get(actualRow) < targetY) {
                joint.setCenterX(this.lColumnPos.get(inputColumn));
                joint.setCenterY((this.lRowPos.get(actualRow + 1) - this.lRowPos.get(actualRow)) / 2.0 + this.lRowPos.get(actualRow));
            } else if (p3 != null) {
                if (this.lColumnPos.get(inputColumn - 1) > p3.getX()) {
                    joint.setCenterX((p2.getX() - this.lColumnPos.get(inputColumn - 1)) / 2.0 + this.lColumnPos.get(inputColumn - 1));
                } else {
                    joint.setCenterX((p2.getX() - p3.getX()) / 2.0 + p3.getX());
                }
                joint.setCenterY(this.lRowPos.get(actualRow));
            } else {
                joint.setCenterX(this.lColumnPos.get(inputColumn));
                joint.setCenterY((this.lRowPos.get(actualRow - 1) - p2.getY()) / 2.0 + p2.getY());
            }
            this.lJoints.add(joint);
            if (previousElement == null) {
                joint = new Joint((LayoutElement)segment.getParentElement(), segment);
                if (this.sizeTrimming) {
                    p1 = this.getSymbolIntersectionPoint(((LayoutElement)segment.getParentElement()).getSymbol(), this.lColumnPos.get(inputColumn), this.lRowPos.get(inputRow - segmentRowIncrease));
                    if (((LayoutElement)segment.getParentElement()).indexOfInnerSegment(segment) != 0 && this.lColumnPos.get(inputColumn - 1) > p1.getX()) {
                        p1 = new Point2D.Double(this.lColumnPos.get(inputColumn - 1), p1.getY());
                    }
                }
                joint.setCenterX((p1.getX() - p2.getX()) / 2.0 + p2.getX());
                joint.setCenterY((p1.getY() - this.lRowPos.get(inputRow)) / 2.0 + this.lRowPos.get(inputRow));
            } else {
                joint = new Joint((LayoutElement)segment.getElement(i - 1 - noPairCommentCount), segment);
                if (this.sizeTrimming && overHangX != 0.0) {
                    joint.setCenterX((this.lColumnPos.get(inputColumn) - overHangX) / 2.0 + overHangX);
                } else {
                    joint.setCenterX(this.lColumnPos.get(inputColumn));
                }
                if (i < segment.size()) {
                    joint.setCenterY((this.lRowPos.get(actualRow - noPairCommentCount) - p1.getY()) / 2.0 + p1.getY());
                } else {
                    joint.setCenterY((this.lRowPos.get(actualRow - noPairCommentCount + 1) - p1.getY()) / 2.0 + p1.getY());
                }
            }
        }
        this.lJoints.add(joint);
    }

    private LayoutElement getPairElement(LayoutElement fistElement) {
        LayoutElement element = (LayoutElement)((LayoutSegment)fistElement.getParentSegment()).getElement(((LayoutSegment)fistElement.getParentSegment()).indexOfElement(fistElement) + 1);
        int i = 2;
        while (element.getSymbol() instanceof Comment) {
            element = (LayoutElement)((LayoutSegment)fistElement.getParentSegment()).getElement(((LayoutSegment)fistElement.getParentSegment()).indexOfElement(fistElement) + i);
            ++i;
        }
        return element;
    }

    @Override
    public Path2D getCommentPathFromRelative(Comment commentSymbol, Symbol fromSymbol) {
        Point2D p;
        Path2D.Double path = new Path2D.Double(1, 4);
        ArrayList<Point2D> lRelativeMiddlePoints = commentSymbol.getRelativeMiddlePointsToSymbol();
        Point2D.Double centerP = new Point2D.Double(commentSymbol.getCenterX() - commentSymbol.getRelativeX(), commentSymbol.getCenterY() - commentSymbol.getRelativeY());
        if (fromSymbol == null) {
            ((Path2D)path).moveTo(((Point2D)centerP).getX(), ((Point2D)centerP).getY());
        } else {
            p = lRelativeMiddlePoints.isEmpty() ? fromSymbol.getIntersectionPoint(commentSymbol.getCenterX(), commentSymbol.getCenterY()) : fromSymbol.getIntersectionPoint(((Point2D)centerP).getX() + lRelativeMiddlePoints.get(0).getX(), ((Point2D)centerP).getY() + lRelativeMiddlePoints.get(0).getY());
            if (p != null) {
                ((Path2D)path).moveTo(p.getX(), p.getY());
            } else {
                ((Path2D)path).moveTo(((Point2D)centerP).getX(), ((Point2D)centerP).getY());
            }
        }
        for (Point2D point : lRelativeMiddlePoints) {
            ((Path2D)path).lineTo(((Point2D)centerP).getX() + point.getX(), ((Point2D)centerP).getY() + point.getY());
        }
        p = commentSymbol.getIntersectionPoint(path.getCurrentPoint().getX(), path.getCurrentPoint().getY());
        ((Path2D)path).lineTo(p.getX(), p.getY());
        return path;
    }

    private void defineGrid(ArrayList<Double> ls, double firstExtraPadding) {
        double previousHalf = ls.get(0) / 2.0;
        ls.set(0, (double)super.getFlowchartPadding() + previousHalf + firstExtraPadding);
        for (int i = 1; i < ls.size(); ++i) {
            double actualHalf = ls.get(i) / 2.0;
            ls.set(i, ls.get(i - 1) + previousHalf + (double)super.getSymbolPadding() + actualHalf);
            previousHalf = actualHalf;
        }
    }

    private int[] analyzeFlowchartGrid(LayoutSegment segment, int inputColumn, int inputRow) {
        int maxColumn = inputColumn;
        int actualColumn = inputColumn;
        int actualRow = inputRow;
        boolean isLastOverHanged = false;
        boolean isLastPaired = false;
        while (this.lColumnWidth.size() <= actualColumn) {
            this.lColumnWidth.add(0.0);
        }
        if (segment.getDescriptionLayout() != null && segment.getParentElement() != null && ((LayoutElement)segment.getParentElement()).getInnerSegmentsCount() > 2 && ((LayoutElement)segment.getParentElement()).indexOfInnerSegment(segment) > 0) {
            double descWidth = segment.getDescriptionLayout().getBounds().getWidth();
            if (this.lColumnWidth.get(actualColumn) < descWidth) {
                this.lColumnWidth.set(actualColumn, descWidth);
            }
        }
        Iterator it = segment.iterator();
        while (it.hasNext()) {
            LayoutElement element = (LayoutElement)it.next();
            if (element.getSymbol() instanceof Comment && element.getSymbol().hasPairSymbol()) continue;
            if (!this.sizeTrimming && !element.getSymbol().isOverHang() && isLastOverHanged && !isLastPaired) {
                ++actualRow;
            } else if (element.getSymbol().isOverHang()) {
                if (isLastOverHanged) {
                    ++actualRow;
                } else {
                    isLastOverHanged = true;
                }
                isLastPaired = element.getSymbol().hasPairSymbol();
            } else if (this.sizeTrimming && isLastOverHanged && element.getSymbol().isPadded()) {
                ++actualRow;
            }
            if (!(element.getSymbol() instanceof Comment)) {
                double elementWidth = element.getSymbol().getWidth();
                double descriptionIncrease = 0.0;
                if (element.getInnerSegmentsCount() > 0) {
                    double descWidth;
                    double descIncrease;
                    if (element.getInnerSegment(0) != null && ((LayoutSegment)element.getInnerSegment(0)).getDescriptionLayout() != null && (descIncrease = -(elementWidth / 2.0 - (descWidth = ((LayoutSegment)element.getInnerSegment(0)).getDescriptionLayout().getBounds().getWidth()) + (double)this.descElseSegmentX + (double)(super.getSymbolPadding() - this.descPadding))) > 0.0) {
                        descriptionIncrease = descIncrease;
                    }
                    if (element.getInnerSegmentsCount() > 1 && element.getInnerSegmentsCount() < 3 && element.getInnerSegment(1) != null && ((LayoutSegment)element.getInnerSegment(1)).getDescriptionLayout() != null && (descIncrease = (double)this.descFirstSegmentX + (descWidth = ((LayoutSegment)element.getInnerSegment(1)).getDescriptionLayout().getBounds().getWidth()) - (double)(super.getSymbolPadding() - this.descPadding)) > descriptionIncrease) {
                        descriptionIncrease = descIncrease;
                    }
                }
                if (this.lColumnWidth.get(actualColumn) < elementWidth + descriptionIncrease * 2.0) {
                    this.lColumnWidth.set(actualColumn, elementWidth + descriptionIncrease * 2.0);
                }
                while (this.lRowWidth.size() <= actualRow) {
                    this.lRowWidth.add(0.0);
                }
                double elementHeight = element.getSymbol().getHeight();
                if (this.lRowWidth.get(actualRow) < elementHeight) {
                    this.lRowWidth.set(actualRow, elementHeight);
                }
            }
            if (element.getInnerSegmentsCount() > 0) {
                int columnIncrease = 0;
                int rowIncrease = 0;
                int maxRow = actualRow;
                int[] maxRows = new int[element.getInnerSegmentsCount()];
                Arrays.fill(maxRows, 0);
                for (int i = 0; i < element.getInnerSegmentsCount(); ++i) {
                    LayoutSegment innerSegment = (LayoutSegment)element.getInnerSegment(i);
                    if (innerSegment != null) {
                        int[] returnedValue;
                        innerSegment.clearExtraData();
                        if (columnIncrease > 0) {
                            innerSegment.setExtraLayoutData(0, columnIncrease);
                        }
                        boolean firstPadded = false;
                        if (innerSegment.size() > 0) {
                            for (LayoutElement elmnt : innerSegment) {
                                if (elmnt.getSymbol() instanceof Comment && elmnt.getSymbol().hasPairSymbol()) continue;
                                if (!elmnt.getSymbol().isPadded()) break;
                                firstPadded = true;
                                break;
                            }
                        }
                        if (!this.sizeTrimming && innerSegment.size() > 0 || i == 0 || element.getInnerSegmentsCount() > 2 || firstPadded) {
                            innerSegment.setExtraLayoutData(1, 1);
                            returnedValue = this.analyzeFlowchartGrid(innerSegment, actualColumn + i + columnIncrease, actualRow + 1);
                        } else {
                            innerSegment.setExtraLayoutData(1, 0);
                            returnedValue = this.analyzeFlowchartGrid(innerSegment, actualColumn + i + columnIncrease, actualRow);
                        }
                        if (returnedValue[1] > maxRow) {
                            maxRow = returnedValue[1];
                            if (!element.getSymbol().hasPairSymbol()) {
                                if (this.expandMultiSegment && element.getInnerSegmentsCount() > 1) {
                                    rowIncrease = element.getInnerSegmentsCount() - i - 1;
                                    int myMaxRow = maxRow;
                                    for (int j = 1; j <= i; ++j) {
                                        if (maxRows[i - j] <= myMaxRow - j) continue;
                                        int increment = maxRows[i - j] - myMaxRow + j;
                                        rowIncrease += increment;
                                        myMaxRow += increment;
                                    }
                                    maxRows[i] = maxRow;
                                    if (i == 0) {
                                        int n = i;
                                        maxRows[n] = maxRows[n] - 1;
                                    }
                                } else {
                                    rowIncrease = i == 0 ? 1 : 0;
                                }
                                if (!(i <= 0 || innerSegment.size() <= 0 || this.sizeTrimming && element.getInnerSegmentsCount() <= 2)) {
                                    ++rowIncrease;
                                }
                            } else if (this.sizeTrimming) {
                                rowIncrease = -1;
                            }
                        }
                        if (returnedValue[0] > maxColumn) {
                            maxColumn = returnedValue[0];
                        }
                        columnIncrease = returnedValue[0] - (actualColumn + i);
                        continue;
                    }
                    ++maxRow;
                    if (element.getSymbol().hasPairSymbol()) continue;
                    rowIncrease = element.getInnerSegmentsCount() - i - 1;
                }
                actualRow = maxRow + rowIncrease;
                element.setExtraLayoutData(0, actualRow);
                if (this.sizeTrimming && !it.hasNext() && element.getSymbol().hasElseSegment() && (segment.getParentElement() == null || ((LayoutElement)segment.getParentElement()).getInnerSegmentsCount() < 3 && ((LayoutElement)segment.getParentElement()).indexOfInnerSegment(segment) > 0)) {
                    ++actualRow;
                }
            } else {
                if (this.sizeTrimming && !it.hasNext() && (segment.getParentElement() == null || ((LayoutElement)segment.getParentElement()).indexOfInnerSegment(segment) > 0) && (isLastOverHanged && !isLastPaired || element.getSymbol().isPadded())) {
                    ++actualRow;
                }
                ++actualRow;
            }
            if (element.getSymbol().isOverHang()) {
                isLastOverHanged = true;
            } else if (isLastPaired) {
                isLastPaired = false;
                element.setExtraLayoutData(0, actualRow);
            } else {
                isLastOverHanged = false;
            }
            if (it.hasNext() || !isLastOverHanged || isLastPaired || this.sizeTrimming && (!isLastOverHanged || ((LayoutElement)segment.getParentElement()).indexOfInnerSegment(segment) != 0) && (((LayoutElement)segment.getParentElement()).getInnerSegmentsCount() <= 2 || !isLastOverHanged)) continue;
            ++actualRow;
        }
        return new int[]{maxColumn, actualRow};
    }
}

