/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.flowchart.symbols;

import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import cz.miroslavbartyzal.psdiagram.app.global.SettingsHolder;
import cz.miroslavbartyzal.psdiagram.app.global.xmlAdapters.LinkedHashMapAdapter;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.awt.Color;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedHashMap;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class AbstractSymbol
implements Symbol {
    @XmlElement(name="borderColor")
    private Color borderColor = Color.BLACK;
    @XmlElement(name="shapeUpColor")
    private Color shapeUpColor = Color.WHITE;
    @XmlElement(name="shapeDownColor")
    private Color shapeDownColor = new Color(230, 230, 230);
    @XmlElement(name="hasShadow")
    private boolean hasShadow = true;
    private final Color errorBorderColor = new Color(137, 20, 20);
    private final Color errorShapeUpColor = Color.WHITE;
    private final Color errorShapeDownColor = new Color(205, 143, 144);
    private double minWidth;
    private double minHeight;
    private Shape shape;
    private String value = null;
    @XmlElement(name="customValue")
    private String customValue = null;
    @XmlElement(name="defaultValue")
    private String defaultValue = null;
    private String[] defaultSegmentDescriptions = new String[0];
    private boolean hasElseSegment = false;
    private int innerOutsCount = 0;
    private boolean overHang = false;
    private boolean hasPairSymbol = false;
    private boolean padded = false;
    private final int textPadding = 6;
    private final int textLeading = 4;
    private ArrayList<TextLayout> textLayoutLines = new ArrayList();
    private ArrayList<Point2D> textLayoutOrigins = new ArrayList();
    @XmlElement(name="commands")
    @XmlJavaTypeAdapter(value=LinkedHashMapAdapter.class)
    private LinkedHashMap<String, String> commands = null;
    @XmlElement(name="commandsValid", defaultValue="true")
    private boolean commandsValid = true;

    AbstractSymbol() {
    }

    AbstractSymbol(double minWidth, double minHeight) {
        this.minWidth = minWidth;
        this.minHeight = minHeight;
    }

    private String getValueAndSize() {
        return this.value;
    }

    @Override
    public void resetFontStyle(int style) {
        if (this.textLayoutLines != null && this.textLayoutLines.size() > 0) {
            this.setValueAndSize(this.value, style);
        }
    }

    private void setValueAndSize(String value, int fontStyle) {
        this.textLayoutLines.clear();
        this.textLayoutOrigins.clear();
        if (value == null) {
            value = "";
        }
        this.value = value;
        if (value.equals("") || this.shape.getBounds2D().getWidth() < this.minWidth) {
            this.reposResizeSymbol(this.shape.getBounds2D().getCenterX() - this.minWidth / 2.0, this.shape.getBounds2D().getCenterY() - this.minHeight / 2.0, this.minWidth, this.minHeight);
            if (value.equals("")) {
                return;
            }
        }
        String[] lines = value.split("\\n");
        double textsHeigt = 6.0;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].equals("")) {
                lines[i] = " ";
            }
            TextLayout textLayout = new TextLayout(lines[i], SettingsHolder.CODEFONT.deriveFont(fontStyle), SettingsHolder.FONTRENDERCONTEXT);
            textsHeigt += textLayout.getBounds().getHeight() + 4.0;
            this.textLayoutLines.add(textLayout);
        }
        if ((textsHeigt += 2.0) != this.shape.getBounds2D().getHeight()) {
            if (textsHeigt > this.minHeight) {
                double width = this.getWidthByHeightRatio(textsHeigt);
                this.reposResizeSymbol(this.shape.getBounds2D().getX(), this.shape.getBounds2D().getY(), width, textsHeigt);
                textsHeigt = 6.0;
            } else {
                this.reposResizeSymbol(this.shape.getBounds2D().getX(), this.shape.getBounds2D().getY(), this.minWidth, this.minHeight);
                textsHeigt = (this.shape.getBounds2D().getHeight() - textsHeigt + 12.0) / 2.0;
            }
        } else {
            textsHeigt = 6.0;
        }
        double maxWith = 0.0;
        for (int i = 0; i < lines.length; ++i) {
            TextLayout textLayout = this.textLayoutLines.get(i);
            double boundsWidth = textLayout.getBounds().getWidth() + 12.0;
            double boundsHeight = textLayout.getBounds().getHeight();
            double boundsX = this.getMyCenterX() - boundsWidth / 2.0;
            double boundsMaxX = this.getMyCenterX() + boundsWidth / 2.0;
            double boundsY = this.shape.getBounds2D().getY() + textsHeigt;
            double boundsMaxY = boundsY + boundsHeight;
            try {
                double possibleWidth = 0.0;
                Point2D p1 = this.getShapeIntersectionPoint(boundsX, boundsY, this.getMyCenterX(), boundsY);
                Point2D p2 = this.getShapeIntersectionPoint(boundsMaxX, boundsY, this.getMyCenterX(), boundsY);
                Point2D p3 = this.getShapeIntersectionPoint(boundsX, boundsMaxY, this.getMyCenterX(), boundsMaxY);
                Point2D p4 = this.getShapeIntersectionPoint(boundsMaxX, boundsMaxY, this.getMyCenterX(), boundsMaxY);
                double leftWidth1 = this.getMyCenterX() - p1.getX();
                double rightWidth1 = p2.getX() - this.getMyCenterX();
                double leftWidth2 = this.getMyCenterX() - p3.getX();
                double rightWidth2 = p4.getX() - this.getMyCenterX();
                if (leftWidth1 > rightWidth1 + 1.0 || leftWidth1 < rightWidth1 - 1.0 || leftWidth2 > rightWidth2 + 1.0 || leftWidth2 < rightWidth2 - 1.0) {
                    double overLapRatio = (boundsWidth + p2.getX() - p4.getX()) / (p2.getX() - p1.getX());
                    double overLapRatio2 = (boundsWidth + p1.getX() - p3.getX()) / (p4.getX() - p3.getX());
                    if (overLapRatio2 > overLapRatio) {
                        overLapRatio = overLapRatio2;
                    }
                    if (overLapRatio > 1.0) {
                        possibleWidth = this.shape.getBounds2D().getWidth() * overLapRatio;
                    }
                    double additionalMove = p4.getX() - boundsMaxX;
                    additionalMove += p1.getX() - boundsX;
                    this.textLayoutOrigins.add(new Point2D.Double(boundsX + (additionalMove /= 2.0) + 6.0 - textLayout.getBounds().getX(), boundsY - textLayout.getBounds().getY()));
                } else {
                    this.textLayoutOrigins.add(new Point2D.Double(boundsX + 6.0 - textLayout.getBounds().getX(), boundsY - textLayout.getBounds().getY()));
                    possibleWidth = this.shape.getBounds2D().getWidth() + boundsWidth - (p2.getX() - p1.getX());
                    double possibleWidth2 = this.shape.getBounds2D().getWidth() + boundsWidth - (p4.getX() - p3.getX());
                    if (possibleWidth2 > possibleWidth) {
                        possibleWidth = possibleWidth2;
                    }
                }
                if (possibleWidth > maxWith) {
                    maxWith = possibleWidth;
                }
            }
            catch (NullPointerException e) {
                this.textLayoutOrigins.add(new Point2D.Double(this.getMyCenterX(), this.shape.getBounds2D().getCenterY()));
            }
            textsHeigt += boundsHeight + 4.0;
        }
        if ((maxWith = this.getSymbolSpecificWidthEdit(maxWith)) > this.shape.getBounds2D().getWidth()) {
            double height = this.getHeightByWidthRatio(maxWith);
            this.reposResizeSymbol(this.shape.getBounds2D().getX(), this.shape.getBounds2D().getY(), maxWith, height);
        }
    }

    @Override
    @XmlElement(name="value")
    public void setValueAndSize(String value) {
        this.setValueAndSize(value, 0);
    }

    double getSymbolSpecificWidthEdit(double width) {
        return width;
    }

    void reposResizeSymbol(double x, double y, double width, double height) {
        for (Point2D p : this.textLayoutOrigins) {
            p.setLocation(p.getX() - this.shape.getBounds2D().getX() + x + (width - this.shape.getBounds2D().getWidth()) / 2.0, p.getY() - this.shape.getBounds2D().getY() + y + (height - this.shape.getBounds2D().getHeight()) / 2.0);
        }
        this.setRect(x, y, width, height);
    }

    abstract void setRect(double var1, double var3, double var5, double var7);

    double getWidthByHeightRatio(double height) {
        return height / this.minHeight * this.minWidth;
    }

    double getHeightByWidthRatio(double width) {
        return width / this.minWidth * this.minHeight;
    }

    @Override
    public void setCenterX(double x) {
        this.reposResizeSymbol(x - this.shape.getBounds2D().getWidth() / 2.0, this.shape.getBounds2D().getY(), this.shape.getBounds2D().getWidth(), this.shape.getBounds2D().getHeight());
    }

    @Override
    public void setCenterY(double y) {
        this.reposResizeSymbol(this.shape.getBounds2D().getX(), y - this.shape.getBounds2D().getHeight() / 2.0, this.shape.getBounds2D().getWidth(), this.shape.getBounds2D().getHeight());
    }

    @Override
    public ArrayList<TextLayout> getTextLayoutLines() {
        return this.textLayoutLines;
    }

    @Override
    public ArrayList<Point2D> getTextLayoutOrigins() {
        return this.textLayoutOrigins;
    }

    void setTextLayoutLines(ArrayList<TextLayout> textLayoutLines) {
        this.textLayoutLines = textLayoutLines;
    }

    void setTextLayoutOrigins(ArrayList<Point2D> textLayoutOrigins) {
        this.textLayoutOrigins = textLayoutOrigins;
    }

    @Override
    public double getCenterX() {
        return this.shape.getBounds2D().getCenterX();
    }

    @Override
    public double getCenterY() {
        return this.shape.getBounds2D().getCenterY();
    }

    @Override
    public double getX() {
        return this.shape.getBounds2D().getX();
    }

    @Override
    public double getY() {
        return this.shape.getBounds2D().getY();
    }

    @Override
    public Point2D getIntersectionPoint(double sourcePointX, double sourcePointY) {
        if (sourcePointX == this.shape.getBounds2D().getCenterX()) {
            if (sourcePointY > this.shape.getBounds2D().getCenterY()) {
                return new Point2D.Double(this.shape.getBounds2D().getCenterX(), this.shape.getBounds2D().getMaxY());
            }
            if (sourcePointY < this.shape.getBounds2D().getCenterY()) {
                return new Point2D.Double(this.shape.getBounds2D().getCenterX(), this.shape.getBounds2D().getY());
            }
            return new Point2D.Double(this.shape.getBounds2D().getCenterX(), this.shape.getBounds2D().getCenterY());
        }
        if (sourcePointY == this.shape.getBounds2D().getCenterY()) {
            if (sourcePointX > this.shape.getBounds2D().getCenterX()) {
                return new Point2D.Double(this.shape.getBounds2D().getMaxX(), this.shape.getBounds2D().getCenterY());
            }
            if (sourcePointX < this.shape.getBounds2D().getCenterX()) {
                return new Point2D.Double(this.shape.getBounds2D().getX(), this.shape.getBounds2D().getCenterY());
            }
            return new Point2D.Double(this.shape.getBounds2D().getCenterX(), this.shape.getBounds2D().getCenterY());
        }
        return this.getShapeIntersectionPoint(sourcePointX, sourcePointY);
    }

    Point2D getShapeIntersectionPoint(double sourcePointX, double sourcePointY) {
        return this.getShapeIntersectionPoint(sourcePointX, sourcePointY, this.shape.getBounds2D().getCenterX(), this.shape.getBounds2D().getCenterY());
    }

    Point2D getShapeIntersectionPoint(double sourcePointX, double sourcePointY, double symbolPointX, double symbolPointY) {
        PathIterator pathIterator = this.shape.getPathIterator(null, 1.0);
        double[] firstCoordinates = new double[2];
        if (!pathIterator.isDone() && pathIterator.currentSegment(firstCoordinates) != 0) {
            throw new Error("Unexpected currentSegment!");
        }
        pathIterator.next();
        int quadrant = this.getPointQuadrant(sourcePointX, sourcePointY);
        while (!pathIterator.isDone()) {
            double[] secondCoordinates = new double[6];
            int type = pathIterator.currentSegment(secondCoordinates);
            if (type == 0 || type == 1) {
                if (type == 1 && (this.isInSameQuadrant(quadrant, firstCoordinates[0], firstCoordinates[1]) || this.isInSameQuadrant(quadrant, secondCoordinates[0], secondCoordinates[1]))) {
                    Point2D.Double p;
                    double[] vEdge = new double[]{secondCoordinates[0] - firstCoordinates[0], secondCoordinates[1] - firstCoordinates[1]};
                    double[] dArray = new double[]{-(symbolPointY - sourcePointY), symbolPointX - sourcePointX};
                    double[] nVSegment = dArray;
                    double h = ((sourcePointX - firstCoordinates[0]) * nVSegment[0] + (sourcePointY - firstCoordinates[1]) * nVSegment[1]) / (vEdge[0] * nVSegment[0] + vEdge[1] * nVSegment[1]);
                    if (h >= 0.0 && h <= 1.0 && this.isInSameQuadrant(quadrant, ((Point2D)(p = new Point2D.Double(firstCoordinates[0] + vEdge[0] * h, firstCoordinates[1] + vEdge[1] * h))).getX(), ((Point2D)p).getY())) {
                        return p;
                    }
                }
                firstCoordinates = secondCoordinates;
            } else if (type != 4) {
                throw new Error("Unexpected currentSegment! (Curves are not supported)");
            }
            pathIterator.next();
        }
        return null;
    }

    private int getPointQuadrant(double x, double y) {
        double myCenterX = Math.rint(this.getMyCenterX() * 10000.0) / 10000.0;
        double myCenterY = Math.rint(this.shape.getBounds2D().getCenterY() * 10000.0) / 10000.0;
        x = Math.rint(x * 10000.0) / 10000.0;
        y = Math.rint(y * 10000.0) / 10000.0;
        if (x < myCenterX) {
            if (y < myCenterY) {
                return 2;
            }
            if (y > myCenterY) {
                return 3;
            }
            return 23;
        }
        if (x > myCenterX) {
            if (y < myCenterY) {
                return 1;
            }
            if (y > myCenterY) {
                return 4;
            }
            return 14;
        }
        if (y < myCenterY) {
            return 12;
        }
        if (y > myCenterY) {
            return 34;
        }
        return 1234;
    }

    private boolean isInSameQuadrant(int quadrant, double x, double y) {
        int result = this.getPointQuadrant(x, y);
        if (quadrant == result || result == 1234 || quadrant == result % 10 || quadrant % 10 == result % 10 || quadrant % 10 == result) {
            return true;
        }
        if (result > 10) {
            while (result % 10 != 0) {
                --result;
            }
            while (quadrant > 10 && quadrant % 10 != 0) {
                --quadrant;
            }
            if (quadrant == result || quadrant == result / 10) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.getShape().contains(p);
    }

    @Override
    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @Override
    public void setShapeUpColor(Color shapeUpColor) {
        this.shapeUpColor = shapeUpColor;
    }

    @Override
    public void setShapeDownColor(Color shapeDownColor) {
        this.shapeDownColor = shapeDownColor;
    }

    void setShape(Shape shape) {
        this.shape = shape;
    }

    void setInnerOutsCount(int innerOutsCount) {
        this.innerOutsCount = innerOutsCount;
    }

    void setHasElseSegment(boolean hasElseSegment) {
        if (this.overHang) {
            throw new Error("Unsoperted combination!");
        }
        this.hasElseSegment = hasElseSegment;
    }

    @Override
    public void setHasShadow(boolean hasShadow) {
        this.hasShadow = hasShadow;
    }

    @Override
    public void setHasPairSymbol(boolean hasPairSymbol) {
        this.hasPairSymbol = hasPairSymbol;
    }

    void setOverHang(boolean overHang) {
        if (this.hasElseSegment) {
            throw new Error("Unsoperted combination!");
        }
        this.overHang = overHang;
        this.setPadded(overHang);
    }

    void setPadded(boolean padded) {
        this.padded = padded;
    }

    @Override
    public double getHeight() {
        return this.shape.getBounds().getHeight();
    }

    @Override
    public double getWidth() {
        return this.shape.getBounds().getWidth();
    }

    double getMyCenterX() {
        return this.getCenterX();
    }

    void setValue(String value) {
        this.value = value;
    }

    int getTextLeading() {
        return 4;
    }

    int getTextPadding() {
        return 6;
    }

    @Override
    public String getCustomValue() {
        return this.customValue;
    }

    @Override
    public void setCustomValue(String customValue) {
        this.customValue = customValue;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public int getInnerOutsCount() {
        return this.innerOutsCount;
    }

    @Override
    public double getMinHeight() {
        return this.minHeight;
    }

    @Override
    public double getMinWidth() {
        return this.minWidth;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public Color getBorderColor() {
        return this.borderColor;
    }

    @Override
    public Color getShapeUpColor() {
        return this.shapeUpColor;
    }

    @Override
    public Color getShapeDownColor() {
        return this.shapeDownColor;
    }

    @Override
    public boolean hasShadow() {
        return this.hasShadow;
    }

    @Override
    public boolean hasElseSegment() {
        return this.hasElseSegment;
    }

    @Override
    public boolean hasPairSymbol() {
        return this.hasPairSymbol;
    }

    @Override
    public boolean isOverHang() {
        return this.overHang;
    }

    @Override
    public boolean isPadded() {
        return this.padded;
    }

    @Override
    public String[] getDefaultSegmentDescriptions() {
        return this.defaultSegmentDescriptions;
    }

    void setDefaultSegmentDescriptions(String[] defaultSegmentDescriptions) {
        this.defaultSegmentDescriptions = defaultSegmentDescriptions;
    }

    @Override
    public LinkedHashMap<String, String> getCommands() {
        return this.commands;
    }

    @Override
    public void setCommands(LinkedHashMap<String, String> commands) {
        this.commands = commands;
    }

    @Override
    public boolean areCommandsValid() {
        return this.commandsValid;
    }

    @Override
    public void setCommandsValid(boolean commandsValid) {
        this.commandsValid = commandsValid;
    }

    @Override
    public Color getErrorBorderColor() {
        return this.errorBorderColor;
    }

    @Override
    public Color getErrorShapeUpColor() {
        return this.errorShapeUpColor;
    }

    @Override
    public Color getErrorShapeDownColor() {
        return this.errorShapeDownColor;
    }
}

