/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.flowchart.symbols;

import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.AbstractSymbol;
import cz.miroslavbartyzal.psdiagram.app.global.SettingsHolder;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.awt.font.TextLayout;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

@XmlRootElement(name="comment")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="comment")
public final class Comment
extends AbstractSymbol {
    private final Path2D myShape = new Path2D.Double(1, 3);
    @XmlElement(name="relativePointToSymbol")
    private ArrayList<Point2D> lRelativeMiddlePointsToSymbol = new ArrayList();
    private boolean toRightSite = true;
    @XmlElement(name="alwaysLeftAlign")
    private boolean alwaysLeftAlign = false;
    @XmlElement(name="relativeX")
    private double relativeX = 0.0;
    @XmlElement(name="relativeY")
    private double relativeY = 0.0;
    private double maxWidthText = 0.0;

    private Comment() {
        this("", false);
    }

    private boolean getPaired() {
        return super.hasPairSymbol();
    }

    @XmlElement(name="paired")
    private void setPaired(boolean paired) {
        super.setHasPairSymbol(paired);
    }

    Comment(boolean paired) {
        this(null, paired);
    }

    Comment(String value, boolean paired) {
        super(7.5, 50.0);
        super.setShape(this.myShape);
        this.setValueAndSize(value);
        super.setShapeUpColor(null);
        if (paired) {
            super.setHasPairSymbol(paired);
        }
        this.relativeX = 50.0;
        this.relativeY = -10.0;
    }

    @Override
    public void resetFontStyle(int style) {
        if (super.getValue() != null && !super.getValue().equals("")) {
            this.setValueAndSize(super.getValue(), style);
        }
    }

    private void setValueAndSize(String value, int fontStyle) {
        TextLayout textLayout;
        int i;
        this.maxWidthText = 0.0;
        ArrayList<TextLayout> textLayoutLines = super.getTextLayoutLines();
        ArrayList<Point2D> textLayoutOrigins = super.getTextLayoutOrigins();
        textLayoutLines.clear();
        textLayoutOrigins.clear();
        if (value == null) {
            value = "";
        }
        super.setValue(value);
        if (value.equals("")) {
            this.reposResizeSymbol(this.getCenterX(), this.myShape.getBounds2D().getY(), super.getMinWidth(), super.getMinHeight());
            return;
        }
        int textPadding = super.getTextPadding();
        int textLeading = super.getTextLeading();
        String[] lines = value.split("\\n");
        double textsHeigt = textPadding;
        for (i = 0; i < lines.length; ++i) {
            if (lines[i].equals("")) {
                lines[i] = " ";
            }
            if ((textLayout = new TextLayout(lines[i], SettingsHolder.CODEFONT.deriveFont(fontStyle), SettingsHolder.FONTRENDERCONTEXT)).getBounds().getWidth() > this.maxWidthText) {
                this.maxWidthText = textLayout.getBounds().getWidth();
            }
            textsHeigt += textLayout.getBounds().getHeight() + (double)textLeading;
            textLayoutLines.add(textLayout);
        }
        if ((textsHeigt += (double)(textPadding - textLeading)) != this.myShape.getBounds2D().getHeight()) {
            if (textsHeigt > super.getMinHeight()) {
                this.reposResizeSymbol(this.getCenterX(), this.myShape.getBounds2D().getY(), super.getMinWidth(), textsHeigt);
                textsHeigt = textPadding;
            } else {
                this.reposResizeSymbol(this.getCenterX(), this.myShape.getBounds2D().getY(), super.getMinWidth(), super.getMinHeight());
                textsHeigt = (this.myShape.getBounds2D().getHeight() - textsHeigt + (double)(2 * textPadding)) / 2.0;
            }
        } else {
            textsHeigt = textPadding;
        }
        for (i = 0; i < lines.length; ++i) {
            textLayout = textLayoutLines.get(i);
            double boundsX = this.getCenterX();
            boundsX = this.toRightSite ? (boundsX += super.getMinWidth()) : (!this.alwaysLeftAlign ? (boundsX -= super.getMinWidth() + textLayout.getBounds().getWidth()) : (boundsX -= super.getMinWidth() + this.maxWidthText));
            textLayoutOrigins.add(new Point2D.Double(boundsX - textLayout.getBounds().getX(), this.myShape.getBounds2D().getY() + textsHeigt - textLayout.getBounds().getY()));
            textsHeigt += textLayout.getBounds().getHeight() + (double)textLeading;
        }
    }

    @Override
    public void setValueAndSize(String value) {
        this.setValueAndSize(value, 0);
    }

    @Override
    public void setCenterX(double x) {
        this.reposResizeSymbol(x, this.myShape.getBounds2D().getY(), super.getMinWidth(), this.myShape.getBounds2D().getHeight());
    }

    @Override
    public void setCenterY(double y) {
        this.reposResizeSymbol(this.getCenterX(), y - this.myShape.getBounds2D().getHeight() / 2.0, super.getMinWidth(), this.myShape.getBounds2D().getHeight());
    }

    @Override
    void setRect(double x, double y, double width, double height) {
        this.myShape.reset();
        double myWidth = this.toRightSite ? super.getMinWidth() : -super.getMinWidth();
        this.myShape.moveTo(x + myWidth, y);
        this.myShape.lineTo(x, y);
        this.myShape.lineTo(x, y + height);
        this.myShape.lineTo(x + myWidth, y + height);
    }

    @Override
    public Point2D getIntersectionPoint(double sourcePointX, double sourcePointY) {
        if (!this.toRightSite && sourcePointX < this.getCenterX()) {
            this.toRightSite = true;
            this.reposResizeSymbol(this.myShape.getBounds2D().getMaxX(), this.myShape.getBounds2D().getY(), super.getMinWidth(), this.myShape.getBounds2D().getHeight());
            this.setValueAndSize(super.getValue());
        } else if (this.toRightSite && sourcePointX > this.getCenterX()) {
            this.toRightSite = false;
            this.reposResizeSymbol(this.myShape.getBounds2D().getX(), this.myShape.getBounds2D().getY(), super.getMinWidth(), this.myShape.getBounds2D().getHeight());
            this.setValueAndSize(super.getValue());
        }
        return new Point2D.Double(this.getCenterX(), super.getCenterY());
    }

    @Override
    void reposResizeSymbol(double x, double y, double width, double height) {
        if (this.toRightSite) {
            for (Point2D p : super.getTextLayoutOrigins()) {
                p.setLocation(p.getX() - this.getCenterX() + x, p.getY() - this.myShape.getBounds2D().getY() + y + (height - this.myShape.getBounds2D().getHeight()) / 2.0);
            }
        } else {
            for (Point2D p : super.getTextLayoutOrigins()) {
                p.setLocation(p.getX() - this.getCenterX() + x, p.getY() - this.myShape.getBounds2D().getY() + y + (height - this.myShape.getBounds2D().getHeight()) / 2.0);
            }
        }
        this.setRect(x, y, width, height);
    }

    @Override
    public double getCenterX() {
        if (this.toRightSite) {
            return this.myShape.getBounds2D().getX();
        }
        return this.myShape.getBounds2D().getMaxX();
    }

    @Override
    public double getX() {
        if (this.toRightSite) {
            return this.myShape.getBounds2D().getX();
        }
        return this.myShape.getBounds2D().getX() - this.maxWidthText;
    }

    public boolean istoRightSite() {
        return this.toRightSite;
    }

    @Override
    public double getWidth() {
        return super.getMinWidth() + this.maxWidthText;
    }

    @Override
    public boolean contains(Point2D p) {
        Rectangle2D.Double frame = new Rectangle2D.Double(this.getX(), this.myShape.getBounds2D().getY(), this.getWidth(), this.myShape.getBounds2D().getHeight());
        return frame.contains(p);
    }

    public void setRelativeX(double relativeX) {
        this.relativeX = relativeX;
    }

    public void setRelativeY(double relativeY) {
        this.relativeY = relativeY;
    }

    public void setRelativeMiddlePointsToSymbol(ArrayList<Point2D> lRelativeMiddlePointsToSymbol) {
        this.lRelativeMiddlePointsToSymbol = lRelativeMiddlePointsToSymbol;
    }

    public double getRelativeX() {
        return this.relativeX;
    }

    public double getRelativeY() {
        return this.relativeY;
    }

    public ArrayList<Point2D> getRelativeMiddlePointsToSymbol() {
        return this.lRelativeMiddlePointsToSymbol;
    }
}

