/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.flowchart.symbols;

import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.AbstractSymbol;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.LinkedHashMap;

@XmlRootElement(name="goto")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="goto")
public final class Goto
extends AbstractSymbol {
    private final Ellipse2D.Double myShape = new Ellipse2D.Double();

    private Goto() {
        this("");
    }

    Goto(String value) {
        super(25.0, 25.0);
        if (value == null || value.equals("")) {
            value = "__\nBR\n__";
            super.setDefaultValue(value);
            LinkedHashMap<String, String> commands = new LinkedHashMap<String, String>();
            commands.put("mode", "break");
            super.setCommands(commands);
        }
        super.setShape(this.myShape);
        this.setValueAndSize(value);
        super.setPadded(true);
    }

    @Override
    void setRect(double x, double y, double width, double height) {
        this.myShape.setFrame(x, y, width, height);
    }

    @Override
    Point2D getShapeIntersectionPoint(double sourcePointX, double sourcePointY) {
        double x = sourcePointX - this.myShape.getCenterX();
        double y = sourcePointY - this.myShape.getCenterY();
        double powerA = Math.pow(this.myShape.width / 2.0, 2.0);
        double h = powerA / Math.sqrt(powerA * Math.pow(y, 2.0) + powerA * Math.pow(x, 2.0));
        return new Point2D.Double(this.myShape.getCenterX() + h * x, this.myShape.getCenterY() + h * y);
    }
}

