/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.flowchart.symbols;

import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.AbstractSymbol;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;

@XmlRootElement(name="gotoLabel")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="gotoLabel")
public final class GotoLabel
extends AbstractSymbol {
    private final Path2D myShape = new Path2D.Double(1);
    private Ellipse2D circle;
    private int myHair = 14;

    private GotoLabel() {
        this("");
    }

    GotoLabel(String value) {
        super(78.0, 25.0);
        super.setShape(this.myShape);
        this.setValueAndSize(value);
        super.setPadded(true);
    }

    @Override
    public Point2D getIntersectionPoint(double sourcePointX, double sourcePointY) {
        if (sourcePointX == this.circle.getBounds2D().getCenterX()) {
            if (sourcePointY > this.circle.getBounds2D().getCenterY()) {
                return new Point2D.Double(this.circle.getBounds2D().getCenterX(), this.circle.getBounds2D().getMaxY());
            }
            if (sourcePointY < this.circle.getBounds2D().getCenterY()) {
                return new Point2D.Double(this.circle.getBounds2D().getCenterX(), this.circle.getBounds2D().getY());
            }
            return new Point2D.Double(this.circle.getBounds2D().getCenterX(), this.circle.getBounds2D().getCenterY());
        }
        if (sourcePointY == this.circle.getBounds2D().getCenterY()) {
            if (sourcePointX > this.circle.getBounds2D().getCenterX()) {
                return new Point2D.Double(this.circle.getBounds2D().getMaxX(), this.circle.getBounds2D().getCenterY());
            }
            if (sourcePointX < this.circle.getBounds2D().getCenterX()) {
                return new Point2D.Double(this.circle.getBounds2D().getX(), this.circle.getBounds2D().getCenterY());
            }
            return new Point2D.Double(this.circle.getBounds2D().getCenterX(), this.circle.getBounds2D().getCenterY());
        }
        return this.getShapeIntersectionPoint(sourcePointX, sourcePointY);
    }

    @Override
    Point2D getShapeIntersectionPoint(double sourcePointX, double sourcePointY) {
        double x = sourcePointX - this.circle.getCenterX();
        double y = sourcePointY - this.circle.getCenterY();
        double powerA = Math.pow(this.circle.getWidth() / 2.0, 2.0);
        double h = powerA / Math.sqrt(powerA * Math.pow(y, 2.0) + powerA * Math.pow(x, 2.0));
        return new Point2D.Double(this.circle.getCenterX() + h * x, this.circle.getCenterY() + h * y);
    }

    public int getMyHair() {
        return this.myHair;
    }

    public Ellipse2D getMyCircle() {
        return this.circle;
    }

    @Override
    void setRect(double x, double y, double width, double height) {
        this.myShape.reset();
        this.circle = new Ellipse2D.Double(x, y, height, height);
        PathIterator pathIterator = this.circle.getPathIterator(null);
        while (!pathIterator.isDone()) {
            double[] coordinates = new double[6];
            int type = pathIterator.currentSegment(coordinates);
            switch (type) {
                case 0: {
                    this.myShape.moveTo(coordinates[0], coordinates[1]);
                    break;
                }
                case 1: {
                    this.myShape.lineTo(coordinates[0], coordinates[1]);
                    break;
                }
                case 3: {
                    this.myShape.curveTo(coordinates[0], coordinates[1], coordinates[2], coordinates[3], coordinates[4], coordinates[5]);
                    break;
                }
                case 4: {
                    this.myShape.closePath();
                    break;
                }
                default: {
                    throw new Error("Unexpected currentSegment!");
                }
            }
            pathIterator.next();
        }
        this.myShape.moveTo(this.myShape.getBounds2D().getMaxX(), this.myShape.getBounds2D().getCenterY());
        this.myShape.lineTo(this.myShape.getBounds2D().getMaxX() + (double)this.myHair, this.myShape.getBounds2D().getCenterY());
        this.myShape.moveTo(this.myShape.getBounds2D().getMaxX() + this.myShape.getBounds2D().getWidth(), this.myShape.getBounds2D().getCenterY());
    }

    @Override
    double getMyCenterX() {
        return this.circle.getCenterX();
    }

    @Override
    double getHeightByWidthRatio(double width) {
        return width + this.myShape.getBounds2D().getHeight() - this.myShape.getBounds2D().getWidth();
    }
}

