/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.flowchart.symbols;

import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutSegment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.AbstractSymbol;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public final class Joint
extends AbstractSymbol {
    private final Ellipse2D.Double myShape;
    private final LayoutElement parentElement;
    private final LayoutSegment parentSegment;

    public Joint(LayoutElement parentElement, LayoutSegment parentSegment) {
        super(8.0, 8.0);
        this.parentElement = parentElement;
        this.parentSegment = parentSegment;
        this.myShape = new Ellipse2D.Double(0.0, 0.0, super.getMinWidth(), super.getMinHeight());
        super.setShape(this.myShape);
        super.setBorderColor(parentElement.getSymbol().getBorderColor());
        if (parentElement.getSymbol().getShapeUpColor() != null) {
            super.setShapeUpColor(parentElement.getSymbol().getShapeUpColor());
            super.setShapeDownColor(parentElement.getSymbol().getShapeDownColor());
        } else {
            super.setShapeUpColor(Color.WHITE);
            super.setShapeDownColor(new Color(230, 230, 230));
        }
        super.setHasShadow(false);
    }

    public LayoutElement getParentElement() {
        return this.parentElement;
    }

    public LayoutSegment getParentSegment() {
        return this.parentSegment;
    }

    @Override
    public void setValueAndSize(String value) {
    }

    @Override
    public void setDefaultValue(String defaultValue) {
    }

    @Override
    public void setCustomValue(String customValue) {
    }

    @Override
    public Point2D getIntersectionPoint(double sourcePointX, double sourcePointY) {
        return new Point2D.Double(this.myShape.getCenterX(), this.myShape.getCenterY());
    }

    @Override
    void setRect(double x, double y, double width, double height) {
        this.myShape.setFrame(x, y, width, height);
    }
}

