/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.global;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegexFunctions {
    public static String[] splitString(String str, String regex) {
        ArrayList<String> strSplit = new ArrayList<String>();
        Matcher matcher = Pattern.compile(regex).matcher(str);
        int lastEndIndex = 0;
        if (matcher.find()) {
            do {
                strSplit.add(str.substring(lastEndIndex, matcher.start()));
                lastEndIndex = matcher.end();
                strSplit.add(str.substring(matcher.start(), lastEndIndex));
            } while (matcher.find());
            if (lastEndIndex < str.length()) {
                strSplit.add(str.substring(lastEndIndex, str.length()));
            }
        } else {
            strSplit.add(str);
        }
        return strSplit.toArray(new String[0]);
    }

    public static String[] splitStringIgnoreQuotesInsides(String str, String regex) {
        ArrayList<Object> strSplit = new ArrayList<Object>();
        String[] withoutQ = RegexFunctions.splitString(str, "\"([^\"\\\\]|\\\\.)*\"?");
        Object part = "";
        for (int i = 0; i < withoutQ.length; ++i) {
            if (i % 2 == 1) {
                part = (String)part + withoutQ[i];
                continue;
            }
            String[] split = RegexFunctions.splitString(withoutQ[i], regex);
            for (int j = 0; j < split.length; ++j) {
                if (j % 2 == 0) {
                    part = (String)part + split[j];
                    continue;
                }
                strSplit.add(part);
                part = "";
                strSplit.add(split[j]);
            }
        }
        if (!((String)part).equals("")) {
            strSplit.add(part);
        }
        return strSplit.toArray(new String[0]);
    }

    public static String[] varBracketsInsides(String variable) {
        ArrayList<String> strOut = new ArrayList<String>();
        int brackets = 0;
        int lastEndIndex = 0;
        block8: for (int i = 1; i <= variable.length(); ++i) {
            switch (variable.substring(i - 1, i)) {
                case "[": {
                    if (brackets == 0) {
                        strOut.add(variable.substring(lastEndIndex, i));
                        lastEndIndex = i;
                    }
                    ++brackets;
                    continue block8;
                }
                case "]": {
                    if (--brackets != 0) continue block8;
                    strOut.add(variable.substring(lastEndIndex, i - 1));
                    lastEndIndex = i - 1;
                }
            }
        }
        if (lastEndIndex < variable.length()) {
            strOut.add(variable.substring(lastEndIndex, variable.length()));
        }
        return strOut.toArray(new String[0]);
    }

    public static String[] varBracketsInsides(String variable, String openingBracket, String closingingBracket) {
        ArrayList<String> strOut = new ArrayList<String>();
        int brackets = 0;
        int lastEndIndex = 0;
        for (int i = 1; i <= variable.length(); ++i) {
            if (variable.substring(i - 1, i).equals(openingBracket)) {
                if (brackets == 0) {
                    strOut.add(variable.substring(lastEndIndex, i));
                    lastEndIndex = i;
                }
                ++brackets;
                continue;
            }
            if (!variable.substring(i - 1, i).equals(closingingBracket) || --brackets != 0) continue;
            strOut.add(variable.substring(lastEndIndex, i - 1));
            lastEndIndex = i - 1;
        }
        if (lastEndIndex < variable.length()) {
            strOut.add(variable.substring(lastEndIndex, variable.length()));
        }
        return strOut.toArray(new String[0]);
    }

    public static String[] getBracketElements(String arrayVariable) {
        ArrayList<String> strOut = new ArrayList<String>();
        int brackets = 0;
        int lastEndIndex = 0;
        boolean quote = false;
        block12: for (int i = 1; i <= arrayVariable.length(); ++i) {
            switch (arrayVariable.substring(i - 1, i)) {
                case "[": {
                    if (quote) continue block12;
                    if (brackets == 0) {
                        lastEndIndex = i;
                    }
                    ++brackets;
                    continue block12;
                }
                case "]": {
                    if (quote || --brackets != 0) continue block12;
                    strOut.add(arrayVariable.substring(lastEndIndex, i - 1).trim());
                    return strOut.toArray(new String[0]);
                }
                case ",": {
                    if (quote || brackets != 1) continue block12;
                    strOut.add(arrayVariable.substring(lastEndIndex, i - 1).trim());
                    lastEndIndex = i;
                    continue block12;
                }
                case "\"": {
                    quote = !quote;
                }
            }
        }
        return strOut.toArray(new String[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] splitByMethods(String value) {
        String functionRegex = "([a-zA-Z\\_\\$][a-zA-Z0-9\\_\\$]*\\.)*[a-zA-Z\\_\\$][a-zA-Z0-9\\_\\$]*\\(.*\\)";
        ArrayList<String> strOut = new ArrayList<String>();
        int brackets = 0;
        int lastEndIndex = 0;
        Matcher matcher = Pattern.compile(functionRegex).matcher(value);
        while (true) {
            if (matcher.find()) {
                int index = lastEndIndex + matcher.start();
                strOut.add(value.substring(lastEndIndex, index));
                lastEndIndex = index;
            } else {
                if (lastEndIndex < value.length()) {
                    strOut.add(value.substring(lastEndIndex, value.length()));
                }
                return strOut.toArray(new String[strOut.size()]);
            }
            block9: for (int i = lastEndIndex + 1; i <= value.length(); ++i) {
                switch (value.substring(i - 1, i)) {
                    case "(": {
                        ++brackets;
                        break;
                    }
                    case ")": {
                        if (--brackets != 0) break;
                        strOut.add(value.substring(lastEndIndex, i));
                        lastEndIndex = i;
                        break block9;
                    }
                }
            }
            matcher = Pattern.compile(functionRegex).matcher(value.substring(lastEndIndex));
        }
    }
}

