/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.global;

import cz.miroslavbartyzal.psdiagram.app.Main;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.AbstractLayout;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.EnumLayout;
import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ResourceBundle;

public final class SettingsHolder {
    public static final Settings settings;
    private static final JAXBContext jAXBcontext;
    private static final Marshaller jAXBmarshaller;
    public static final File WORKING_DIR;
    public static final File MY_FILE;
    public static final File MY_DIR;
    public static final File MY_WORKING_DIR;
    private static final File settingsFile;
    public static final Font CODEFONT;
    public static final Font SMALL_CODEFONT;
    public static final Font SMALLFONT_SYMBOLDESC;
    public static final FontRenderContext FONTRENDERCONTEXT;
    public static final String PSDIAGRAM_SERVER;
    public static final String PSDIAGRAM_VERSION;
    public static final String PSDIAGRAM_BUILD;
    public static final String PSDIAGRAM_BUILD_NUMBER;
    public static final String PSDIAGRAM_BUILD_DATE;
    public static final String BUILD_PROFILE;
    public static final boolean IS_DEPLOYMENT_MODE;
    public static final File JAVAW;

    private SettingsHolder() {
        throw new AssertionError();
    }

    public static void saveSettings() {
        if (jAXBcontext == null || jAXBmarshaller == null) {
            return;
        }
        if (!WORKING_DIR.exists() && !WORKING_DIR.mkdir()) {
            return;
        }
        try {
            jAXBmarshaller.marshal((Object)settings, settingsFile);
        }
        catch (JAXBException ex) {
            MyExceptionHandler.handle(ex);
        }
    }

    private static Font getCodeFont(float size) {
        String[] fontFamilies;
        for (String fontFamily : fontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            if (!fontFamily.toLowerCase().equals("consolas")) continue;
            return new Font("consolas", 0, (int)size);
        }
        return SettingsHolder.getMyFont(size, "DejaVuSansMono.ttf");
    }

    private static Font getMyFont(float size, String fontName) {
        try {
            Font font = Font.createFont(0, Settings.class.getResourceAsStream("/fonts/" + fontName));
            switch (fontName) {
                case "DejaVuSansMono.ttf": {
                    if (size > 10.0f) {
                        font = font.deriveFont(0, size - 2.0f);
                        break;
                    }
                    font = font.deriveFont(0, size - 1.0f);
                    break;
                }
                case "LiberationMono-Regular.ttf": {
                    font = font.deriveFont(0, size - 1.0f);
                    break;
                }
                default: {
                    font = font.deriveFont(0, size);
                }
            }
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(font);
            return font;
        }
        catch (FontFormatException | IOException e) {
            return new Font("monospaced", 0, (int)size);
        }
    }

    private static File getJavaw() {
        File file = new File(MY_DIR, "jre/bin");
        if (!file.exists()) {
            file = new File(System.getProperty("java.home"), "bin");
        }
        if ((file = SettingsHolder.isWindows() ? new File(file, "javaw.exe") : new File(file, "javaw")).exists()) {
            return file;
        }
        return null;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    static {
        WORKING_DIR = new File(System.getProperty("user.home"), ".psdiagram");
        settingsFile = new File(WORKING_DIR, "settings.xml");
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Font font = Font.createFont(0, Settings.class.getResourceAsStream("/fonts/PSDSpecialSymbols.ttf"));
            ge.registerFont(font);
        }
        catch (FontFormatException | IOException ex) {
            MyExceptionHandler.handle(ex);
        }
        JAXBContext context = null;
        Marshaller marshaller = null;
        try {
            context = JAXBContext.newInstance(Settings.class);
            marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", true);
        }
        catch (JAXBException ex) {
            MyExceptionHandler.handle(ex);
        }
        jAXBcontext = context;
        jAXBmarshaller = marshaller;
        if (jAXBcontext != null && settingsFile.exists()) {
            Settings stngs;
            boolean settingsAreNew = false;
            try {
                stngs = (Settings)jAXBcontext.createUnmarshaller().unmarshal(settingsFile);
                if (!stngs.loadLastFlowchart || stngs.actualFlowchartFile != null && !stngs.actualFlowchartFile.exists()) {
                    stngs.actualFlowchartFile = null;
                }
            }
            catch (JAXBException ex) {
                MyExceptionHandler.handle(ex);
                stngs = new Settings();
                settingsAreNew = true;
            }
            settings = stngs;
            if (settingsAreNew) {
                SettingsHolder.saveSettings();
            }
        } else {
            settings = new Settings();
            SettingsHolder.saveSettings();
        }
        File myFile = null;
        try {
            myFile = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
        }
        catch (URISyntaxException ex) {
            MyExceptionHandler.handle(ex);
        }
        MY_FILE = myFile;
        MY_WORKING_DIR = Paths.get("", new String[0]).toAbsolutePath().toFile();
        MY_DIR = MY_FILE != null ? MY_FILE.getParentFile() : MY_WORKING_DIR;
        CODEFONT = SettingsHolder.getCodeFont(13.0f);
        SMALL_CODEFONT = SettingsHolder.getCodeFont(10.0f);
        SMALLFONT_SYMBOLDESC = new Font("sansserif", 0, 10);
        FONTRENDERCONTEXT = new FontRenderContext(null, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT);
        PSDIAGRAM_SERVER = ResourceBundle.getBundle("application").getString("psdiagramWebUrl");
        PSDIAGRAM_VERSION = ResourceBundle.getBundle("application").getString("version");
        PSDIAGRAM_BUILD = ResourceBundle.getBundle("application").getString("buildInfo");
        PSDIAGRAM_BUILD_NUMBER = PSDIAGRAM_BUILD.replaceAll("\\s.*$", "");
        PSDIAGRAM_BUILD_DATE = PSDIAGRAM_BUILD.replaceAll("^[\\d\\s]+\\(", "").replaceAll("\\)$", "");
        BUILD_PROFILE = ResourceBundle.getBundle("application").getString("buildProfile");
        IS_DEPLOYMENT_MODE = BUILD_PROFILE.equals("deployment");
        JAVAW = SettingsHolder.getJavaw();
    }

    @XmlRootElement(name="settings")
    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlType(name="settings")
    public static final class Settings {
        @XmlElement(name="selectedLayout")
        private String selectedLayout = EnumLayout.TBLRLayout.name();
        @XmlElement(name="blockScopeVariables")
        private boolean blockScopeVariables = false;
        @XmlElement(name="ballShine")
        private boolean ballShine = true;
        @XmlElement(name="ballShineRadius")
        private int ballShineRadius = 200;
        @XmlElement(name="fps")
        private int fps = 25;
        @XmlElement(name="lastDir")
        private String lastDir;
        @XmlElement(name="loadLastFlowchart")
        private boolean loadLastFlowchart = true;
        @XmlElement(name="actualFlowchartFile")
        private File actualFlowchartFile;
        @XmlElement(name="dontSaveDirectly")
        private boolean dontSaveDirectly = false;
        @XmlElement(name="exportTransparency")
        private boolean exportTransparency = true;
        @XmlElement(name="exportFlowchartPadding")
        private int exportFlowchartPadding = AbstractLayout.flowchartPadding;
        @XmlElement(name="proxyHost", defaultValue="")
        private String proxyHost = "";
        @XmlElement(name="proxyPort")
        private int proxyPort = -1;
        @XmlElement(name="associateExtension")
        private Boolean associateExtension;

        public boolean isBallShine() {
            return this.ballShine;
        }

        public void setBallShine(boolean ballShine) {
            this.ballShine = ballShine;
            SettingsHolder.saveSettings();
        }

        public int getBallShineRadius() {
            return this.ballShineRadius;
        }

        public void setBallShineRadius(int ballShineRadius) {
            this.ballShineRadius = ballShineRadius;
            SettingsHolder.saveSettings();
        }

        public boolean isBlockScopeVariables() {
            return this.blockScopeVariables;
        }

        public void setBlockScopeVariables(boolean blockScopeVariables) {
            this.blockScopeVariables = blockScopeVariables;
            SettingsHolder.saveSettings();
        }

        public int getExportFlowchartPadding() {
            return this.exportFlowchartPadding;
        }

        public void setExportFlowchartPadding(int exportFlowchartPadding) {
            this.exportFlowchartPadding = exportFlowchartPadding;
            SettingsHolder.saveSettings();
        }

        public boolean isExportTransparency() {
            return this.exportTransparency;
        }

        public void setExportTransparency(boolean exportTransparency) {
            this.exportTransparency = exportTransparency;
            SettingsHolder.saveSettings();
        }

        public String getLastDir() {
            return this.lastDir;
        }

        public void setLastDir(String lastDir) {
            this.lastDir = lastDir;
            SettingsHolder.saveSettings();
        }

        public File getActualFlowchartFile() {
            return this.actualFlowchartFile;
        }

        public void setActualFlowchartFile(File actualFlowchartFile) {
            this.actualFlowchartFile = actualFlowchartFile;
            SettingsHolder.saveSettings();
        }

        public boolean isLoadLastFlowchart() {
            return this.loadLastFlowchart;
        }

        public void setLoadLastFlowchart(boolean loadLastFlowchart) {
            this.loadLastFlowchart = loadLastFlowchart;
            SettingsHolder.saveSettings();
        }

        public boolean isDontSaveDirectly() {
            return this.dontSaveDirectly;
        }

        public void setDontSaveDirectly(boolean dontSaveDirectly) {
            this.dontSaveDirectly = dontSaveDirectly;
            SettingsHolder.saveSettings();
        }

        public String getSelectedLayout() {
            return this.selectedLayout;
        }

        public void setSelectedLayout(String selectedLayout) {
            this.selectedLayout = selectedLayout;
            SettingsHolder.saveSettings();
        }

        public int getFps() {
            return this.fps;
        }

        public void setFps(int fps) {
            this.fps = fps;
            SettingsHolder.saveSettings();
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public void setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            SettingsHolder.saveSettings();
        }

        public int getProxyPort() {
            return this.proxyPort;
        }

        public void setProxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            SettingsHolder.saveSettings();
        }

        public Boolean getAssociateExtension() {
            return this.associateExtension;
        }

        public void setAssociateExtension(Boolean associateExtension) {
            this.associateExtension = associateExtension;
        }
    }
}

