/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.global.xmlAdapters;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public final class LinkedHashMapAdapter
extends XmlAdapter<MapType, LinkedHashMap<String, String>> {
    @Override
    public MapType marshal(LinkedHashMap<String, String> map) {
        if (map == null) {
            return null;
        }
        MapType mapType = new MapType();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            mapType.entryList.add(new MapEntry(entry.getKey(), entry.getValue()));
        }
        return mapType;
    }

    @Override
    public LinkedHashMap<String, String> unmarshal(MapType type) throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (MapEntry entry : type.entryList) {
            map.put(entry.key, entry.value);
        }
        return map;
    }

    public static class MapEntry {
        @XmlAttribute(name="key")
        private String key;
        @XmlValue
        private String value;

        private MapEntry() {
        }

        public MapEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    public static class MapType {
        @XmlElement(name="entry")
        private ArrayList<MapEntry> entryList = new ArrayList();

        private MapType() {
        }
    }
}

