/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.global.xmlAdapters;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.persistence.oxm.annotations.XmlCDATA;

public final class MapChangesAdapter
extends XmlAdapter<MapType, Map<String, String>> {
    @Override
    public MapType marshal(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        MapType mapType = new MapType();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            mapType.entryList.add(new MapEntry(entry.getKey(), entry.getValue()));
        }
        return mapType;
    }

    @Override
    public Map<String, String> unmarshal(MapType type) throws Exception {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (MapEntry entry : type.entryList) {
            map.put(entry.version, entry.message.trim());
        }
        return map;
    }

    @XmlType(namespace="MapChangesAdapter")
    public static final class MapEntry {
        @XmlAttribute(name="id")
        private String version;
        @XmlCDATA
        @XmlValue
        private String message;

        private MapEntry() {
        }

        public MapEntry(String version, String message) {
            this.version = version;
            this.message = message;
        }
    }

    @XmlType(namespace="MapChangesAdapter")
    public static final class MapType {
        @XmlElement(name="version")
        private List<MapEntry> entryList = new ArrayList<MapEntry>();

        private MapType() {
        }
    }
}

