/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.global.xmlAdapters;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class MapChangesCalendarAdapter
extends XmlAdapter<MapType, Map<String, Calendar>> {
    @Override
    public MapType marshal(Map<String, Calendar> map) {
        if (map == null) {
            return null;
        }
        MapType mapType = new MapType();
        for (Map.Entry<String, Calendar> entry : map.entrySet()) {
            mapType.entryList.add(new MapEntry(entry.getKey(), entry.getValue().get(1) + "-" + entry.getValue().get(2) + "-" + entry.getValue().get(5)));
        }
        return mapType;
    }

    @Override
    public Map<String, Calendar> unmarshal(MapType type) throws Exception {
        TreeMap<String, Calendar> map = new TreeMap<String, Calendar>();
        for (MapEntry entry : type.entryList) {
            String[] s = entry.date.trim().split("\\-");
            map.put(entry.version, new GregorianCalendar(Integer.parseInt(s[0]), Integer.parseInt(s[1]), Integer.parseInt(s[2])));
        }
        return map;
    }

    @XmlType(namespace="MapChangesCalendarAdapter")
    public static final class MapEntry {
        @XmlAttribute(name="id")
        private String version;
        @XmlValue
        private String date;

        private MapEntry() {
        }

        public MapEntry(String version, String date) {
            this.version = version;
            this.date = date;
        }
    }

    @XmlType(namespace="MapChangesCalendarAdapter")
    public static final class MapType {
        @XmlElement(name="version")
        private List<MapEntry> entryList = new ArrayList<MapEntry>();

        private MapType() {
        }
    }
}

