/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui;

import cz.miroslavbartyzal.psdiagram.app.flowchart.Flowchart;
import cz.miroslavbartyzal.psdiagram.app.global.GlobalFunctions;
import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import cz.miroslavbartyzal.psdiagram.app.global.SettingsHolder;
import cz.miroslavbartyzal.psdiagram.app.gui.MainWindow;
import cz.miroslavbartyzal.psdiagram.app.persistence.FlowchartSaveContainer;
import jakarta.xml.bind.JAXBException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ExamplesLoader {
    public static final String EXAMPLES_DIR = "examples";
    public static final File WORKING_DIR_EXAMPLES = new File(SettingsHolder.WORKING_DIR, "examples");
    public static final File MY_DIR_EXAMPLES = new File(SettingsHolder.MY_DIR, "examples");
    public static final File MY_WORKING_DIR_EXAMPLES = new File(SettingsHolder.MY_WORKING_DIR, "examples");

    public static ArrayList<Component> getExamplesMenuItems(ExampleActionListener exampleActionListener) {
        TreeSet<File> examples = new TreeSet<File>(new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                String path2L;
                String path1 = f1.getAbsolutePath().replaceFirst("^.+examples", "");
                String path2 = f2.getAbsolutePath().replaceFirst("^.+examples", "");
                String path1L = path1.toLowerCase(Locale.ENGLISH);
                if (!path1L.equals(path2L = path2.toLowerCase(Locale.ENGLISH))) {
                    return path1L.compareTo(path2L);
                }
                return path1.compareTo(path2);
            }
        });
        examples.addAll(ExamplesLoader.loadFiles());
        if (!examples.isEmpty()) {
            return ExamplesLoader.loadExamples(examples, exampleActionListener);
        }
        ArrayList<Component> ret = new ArrayList<Component>();
        JMenuItem item = new JMenuItem("nenalezeny \u017e\u00e1dn\u00e9 algoritmy...");
        item.setEnabled(false);
        item.setToolTipText(ExamplesLoader.getExamplesLocationLoadToolTip());
        ret.add(item);
        return ret;
    }

    public static ArrayList<File> loadFiles() {
        ArrayList<File> files = new ArrayList<File>();
        if (WORKING_DIR_EXAMPLES.exists() || WORKING_DIR_EXAMPLES.mkdirs()) {
            files.addAll(ExamplesLoader.loadFiles(WORKING_DIR_EXAMPLES));
        }
        if (MY_DIR_EXAMPLES.exists()) {
            files.addAll(ExamplesLoader.loadFiles(MY_DIR_EXAMPLES));
        }
        if (!MY_DIR_EXAMPLES.equals(MY_WORKING_DIR_EXAMPLES) && MY_WORKING_DIR_EXAMPLES.exists()) {
            files.addAll(ExamplesLoader.loadFiles(MY_WORKING_DIR_EXAMPLES));
        }
        return files;
    }

    public static ArrayList<File> loadFiles(File parentDirectory) {
        ArrayList<File> files = new ArrayList<File>();
        for (File f : parentDirectory.listFiles()) {
            if (!f.isDirectory()) {
                if (!ExamplesLoader.isValidFlowchartFile(f, true)) continue;
                files.add(f);
                continue;
            }
            ArrayList<File> subFiles = ExamplesLoader.loadFiles(f);
            if (subFiles.isEmpty()) continue;
            files.add(f);
            for (File file : subFiles) {
                files.add(file);
            }
        }
        return files;
    }

    private static ArrayList<Component> loadExamples(SortedSet<File> filesCollection, final ExampleActionListener exampleActionListener) {
        ArrayList<Component> jMenuItems = new ArrayList<Component>();
        int dirsAddedCount = 0;
        while (!filesCollection.isEmpty()) {
            File f = filesCollection.first();
            filesCollection.remove(f);
            if (!f.isDirectory()) {
                JMenuItem item = new JMenuItem(f.getName().substring(0, f.getName().lastIndexOf(".")));
                item.setToolTipText(f.getAbsolutePath());
                item.setActionCommand(f.getAbsolutePath());
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        exampleActionListener.exampleActionPerformed(e.getActionCommand());
                    }
                });
                item.setIcon(new ImageIcon(ExamplesLoader.class.getResource("/img/menuitems/16-File.png")));
                jMenuItems.add(item);
                continue;
            }
            JMenu subMenu = new JMenu(f.getName());
            for (File toFile : filesCollection) {
                if (toFile.getAbsolutePath().startsWith(f.getAbsolutePath()) && !toFile.equals(filesCollection.last())) continue;
                ArrayList<Component> subItems = !toFile.getAbsolutePath().startsWith(f.getAbsolutePath()) ? ExamplesLoader.loadExamples(filesCollection.headSet(toFile), exampleActionListener) : ExamplesLoader.loadExamples(filesCollection, exampleActionListener);
                for (Component component : subItems) {
                    subMenu.add(component);
                }
            }
            subMenu.setIcon(new ImageIcon(ExamplesLoader.class.getResource("/img/menuitems/16-Open.png")));
            jMenuItems.add(dirsAddedCount, subMenu);
            ++dirsAddedCount;
        }
        if (dirsAddedCount > 0) {
            jMenuItems.add(dirsAddedCount, new JPopupMenu.Separator());
        }
        return jMenuItems;
    }

    public static boolean isValidFlowchartFile(File file, boolean tryToLoadIt) {
        if (file.getName().endsWith(".xml") || file.getName().endsWith(".psdiagram")) {
            if (!tryToLoadIt) {
                return true;
            }
            try {
                if (file.getName().endsWith(".xml")) {
                    Flowchart flowchart = (Flowchart)GlobalFunctions.unsafeCast(MainWindow.unmarshal(file));
                } else {
                    FlowchartSaveContainer flowchartSaveContainer = (FlowchartSaveContainer)GlobalFunctions.unsafeCast(MainWindow.unmarshal(file));
                }
                return true;
            }
            catch (JAXBException | FileNotFoundException ex) {
                MyExceptionHandler.handle(ex);
            }
        }
        return false;
    }

    public static String getExamplesLocationLoadToolTip() {
        String toolTip = "<html>Algoritmy jsou na\u010d\u00edt\u00e1ny z n\u00e1sleduj\u00edc\u00edch um\u00edst\u011bn\u00ed: <br />" + WORKING_DIR_EXAMPLES + "<br />" + MY_DIR_EXAMPLES;
        if (!MY_WORKING_DIR_EXAMPLES.equals(MY_DIR_EXAMPLES)) {
            toolTip = toolTip + "<br />" + MY_WORKING_DIR_EXAMPLES;
        }
        toolTip = toolTip + "</html>";
        return toolTip;
    }

    public static interface ExampleActionListener {
        public void exampleActionPerformed(String var1);
    }
}

