/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui;

import cz.miroslavbartyzal.psdiagram.app.global.GlobalFunctions;
import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import cz.miroslavbartyzal.psdiagram.app.global.SettingsHolder;
import cz.miroslavbartyzal.psdiagram.app.gui.JFrameUpdateChild;
import cz.miroslavbartyzal.psdiagram.app.gui.dialog.MyJOptionPane;
import cz.miroslavbartyzal.psdiagram.app.update.ChangesCondenser;
import cz.miroslavbartyzal.psdiagram.app.update.Updater;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;

public class JFrameUpdate
extends JFrame
implements PropertyChangeListener {
    private final Updater updater;
    private String fileSize;
    private boolean downloadInProgress;
    private final Updater.BeforeExitListener beforeExitListener;
    private JButton jButtonDoIn;
    private JButton jButtonWebIntro;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelDescription;
    private JLabel jLabelHeading;
    private JLabel jLabelIntro;
    private JLabel jLabelNewVersion;
    private JLabel jLabelOldVersion;
    private JLabel jLabelSizes;
    private JLabel jLabelSpeed;
    private JLabel jLabelStatus;
    private JLabel jLabelTitle;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JProgressBar jProgressBar;
    private JScrollPane jScrollPane2;
    private JTextPane jTextPaneNews;

    public JFrameUpdate(Updater updater, Updater.BeforeExitListener beforeExitListener) {
        this.updater = updater;
        this.beforeExitListener = beforeExitListener;
        super.setDefaultCloseOperation(1);
        this.initComponents();
        this.jScrollPane2.getVerticalScrollBar().setUnitIncrement(10);
        this.jScrollPane2.getViewport().setScrollMode(0);
    }

    @Override
    public void setVisible(boolean visibility) {
        if (visibility && !super.isVisible()) {
            if (!this.updater.hasNewerVersion()) {
                final JFrameUpdateChild child = new JFrameUpdateChild();
                child.setLocationRelativeTo(this);
                child.setVisible(true);
                this.updater.loadInfo(child, new Updater.InfoLoadListener(){

                    @Override
                    public void onInfoLoaded(Boolean newVersionAvailable) {
                        if (child.isVisible()) {
                            if (Boolean.TRUE.equals(newVersionAvailable)) {
                                child.dispose();
                                JFrameUpdate.this.setVisible(true);
                            } else {
                                child.setNoUpdateState();
                            }
                        }
                    }
                });
                return;
            }
            this.setInfo(this.updater.getChangesCondenser());
        }
        super.setVisible(visibility);
    }

    private void setInfo(ChangesCondenser condenser) {
        String newVersion = condenser.getTopVersion();
        Object ov = SettingsHolder.PSDIAGRAM_VERSION;
        Object nv = newVersion;
        if (condenser.getReleaseDates() != null) {
            ov = condenser.getReleaseDates().get(ov) != null ? (String)ov + " (" + condenser.getReleaseDates().get(ov).get(5) + "." + (condenser.getReleaseDates().get(ov).get(2) + 1) + "." + condenser.getReleaseDates().get(ov).get(1) + ")" : (String)ov + " (" + SettingsHolder.PSDIAGRAM_BUILD_DATE + ")";
            if (condenser.getReleaseDates().get(nv) != null) {
                nv = (String)nv + " (" + condenser.getReleaseDates().get(nv).get(5) + "." + (condenser.getReleaseDates().get(nv).get(2) + 1) + "." + condenser.getReleaseDates().get(nv).get(1) + ")";
            }
        }
        this.jLabelOldVersion.setText((String)ov);
        this.jLabelNewVersion.setText((String)nv);
        this.resetProgress();
        int newVersionsCount = condenser.getAllVersions().size();
        if (newVersionsCount == 1 && condenser.getReleaseURLs() != null && condenser.getReleaseURLs().get(newVersion) != null) {
            this.setUrlAnchor("Podrobn\u00e9 p\u0159edstaven\u00ed nov\u00e9 verze:", condenser.getReleaseURLs().get(newVersion), "www.psdiagram.cz");
        } else if (newVersionsCount > 1 && condenser.getChanglelogURL() != null) {
            this.setUrlAnchor("Kompletn\u00ed seznam zm\u011bn je k nalezen\u00ed na:", condenser.getChanglelogURL(), null);
        } else {
            this.jLabelIntro.setText(null);
            this.jButtonWebIntro.setText(null);
            this.jButtonWebIntro.setToolTipText(null);
        }
        this.jButtonWebIntro.requestFocus();
        if (newVersionsCount == 1 && condenser.getHeadlines() != null && condenser.getDescriptions() != null) {
            String headline = condenser.getHeadlines().get(newVersion);
            String description = condenser.getDescriptions().get(newVersion);
            if (headline == null && description != null) {
                this.jLabelHeading.setText(newVersion);
            } else {
                this.jLabelHeading.setText(headline);
            }
            this.jLabelDescription.setText(description);
        } else {
            this.jLabelHeading.setText(null);
            this.jLabelDescription.setText(null);
        }
        this.jTextPaneNews.setText(this.updater.getChangesHTML());
        this.jPanel2.revalidate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrameUpdate.this.jScrollPane2.getVerticalScrollBar().setValue(0);
            }
        });
    }

    private void setUrlAnchor(String text, final String url, String urlText) {
        this.jLabelIntro.setText(text);
        if (urlText == null || urlText.isEmpty()) {
            urlText = url.replaceAll("^http\\:\\/\\/", "");
        }
        this.jButtonWebIntro.setText("<html><font color=\"#000099\"><u>" + urlText + "</u></font></html>");
        this.jButtonWebIntro.setToolTipText(url);
        this.jButtonWebIntro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(URI.create(url));
                    }
                    catch (IOException ex) {
                        MyExceptionHandler.handle(ex);
                    }
                }
            }
        });
    }

    private void resetProgress() {
        this.jLabelSpeed.setText(" ");
        this.jLabelSizes.setText(" ");
        this.jProgressBar.setIndeterminate(false);
        this.jProgressBar.setValue(0);
        this.jProgressBar.setStringPainted(false);
        this.jProgressBar.setEnabled(true);
        this.jButtonDoIn.setText("St\u00e1hnout a nainstalovat");
        this.jLabelStatus.setText(null);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabelTitle = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabelOldVersion = new JLabel();
        this.jLabelNewVersion = new JLabel();
        this.jButtonDoIn = new JButton();
        this.jProgressBar = new JProgressBar();
        this.jLabelStatus = new JLabel();
        this.jLabelSizes = new JLabel();
        this.jLabelSpeed = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel3 = new JPanel();
        this.jLabelIntro = new JLabel();
        this.jButtonWebIntro = new JButton();
        this.jLabelHeading = new JLabel();
        this.jPanel2 = new JPanel();
        this.jTextPaneNews = new JTextPane();
        this.jLabelDescription = new JLabel();
        this.setTitle("Aktualizace PS Diagramu");
        this.setAlwaysOnTop(true);
        this.setMinimumSize(new Dimension(500, 500));
        this.setResizable(false);
        this.setType(Window.Type.UTILITY);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(""));
        this.jLabelTitle.setFont(new Font("sansserif", 1, 24));
        this.jLabelTitle.setHorizontalAlignment(0);
        this.jLabelTitle.setText("Vy\u0161la nov\u00e1 verze PS Diagramu! :)");
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("St\u00e1vaj\u00edc\u00ed verze:");
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Verze k dispozici:");
        this.jLabelOldVersion.setFont(new Font("sansserif", 0, 11));
        this.jLabelOldVersion.setText("1.0.2.5 (25.6.2013)");
        this.jLabelNewVersion.setText("1.1.0.3 (10.9.2013)");
        this.jButtonDoIn.setText("St\u00e1hnout a nainstalovat");
        this.jButtonDoIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFrameUpdate.this.jButtonDoInActionPerformed(evt);
            }
        });
        this.jProgressBar.setValue(20);
        this.jProgressBar.setStringPainted(true);
        this.jLabelStatus.setText("chyba p\u0159i stahov\u00e1n\u00ed souboru");
        this.jLabelSizes.setHorizontalAlignment(4);
        this.jLabelSizes.setText("5 KB / 2.1 MB");
        this.jLabelSizes.setVerticalAlignment(3);
        this.jLabelSpeed.setText("30 KB/s");
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setVerticalScrollBarPolicy(22);
        this.jLabelIntro.setText("Kompletn\u00ed seznam zm\u011bn je k nalezen\u00ed na:");
        this.jLabelIntro.setToolTipText("");
        this.jButtonWebIntro.setText("<html> <FONT color=\\\"#000099\\\"><U>www.psdiagram.cz/changelog</U></FONT> </html>");
        this.jButtonWebIntro.setAlignmentY(0.0f);
        this.jButtonWebIntro.setBorder(null);
        this.jButtonWebIntro.setBorderPainted(false);
        this.jButtonWebIntro.setContentAreaFilled(false);
        this.jButtonWebIntro.setCursor(new Cursor(12));
        this.jButtonWebIntro.setHorizontalAlignment(2);
        this.jLabelHeading.setFont(new Font("sansserif", 0, 18));
        this.jLabelHeading.setText("A\u0165 \u017eij\u00ed aktualizace!");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("<html>Dal\u0161\u00ed informace</html>"));
        this.jTextPaneNews.setEditable(false);
        this.jTextPaneNews.setBorder(null);
        this.jTextPaneNews.setContentType("text/html");
        this.jTextPaneNews.setText("<html>\n<style type=\"text/css\">\nbody { background-color:D6D9DF; }\nh2 { font-size: 19;\nmargin: 0;\nmargin-left: 2; \nmargin-top: 5; \npadding: 0;  }\nul { margin-left: 30;\nmargin-bottom: 10; }\nli { margin-bottom: 2; }\n</style>\n<h2>Nov\u00e9 funkce</h2>\n<ul>\n<li>automatick\u00e9 aktualizace</li>\n<li>dal\u0161\u00ed polo\u017eka</li>\n</ul>\n<h2>Vylep\u0161en\u00ed</h2>\n<lu>\n<li>dlouh\u00e1 polo\u017eka dlouh\u00e1 polo\u017eka dlouh\u00e1 polo\u017eka dlouh\u00e1 polo\u017eka dlouh\u00e1 polo\u017eka dlouh\u00e1 polo\u017eka dlouh\u00e1 polo\u017eka dlouh\u00e1 polo\u017eka dlouh\u00e1 polo\u017eka</li>\n<li>polo\u017eka</li>\n</lu>\n</html>");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jTextPaneNews, -2, 405, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextPaneNews, -2, -1, -2));
        this.jLabelDescription.setText("<html> Kone\u010dn\u011b jsme se do\u010dkali. Nov\u00e1 verze PS Diagramu p\u0159in\u00e1\u0161\u00ed funkci automatick\u00fdch aktualizac\u00ed. Nejen \u017ee je aplikace schopna sama detekovat p\u0159\u00edtomnost nov\u00fdch verz\u00ed, um\u00ed je dokonce stahnout a sama nainstalovat.\n<br /><br />\nPS: u\u017eijte si to :)\n</html>");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabelHeading, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelDescription, -2, 0, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabelIntro).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonWebIntro, -2, 255, -2))).addContainerGap(158, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelIntro).addComponent(this.jButtonWebIntro, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelHeading).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelDescription, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()));
        this.jScrollPane2.setViewportView(this.jPanel3);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -1, 237, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelNewVersion, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelOldVersion, -1, -1, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelTitle, -1, 474, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabelStatus, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDoIn)).addComponent(this.jProgressBar, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabelSpeed, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelSizes, -1, -1, Short.MAX_VALUE))).addContainerGap()))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelTitle).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabelOldVersion)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabelNewVersion)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelSizes).addComponent(this.jLabelSpeed)).addGap(0, 0, 0).addComponent(this.jProgressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonDoIn).addComponent(this.jLabelStatus)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane2, -1, 392, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonDoInActionPerformed(ActionEvent evt) {
        if (!GlobalFunctions.isWindows()) {
            JEditorPane ep = new JEditorPane("text/html", "<html>Aktualizace PS Diagramu je (prozat\u00edm) vyv\u00edjena jen pro opera\u010dn\u00ed syst\u00e9m Windows.<br />St\u00e1le ji v\u0161ak m\u016f\u017eete prov\u00e9st sami sta\u017een\u00edm nov\u00e9 verze aplikace na str\u00e1nk\u00e1ch <a href=\"" + SettingsHolder.PSDIAGRAM_SERVER + "\">psdiagram.cz</a>.</html>");
            ep.addHyperlinkListener(e -> {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        try {
                            Desktop.getDesktop().browse(e.getURL().toURI());
                        }
                        catch (URISyntaxException uRISyntaxException) {}
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            ep.setEditable(false);
            ep.setBackground(new Color(0, 0, 0, 0));
            MyJOptionPane.showMessageDialog(null, ep, "Nepodporovan\u00fd oprera\u010dn\u00ed syst\u00e9m", 2);
            return;
        }
        if (!this.downloadInProgress) {
            this.resetProgress();
            this.downloadInProgress = true;
            this.jButtonDoIn.setText("Zru\u0161it");
            this.fileSize = null;
            this.updater.downloadAndInstallUdate(this, this.beforeExitListener);
            this.jProgressBar.setIndeterminate(true);
        } else {
            this.updater.cancelDownloadAndInstallUdate();
            this.jProgressBar.setEnabled(false);
            this.jButtonDoIn.setText("St\u00e1hnout a nainstalovat");
            this.downloadInProgress = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (this.downloadInProgress) {
            switch (propertyName) {
                case "status": {
                    String message;
                    switch (message = (String)evt.getNewValue()) {
                        case "stahuji...": {
                            this.jProgressBar.setIndeterminate(false);
                            this.jProgressBar.setStringPainted(true);
                            break;
                        }
                        case "ov\u011b\u0159uji kontroln\u00ed sou\u010det": {
                            this.jLabelSpeed.setText(" ");
                            this.jProgressBar.setStringPainted(false);
                            this.jProgressBar.setValue(100);
                            this.jProgressBar.setIndeterminate(true);
                            break;
                        }
                    }
                    this.jLabelStatus.setText(message);
                    break;
                }
                case "speed": {
                    float speed = ((Integer)evt.getNewValue()).intValue();
                    DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance();
                    symbols.setGroupingSeparator(' ');
                    DecimalFormat df = new DecimalFormat("###,##0.#", symbols);
                    df.setRoundingMode(RoundingMode.HALF_UP);
                    this.jLabelSpeed.setText(df.format(speed / 1000.0f) + " KB/s");
                    break;
                }
                case "currentsize": {
                    long currentSize = (Long)evt.getNewValue();
                    this.jLabelSizes.setText(this.getProperFileSize(currentSize));
                    if (this.fileSize == null || this.fileSize.equals("")) break;
                    this.jLabelSizes.setText(this.jLabelSizes.getText() + " / " + this.fileSize);
                    break;
                }
                case "progress": {
                    this.jProgressBar.setValue((Integer)evt.getNewValue());
                    break;
                }
                case "filesize": {
                    this.fileSize = this.getProperFileSize((Long)evt.getNewValue());
                    break;
                }
                case "error": {
                    String message = (String)evt.getNewValue();
                    this.jLabelStatus.setText(message);
                    this.jProgressBar.setIndeterminate(false);
                    this.jProgressBar.setEnabled(false);
                    this.jButtonDoIn.setText("Zkusit to znovu");
                    this.downloadInProgress = false;
                }
            }
        } else if (propertyName.equals("status") && evt.getNewValue().equals("stahov\u00e1n\u00ed zru\u0161eno")) {
            this.jLabelStatus.setText((String)evt.getNewValue());
        }
    }

    private String getProperFileSize(long sizeInBytes) {
        if (sizeInBytes < 1000L) {
            return sizeInBytes + "B";
        }
        int exp = (int)(Math.log(sizeInBytes) / Math.log(1000.0));
        DecimalFormat df = new DecimalFormat("0.#");
        df.setRoundingMode(RoundingMode.HALF_UP);
        return df.format((double)sizeInBytes / Math.pow(1000.0, exp)) + "KMGTPE".charAt(exp - 1) + "B";
    }
}

