/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui;

import cz.miroslavbartyzal.psdiagram.app.flowchart.Flowchart;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.EnumLayout;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.Layout;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutSegment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Comment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Decision;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Ellipsis;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.EnumSymbol;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.For;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Goto;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.GotoLabel;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.IO;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.LoopEnd;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.LoopStart;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Process;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.StartEnd;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.SubRoutine;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Switch;
import cz.miroslavbartyzal.psdiagram.app.global.GlobalFunctions;
import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import cz.miroslavbartyzal.psdiagram.app.global.RegexFunctions;
import cz.miroslavbartyzal.psdiagram.app.global.SettingsHolder;
import cz.miroslavbartyzal.psdiagram.app.gui.ExamplesLoader;
import cz.miroslavbartyzal.psdiagram.app.gui.JFrameAbout;
import cz.miroslavbartyzal.psdiagram.app.gui.JFrameCodeExport;
import cz.miroslavbartyzal.psdiagram.app.gui.JFrameCodeImport;
import cz.miroslavbartyzal.psdiagram.app.gui.JFrameSettings;
import cz.miroslavbartyzal.psdiagram.app.gui.JFrameUpdate;
import cz.miroslavbartyzal.psdiagram.app.gui.JPanelVariables;
import cz.miroslavbartyzal.psdiagram.app.gui.MyFileChooser;
import cz.miroslavbartyzal.psdiagram.app.gui.balloonToolTip.MaxBalloonSizeCallback;
import cz.miroslavbartyzal.psdiagram.app.gui.dialog.MyJOptionPane;
import cz.miroslavbartyzal.psdiagram.app.gui.managers.FlowchartDebugManager;
import cz.miroslavbartyzal.psdiagram.app.gui.managers.FlowchartEditManager;
import cz.miroslavbartyzal.psdiagram.app.gui.managers.FlowchartEditUndoManager;
import cz.miroslavbartyzal.psdiagram.app.gui.managers.FlowchartOverlookManager;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.AbstractSymbolFunctionForm;
import cz.miroslavbartyzal.psdiagram.app.network.TimeCollector;
import cz.miroslavbartyzal.psdiagram.app.persistence.FlowchartSaveContainer;
import cz.miroslavbartyzal.psdiagram.app.persistence.collector.FlowchartCollector;
import cz.miroslavbartyzal.psdiagram.app.persistence.recovery.FlowchartCrashRecovery;
import cz.miroslavbartyzal.psdiagram.app.persistence.recovery.FlowchartRecovery;
import cz.miroslavbartyzal.psdiagram.app.update.Updater;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputAdapter;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.pdf.PDFGraphics2D;

public final class MainWindow
extends JFrame {
    private final String WINDOW_TITLE = "PS Diagram";
    private Layout layout;
    private boolean editMode = true;
    private boolean animationMode = false;
    private final FlowchartEditManager flowchartEditManager;
    private final FlowchartOverlookManager flowchartOverlookManager;
    private final FlowchartDebugManager flowchartDebugManager;
    private final JPanelDiagram jPnlDiagram;
    private AffineTransform affineTransform;
    private boolean graphicsXTransformedByScrollbar = false;
    private boolean graphicsYTransformedByScrollbar = false;
    private final JPanelVariables jPanelVariables = new JPanelVariables();
    private final JFrameSettings jFrameSettings;
    private final JFrameCodeImport jFrameCodeImport;
    private final JFrameCodeExport jFrameCodeExport;
    private final JFrameAbout jFrameAbout;
    private final JFrameUpdate jFrameUpdate;
    private static final JAXBContext jAXBcontext = MainWindow.createJAXBContext();
    private final FlowchartCrashRecovery flowchartCrashRecovery;
    private final FlowchartCollector flowchartCollector;
    private static Timer statusTimer = new Timer(0, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ae) {
            jLabelStatus.setText("");
            statusTimer.stop();
        }
    });
    private JButton jButtonLaunch;
    private JToggleButton jButtonToolAnimation;
    private JToggleButton jButtonToolEdit;
    private JButton jButtonToolNew;
    private JButton jButtonToolNext;
    private JButton jButtonToolOpen;
    private JButton jButtonToolPlayPause;
    private JButton jButtonToolPrevious;
    private JButton jButtonToolRedo;
    private JButton jButtonToolSave;
    private JButton jButtonToolStop;
    private JButton jButtonToolUndo;
    private JButton jButtonToolZoomIn;
    private JButton jButtonToolZoomOut;
    private JCheckBox jCheckBoxDefaultText;
    private JComboBox<String> jComboBoxSegment;
    private JLabel jLabelFunction;
    private static JLabel jLabelStatus;
    private JLabel jLabelZoom;
    private JMenu jMenuAlgorithms;
    private JMenuBar jMenuBar1;
    private JMenu jMenuConfiguration;
    private JMenu jMenuEdit;
    private JMenu jMenuFile;
    private JMenu jMenuHelp;
    private JMenuItem jMenuItemAbout;
    private JMenuItem jMenuItemCodeExport;
    private JMenuItem jMenuItemCodeImport;
    private JMenuItem jMenuItemCopy;
    private JMenuItem jMenuItemCut;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemExportImage;
    private JMenuItem jMenuItemExportPDF;
    private JMenuItem jMenuItemNew;
    private JMenuItem jMenuItemOpen;
    private JMenuItem jMenuItemPaste;
    private JMenuItem jMenuItemRedo;
    private JMenuItem jMenuItemSave;
    private JMenuItem jMenuItemSaveAs;
    private JMenuItem jMenuItemSettings;
    private JMenuItem jMenuItemUndo;
    private JMenuItem jMenuItemUpdate;
    private JMenu jMenuLayoutSetting;
    private JMenu jMenuLayouts;
    private JPanel jPanelDetails;
    private JPanel jPanelDiagram;
    private JPanel jPanelEdit;
    private JPanel jPanelInnerFunction;
    private JPanel jPanelInnerText;
    private JPanel jPanelLeftSplit;
    private JPanel jPanelOuterFunction;
    private JPanel jPanelOuterText;
    private JPanel jPanelStatus;
    private JPanel jPanelTextSegment;
    private JPanel jPanelTextSymbol;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneDiagram;
    private JScrollPane jScrollPaneFunction;
    private JScrollPane jScrollPaneText;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator10;
    private JPopupMenu.Separator jSeparator11;
    private JPopupMenu.Separator jSeparator12;
    private JToolBar.Separator jSeparator13;
    private JPopupMenu.Separator jSeparator14;
    private JPopupMenu.Separator jSeparator15;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JToolBar.Separator jSeparator8;
    private JToolBar.Separator jSeparator9;
    private JSlider jSliderSpeed;
    private JSlider jSliderZoom;
    private JSplitPane jSplitPane;
    private JTabbedPane jTabbedPaneEdit;
    private JTextArea jTextAreaTextSymbol;
    private JTextField jTextFieldTextSegment;
    private JToolBar jToolBarMenu;
    private JToolBar jToolBarSymbols;

    /*
     * WARNING - void declaration
     */
    private MainWindow(File flowchartToOpen) {
        void var7_15;
        System.setProperty("java.net.useSystemProxies", "true");
        this.initComponents();
        super.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                MainWindow.this.exit();
            }
        });
        ButtonGroup layoutGroup = new ButtonGroup();
        for (EnumLayout enumLayout : EnumLayout.values()) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(enumLayout.getName());
            if (enumLayout.equals((Object)EnumLayout.valueOf(SettingsHolder.settings.getSelectedLayout()))) {
                jRadioButtonMenuItem.setSelected(true);
                this.layout = enumLayout.getInstance(this.jPanelDiagram, null);
                this.loadLayoutSettings();
            }
            jRadioButtonMenuItem.setActionCommand("layout/" + enumLayout.name());
            layoutGroup.add(jRadioButtonMenuItem);
            this.jMenuLayouts.add((Component)jRadioButtonMenuItem, 0);
        }
        ArrayList<Component> examples = ExamplesLoader.getExamplesMenuItems(new ExamplesLoader.ExampleActionListener(){

            @Override
            public void exampleActionPerformed(String examplePath) {
                MainWindow.this.openDiagram(new File(examplePath));
                SettingsHolder.settings.setDontSaveDirectly(true);
            }
        });
        for (Component component : examples) {
            this.jMenuAlgorithms.add(component);
        }
        this.jMenuAlgorithms.setToolTipText(ExamplesLoader.getExamplesLocationLoadToolTip());
        this.jPanelVariables.setVisible(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (super.getWidth() + 20 > screenSize.width) {
            super.setSize(screenSize.width - 20, super.getHeight());
        }
        if (super.getHeight() + 20 > screenSize.height) {
            super.setSize(super.getWidth(), screenSize.height - 20);
        }
        this.jPnlDiagram = (JPanelDiagram)this.jPanelDiagram;
        TimeCollector.getTimeAndDate(SettingsHolder.PSDIAGRAM_SERVER);
        this.jTextAreaTextSymbol.setFont(SettingsHolder.CODEFONT);
        AbstractSymbolFunctionForm.enhanceWithUndoRedoCapability(this.jTextAreaTextSymbol);
        this.jTextFieldTextSegment.setFont(SettingsHolder.SMALL_CODEFONT.deriveFont(13.0f));
        this.jPanelDiagram.setFocusable(true);
        this.jPanelDiagram.requestFocusInWindow();
        this.jPanelDiagram.setTransferHandler(this.createTransferHandler());
        this.jScrollPaneDiagram.getVerticalScrollBar().setUnitIncrement(10);
        this.jScrollPaneDiagram.getHorizontalScrollBar().setUnitIncrement(10);
        this.jScrollPaneFunction.getVerticalScrollBar().setUnitIncrement(10);
        this.jScrollPaneFunction.getHorizontalScrollBar().setUnitIncrement(10);
        this.jScrollPaneText.getVerticalScrollBar().setUnitIncrement(10);
        this.jScrollPaneText.getHorizontalScrollBar().setUnitIncrement(10);
        this.jScrollPane1.getViewport().setScrollMode(0);
        this.jScrollPaneFunction.getViewport().setScrollMode(0);
        this.jScrollPaneText.getViewport().setScrollMode(0);
        this.jScrollPaneDiagram.getViewport().setScrollMode(0);
        Updater updater = new Updater();
        this.jFrameUpdate = new JFrameUpdate(updater, new Updater.BeforeExitListener(){

            @Override
            public void onBeforeExit() {
                if (!MainWindow.this.checkIfSaved(false)) {
                    MainWindow.this.flowchartCrashRecovery.backupFlowchart();
                }
            }
        });
        this.flowchartEditManager = new FlowchartEditManager(this.layout, this, this.jPanelDiagram, new FlowchartEditUndoManager(this.jMenuItemUndo, this.jMenuItemRedo, this.jButtonToolUndo, this.jButtonToolRedo), this.jCheckBoxDefaultText, this.jComboBoxSegment, this.jTextFieldTextSegment, this.jTextAreaTextSymbol);
        this.flowchartOverlookManager = new FlowchartOverlookManager(this, this.jScrollPaneDiagram.getHorizontalScrollBar(), this.jScrollPaneDiagram.getVerticalScrollBar(), this.jSliderZoom);
        this.flowchartDebugManager = new FlowchartDebugManager(this, this.jPanelVariables.getVariableModel(), this.jPanelDiagram, this.jSliderSpeed, this.jButtonToolPlayPause, this.jButtonToolPrevious, this.jButtonToolNext, this.jButtonToolStop, this.jButtonLaunch);
        this.jFrameSettings = new JFrameSettings(this.flowchartEditManager);
        this.jFrameCodeImport = new JFrameCodeImport(this);
        this.jFrameCodeExport = new JFrameCodeExport(this);
        this.jFrameAbout = new JFrameAbout();
        JPopupMenu symbolPopup = new JPopupMenu();
        for (Component component : this.jMenuEdit.getMenuComponents()) {
            if (component instanceof JMenuItem) {
                JMenuItem forItem = (JMenuItem)component;
                JMenuItem jMenuItem = new JMenuItem(forItem.getText(), forItem.getIcon());
                jMenuItem.setMnemonic(forItem.getMnemonic());
                jMenuItem.setAccelerator(forItem.getAccelerator());
                jMenuItem.setActionCommand(forItem.getActionCommand());
                jMenuItem.addActionListener(this.flowchartEditManager);
                forItem.addActionListener(this.flowchartEditManager);
                symbolPopup.add(jMenuItem);
                continue;
            }
            if (!(component instanceof JSeparator)) continue;
            symbolPopup.addSeparator();
        }
        this.flowchartEditManager.setSymbolPopup(symbolPopup);
        for (EnumSymbol enumSymbol : EnumSymbol.values()) {
            try {
                final JButton button = new JButton(new ImageIcon(this.getClass().getResource("/img/symbols/24-" + enumSymbol.name() + ".png")));
                button.setFocusable(false);
                button.setActionCommand("addSymbol/" + enumSymbol.name());
                button.setToolTipText(enumSymbol.getToolTipText());
                button.addActionListener(this.flowchartEditManager);
                if (!enumSymbol.name().equals("COMMENT")) {
                    MouseInputAdapter listener = new MouseInputAdapter(){
                        private boolean isPressed = false;
                        private boolean isDragging = false;
                        private ActionListener[] removedListeners = null;

                        @Override
                        public void mouseExited(MouseEvent e) {
                            if (this.isPressed) {
                                this.isDragging = true;
                                this.reAddActionListeners();
                                String action = button.getActionCommand();
                                for (ActionListener a : button.getActionListeners()) {
                                    a.actionPerformed(new ActionEvent(button, 1001, action + "/byDnD"));
                                }
                            }
                        }

                        @Override
                        public void mouseEntered(MouseEvent e) {
                            if (this.isDragging) {
                                this.isDragging = false;
                                MainWindow.this.flowchartEditManager.cancelDragCreationProcess();
                                this.removeActionListeners();
                            }
                        }

                        @Override
                        public void mouseDragged(MouseEvent e) {
                            if (this.isDragging) {
                                for (MouseMotionListener listener : MainWindow.this.jPanelDiagram.getMouseMotionListeners()) {
                                    listener.mouseDragged(SwingUtilities.convertMouseEvent(button, e, MainWindow.this.jPanelDiagram));
                                }
                            }
                        }

                        @Override
                        public void mouseReleased(MouseEvent e) {
                            this.reAddActionListeners();
                            this.isPressed = false;
                            if (this.isDragging) {
                                this.isDragging = false;
                                for (MouseListener listener : MainWindow.this.jPanelDiagram.getMouseListeners()) {
                                    listener.mouseReleased(SwingUtilities.convertMouseEvent(button, e, MainWindow.this.jPanelDiagram));
                                }
                            }
                        }

                        @Override
                        public void mousePressed(MouseEvent e) {
                            this.isPressed = true;
                        }

                        private void removeActionListeners() {
                            for (ActionListener ac : this.removedListeners = button.getActionListeners()) {
                                button.removeActionListener(ac);
                            }
                        }

                        private void reAddActionListeners() {
                            if (this.removedListeners != null) {
                                for (ActionListener ac : this.removedListeners) {
                                    button.addActionListener(ac);
                                }
                                this.removedListeners = null;
                            }
                        }
                    };
                    button.addMouseListener(listener);
                    button.addMouseMotionListener(listener);
                }
                this.jToolBarSymbols.add(button);
            }
            catch (NullPointerException e) {
                throw new Error("Error while loading symbol images!");
            }
        }
        this.jButtonToolEdit.addActionListener(this.flowchartEditManager);
        this.jButtonToolAnimation.addActionListener(this.flowchartDebugManager);
        this.jButtonToolZoomIn.addActionListener(this.flowchartOverlookManager);
        this.jButtonToolZoomOut.addActionListener(this.flowchartOverlookManager);
        this.jPanelDiagram.addMouseListener(this.flowchartOverlookManager);
        this.jPanelDiagram.addMouseMotionListener(this.flowchartOverlookManager);
        this.jPanelDiagram.addMouseWheelListener(this.flowchartOverlookManager);
        this.jPanelDiagram.addKeyListener(this.flowchartOverlookManager);
        this.jSliderZoom.addChangeListener(this.flowchartOverlookManager);
        this.jButtonToolPlayPause.addActionListener(this.flowchartDebugManager);
        this.jButtonToolNext.addActionListener(this.flowchartDebugManager);
        this.jButtonToolPrevious.addActionListener(this.flowchartDebugManager);
        this.jButtonToolStop.addActionListener(this.flowchartDebugManager);
        this.jButtonLaunch.addActionListener(this.flowchartDebugManager);
        Object var7_13 = null;
        try {
            Marshaller marshaller = jAXBcontext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", true);
        }
        catch (JAXBException ex) {
            MyExceptionHandler.handle(ex);
        }
        this.flowchartCrashRecovery = new FlowchartCrashRecovery(this.layout, (Marshaller)var7_15);
        this.flowchartCollector = new FlowchartCollector();
        this.editMode = !this.editMode;
        this.setEditMode(!this.editMode);
        this.startupFlowchartLoad(flowchartToOpen);
        updater.loadInfo(null, new Updater.InfoLoadListener(){

            @Override
            public void onInfoLoaded(Boolean newVersionAvailable) {
                if (Boolean.TRUE.equals(newVersionAvailable)) {
                    MainWindow.this.jMenuItemUpdateActionPerformed(null);
                }
            }
        });
    }

    private void startupFlowchartLoad(File flowchartToOpen) {
        boolean dontSaveDirectly = SettingsHolder.settings.isDontSaveDirectly();
        if (this.flowchartCrashRecovery.isFlowchartRestorationAvailable()) {
            List<File> recoveryFiles = this.flowchartCrashRecovery.getFilesToRestore();
            File recoveryFile = recoveryFiles.get(0);
            try {
                FlowchartRecovery flowchartRecovery = (FlowchartRecovery)GlobalFunctions.unsafeCast(MainWindow.unmarshal(recoveryFile));
                this.openDiagram(flowchartRecovery.flowchartSaveContainer.flowchart, flowchartRecovery.actualFlowchartFile);
                SettingsHolder.settings.setDontSaveDirectly(flowchartRecovery.dontSaveDirectly);
                this.flowchartCrashRecovery.realocateBackupFile(recoveryFile.getName());
                this.updateTitle();
                super.setTitle(super.getTitle() + " (zotaveno)");
                MainWindow.setStatusText("Diagram byl po neo\u010dek\u00e1van\u00e9m ukon\u010den\u00ed aplikace \u00fasp\u011b\u0161n\u011b zotaven.", 8000);
            }
            catch (JAXBException | FileNotFoundException ex) {
                MyExceptionHandler.handle(ex);
            }
            String[] args = flowchartToOpen != null ? new String[]{"\"" + flowchartToOpen.getAbsolutePath() + "\""} : new String[]{};
            if (recoveryFiles.size() > 1 || flowchartToOpen != null) {
                this.runAnotherInstance(args);
            }
        } else if (flowchartToOpen != null) {
            this.openDiagram(flowchartToOpen);
        } else if (SettingsHolder.settings.isLoadLastFlowchart() && SettingsHolder.settings.getActualFlowchartFile() != null) {
            this.openDiagram(SettingsHolder.settings.getActualFlowchartFile());
            SettingsHolder.settings.setDontSaveDirectly(dontSaveDirectly);
        }
    }

    private void runAnotherInstance(String[] args) {
        try {
            String command = SettingsHolder.JAVAW == null ? "start \"PS Diagram\" /d \"" + SettingsHolder.MY_DIR.getAbsolutePath() + "\" \"" + SettingsHolder.MY_FILE.getAbsolutePath() + "\"" : "start \"PS Diagram\" /d \"" + SettingsHolder.MY_DIR.getAbsolutePath() + "\" \"" + SettingsHolder.JAVAW.getAbsolutePath() + "\" -jar \"" + SettingsHolder.MY_FILE.getAbsolutePath() + "\"";
            for (String arg : args) {
                command = command + " \"" + arg + "\"";
            }
            Runtime.getRuntime().exec(new String[]{"cmd", "/s", "/c", "\"" + command + "\""});
        }
        catch (IOException ex) {
            MyExceptionHandler.handle(ex);
        }
    }

    private void initComponents() {
        this.jToolBarMenu = new JToolBar();
        this.jButtonToolNew = new JButton();
        this.jButtonToolOpen = new JButton();
        this.jButtonToolSave = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonToolUndo = new JButton();
        this.jButtonToolRedo = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jSeparator9 = new JToolBar.Separator();
        this.jButtonToolZoomIn = new JButton();
        this.jButtonToolZoomOut = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.jButtonToolEdit = new JToggleButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonToolAnimation = new JToggleButton();
        this.jButtonToolPlayPause = new JButton();
        this.jButtonToolPrevious = new JButton();
        this.jButtonToolNext = new JButton();
        this.jButtonToolStop = new JButton();
        this.jSeparator8 = new JToolBar.Separator();
        this.jButtonLaunch = new JButton();
        this.jSeparator13 = new JToolBar.Separator();
        this.jSliderSpeed = new JSlider();
        this.jPanelStatus = new JPanel();
        this.jSliderZoom = new JSlider();
        this.jLabelZoom = new JLabel();
        jLabelStatus = new JLabel();
        this.jSplitPane = new JSplitPane();
        this.jPanelLeftSplit = new JPanel();
        this.jPanelEdit = new JPanel();
        this.jPanelDetails = new JPanel();
        this.jTabbedPaneEdit = new JTabbedPane();
        this.jPanelOuterFunction = new JPanel();
        this.jScrollPaneFunction = new JScrollPane();
        this.jPanelInnerFunction = new JPanel();
        this.jLabelFunction = new JLabel();
        this.jPanelOuterText = new JPanel();
        this.jScrollPaneText = new JScrollPane();
        this.jPanelInnerText = new JPanel();
        this.jCheckBoxDefaultText = new JCheckBox();
        this.jPanelTextSymbol = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaTextSymbol = new JTextArea();
        this.jPanelTextSegment = new JPanel();
        this.jTextFieldTextSegment = new JTextField();
        this.jComboBoxSegment = new JComboBox();
        this.jToolBarSymbols = new JToolBar();
        this.jSeparator5 = new JToolBar.Separator();
        this.jScrollPaneDiagram = new JScrollPane();
        this.jPanelDiagram = new JPanelDiagram();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemNew = new JMenuItem();
        this.jMenuItemOpen = new JMenuItem();
        this.jMenuItemSave = new JMenuItem();
        this.jMenuItemSaveAs = new JMenuItem();
        this.jSeparator10 = new JPopupMenu.Separator();
        this.jMenuItemExportImage = new JMenuItem();
        this.jMenuItemExportPDF = new JMenuItem();
        this.jSeparator11 = new JPopupMenu.Separator();
        this.jMenuItemCodeImport = new JMenuItem();
        this.jMenuItemCodeExport = new JMenuItem();
        this.jSeparator14 = new JPopupMenu.Separator();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuEdit = new JMenu();
        this.jMenuItemUndo = new JMenuItem();
        this.jMenuItemRedo = new JMenuItem();
        this.jSeparator12 = new JPopupMenu.Separator();
        this.jMenuItemCut = new JMenuItem();
        this.jMenuItemCopy = new JMenuItem();
        this.jMenuItemPaste = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.jMenuItemDelete = new JMenuItem();
        this.jMenuAlgorithms = new JMenu();
        this.jMenuLayouts = new JMenu();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.jMenuLayoutSetting = new JMenu();
        this.jMenuConfiguration = new JMenu();
        this.jMenuItemSettings = new JMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuItemUpdate = new JMenuItem();
        this.jSeparator15 = new JPopupMenu.Separator();
        this.jMenuItemAbout = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("PS Diagram");
        this.setIconImages(Arrays.asList(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("/img/icon_16.png")), Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("/img/icon_32.png")), Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("/img/icon_48.png")), Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("/img/icon_64.png")), Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("/img/icon_128.png")), Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("/img/icon_256.png"))));
        this.setLocationByPlatform(true);
        this.setMinimumSize(new Dimension(712, 550));
        this.jToolBarMenu.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(147, 152, 161)));
        this.jToolBarMenu.setFloatable(false);
        this.jToolBarMenu.setRollover(true);
        this.jToolBarMenu.setName("");
        this.jButtonToolNew.setIcon(new ImageIcon(this.getClass().getResource("/img/toolBar/24-New.png")));
        this.jButtonToolNew.setToolTipText("<html>\nNov\u00fd diagram<br />\n(Ctrl + N)\n</html>");
        this.jButtonToolNew.setFocusable(false);
        this.jButtonToolNew.setHorizontalTextPosition(0);
        this.jButtonToolNew.setVerticalTextPosition(3);
        this.jButtonToolNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jMenuItemNewActionPerformed(evt);
            }
        });
        this.jToolBarMenu.add(this.jButtonToolNew);
        this.jButtonToolOpen.setIcon(new ImageIcon(this.getClass().getResource("/img/toolBar/24-Open.png")));
        this.jButtonToolOpen.setToolTipText("<html>\nOtev\u0159\u00edt diagram<br />\n(Ctrl + O)\n</html>");
        this.jButtonToolOpen.setFocusable(false);
        this.jButtonToolOpen.setHorizontalTextPosition(0);
        this.jButtonToolOpen.setVerticalTextPosition(3);
        this.jButtonToolOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jMenuItemOpenActionPerformed(evt);
            }
        });
        this.jToolBarMenu.add(this.jButtonToolOpen);
        this.jButtonToolSave.setIcon(new ImageIcon(this.getClass().getResource("/img/toolBar/24-Save.png")));
        this.jButtonToolSave.setToolTipText("<html>\nUlo\u017eit diagram<br />\n(Ctrl + S)\n</html>");
        this.jButtonToolSave.setFocusable(false);
        this.jButtonToolSave.setHorizontalTextPosition(0);
        this.jButtonToolSave.setVerticalTextPosition(3);
        this.jButtonToolSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jMenuItemSaveActionPerformed(evt);
            }
        });
        this.jToolBarMenu.add(this.jButtonToolSave);
        this.jToolBarMenu.add(this.jSeparator1);
        this.jButtonToolUndo.setIcon(new ImageIcon(this.getClass().getResource("/img/toolBar/24-Undo.png")));
        this.jButtonToolUndo.setToolTipText("<html>Zp\u011bt<br />(Ctrl + Z)</html>");
        this.jButtonToolUndo.setEnabled(false);
        this.jButtonToolUndo.setFocusable(false);
        this.jButtonToolUndo.setHorizontalTextPosition(0);
        this.jButtonToolUndo.setVerticalTextPosition(3);
        this.jButtonToolUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jMenuItemUndoActionPerformed(evt);
            }
        });
        this.jToolBarMenu.add(this.jButtonToolUndo);
        this.jButtonToolRedo.setIcon(new ImageIcon(this.getClass().getResource("/img/toolBar/24-Redo.png")));
        this.jButtonToolRedo.setToolTipText("<html>Znovu<br />(Ctrl + Y)</html>");
        this.jButtonToolRedo.setEnabled(false);
        this.jButtonToolRedo.setFocusable(false);
        this.jButtonToolRedo.setHorizontalTextPosition(0);
        this.jButtonToolRedo.setVerticalTextPosition(3);
        this.jButtonToolRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jMenuItemRedoActionPerformed(evt);
            }
        });
        this.jToolBarMenu.add(this.jButtonToolRedo);
        this.jSeparator2.setEnabled(false);
        this.jSeparator2.setSeparatorSize(new Dimension(14, 10));
        this.jToolBarMenu.add(this.jSeparator2);
        this.jToolBarMenu.add(this.jSeparator9);
        this.jButtonToolZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/img/toolBar/24-ZoomIn.png")));
        this.jButtonToolZoomIn.setToolTipText("<html>\nP\u0159ibl\u00ed\u017eit<br />\n(Ctrl + kole\u010dko my\u0161i)\n</html>");
        this.jButtonToolZoomIn.setActionCommand("overlook/zoomIn");
        this.jButtonToolZoomIn.setFocusable(false);
        this.jButtonToolZoomIn.setHorizontalTextPosition(0);
        this.jButtonToolZoomIn.setVerticalTextPosition(3);
        this.jToolBarMenu.add(this.jButtonToolZoomIn);
        this.jButtonToolZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/img/toolBar/24-ZoomOut.png")));
        this.jButtonToolZoomOut.setToolTipText("<html>\nOdd\u00e1lit<br />\n(Ctrl + kole\u010dko my\u0161i)\n</html>");
        this.jButtonToolZoomOut.setActionCommand("overlook/zoomOut");
        this.jButtonToolZoomOut.setFocusable(false);
        this.jButtonToolZoomOut.setHorizontalTextPosition(0);
        this.jButtonToolZoomOut.setVerticalTextPosition(3);
        this.jToolBarMenu.add(this.jButtonToolZoomOut);
        this.jToolBarMenu.add(this.jSeparator4);
        this.jButtonToolEdit.setIcon(new ImageIcon(this.getClass().getResource("/img/toolBar/24-Unlock.png")));
        this.jButtonToolEdit.setSelected(true);
        this.jButtonToolEdit.setToolTipText("Edita\u010dn\u00ed re\u017eim");
        this.jButtonToolEdit.setActionCommand("mode/editMode");
        this.jButtonToolEdit.setFocusable(false);
        this.jButtonToolEdit.setHorizontalTextPosition(0);
        this.jButtonToolEdit.setVerticalTextPosition(3);
        this.jToolBarMenu.add(this.jButtonToolEdit);
        this.jToolBarMenu.add(this.jSeparator3);
        this.jButtonToolAnimation.setIcon(new ImageIcon(this.getClass().getResource("/img/toolBar/24-MagicWand.png")));
        this.jButtonToolAnimation.setToolTipText("Anima\u010dn\u00ed re\u017eim");
        this.jButtonToolAnimation.setActionCommand("mode/animationMode");
        this.jButtonToolAnimation.setFocusable(false);
        this.jButtonToolAnimation.setHorizontalTextPosition(0);
        this.jButtonToolAnimation.setVerticalTextPosition(3);
        this.jToolBarMenu.add(this.jButtonToolAnimation);
        this.jButtonToolPlayPause.setIcon(new ImageIcon(this.getClass().getResource("/img/toolBar/24-Play.png")));
        this.jButtonToolPlayPause.setToolTipText("<html>\nSpustit animaci<br />\n(Mezern\u00edk)\n</html>");
        this.jButtonToolPlayPause.setActionCommand("animation/play");
        this.jButtonToolPlayPause.setEnabled(false);
        this.jButtonToolPlayPause.setFocusable(false);
        this.jButtonToolPlayPause.setHorizontalTextPosition(0);
        this.jButtonToolPlayPause.setVerticalTextPosition(3);
        this.jToolBarMenu.add(this.jButtonToolPlayPause);
        this.jButtonToolPrevious.setIcon(new ImageIcon(this.getClass().getResource("/img/toolBar/24-Previous.png")));
        this.jButtonToolPrevious.setToolTipText("<html>\nKrok zp\u011bt<br />\n(Ctrl+\u0161ipka doleva, nebo nahoru)\n</html>");
        this.jButtonToolPrevious.setActionCommand("animation/previous");
        this.jButtonToolPrevious.setEnabled(false);
        this.jButtonToolPrevious.setFocusable(false);
        this.jButtonToolPrevious.setHorizontalTextPosition(0);
        this.jButtonToolPrevious.setVerticalTextPosition(3);
        this.jToolBarMenu.add(this.jButtonToolPrevious);
        this.jButtonToolNext.setIcon(new ImageIcon(this.getClass().getResource("/img/toolBar/24-Next.png")));
        this.jButtonToolNext.setToolTipText("<html>\nKrok vp\u0159ed<br />\n(Ctrl+\u0161ipka doprava, nebo dolu)\n</html>");
        this.jButtonToolNext.setActionCommand("animation/next");
        this.jButtonToolNext.setEnabled(false);
        this.jButtonToolNext.setFocusable(false);
        this.jButtonToolNext.setHorizontalTextPosition(0);
        this.jButtonToolNext.setVerticalTextPosition(3);
        this.jToolBarMenu.add(this.jButtonToolNext);
        this.jButtonToolStop.setIcon(new ImageIcon(this.getClass().getResource("/img/toolBar/24-Stop.png")));
        this.jButtonToolStop.setToolTipText("Reset");
        this.jButtonToolStop.setActionCommand("animation/stop");
        this.jButtonToolStop.setEnabled(false);
        this.jButtonToolStop.setFocusable(false);
        this.jButtonToolStop.setHorizontalTextPosition(0);
        this.jButtonToolStop.setVerticalTextPosition(3);
        this.jToolBarMenu.add(this.jButtonToolStop);
        this.jToolBarMenu.add(this.jSeparator8);
        this.jButtonLaunch.setIcon(new ImageIcon(this.getClass().getResource("/img/toolBar/24-Launch.png")));
        this.jButtonLaunch.setToolTipText("<html>\nSpustit rychle<br />\n(zastav\u00ed na um\u00edst\u011bn\u00e9m breakpointu)\n</html>");
        this.jButtonLaunch.setActionCommand("animation/launch");
        this.jButtonLaunch.setEnabled(false);
        this.jButtonLaunch.setFocusable(false);
        this.jButtonLaunch.setHorizontalTextPosition(0);
        this.jButtonLaunch.setVerticalTextPosition(3);
        this.jToolBarMenu.add(this.jButtonLaunch);
        this.jSeparator13.setEnabled(false);
        this.jToolBarMenu.add(this.jSeparator13);
        this.jSliderSpeed.setMaximum(20);
        this.jSliderSpeed.setToolTipText("Rychlost animace");
        this.jSliderSpeed.setValue(10);
        this.jSliderSpeed.setEnabled(false);
        this.jSliderSpeed.setInverted(true);
        this.jSliderSpeed.setPreferredSize(new Dimension(150, 21));
        this.jToolBarMenu.add(this.jSliderSpeed);
        this.jPanelStatus.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(147, 152, 161)));
        this.jPanelStatus.setPreferredSize(new Dimension(200, 25));
        this.jSliderZoom.setMaximum(50);
        this.jSliderZoom.setMinimum(1);
        this.jSliderZoom.setToolTipText("P\u0159ibl\u00ed\u017een\u00ed");
        this.jSliderZoom.setValue(10);
        this.jSliderZoom.setPreferredSize(new Dimension(150, 21));
        this.jLabelZoom.setHorizontalAlignment(4);
        this.jLabelZoom.setText("100%");
        this.jLabelZoom.setPreferredSize(new Dimension(32, 21));
        GroupLayout jPanelStatusLayout = new GroupLayout(this.jPanelStatus);
        this.jPanelStatus.setLayout(jPanelStatusLayout);
        jPanelStatusLayout.setHorizontalGroup(jPanelStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelStatusLayout.createSequentialGroup().addContainerGap().addComponent(jLabelStatus, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelZoom, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderZoom, -2, -1, -2).addContainerGap()));
        jPanelStatusLayout.setVerticalGroup(jPanelStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelStatusLayout.createSequentialGroup().addGroup(jPanelStatusLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabelZoom, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jSliderZoom, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jLabelStatus, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jSplitPane.setDividerLocation(306);
        this.jPanelLeftSplit.setMinimumSize(new Dimension(231, 0));
        this.jPanelDetails.setBorder(null);
        this.jPanelDetails.setPreferredSize(new Dimension(188, 517));
        this.jPanelInnerFunction.setPreferredSize(new Dimension(0, 0));
        this.jLabelFunction.setHorizontalAlignment(0);
        this.jLabelFunction.setText("<html>\n<p style=\"text-align: center;\">\nTento symbol nem\u00e1 mo\u017enost nastaven\u00ed funkce.\n</p>\n</html>");
        GroupLayout jPanelInnerFunctionLayout = new GroupLayout(this.jPanelInnerFunction);
        this.jPanelInnerFunction.setLayout(jPanelInnerFunctionLayout);
        jPanelInnerFunctionLayout.setHorizontalGroup(jPanelInnerFunctionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelInnerFunctionLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelFunction, -1, 170, Short.MAX_VALUE).addContainerGap()));
        jPanelInnerFunctionLayout.setVerticalGroup(jPanelInnerFunctionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelInnerFunctionLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelFunction, -1, 567, Short.MAX_VALUE).addContainerGap()));
        this.jScrollPaneFunction.setViewportView(this.jPanelInnerFunction);
        GroupLayout jPanelOuterFunctionLayout = new GroupLayout(this.jPanelOuterFunction);
        this.jPanelOuterFunction.setLayout(jPanelOuterFunctionLayout);
        jPanelOuterFunctionLayout.setHorizontalGroup(jPanelOuterFunctionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneFunction, -1, 188, Short.MAX_VALUE));
        jPanelOuterFunctionLayout.setVerticalGroup(jPanelOuterFunctionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneFunction, -1, 585, Short.MAX_VALUE));
        this.jTabbedPaneEdit.addTab("Funkce", this.jPanelOuterFunction);
        this.jPanelInnerText.setPreferredSize(new Dimension(0, 0));
        this.jCheckBoxDefaultText.setText("V\u00fdchoz\u00ed hodnoty");
        this.jCheckBoxDefaultText.setToolTipText("Nastav\u00ed text symbolu, resp. jeho v\u011btv\u00ed, na z\u00e1klad\u011b vypln\u011bn\u00e9 funkce");
        this.jCheckBoxDefaultText.setActionCommand("edit/defaultText");
        this.jPanelTextSymbol.setBorder(BorderFactory.createTitledBorder("<html>Text symbolu</html>"));
        this.jScrollPane1.setViewportView(this.jTextAreaTextSymbol);
        GroupLayout jPanelTextSymbolLayout = new GroupLayout(this.jPanelTextSymbol);
        this.jPanelTextSymbol.setLayout(jPanelTextSymbolLayout);
        jPanelTextSymbolLayout.setHorizontalGroup(jPanelTextSymbolLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1));
        jPanelTextSymbolLayout.setVerticalGroup(jPanelTextSymbolLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTextSymbolLayout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 170, Short.MAX_VALUE).addContainerGap()));
        this.jPanelTextSegment.setBorder(BorderFactory.createTitledBorder("<html>Text v\u011btv\u00ed symbolu</html>"));
        this.jComboBoxSegment.setActionCommand("edit/segmentText");
        GroupLayout jPanelTextSegmentLayout = new GroupLayout(this.jPanelTextSegment);
        this.jPanelTextSegment.setLayout(jPanelTextSegmentLayout);
        jPanelTextSegmentLayout.setHorizontalGroup(jPanelTextSegmentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldTextSegment).addComponent(this.jComboBoxSegment, 0, -1, Short.MAX_VALUE));
        jPanelTextSegmentLayout.setVerticalGroup(jPanelTextSegmentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelTextSegmentLayout.createSequentialGroup().addComponent(this.jTextFieldTextSegment, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxSegment, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanelInnerTextLayout = new GroupLayout(this.jPanelInnerText);
        this.jPanelInnerText.setLayout(jPanelInnerTextLayout);
        jPanelInnerTextLayout.setHorizontalGroup(jPanelInnerTextLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelTextSymbol, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelTextSegment, -1, -1, Short.MAX_VALUE).addGroup(jPanelInnerTextLayout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxDefaultText, -1, 170, Short.MAX_VALUE).addContainerGap()));
        jPanelInnerTextLayout.setVerticalGroup(jPanelInnerTextLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelInnerTextLayout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxDefaultText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelTextSymbol, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelTextSegment, -2, -1, -2).addContainerGap(217, Short.MAX_VALUE)));
        this.jScrollPaneText.setViewportView(this.jPanelInnerText);
        GroupLayout jPanelOuterTextLayout = new GroupLayout(this.jPanelOuterText);
        this.jPanelOuterText.setLayout(jPanelOuterTextLayout);
        jPanelOuterTextLayout.setHorizontalGroup(jPanelOuterTextLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneText, -1, 188, Short.MAX_VALUE));
        jPanelOuterTextLayout.setVerticalGroup(jPanelOuterTextLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneText, -1, 585, Short.MAX_VALUE));
        this.jTabbedPaneEdit.addTab("Text symbolu", this.jPanelOuterText);
        GroupLayout jPanelDetailsLayout = new GroupLayout(this.jPanelDetails);
        this.jPanelDetails.setLayout(jPanelDetailsLayout);
        jPanelDetailsLayout.setHorizontalGroup(jPanelDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPaneEdit));
        jPanelDetailsLayout.setVerticalGroup(jPanelDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPaneEdit));
        this.jToolBarSymbols.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 1, new Color(147, 152, 161)));
        this.jToolBarSymbols.setFloatable(false);
        this.jToolBarSymbols.setOrientation(1);
        this.jToolBarSymbols.setRollover(true);
        this.jToolBarSymbols.add(this.jSeparator5);
        GroupLayout jPanelEditLayout = new GroupLayout(this.jPanelEdit);
        this.jPanelEdit.setLayout(jPanelEditLayout);
        jPanelEditLayout.setHorizontalGroup(jPanelEditLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelEditLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jPanelDetails, -1, 262, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jToolBarSymbols, -2, 43, -2).addGap(0, 0, 0)));
        jPanelEditLayout.setVerticalGroup(jPanelEditLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelEditLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanelEditLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBarSymbols, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelDetails, GroupLayout.Alignment.TRAILING, -1, 615, Short.MAX_VALUE)).addGap(0, 0, 0)));
        GroupLayout jPanelLeftSplitLayout = new GroupLayout(this.jPanelLeftSplit);
        this.jPanelLeftSplit.setLayout(jPanelLeftSplitLayout);
        jPanelLeftSplitLayout.setHorizontalGroup(jPanelLeftSplitLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelEdit, -1, -1, Short.MAX_VALUE));
        jPanelLeftSplitLayout.setVerticalGroup(jPanelLeftSplitLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelEdit, -1, -1, Short.MAX_VALUE));
        this.jSplitPane.setLeftComponent(this.jPanelLeftSplit);
        this.jScrollPaneDiagram.setHorizontalScrollBar(new JScrollBarDiagram(0));
        this.jScrollPaneDiagram.setMinimumSize(new Dimension(101, 20));
        this.jScrollPaneDiagram.setPreferredSize(new Dimension(690, 417));
        this.jScrollPaneDiagram.setVerticalScrollBar(new JScrollBarDiagram(1));
        this.jPanelDiagram.setBackground(new Color(255, 255, 255));
        this.jPanelDiagram.setCursor(new Cursor(0));
        this.jPanelDiagram.setPreferredSize(new Dimension(0, 0));
        GroupLayout jPanelDiagramLayout = new GroupLayout(this.jPanelDiagram);
        this.jPanelDiagram.setLayout(jPanelDiagramLayout);
        jPanelDiagramLayout.setHorizontalGroup(jPanelDiagramLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 659, Short.MAX_VALUE));
        jPanelDiagramLayout.setVerticalGroup(jPanelDiagramLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 609, Short.MAX_VALUE));
        this.jScrollPaneDiagram.setViewportView(this.jPanelDiagram);
        this.jSplitPane.setRightComponent(this.jScrollPaneDiagram);
        this.jMenuBar1.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(147, 152, 161)));
        this.jMenuFile.setText("Soubor");
        this.jMenuItemNew.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.jMenuItemNew.setIcon(new ImageIcon(this.getClass().getResource("/img/menuitems/16-New.png")));
        this.jMenuItemNew.setMnemonic('n');
        this.jMenuItemNew.setText("Nov\u00fd");
        this.jMenuItemNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jMenuItemNewActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemNew);
        this.jMenuItemOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItemOpen.setIcon(new ImageIcon(this.getClass().getResource("/img/menuitems/16-Open.png")));
        this.jMenuItemOpen.setMnemonic('o');
        this.jMenuItemOpen.setText("Otev\u0159\u00edt");
        this.jMenuItemOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jMenuItemOpenActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemOpen);
        this.jMenuItemSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuItemSave.setIcon(new ImageIcon(this.getClass().getResource("/img/menuitems/16-Save.png")));
        this.jMenuItemSave.setMnemonic('u');
        this.jMenuItemSave.setText("Ulo\u017eit");
        this.jMenuItemSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jMenuItemSaveActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSave);
        this.jMenuItemSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, 10));
        this.jMenuItemSaveAs.setIcon(new ImageIcon(this.getClass().getResource("/img/menuitems/16-SaveAs.png")));
        this.jMenuItemSaveAs.setMnemonic('j');
        this.jMenuItemSaveAs.setText("Ulo\u017eit Jako");
        this.jMenuItemSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jMenuItemSaveAsActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSaveAs);
        this.jMenuFile.add(this.jSeparator10);
        this.jMenuItemExportImage.setIcon(new ImageIcon(this.getClass().getResource("/img/menuitems/16-Export_image.png")));
        this.jMenuItemExportImage.setText("Export do obr\u00e1zku");
        this.jMenuItemExportImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jMenuItemExportImageActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExportImage);
        this.jMenuItemExportPDF.setIcon(new ImageIcon(this.getClass().getResource("/img/menuitems/16-Export_pdf.png")));
        this.jMenuItemExportPDF.setText("Export do PDF");
        this.jMenuItemExportPDF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jMenuItemExportPDFActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExportPDF);
        this.jMenuFile.add(this.jSeparator11);
        this.jMenuItemCodeImport.setIcon(new ImageIcon(this.getClass().getResource("/img/menuitems/16-Import_Code.png")));
        this.jMenuItemCodeImport.setText("Import ze zdoj. k\u00f3du");
        this.jMenuItemCodeImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jMenuItemCodeImportActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemCodeImport);
        this.jMenuItemCodeExport.setIcon(new ImageIcon(this.getClass().getResource("/img/menuitems/16-Export_Code.png")));
        this.jMenuItemCodeExport.setText("Export do zdoj. k\u00f3du");
        this.jMenuItemCodeExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jMenuItemCodeExportActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemCodeExport);
        this.jMenuFile.add(this.jSeparator14);
        this.jMenuItemExit.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.jMenuItemExit.setText("Konec");
        this.jMenuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuEdit.setText("\u00dapravy");
        this.jMenuEdit.setActionCommand("edit");
        this.jMenuEdit.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                MainWindow.this.jMenuEditMenuSelected(evt);
            }
        });
        this.jMenuItemUndo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.jMenuItemUndo.setIcon(new ImageIcon(this.getClass().getResource("/img/menuitems/16-Undo.png")));
        this.jMenuItemUndo.setText("Zp\u011bt");
        this.jMenuItemUndo.setEnabled(false);
        this.jMenuItemUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jMenuItemUndoActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemUndo);
        this.jMenuItemRedo.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.jMenuItemRedo.setIcon(new ImageIcon(this.getClass().getResource("/img/menuitems/16-Redo.png")));
        this.jMenuItemRedo.setText("Znovu");
        this.jMenuItemRedo.setEnabled(false);
        this.jMenuItemRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jMenuItemRedoActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemRedo);
        this.jMenuEdit.add(this.jSeparator12);
        this.jMenuItemCut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.jMenuItemCut.setIcon(new ImageIcon(this.getClass().getResource("/img/menuitems/16-Cut.png")));
        this.jMenuItemCut.setText("Vyjmout symbol");
        this.jMenuItemCut.setActionCommand("edit/cut");
        this.jMenuEdit.add(this.jMenuItemCut);
        this.jMenuItemCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.jMenuItemCopy.setIcon(new ImageIcon(this.getClass().getResource("/img/menuitems/16-Copy.png")));
        this.jMenuItemCopy.setText("Kop\u00edrovat symbol");
        this.jMenuItemCopy.setActionCommand("edit/copy");
        this.jMenuEdit.add(this.jMenuItemCopy);
        this.jMenuItemPaste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.jMenuItemPaste.setIcon(new ImageIcon(this.getClass().getResource("/img/menuitems/16-Copy.png")));
        this.jMenuItemPaste.setText("Vlo\u017eit symbol");
        this.jMenuItemPaste.setActionCommand("edit/paste");
        this.jMenuEdit.add(this.jMenuItemPaste);
        this.jMenuEdit.add(this.jSeparator6);
        this.jMenuItemDelete.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.jMenuItemDelete.setIcon(new ImageIcon(this.getClass().getResource("/img/menuitems/16-Delete.png")));
        this.jMenuItemDelete.setMnemonic('d');
        this.jMenuItemDelete.setText("Smazat symbol");
        this.jMenuItemDelete.setActionCommand("edit/delete");
        this.jMenuEdit.add(this.jMenuItemDelete);
        this.jMenuBar1.add(this.jMenuEdit);
        this.jMenuAlgorithms.setText("Knihovna algoritm\u016f");
        this.jMenuBar1.add(this.jMenuAlgorithms);
        this.jMenuLayouts.setText("Layouty");
        this.jMenuLayouts.setActionCommand("layout");
        this.jMenuLayouts.add(this.jSeparator7);
        this.jMenuLayoutSetting.setText("Nastaven\u00ed zvolen\u00e9ho");
        this.jMenuLayoutSetting.setActionCommand("layout/setting");
        this.jMenuLayouts.add(this.jMenuLayoutSetting);
        this.jMenuBar1.add(this.jMenuLayouts);
        this.jMenuConfiguration.setText("Nastaven\u00ed");
        this.jMenuConfiguration.setActionCommand("settings");
        this.jMenuItemSettings.setIcon(new ImageIcon(this.getClass().getResource("/img/menuitems/16-Settings.png")));
        this.jMenuItemSettings.setMnemonic('v');
        this.jMenuItemSettings.setText("  Volby");
        this.jMenuItemSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jMenuItemSettingsActionPerformed(evt);
            }
        });
        this.jMenuConfiguration.add(this.jMenuItemSettings);
        this.jMenuBar1.add(this.jMenuConfiguration);
        this.jMenuHelp.setText("N\u00e1pov\u011bda");
        this.jMenuHelp.setActionCommand("help");
        this.jMenuItemUpdate.setText("Kontrola aktualizac\u00ed");
        this.jMenuItemUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jMenuItemUpdateActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemUpdate);
        this.jMenuHelp.add(this.jSeparator15);
        this.jMenuItemAbout.setText("O aplikaci");
        this.jMenuItemAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jMenuItemAboutActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemAbout);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBarMenu, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelStatus, -1, 908, Short.MAX_VALUE).addComponent(this.jSplitPane, -1, 908, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBarMenu, -2, 32, -2).addGap(0, 0, 0).addComponent(this.jSplitPane).addGap(0, 0, 0).addComponent(this.jPanelStatus, -2, -1, -2)));
        this.pack();
    }

    private void jMenuItemSettingsActionPerformed(ActionEvent evt) {
        this.jFrameSettings.setLocationRelativeTo(this);
        this.jFrameSettings.setVisible(true);
    }

    private void jMenuItemExportPDFActionPerformed(ActionEvent evt) {
        File file = MyFileChooser.saveFileDialog(MyFileChooser.FilterType.PDF, "Export PDF", null);
        if (file != null) {
            PDFGraphics2D graphics;
            int prevFlowchartPadding = this.layout.getFlowchartPadding();
            this.layout.setFlowchartPadding(SettingsHolder.settings.getExportFlowchartPadding());
            try {
                graphics = new PDFGraphics2D(file, new Dimension((int)this.layout.getWidth(), (int)this.layout.getHeight()));
            }
            catch (FileNotFoundException ex) {
                MyExceptionHandler.handle(ex);
                MyJOptionPane.showMessageDialog(this, "P\u0159i vytv\u00e1\u0159en\u00ed PDF souboru nastala chyba!", "Chyba", 0);
                return;
            }
            ((VectorGraphics)graphics).startExport();
            this.layout.setEditMode(false);
            this.layout.paintFlowchart(graphics, true);
            this.layout.setEditMode(this.editMode);
            this.layout.setFlowchartPadding(prevFlowchartPadding);
            ((VectorGraphics)graphics).endExport();
            ((VectorGraphics)graphics).dispose();
            MainWindow.setStatusText("Diagram byl \u00fasp\u011b\u0161n\u011b exportov\u00e1n do " + file.getPath(), 8000);
        }
    }

    private void jMenuItemExportImageActionPerformed(ActionEvent evt) {
        File file = MyFileChooser.saveFileDialog(MyFileChooser.FilterType.IMAGE, "Export obr\u00e1zku", null);
        if (file != null) {
            BufferedImage img;
            int prevFlowchartPadding = this.layout.getFlowchartPadding();
            this.layout.setFlowchartPadding(SettingsHolder.settings.getExportFlowchartPadding());
            String extension = file.getName().substring(file.getName().lastIndexOf(46) + 1, file.getName().length());
            int width = (int)(this.layout.getWidth() * this.jPnlDiagram.getScale());
            int height = (int)(this.layout.getHeight() * this.jPnlDiagram.getScale());
            switch (extension) {
                case "wbmp": {
                    img = new BufferedImage(width, height, 12);
                    break;
                }
                case "gif": 
                case "png": {
                    if (SettingsHolder.settings.isExportTransparency()) {
                        img = new BufferedImage(width, height, 2);
                        break;
                    }
                }
                default: {
                    img = new BufferedImage(width, height, 1);
                }
            }
            Graphics2D g2d = img.createGraphics();
            if (!SettingsHolder.settings.isExportTransparency() || !extension.equals("gif") && !extension.equals("png")) {
                g2d.setColor(Color.WHITE);
                g2d.fill(new Rectangle((int)(this.layout.getWidth() * this.jPnlDiagram.getScale()), (int)(this.layout.getHeight() * this.jPnlDiagram.getScale())));
            }
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.scale(this.jPnlDiagram.getScale(), this.jPnlDiagram.getScale());
            this.layout.setEditMode(false);
            this.layout.paintFlowchart(g2d, false);
            this.layout.setEditMode(this.editMode);
            this.layout.setFlowchartPadding(prevFlowchartPadding);
            g2d.dispose();
            try {
                if (!ImageIO.write((RenderedImage)img, extension, file)) {
                    MyJOptionPane.showMessageDialog(this, "Obr\u00e1zek se nepoda\u0159ilo vytvo\u0159it.", "Chyba", 0);
                }
            }
            catch (IOException ex) {
                MyExceptionHandler.handle(ex);
                MyJOptionPane.showMessageDialog(this, "P\u0159i vytv\u00e1\u0159en\u00ed souboru obr\u00e1zku nastala chyba!", "Chyba", 0);
                return;
            }
            MainWindow.setStatusText("Diagram byl \u00fasp\u011b\u0161n\u011b exportov\u00e1n do " + file.getPath(), 8000);
        }
    }

    private void jMenuItemOpenActionPerformed(ActionEvent evt) {
        File file = MyFileChooser.openFileDialog(MyFileChooser.FilterType.XML_AND_PSDIAGRAM, "Otev\u0159\u00edt diagram");
        if (file != null) {
            this.openDiagram(file);
        }
    }

    private void jMenuItemSaveActionPerformed(ActionEvent evt) {
        if (SettingsHolder.settings.getActualFlowchartFile() == null || SettingsHolder.settings.isDontSaveDirectly()) {
            this.jMenuItemSaveAsActionPerformed(evt);
        } else {
            try {
                if (SettingsHolder.settings.getActualFlowchartFile().getName().endsWith(".xml")) {
                    MainWindow.marshal(this.layout.getFlowchart(), SettingsHolder.settings.getActualFlowchartFile(), true);
                } else {
                    MainWindow.marshal((Object)new FlowchartSaveContainer(this.layout.getFlowchart()), SettingsHolder.settings.getActualFlowchartFile(), true);
                }
                this.flowchartCrashRecovery.updateSavedFlowchart();
                MainWindow.setStatusText("Diagram byl \u00fasp\u011b\u0161n\u011b ulo\u017een do " + SettingsHolder.settings.getActualFlowchartFile().getPath(), 3500);
            }
            catch (JAXBException | FileNotFoundException ex) {
                MyExceptionHandler.handle(ex);
                MyJOptionPane.showMessageDialog(this, "P\u0159i ukl\u00e1d\u00e1n\u00ed diagramu nastala chyba!", "Diagram se nepoda\u0159ilo ulo\u017eit", 0);
            }
        }
    }

    private void jMenuItemNewActionPerformed(ActionEvent evt) {
        if (!this.checkIfSaved(true)) {
            return;
        }
        if (!this.editMode) {
            this.flowchartEditManager.actionPerformed(new ActionEvent(this.jButtonToolEdit, this.jButtonToolEdit.hashCode(), "mode/editMode"));
        }
        SettingsHolder.settings.setDontSaveDirectly(false);
        this.layout.setFlowchart(null);
        this.flowchartEditManager.loadMarkedSymbolText();
        this.flowchartEditManager.resetUndoManager();
        this.jPanelDiagram.repaint();
        SettingsHolder.settings.setActualFlowchartFile(null);
        this.flowchartCrashRecovery.updateSavedFlowchart();
        this.updateTitle();
        SwingUtilities.invokeLater(() -> {
            this.jScrollPaneDiagram.getVerticalScrollBar().setValue(0);
            this.jScrollPaneDiagram.getHorizontalScrollBar().setValue(0);
            this.jPnlDiagram.setTranslateX(0.0);
            this.jPnlDiagram.setTranslateY(0.0);
        });
    }

    private void jMenuItemSaveAsActionPerformed(ActionEvent evt) {
        File file;
        String defaultName = null;
        if (SettingsHolder.settings.getActualFlowchartFile() != null) {
            defaultName = SettingsHolder.settings.getActualFlowchartFile().getName().replaceFirst("\\.[^\\" + File.separator + "]+$", "");
        }
        if ((file = MyFileChooser.saveFileDialog(MyFileChooser.FilterType.PSDIAGRAM, "Ulo\u017eit diagram", defaultName)) != null) {
            try {
                MainWindow.marshal((Object)new FlowchartSaveContainer(this.layout.getFlowchart()), file, true);
                SettingsHolder.settings.setDontSaveDirectly(false);
                SettingsHolder.settings.setActualFlowchartFile(file);
                this.flowchartCrashRecovery.updateSavedFlowchart();
                this.updateTitle();
                MainWindow.setStatusText("Diagram byl \u00fasp\u011b\u0161n\u011b ulo\u017een do " + SettingsHolder.settings.getActualFlowchartFile().getPath(), 3500);
            }
            catch (JAXBException | FileNotFoundException ex) {
                MyExceptionHandler.handle(ex);
                MyJOptionPane.showMessageDialog(this, "P\u0159i ukl\u00e1d\u00e1n\u00ed diagramu nastala chyba!", "Diagram se nepoda\u0159ilo ulo\u017eit", 0);
            }
        }
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        this.exit();
    }

    private void jMenuItemUndoActionPerformed(ActionEvent evt) {
        if (this.jMenuItemUndo.isEnabled()) {
            this.flowchartEditManager.undo();
        }
    }

    private void jMenuItemRedoActionPerformed(ActionEvent evt) {
        if (this.jMenuItemRedo.isEnabled()) {
            this.flowchartEditManager.redo();
        }
    }

    private void jMenuItemCodeImportActionPerformed(ActionEvent evt) {
        this.jFrameCodeImport.setLocationRelativeTo(this);
        this.jFrameCodeImport.setVisible(true);
    }

    private void jMenuItemCodeExportActionPerformed(ActionEvent evt) {
        for (LayoutSegment segment : this.layout.getFlowchart()) {
            if (segment == null) continue;
            for (LayoutElement element : segment) {
                if (element.getSymbol().areCommandsValid()) continue;
                MyJOptionPane.showMessageDialog(null, "<html>Export diagramu do zdrojov\u00e9ho k\u00f3du nelze prov\u00e9st, proto\u017ee jeden nebo <br />v\u00edce symbol\u016f diagramu obsahuje chybu ve sv\u00e9 funkci (symbol ozna\u010den \u010derven\u011b).<br /><br />Odstra\u0148te ozna\u010den\u00e9 chyby a akci opakujte.</html>", "Diagram obsahuje chyby", 0);
                return;
            }
        }
        this.jFrameCodeExport.setLocationRelativeTo(this);
        this.jFrameCodeExport.setVisible(true);
    }

    private void jMenuItemAboutActionPerformed(ActionEvent evt) {
        this.jFrameAbout.setLocationRelativeTo(this);
        this.jFrameAbout.setVisible(true);
    }

    private void jMenuItemUpdateActionPerformed(ActionEvent evt) {
        this.jFrameUpdate.setLocationRelativeTo(this);
        this.jFrameUpdate.setVisible(true);
    }

    private void jMenuEditMenuSelected(MenuEvent evt) {
        this.flowchartEditManager.updateEditMenuEnablers();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            Thread.currentThread().setUncaughtExceptionHandler(new MyExceptionHandler());
            File flowchartToOpen = null;
            if (args.length > 0 && new File(args[0]).isFile()) {
                flowchartToOpen = new File(args[0]);
            }
            new MainWindow(flowchartToOpen).setVisible(true);
            if (args.length > 0 && args[0].equals("-updated")) {
                MyJOptionPane.showMessageDialog(null, "PS Diagram byl \u00fasp\u011b\u0161n\u011b aktualizov\u00e1n na verzi " + SettingsHolder.PSDIAGRAM_VERSION + "-" + SettingsHolder.PSDIAGRAM_BUILD + ".", "Aktualizace prob\u011bhla v po\u0159\u00e1dku", 1);
            }
        });
    }

    public static void setStatusText(String text, int delay) {
        jLabelStatus.setText(text);
        statusTimer.setInitialDelay(delay);
        statusTimer.restart();
    }

    public void setEditMode(boolean editMode) {
        if (this.editMode == editMode) {
            return;
        }
        if (editMode) {
            if (this.animationMode) {
                this.flowchartDebugManager.actionPerformed(new ActionEvent(this.jButtonToolAnimation, this.jButtonToolAnimation.hashCode(), "mode/animationMode"));
            }
            try {
                this.jButtonToolEdit.setIcon(new ImageIcon(this.getClass().getResource("/img/toolBar/24-Unlock.png")));
            }
            catch (NullPointerException e) {
                throw new Error("Error while loading toolbar image!");
            }
            this.jButtonToolEdit.setSelected(true);
            this.jPanelDiagram.addMouseListener(this.flowchartEditManager);
            this.jPanelDiagram.addMouseMotionListener(this.flowchartEditManager);
            this.jPanelDiagram.addKeyListener(this.flowchartEditManager);
            this.jTextAreaTextSymbol.addFocusListener(this.flowchartEditManager);
            this.jTextFieldTextSegment.addFocusListener(this.flowchartEditManager);
            if (this.jPanelVariables.isVisible()) {
                this.jPanelVariables.setVisible(false);
                ((GroupLayout)this.jPanelLeftSplit.getLayout()).replace(this.jPanelVariables, this.jPanelEdit);
                this.jPanelEdit.setVisible(true);
            }
            this.flowchartEditManager.updateUndoRedoEnablers();
            for (Component component : this.getAllComponents(this.jPanelLeftSplit)) {
                component.setEnabled(true);
            }
            this.jTextAreaTextSymbol.getDocument().addDocumentListener(this.flowchartEditManager);
            this.jTextFieldTextSegment.getDocument().addDocumentListener(this.flowchartEditManager);
            this.flowchartCrashRecovery.startPolling();
        } else {
            try {
                this.jButtonToolEdit.setIcon(new ImageIcon(this.getClass().getResource("/img/toolBar/24-Lock.png")));
            }
            catch (NullPointerException e) {
                throw new Error("Error while loading toolbar image!");
            }
            this.jButtonToolEdit.setSelected(false);
            this.jPanelDiagram.removeMouseListener(this.flowchartEditManager);
            this.jPanelDiagram.removeMouseMotionListener(this.flowchartEditManager);
            this.jPanelDiagram.removeKeyListener(this.flowchartEditManager);
            this.jTextAreaTextSymbol.removeFocusListener(this.flowchartEditManager);
            this.jTextFieldTextSegment.removeFocusListener(this.flowchartEditManager);
            this.jTextAreaTextSymbol.getDocument().removeDocumentListener(this.flowchartEditManager);
            this.jTextFieldTextSegment.getDocument().removeDocumentListener(this.flowchartEditManager);
            this.jTextAreaTextSymbol.setText("");
            this.jTextFieldTextSegment.setText("");
            this.jButtonToolUndo.setEnabled(false);
            this.jButtonToolRedo.setEnabled(false);
            this.jMenuItemUndo.setEnabled(false);
            this.jMenuItemRedo.setEnabled(false);
            for (Component component : this.getAllComponents(this.jPanelLeftSplit)) {
                component.setEnabled(false);
            }
            this.flowchartCrashRecovery.stopPolling();
        }
        this.layout.setEditMode(editMode);
        this.editMode = editMode;
    }

    public void setAnimationMode(boolean animationMode) {
        if (this.animationMode == animationMode) {
            return;
        }
        if (animationMode) {
            if (this.editMode) {
                this.flowchartEditManager.actionPerformed(new ActionEvent(this.jButtonToolEdit, this.jButtonToolEdit.hashCode(), "mode/editMode"));
            }
            this.jMenuLayouts.setEnabled(false);
            this.jButtonToolAnimation.setSelected(true);
            this.jSliderZoom.addKeyListener(this.flowchartDebugManager);
            this.jSliderSpeed.addKeyListener(this.flowchartDebugManager);
            this.jPanelDiagram.addKeyListener(this.flowchartDebugManager);
            this.jPanelDiagram.addMouseListener(this.flowchartDebugManager);
            this.jPanelDiagram.addMouseMotionListener(this.flowchartDebugManager);
            this.jButtonToolPlayPause.setEnabled(true);
            this.jButtonToolNext.setEnabled(true);
            this.jButtonToolStop.setEnabled(true);
            this.jButtonLaunch.setEnabled(true);
            this.jSliderSpeed.setEnabled(true);
            if (this.jPanelEdit.isVisible()) {
                this.jPanelEdit.setVisible(false);
                ((GroupLayout)this.jPanelLeftSplit.getLayout()).replace(this.jPanelEdit, this.jPanelVariables);
                this.jPanelVariables.setVisible(true);
            }
            for (Component component : this.getAllComponents(this.jPanelLeftSplit)) {
                component.setEnabled(true);
            }
        } else {
            this.jMenuLayouts.setEnabled(true);
            this.jButtonToolAnimation.setSelected(false);
            this.jSliderZoom.removeKeyListener(this.flowchartDebugManager);
            this.jSliderSpeed.removeKeyListener(this.flowchartDebugManager);
            this.jPanelDiagram.removeKeyListener(this.flowchartDebugManager);
            this.jPanelDiagram.removeMouseListener(this.flowchartDebugManager);
            this.jPanelDiagram.removeMouseMotionListener(this.flowchartDebugManager);
            this.jButtonToolPlayPause.setEnabled(false);
            this.jButtonToolPrevious.setEnabled(false);
            this.jButtonToolNext.setEnabled(false);
            this.jButtonToolStop.setEnabled(false);
            this.jButtonLaunch.setEnabled(false);
            this.jSliderSpeed.setEnabled(false);
            for (Component component : this.getAllComponents(this.jPanelLeftSplit)) {
                component.setEnabled(false);
            }
        }
        this.animationMode = animationMode;
    }

    public boolean getEditMode() {
        return this.editMode;
    }

    public boolean getAnimationMode() {
        return this.animationMode;
    }

    public void repaintJPanelDiagram() {
        this.jPanelDiagram.repaint();
    }

    public void setjMenuItemDeleteEnabled(boolean enabled) {
        this.jMenuItemDelete.setEnabled(enabled);
    }

    public void setjMenuItemCutEnabled(boolean enabled) {
        this.jMenuItemCut.setEnabled(enabled);
    }

    public void setjMenuItemCopyEnabled(boolean enabled) {
        this.jMenuItemCopy.setEnabled(enabled);
    }

    public void setjMenuItemPasteEnabled(boolean enabled) {
        this.jMenuItemPaste.setEnabled(enabled);
    }

    public void setJPanelDiagramFocus() {
        this.jPanelDiagram.requestFocusInWindow();
    }

    public void setJPanelTextSegmentVisible(boolean visible) {
        this.jPanelTextSegment.setVisible(visible);
    }

    public boolean graphicsXTransformedByScrollbar() {
        return this.graphicsXTransformedByScrollbar;
    }

    public boolean graphicsYTransformedByScrollbar() {
        return this.graphicsYTransformedByScrollbar;
    }

    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    public double getTranslateX() {
        return this.jPnlDiagram.getTranslateX();
    }

    public double getTranslateY() {
        return this.jPnlDiagram.getTranslateY();
    }

    public void setScale(double scale, Point2D anchorPoint) {
        this.jPnlDiagram.setScale(scale, anchorPoint);
    }

    public double getScale() {
        return this.jPnlDiagram.getScale();
    }

    public void setJLabelZoomText(String text) {
        this.jLabelZoom.setText(text);
    }

    public void packJPanelInnerText() {
        this.jPanelInnerText.setPreferredSize(this.jPanelInnerText.getLayout().minimumLayoutSize(this.jPanelInnerText));
        this.jScrollPaneText.revalidate();
    }

    public JTabbedPane getJTabbedPaneEdit() {
        return this.jTabbedPaneEdit;
    }

    public void setJScrollPaneFunctionViewportView(Component component) {
        if (component == null) {
            this.jScrollPaneFunction.setViewportView(this.jPanelInnerFunction);
        } else {
            this.jScrollPaneFunction.setViewportView(component);
        }
    }

    public Component getJScrollPaneFunctionViewportView() {
        return this.jScrollPaneFunction.getViewport().getView();
    }

    public Layout getFlowchartLayout() {
        return this.layout;
    }

    public FlowchartOverlookManager getFlowchartOverlookManager() {
        return this.flowchartOverlookManager;
    }

    public static void marshal(Object object, File file, boolean formated) throws JAXBException, FileNotFoundException {
        MainWindow.marshal(object, new FileOutputStream(file), formated);
    }

    public static void marshal(Object object, OutputStream os, boolean formated) throws JAXBException {
        Marshaller jAXBmarshaller = jAXBcontext.createMarshaller();
        jAXBmarshaller.setProperty("jaxb.formatted.output", formated);
        jAXBmarshaller.marshal(object, os);
    }

    public static Object unmarshal(File file) throws JAXBException, FileNotFoundException {
        return MainWindow.unmarshal(new FileInputStream(file));
    }

    public static Object unmarshal(InputStream is) throws JAXBException {
        Object object = jAXBcontext.createUnmarshaller().unmarshal(is);
        if (object instanceof FlowchartSaveContainer) {
            MainWindow.ensureBackwardCompatibility(((FlowchartSaveContainer)object).flowchart);
        } else if (object instanceof FlowchartRecovery) {
            MainWindow.ensureBackwardCompatibility(((FlowchartRecovery)object).flowchartSaveContainer.flowchart);
        } else if (object instanceof Flowchart) {
            MainWindow.ensureBackwardCompatibility((Flowchart)GlobalFunctions.unsafeCast(object));
        }
        return object;
    }

    private static void ensureBackwardCompatibility(Flowchart<LayoutSegment, LayoutElement> flowchart) {
        for (LayoutSegment segment : flowchart) {
            if (segment == null) continue;
            for (LayoutElement element : segment) {
                LinkedHashMap<String, String> commands = element.getSymbol().getCommands();
                if (commands == null) continue;
                for (String key : commands.keySet()) {
                    String command = (String)commands.get(key);
                    if (command == null) continue;
                    String[] commandWithoutQ = RegexFunctions.splitString(command, "\"([^\"\\\\]|\\\\.)*\"?");
                    for (int i = 0; i < commandWithoutQ.length; i += 2) {
                        commandWithoutQ[i] = commandWithoutQ[i].replace("==", "=");
                    }
                    Object cmnd = "";
                    for (String commandPart : commandWithoutQ) {
                        cmnd = (String)cmnd + commandPart;
                    }
                    commands.put(key, (String)cmnd);
                }
            }
        }
    }

    private TransferHandler createTransferHandler() {
        return new TransferHandler(){

            @Override
            public boolean importData(TransferHandler.TransferSupport ts) {
                try {
                    if (this.canImport(ts)) {
                        List fileList = (List)GlobalFunctions.unsafeCast(ts.getTransferable().getTransferData(DataFlavor.javaFileListFlavor));
                        MainWindow.this.openDiagram((File)fileList.get(0));
                    }
                }
                catch (UnsupportedFlavorException | IOException e) {
                    throw new RuntimeException(e);
                }
                return true;
            }

            @Override
            public boolean canImport(TransferHandler.TransferSupport ts) {
                if (ts.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    try {
                        List fileList = (List)GlobalFunctions.unsafeCast(ts.getTransferable().getTransferData(DataFlavor.javaFileListFlavor));
                        if (fileList != null && fileList.size() == 1 && (((File)fileList.get(0)).getName().endsWith(".xml") || ((File)fileList.get(0)).getName().endsWith(".psdiagram"))) {
                            return true;
                        }
                    }
                    catch (InvalidDnDOperationException ex) {
                        return true;
                    }
                    catch (UnsupportedFlavorException | IOException exception) {
                        // empty catch block
                    }
                }
                return false;
            }
        };
    }

    private static JAXBContext createJAXBContext() {
        try {
            return JAXBContext.newInstance(FlowchartSaveContainer.class, FlowchartRecovery.class, Flowchart.class, LayoutSegment.class, LayoutElement.class, Comment.class, Decision.class, Ellipsis.class, For.class, Goto.class, GotoLabel.class, IO.class, LoopEnd.class, LoopStart.class, Process.class, StartEnd.class, SubRoutine.class, Switch.class);
        }
        catch (JAXBException ex) {
            MyExceptionHandler.handle(ex);
            return null;
        }
    }

    private boolean checkIfSaved(boolean askAboutIt) {
        Boolean userWantedToSave = null;
        boolean saved = false;
        if (this.layout.getFlowchart().getMainSegment().size() > 2) {
            if (SettingsHolder.settings.getActualFlowchartFile() == null) {
                if (askAboutIt) {
                    userWantedToSave = this.askAboutSavingAndSave();
                }
            } else {
                try (ByteArrayOutputStream baosCurrent = new ByteArrayOutputStream();
                     ByteArrayOutputStream baosSaved = new ByteArrayOutputStream();){
                    if (SettingsHolder.settings.getActualFlowchartFile().getName().endsWith(".xml")) {
                        MainWindow.marshal(this.layout.getFlowchart(), baosCurrent, false);
                    } else {
                        MainWindow.marshal((Object)new FlowchartSaveContainer(this.layout.getFlowchart()), baosCurrent, false);
                    }
                    MainWindow.marshal(MainWindow.unmarshal(SettingsHolder.settings.getActualFlowchartFile()), baosSaved, false);
                    if (!Arrays.equals(baosCurrent.toByteArray(), baosSaved.toByteArray())) {
                        if (askAboutIt) {
                            userWantedToSave = this.askAboutSavingAndSave();
                        }
                    } else {
                        saved = true;
                    }
                }
                catch (JAXBException | IOException ex) {
                    MyExceptionHandler.handle(ex);
                }
            }
            if (Boolean.TRUE.equals(userWantedToSave)) {
                saved = true;
            }
            if (saved && !SettingsHolder.settings.isDontSaveDirectly()) {
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    MainWindow.marshal((Object)new FlowchartSaveContainer(this.layout.getFlowchart()), baos, false);
                    this.flowchartCollector.uploadFlowchart(baos.toString(StandardCharsets.UTF_8.name()), SettingsHolder.settings.getActualFlowchartFile());
                }
                catch (JAXBException | IOException ex) {
                    MyExceptionHandler.handle(ex);
                }
            }
            return saved || userWantedToSave != null;
        }
        return true;
    }

    private Boolean askAboutSavingAndSave() {
        int n = MyJOptionPane.showConfirmDialog(this, "<html>Diagram nen\u00ed ulo\u017een. Pokud jej neulo\u017e\u00edte p\u0159ed jeho zav\u0159en\u00edm,<br />ve\u0161ker\u00e9 zm\u011bny budou ztraceny.<br />Ulo\u017eit nyn\u00ed?</html>", "Diagram nen\u00ed ulo\u017een", 1, 2);
        if (n == 2 || n == -1) {
            return null;
        }
        if (n == 0) {
            this.jMenuItemSaveActionPerformed(null);
            return true;
        }
        return false;
    }

    public boolean openGeneratedDiagram(Flowchart<LayoutSegment, LayoutElement> flowchart) {
        if (!this.checkIfSaved(true)) {
            return false;
        }
        if (!this.editMode) {
            this.flowchartEditManager.actionPerformed(new ActionEvent(this.jButtonToolEdit, this.jButtonToolEdit.hashCode(), "mode/editMode"));
        }
        SettingsHolder.settings.setDontSaveDirectly(false);
        this.layout.setFlowchart(flowchart);
        this.flowchartEditManager.loadMarkedSymbolText();
        this.flowchartEditManager.resetUndoManager();
        this.jPanelDiagram.repaint();
        SettingsHolder.settings.setActualFlowchartFile(null);
        this.flowchartCrashRecovery.updateSavedFlowchart();
        this.updateTitle();
        this.flowchartEditManager.revalidateSymbolCommands();
        MainWindow.setStatusText("Diagram byl \u00fasp\u011b\u0161n\u011b vygenerov\u00e1n ze zdrojov\u00e9ho k\u00f3du", 8000);
        SwingUtilities.invokeLater(() -> {
            this.jScrollPaneDiagram.getVerticalScrollBar().setValue(0);
            this.jScrollPaneDiagram.getHorizontalScrollBar().setValue(0);
            this.jPnlDiagram.setTranslateX(0.0);
            this.jPnlDiagram.setTranslateY(0.0);
        });
        return true;
    }

    private void updateTitle() {
        if (SettingsHolder.settings.getActualFlowchartFile() == null) {
            super.setTitle("PS Diagram");
        } else {
            String fileName = SettingsHolder.settings.getActualFlowchartFile().getName();
            super.setTitle(fileName.substring(0, fileName.lastIndexOf(46)) + " - PS Diagram");
        }
    }

    private void openDiagram(File file) {
        block5: {
            if (!this.checkIfSaved(true)) {
                return;
            }
            try {
                Flowchart<LayoutSegment, LayoutElement> flowchart;
                if (file.getName().endsWith(".xml")) {
                    flowchart = (Flowchart<LayoutSegment, LayoutElement>)GlobalFunctions.unsafeCast(MainWindow.unmarshal(file));
                } else {
                    FlowchartSaveContainer flowchartSaveContainer = (FlowchartSaveContainer)GlobalFunctions.unsafeCast(MainWindow.unmarshal(file));
                    flowchart = flowchartSaveContainer.flowchart;
                }
                this.openDiagram(flowchart, file);
            }
            catch (JAXBException | FileNotFoundException ex) {
                MyExceptionHandler.handle(ex);
                MyJOptionPane.showMessageDialog(this, "P\u0159i na\u010d\u00edt\u00e1n\u00ed diagramu nastala chyba!", "Diagram se nepoda\u0159ilo otev\u0159\u00edt", 0);
                if (SettingsHolder.settings.getActualFlowchartFile() == null || !SettingsHolder.settings.getActualFlowchartFile().equals(file)) break block5;
                SettingsHolder.settings.setActualFlowchartFile(null);
                this.flowchartCrashRecovery.updateSavedFlowchart();
            }
        }
    }

    private void openDiagram(Flowchart<LayoutSegment, LayoutElement> flowchart, File file) {
        SettingsHolder.settings.setDontSaveDirectly(false);
        this.setJScrollPaneFunctionViewportView(null);
        if (this.editMode) {
            this.flowchartEditManager.actionPerformed(new ActionEvent(this.jButtonToolEdit, this.jButtonToolEdit.hashCode(), "mode/editMode"));
        } else if (this.animationMode) {
            this.flowchartDebugManager.actionPerformed(new ActionEvent(this.jButtonToolAnimation, this.jButtonToolAnimation.hashCode(), "mode/animationMode"));
        }
        this.layout.setFlowchart(flowchart);
        this.flowchartEditManager.resetUndoManager();
        this.jPanelDiagram.repaint();
        SettingsHolder.settings.setActualFlowchartFile(file);
        this.flowchartCrashRecovery.updateSavedFlowchart();
        this.updateTitle();
        this.flowchartEditManager.revalidateSymbolCommands();
        if (file != null) {
            MainWindow.setStatusText("Diagram " + SettingsHolder.settings.getActualFlowchartFile().getPath() + " byl \u00fasp\u011b\u0161n\u011b otev\u0159en.", 8000);
        }
        SwingUtilities.invokeLater(() -> {
            this.jScrollPaneDiagram.getVerticalScrollBar().setValue(0);
            this.jScrollPaneDiagram.getHorizontalScrollBar().setValue(0);
            this.jPnlDiagram.setTranslateX(0.0);
            this.jPnlDiagram.setTranslateY(0.0);
        });
    }

    private ArrayList<Component> getAllComponents(Container c) {
        Component[] comps = c.getComponents();
        ArrayList<Component> compList = new ArrayList<Component>();
        for (Component comp : comps) {
            compList.add(comp);
            if (!(comp instanceof Container)) continue;
            compList.addAll(this.getAllComponents((Container)comp));
        }
        return compList;
    }

    private void loadLayoutSettings() {
        ArrayList<JMenuItem> menuItems = this.layout.getSettings();
        if (menuItems == null || menuItems.isEmpty()) {
            this.jMenuLayoutSetting.setEnabled(false);
        } else {
            this.jMenuLayoutSetting.setEnabled(true);
            for (JMenuItem menuItem : menuItems) {
                this.jMenuLayoutSetting.add(menuItem);
            }
        }
    }

    public MaxBalloonSizeCallback getMaxBalloonSizeCallback() {
        return new MaxBalloonSizeCallback(){

            @Override
            public Dimension getMaxBalloonSize() {
                return MainWindow.this.jSplitPane.getSize();
            }
        };
    }

    private void exit() {
        if (!this.checkIfSaved(true)) {
            return;
        }
        this.flowchartCrashRecovery.stopPolling();
        this.flowchartCrashRecovery.deleteBackup();
        SettingsHolder.saveSettings();
        this.jFrameAbout.setVisible(false);
        this.jFrameCodeExport.setVisible(false);
        this.jFrameCodeImport.setVisible(false);
        this.jFrameSettings.setVisible(false);
        this.jFrameUpdate.setVisible(false);
        this.setVisible(false);
        this.flowchartCollector.requestExitApp();
    }

    private class JScrollBarDiagram
    extends JScrollBar {
        private int value;

        public JScrollBarDiagram(int orientation) {
            super(orientation);
        }

        @Override
        public int getMaximum() {
            int maximum = super.getMaximum();
            if (this.orientation == 0) {
                JScrollBar theOtherScrollBar = MainWindow.this.jScrollPaneDiagram.getVerticalScrollBar();
                if (MainWindow.this.jPnlDiagram != null && theOtherScrollBar.isVisible() && MainWindow.this.jPnlDiagram.getTranslateX() < 0.0) {
                    maximum -= theOtherScrollBar.getWidth();
                }
            } else {
                JScrollBar theOtherScrollBar = MainWindow.this.jScrollPaneDiagram.getHorizontalScrollBar();
                if (MainWindow.this.jPnlDiagram != null && theOtherScrollBar.isVisible() && MainWindow.this.jPnlDiagram.getTranslateY() < 0.0) {
                    maximum -= theOtherScrollBar.getHeight();
                }
            }
            return maximum;
        }

        public Dimension getViewSize() {
            Dimension dimension = MainWindow.this.jScrollPaneDiagram.getViewport().getExtentSize();
            if (this.orientation == 0) {
                JScrollBar theOtherScrollBar = MainWindow.this.jScrollPaneDiagram.getVerticalScrollBar();
                if (theOtherScrollBar.isVisible()) {
                    dimension.width += theOtherScrollBar.getWidth();
                }
                if (super.isVisible()) {
                    dimension.height += super.getHeight();
                }
            } else {
                JScrollBar theOtherScrollBar = MainWindow.this.jScrollPaneDiagram.getHorizontalScrollBar();
                if (theOtherScrollBar.isVisible()) {
                    dimension.height += theOtherScrollBar.getHeight();
                }
                if (super.isVisible()) {
                    dimension.width += super.getWidth();
                }
            }
            return dimension;
        }

        @Override
        public void setValue(int value) {
            int minValue;
            int viewportSize;
            int diagramSize;
            if (super.getValueIsAdjusting()) {
                super.setValue(value);
                return;
            }
            if (this.orientation == 0) {
                MainWindow.this.graphicsXTransformedByScrollbar = false;
            } else {
                MainWindow.this.graphicsYTransformedByScrollbar = false;
            }
            int flowchartPadding = (int)((double)MainWindow.this.layout.getFlowchartPadding() * MainWindow.this.getScale());
            if (this.orientation == 0) {
                value = (int)Math.round(MainWindow.this.jPnlDiagram.getTranslateX()) + this.value - value;
                diagramSize = (int)(MainWindow.this.layout.getWidth() * MainWindow.this.jPnlDiagram.getScale());
                viewportSize = this.getViewSize().width;
            } else {
                value = (int)Math.round(MainWindow.this.jPnlDiagram.getTranslateY()) + this.value - value;
                diagramSize = (int)(MainWindow.this.layout.getHeight() * MainWindow.this.jPnlDiagram.getScale());
                viewportSize = this.getViewSize().height;
            }
            if (value > 0) {
                int maxValue = viewportSize - flowchartPadding;
                if (value > maxValue) {
                    value = maxValue;
                }
            } else if (value < 0 && value < (minValue = -diagramSize + flowchartPadding)) {
                value = minValue;
            }
            if (this.orientation == 0) {
                MainWindow.this.jPnlDiagram.setTranslateX(value);
            } else {
                MainWindow.this.jPnlDiagram.setTranslateY(value);
            }
            if (value >= 0) {
                value = 0;
            } else {
                int jPanelDiagramSize = this.orientation == 0 ? MainWindow.this.jPnlDiagram.getPreferredSize().width : MainWindow.this.jPnlDiagram.getPreferredSize().height;
                int diagramSizeDifference = jPanelDiagramSize - Math.abs(value) - viewportSize;
                value = jPanelDiagramSize - viewportSize;
                if (diagramSizeDifference > 0) {
                    value -= diagramSizeDifference;
                }
            }
            final int val = value;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JScrollBarDiagram.this.superSetValue(val);
                }
            });
            this.superSetValue(value);
        }

        public void superSetValue(int value) {
            this.value = value;
            super.setValue(value);
            MainWindow.this.jPnlDiagram.repaint();
        }
    }

    private class JPanelDiagram
    extends JPanel {
        private double translateX = 0.0;
        private double translateY = 0.0;
        private double scale = 1.0;

        private JPanelDiagram() {
        }

        @Override
        protected void paintComponent(Graphics grphcs) {
            Graphics2D grphcs2D;
            super.paintComponent(grphcs);
            if (grphcs instanceof Graphics2D) {
                grphcs2D = (Graphics2D)grphcs;
                grphcs2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                double transX = this.translateX;
                double transY = this.translateY;
                if (transX < 0.0) {
                    transX = 0.0;
                }
                if (transY < 0.0) {
                    transY = 0.0;
                }
                this.updateAffineTransform();
                grphcs2D.translate(transX, transY);
                grphcs2D.scale(this.scale, this.scale);
                if (MainWindow.this.animationMode) {
                    MainWindow.this.flowchartDebugManager.paintFlowchart(grphcs2D);
                } else {
                    MainWindow.this.layout.paintFlowchart(grphcs2D, false);
                }
            } else {
                throw new Error("Parameter Graphics g is not instance of Graphics2D!");
            }
            MainWindow.this.flowchartEditManager.paint(grphcs2D);
        }

        private void updateAffineTransform() {
            double transX = this.translateX;
            double transY = this.translateY;
            if (transX < 0.0) {
                transX = 0.0;
            }
            if (transY < 0.0) {
                transY = 0.0;
            }
            MainWindow.this.affineTransform = AffineTransform.getTranslateInstance(transX, transY);
            MainWindow.this.affineTransform.scale(this.scale, this.scale);
        }

        @Override
        public void setPreferredSize(Dimension dmnsn) {
            int difference;
            Dimension dim = new Dimension((int)((double)dmnsn.width * this.scale), (int)((double)dmnsn.height * this.scale));
            Dimension viewSize = ((JScrollBarDiagram)MainWindow.this.jScrollPaneDiagram.getHorizontalScrollBar()).getViewSize();
            if (this.translateX >= 0.0) {
                dim.width = (int)((double)dim.width + this.translateX);
            } else if (dim.width <= viewSize.width) {
                dim.width = viewSize.width - (int)this.translateX;
            } else {
                difference = viewSize.width - dim.width - (int)this.translateX;
                if (difference > 0) {
                    dim.width += difference;
                }
            }
            if (this.translateY >= 0.0) {
                dim.height = (int)((double)dim.height + this.translateY);
            } else if (dim.height <= viewSize.height) {
                dim.height = viewSize.height - (int)this.translateY;
            } else {
                difference = viewSize.height - dim.height - (int)this.translateY;
                if (difference > 0) {
                    dim.height += difference;
                }
            }
            super.setPreferredSize(dim);
            MainWindow.this.jPanelDiagram.revalidate();
            MainWindow.this.jScrollPaneDiagram.revalidate();
        }

        public void setTranslateX(double translateX) {
            if (this.translateX != translateX) {
                MainWindow.this.graphicsXTransformedByScrollbar = true;
            }
            this.translateX = translateX;
            this.setPreferredSize(new Dimension((int)MainWindow.this.layout.getWidth(), (int)MainWindow.this.layout.getHeight()));
        }

        public void setTranslateY(double translateY) {
            if (this.translateY != translateY) {
                MainWindow.this.graphicsYTransformedByScrollbar = true;
            }
            this.translateY = translateY;
            this.setPreferredSize(new Dimension((int)MainWindow.this.layout.getWidth(), (int)MainWindow.this.layout.getHeight()));
        }

        public double getTranslateX() {
            return this.translateX;
        }

        public double getTranslateY() {
            return this.translateY;
        }

        public void setScale(double scale, Point2D anchorPoint) {
            if (anchorPoint == null) {
                anchorPoint = MainWindow.this.jScrollPaneDiagram.getViewport().getViewPosition();
            }
            Point2D anchorTranslated = null;
            try {
                anchorTranslated = MainWindow.this.affineTransform.createInverse().transform(anchorPoint, null);
            }
            catch (NoninvertibleTransformException e) {
                throw new Error("Error while transforming coordnates!");
            }
            this.scale = scale;
            this.setPreferredSize(new Dimension((int)MainWindow.this.layout.getWidth(), (int)MainWindow.this.layout.getHeight()));
            this.updateAffineTransform();
            Point2D anchorPostTranslated = null;
            try {
                anchorPostTranslated = MainWindow.this.affineTransform.createInverse().transform(anchorPoint, null);
            }
            catch (NoninvertibleTransformException e) {
                throw new Error("Error while transforming coordnates!");
            }
            if (anchorPostTranslated != null && anchorTranslated != null) {
                double changeX = (anchorTranslated.getX() - anchorPostTranslated.getX()) * scale;
                double changeY = (anchorTranslated.getY() - anchorPostTranslated.getY()) * scale;
                JScrollBar horizontalScrollbar = MainWindow.this.jScrollPaneDiagram.getHorizontalScrollBar();
                JScrollBar verticalScrollbar = MainWindow.this.jScrollPaneDiagram.getVerticalScrollBar();
                horizontalScrollbar.setValue(horizontalScrollbar.getValue() + (int)Math.round(changeX));
                verticalScrollbar.setValue(verticalScrollbar.getValue() + (int)Math.round(changeY));
            }
        }

        public double getScale() {
            return this.scale;
        }
    }
}

