/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui;

import cz.miroslavbartyzal.psdiagram.app.global.SettingsHolder;
import cz.miroslavbartyzal.psdiagram.app.gui.dialog.MyJOptionPane;
import java.io.File;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public final class MyFileChooser {
    public static File saveFileDialog(FilterType filterType, String title, String defaultFileName) {
        if (defaultFileName == null || defaultFileName.equals("")) {
            defaultFileName = "Bez_n\u00e1zvu";
        }
        JFileChooser jFileChooser = new JFileChooser(SettingsHolder.settings.getLastDir()){

            @Override
            public void approveSelection() {
                File f = MyFileChooser.checkExtension(this.getSelectedFile(), ((FileNameExtensionFilter)this.getFileFilter()).getExtensions()[0]);
                if (this.getDialogType() == 1 && f.exists()) {
                    int result = MyJOptionPane.showConfirmDialog(this, "Soubor ji\u017e existuje, p\u0159epsat?", "P\u0159epsat soubor?", 1, 2);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case -1: 
                        case 1: {
                            return;
                        }
                        case 2: {
                            this.cancelSelection();
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        jFileChooser.setDialogTitle(title);
        jFileChooser.setSelectedFile(new File(defaultFileName));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        for (FileFilter fileFilter : filterType.getFileFilters()) {
            jFileChooser.addChoosableFileFilter(fileFilter);
        }
        jFileChooser.setFileFilter(filterType.getDefaultFileFilter());
        if (jFileChooser.showSaveDialog(null) == 0) {
            SettingsHolder.settings.setLastDir(jFileChooser.getCurrentDirectory().getPath());
            return MyFileChooser.checkExtension(jFileChooser.getSelectedFile(), ((FileNameExtensionFilter)jFileChooser.getFileFilter()).getExtensions()[0]);
        }
        return null;
    }

    public static File openFileDialog(FilterType filterType, String title) {
        JFileChooser jFileChooser = new JFileChooser(SettingsHolder.settings.getLastDir());
        jFileChooser.setDialogTitle(title);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        for (FileFilter fileFilter : filterType.getFileFilters()) {
            jFileChooser.addChoosableFileFilter(fileFilter);
        }
        jFileChooser.setFileFilter(filterType.getDefaultFileFilter());
        if (jFileChooser.showOpenDialog(null) == 0) {
            SettingsHolder.settings.setLastDir(jFileChooser.getCurrentDirectory().getPath());
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private static File checkExtension(File file, String extension) {
        if (file.getName().endsWith("." + extension)) {
            return file;
        }
        return new File(file.getPath() + "." + extension);
    }

    public static enum FilterType {
        IMAGE{
            private final FileFilter[] filters;
            {
                TreeSet<String> formats = new TreeSet<String>();
                for (String format : ImageIO.getWriterFormatNames()) {
                    if (format.toLowerCase().equals("wbmp")) continue;
                    formats.add(format.toLowerCase());
                }
                this.filters = new FileFilter[formats.size()];
                int i = 0;
                for (String format : formats) {
                    this.filters[i] = new FileNameExtensionFilter("*." + format, format);
                    ++i;
                }
            }

            @Override
            FileFilter[] getFileFilters() {
                return this.filters;
            }

            @Override
            FileFilter getDefaultFileFilter() {
                for (FileFilter fileFilter : this.filters) {
                    if (!fileFilter.getDescription().equals("*.png")) continue;
                    return fileFilter;
                }
                return null;
            }
        }
        ,
        PDF{
            private final FileFilter[] filters = new FileFilter[]{new FileNameExtensionFilter("*.pdf", "pdf")};

            @Override
            FileFilter[] getFileFilters() {
                return this.filters;
            }

            @Override
            FileFilter getDefaultFileFilter() {
                return this.filters[0];
            }
        }
        ,
        XML{
            private final FileFilter[] filters = new FileFilter[]{new FileNameExtensionFilter("*.xml", "xml")};

            @Override
            FileFilter[] getFileFilters() {
                return this.filters;
            }

            @Override
            FileFilter getDefaultFileFilter() {
                return this.filters[0];
            }
        }
        ,
        PSDIAGRAM{
            private final FileFilter[] filters = new FileFilter[]{new FileNameExtensionFilter("*.psdiagram", "psdiagram")};

            @Override
            FileFilter[] getFileFilters() {
                return this.filters;
            }

            @Override
            FileFilter getDefaultFileFilter() {
                return this.filters[0];
            }
        }
        ,
        XML_AND_PSDIAGRAM{
            private final FileFilter[] filters = new FileFilter[]{new FileNameExtensionFilter("*.psdiagram, *.xml", "psdiagram", "xml")};

            @Override
            FileFilter[] getFileFilters() {
                return this.filters;
            }

            @Override
            FileFilter getDefaultFileFilter() {
                return this.filters[0];
            }
        };


        abstract FileFilter[] getFileFilters();

        abstract FileFilter getDefaultFileFilter();
    }
}

