/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui.balloonToolTip;

import cz.miroslavbartyzal.psdiagram.app.global.SettingsHolder;
import cz.miroslavbartyzal.psdiagram.app.gui.balloonToolTip.MaxBalloonSizeCallback;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.styles.BalloonTipStyle;
import net.java.balloontip.styles.RoundedBalloonStyle;

public class PSDBalloonToolTip {
    private final BalloonTipStyle balloonTipStyle;
    private final BalloonTip balloonTip;
    private final JPanel balloonTipContent;
    private final FadeOutTimer fadeOutTimer;
    private static final int ARC_SIZE = 5;
    private int lastInitialDelay = -1;
    private boolean displayMessages = false;
    private final JPanel balloonTipTempContent;
    private final JLabel balloonTipTempMessage;
    private final JComponent parentComponent;
    private final MaxBalloonSizeCallback maxBalloonSizeCallback;

    public PSDBalloonToolTip(JComponent parentComponent, MaxBalloonSizeCallback maxBalloonSizeCallback) {
        this.parentComponent = parentComponent;
        this.maxBalloonSizeCallback = maxBalloonSizeCallback;
        JLabel balloonTipMessage = new JLabel();
        JLabel balloonTipCommand = new JLabel();
        balloonTipMessage.setFont(SettingsHolder.CODEFONT);
        balloonTipCommand.setFont(SettingsHolder.CODEFONT);
        this.balloonTipContent = new JPanel();
        this.balloonTipContent.setLayout(new BoxLayout(this.balloonTipContent, 1));
        this.balloonTipContent.setOpaque(false);
        this.balloonTipContent.add(balloonTipMessage);
        this.balloonTipContent.add(balloonTipCommand);
        this.balloonTipTempMessage = new JLabel();
        this.balloonTipTempMessage.setFont(SettingsHolder.CODEFONT);
        this.balloonTipTempContent = new JPanel();
        this.balloonTipTempContent.setLayout(new BoxLayout(this.balloonTipTempContent, 1));
        this.balloonTipTempContent.setOpaque(false);
        this.balloonTipTempContent.add(this.balloonTipTempMessage);
        this.balloonTipStyle = new RoundedBalloonStyle(5, 5, Color.WHITE, Color.BLACK);
        this.balloonTip = new BalloonTip(parentComponent, this.balloonTipContent, this.balloonTipStyle, false){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = new Dimension(super.getPreferredSize());
                Dimension dimMax = PSDBalloonToolTip.this.maxBalloonSizeCallback.getMaxBalloonSize();
                if (dimension.width > dimMax.width) {
                    dimension.width = dimMax.width;
                }
                if (dimension.height > dimMax.height) {
                    dimension.height = dimMax.height;
                }
                return dimension;
            }

            @Override
            public boolean contains(Point p) {
                return super.contains(p) && p.getY() <= (double)(super.getHeight() - PSDBalloonToolTip.this.balloonTipStyle.getMinimalHorizontalOffset() + 5);
            }

            @Override
            public boolean contains(int x, int y) {
                return super.contains(x, y) && y <= super.getHeight() - PSDBalloonToolTip.this.balloonTipStyle.getMinimalHorizontalOffset() + 5;
            }
        };
        this.balloonTip.setVisible(false);
        MyMouseMotionListener myMouseMotionListener = new MyMouseMotionListener();
        this.balloonTip.addMouseListener(myMouseMotionListener);
        this.balloonTip.addMouseMotionListener(myMouseMotionListener);
        this.fadeOutTimer = new FadeOutTimer(500, 3000, 25);
        parentComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                PSDBalloonToolTip.this.fadeOutTimer.dismiss();
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (PSDBalloonToolTip.this.displayMessages) {
                    PSDBalloonToolTip.this.fadeOutTimer.stopFadingOut();
                    PSDBalloonToolTip.this.balloonTip.setContents(PSDBalloonToolTip.this.balloonTipContent);
                    PSDBalloonToolTip.this.balloonTip.setVisible(true);
                    if (PSDBalloonToolTip.this.lastInitialDelay >= 0) {
                        PSDBalloonToolTip.this.fadeOutTimer.setInitialDelay(PSDBalloonToolTip.this.lastInitialDelay);
                        if (PSDBalloonToolTip.this.balloonTip.getMousePosition() == null) {
                            PSDBalloonToolTip.this.fadeOutTimer.startFadingOut();
                        }
                        PSDBalloonToolTip.this.fadeOutTimer.setInitialDelay(100);
                    }
                }
            }
        });
    }

    public void wipeMessage() {
        this.lastInitialDelay = -1;
        this.displayMessages = false;
        this.dismiss();
    }

    public void showMessages(List<String> messages, int timeMilliseconds) {
        this.displayMessages = true;
        this.lastInitialDelay = timeMilliseconds;
        this.fadeOutTimer.stopFadingOut();
        this.balloonTipContent.removeAll();
        for (String message : messages) {
            JLabel jLabel = new JLabel(message);
            jLabel.setFont(SettingsHolder.CODEFONT);
            this.balloonTipContent.add(jLabel);
        }
        this.balloonTip.setContents(this.balloonTipContent);
        if (this.parentComponent.hasFocus()) {
            this.balloonTip.setVisible(true);
            if (this.lastInitialDelay >= 0) {
                this.fadeOutTimer.setInitialDelay(timeMilliseconds);
                if (this.balloonTip.getMousePosition() == null) {
                    this.fadeOutTimer.startFadingOut();
                }
                this.fadeOutTimer.setInitialDelay(100);
            }
        }
    }

    public void showTemporaryMessage(String message, int timeMilliseconds) {
        this.fadeOutTimer.setInitialDelay(timeMilliseconds);
        this.fadeOutTimer.stopFadingOut();
        this.balloonTipTempMessage.setText(message);
        this.balloonTip.setContents(this.balloonTipTempContent);
        this.balloonTip.setVisible(true);
        if (this.balloonTip.getMousePosition() == null) {
            this.fadeOutTimer.startFadingOut();
        }
        this.fadeOutTimer.setInitialDelay(100);
    }

    public void dismiss() {
        this.fadeOutTimer.dismiss();
    }

    private class FadeOutTimer {
        private final Timer timer;
        private int curTime;

        public FadeOutTimer(int initialDelay, final int fadeoutTime, int refreshRate) {
            final int timeDelta = 1000 / refreshRate;
            this.timer = new Timer(timeDelta, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FadeOutTimer.this.curTime += timeDelta;
                    float newOpacity = -1.0f / (float)fadeoutTime * (float)FadeOutTimer.this.curTime + 1.0f;
                    if (newOpacity <= 0.0f || Float.isNaN(newOpacity)) {
                        FadeOutTimer.this.dismiss();
                    } else {
                        PSDBalloonToolTip.this.balloonTip.setOpacity(newOpacity);
                    }
                }
            });
            this.timer.setInitialDelay(initialDelay);
            this.timer.setRepeats(true);
        }

        public void dismiss() {
            this.timer.stop();
            PSDBalloonToolTip.this.balloonTip.setVisible(false);
            PSDBalloonToolTip.this.balloonTip.setOpacity(1.0f);
        }

        public void startFadingOut() {
            if (!this.timer.isRunning()) {
                PSDBalloonToolTip.this.balloonTip.setOpacity(1.0f);
                this.curTime = 0;
                this.timer.start();
            }
        }

        public void stopFadingOut() {
            if (this.timer.isRunning()) {
                this.timer.stop();
                PSDBalloonToolTip.this.balloonTip.setOpacity(1.0f);
            }
        }

        public void setInitialDelay(int initialDelay) {
            this.timer.setInitialDelay(initialDelay);
        }
    }

    private class MyMouseMotionListener
    extends MouseAdapter {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (PSDBalloonToolTip.this.lastInitialDelay >= 0) {
                PSDBalloonToolTip.this.fadeOutTimer.stopFadingOut();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (PSDBalloonToolTip.this.lastInitialDelay >= 0) {
                PSDBalloonToolTip.this.fadeOutTimer.startFadingOut();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            PSDBalloonToolTip.this.balloonTip.setVisible(false);
            PSDBalloonToolTip.this.fadeOutTimer.stopFadingOut();
        }
    }
}

