/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui.managers;

import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.Layout;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Comment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class FlowchartCommentSymbolManager {
    private final Layout layout;
    private int procesCommentsPointIndex = -1;
    private Ellipse2D commentPathConnector = null;
    private int futureRelativePointIndex = -1;
    private Comment procesComment;
    private LayoutElement procesCommentElement;
    private Symbol pairedSymbol;
    private double cursorRelX;
    private double cursorRelY;
    private String commentAction;
    private boolean dragging = false;

    protected FlowchartCommentSymbolManager(Layout layout) {
        this.layout = layout;
    }

    protected void analyzeMouseToCommentPathAndConnector(Point2D p) {
        Comment boldPathComment = null;
        for (Comment comment : this.layout.getlCommentSymbols()) {
            double origAbsX = comment.getCenterX() - comment.getRelativeX();
            double origAbsY = comment.getCenterY() - comment.getRelativeY();
            Point2D.Double prevPoint = new Point2D.Double(origAbsX, origAbsY);
            for (Point2D pnt : comment.getRelativeMiddlePointsToSymbol()) {
                Point2D.Double point = new Point2D.Double(origAbsX + pnt.getX(), origAbsY + pnt.getY());
                if (point.distance(p.getX(), p.getY()) < 4.0) {
                    this.setCommentPathConnector(((Point2D)point).getX(), ((Point2D)point).getY());
                    this.layout.setBoldPathComment(null);
                    return;
                }
                if (boldPathComment != null) continue;
                if (this.shouldBeBold(comment, prevPoint, point, p)) {
                    boldPathComment = comment;
                    this.futureRelativePointIndex = comment.getRelativeMiddlePointsToSymbol().indexOf(pnt);
                    continue;
                }
                prevPoint = point;
            }
            if (boldPathComment != null || !this.shouldBeBold(comment, prevPoint, new Point2D.Double(comment.getCenterX(), comment.getCenterY()), p)) continue;
            boldPathComment = comment;
            this.futureRelativePointIndex = comment.getRelativeMiddlePointsToSymbol().size();
        }
        if (this.commentPathConnector != null) {
            this.commentPathConnector = null;
        }
        this.layout.setBoldPathComment(boldPathComment);
    }

    protected void resetVariables() {
        this.procesComment = null;
        this.procesCommentsPointIndex = -1;
        if (this.layout.getBoldPathComment() == null) {
            this.futureRelativePointIndex = -1;
        }
        this.procesCommentElement = null;
        this.pairedSymbol = null;
        this.cursorRelX = 0.0;
        this.cursorRelY = 0.0;
        this.dragging = false;
    }

    protected boolean wasMousePressedEventRelevantForConnector(Point2D mouseCoords) {
        if (this.commentPathConnector != null) {
            if (this.commentPathConnector.contains(mouseCoords)) {
                for (Comment comment : this.layout.getlCommentSymbols()) {
                    int i = 0;
                    for (Point2D point : comment.getRelativeMiddlePointsToSymbol()) {
                        if (comment.getCenterX() - comment.getRelativeX() + point.getX() == this.commentPathConnector.getCenterX() && comment.getCenterY() - comment.getRelativeY() + point.getY() == this.commentPathConnector.getCenterY()) {
                            this.procesComment = comment;
                            this.procesCommentsPointIndex = i;
                            this.procesCommentElement = this.layout.findMyElement(comment);
                            if (comment.hasPairSymbol()) {
                                this.pairedSymbol = this.layout.findMyPairedElement(this.procesCommentElement).getSymbol();
                            }
                            return true;
                        }
                        ++i;
                    }
                }
            } else {
                this.commentPathConnector = null;
            }
        }
        return false;
    }

    protected boolean wereMouseReleasedCoordsInsideConnector(Point2D mouseCoords) {
        if (this.commentPathConnector != null) {
            if (!this.commentPathConnector.contains(mouseCoords)) {
                this.commentPathConnector = null;
            } else {
                return true;
            }
        }
        return false;
    }

    protected void mousePressedOnComment(LayoutElement commentElement, Point2D mouseCoords) {
        this.procesCommentElement = commentElement;
        this.procesComment = (Comment)commentElement.getSymbol();
        this.setCursorRelCoords(mouseCoords.getX(), mouseCoords.getY());
        if (this.procesCommentElement.getSymbol().hasPairSymbol()) {
            this.pairedSymbol = this.layout.findMyPairedElement(commentElement).getSymbol();
        }
    }

    protected void setCommentPathConnectorFromDraggedMouse(Point2D mouseCoords) {
        Comment comment = this.layout.getBoldPathComment();
        this.setCommentPathConnector(mouseCoords.getX(), mouseCoords.getY());
        this.procesComment = comment;
        comment.getRelativeMiddlePointsToSymbol().add(this.futureRelativePointIndex, null);
        this.procesCommentsPointIndex = this.futureRelativePointIndex;
        this.procesCommentElement = this.layout.findMyElement(comment);
        if (comment.hasPairSymbol()) {
            this.pairedSymbol = this.layout.findMyPairedElement(this.procesCommentElement).getSymbol();
        }
        this.layout.setBoldPathComment(null);
        this.futureRelativePointIndex = -1;
    }

    private void dragCommentPathConnector(Point2D mouseCoords) {
        Point2D.Double point = new Point2D.Double(mouseCoords.getX() - this.procesComment.getCenterX() + this.procesComment.getRelativeX(), mouseCoords.getY() - this.procesComment.getCenterY() + this.procesComment.getRelativeY());
        this.procesComment.getRelativeMiddlePointsToSymbol().set(this.procesCommentsPointIndex, point);
        this.setCommentPathConnector(mouseCoords.getX(), mouseCoords.getY());
        this.procesCommentElement.setPathToNextSymbol(this.layout.getCommentPathFromRelative(this.procesComment, this.pairedSymbol));
    }

    private void dragCommentElement(Point2D mouseCoords) {
        double relX = mouseCoords.getX() - this.procesComment.getCenterX() - this.cursorRelX;
        double relY = mouseCoords.getY() - this.procesComment.getCenterY() - this.cursorRelY;
        this.procesComment.setCenterX(this.procesComment.getCenterX() + relX);
        this.procesComment.setCenterY(this.procesComment.getCenterY() + relY);
        this.procesComment.setRelativeX(this.procesComment.getRelativeX() + relX);
        this.procesComment.setRelativeY(this.procesComment.getRelativeY() + relY);
        boolean toRightSite = this.procesComment.istoRightSite();
        this.procesCommentElement.setPathToNextSymbol(this.layout.getCommentPathFromRelative(this.procesComment, this.pairedSymbol));
        if (toRightSite != this.procesComment.istoRightSite()) {
            this.setCursorRelCoords(mouseCoords.getX(), mouseCoords.getY());
        }
    }

    protected boolean isCommentPathConnectorDeletable() {
        return this.procesCommentsPointIndex >= 0;
    }

    protected void deleteCommentPathConnector() {
        this.procesComment.getRelativeMiddlePointsToSymbol().remove(this.procesCommentsPointIndex);
        this.procesCommentElement.setPathToNextSymbol(this.layout.getCommentPathFromRelative(this.procesComment, this.pairedSymbol));
        this.commentPathConnector = null;
        this.resetVariables();
    }

    protected boolean isCommentPathConnectorVisible() {
        return this.commentPathConnector != null;
    }

    protected boolean isCommentElementBeingProcessed() {
        return this.procesCommentElement != null;
    }

    protected Ellipse2D getCommentPathConnector() {
        return this.commentPathConnector;
    }

    private boolean shouldBeBold(Comment comment, Point2D p1, Point2D p2, Point2D p3) {
        return Line2D.ptSegDist(p1.getX(), p1.getY(), p2.getX(), p2.getY(), p3.getX(), p3.getY()) <= 3.0 && !comment.contains(p3) && (!comment.hasPairSymbol() || !this.layout.findMyPairedSymbol(comment).contains(p3));
    }

    private void setCommentPathConnector(double centerPointX, double centerPointY) {
        double width = 8.0;
        this.commentPathConnector = new Ellipse2D.Double(centerPointX - width / 2.0, centerPointY - width / 2.0, width, width);
    }

    private void setCursorRelCoords(double mouseX, double mouseY) {
        this.cursorRelX = mouseX - this.procesCommentElement.getSymbol().getCenterX();
        this.cursorRelY = mouseY - this.procesCommentElement.getSymbol().getCenterY();
    }

    protected boolean isAbleToDrag() {
        return this.isCommentElementBeingProcessed() || this.layout.getBoldPathComment() != null || this.isCommentPathConnectorVisible();
    }

    protected void performDrag(Point2D p) {
        if (this.layout.getBoldPathComment() != null) {
            this.commentAction = "Vytvo\u0159en\u00ed bodu koment\u00e1\u0159e";
            this.dragging = true;
            this.setCommentPathConnectorFromDraggedMouse(p);
        }
        if (this.isCommentPathConnectorVisible()) {
            if (!this.dragging) {
                this.commentAction = "P\u0159esunut\u00ed bodu koment\u00e1\u0159e";
                this.dragging = true;
            }
            this.dragCommentPathConnector(p);
        } else if (this.isCommentElementBeingProcessed()) {
            if (!this.dragging) {
                this.commentAction = "P\u0159esunut\u00ed koment\u00e1\u0159e";
                this.dragging = true;
            }
            this.dragCommentElement(p);
        }
    }

    protected boolean isCommentOrJointBeingDragged() {
        return this.dragging;
    }

    public String getCommentAction() {
        return this.commentAction;
    }

    public void paint(Graphics2D grphcs2D) {
        if (this.commentPathConnector != null) {
            float[] dash = new float[]{4.0f, 4.0f};
            grphcs2D.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f));
            grphcs2D.setColor(new Color(230, 230, 230));
            grphcs2D.fill(this.commentPathConnector);
            grphcs2D.setColor(Color.BLACK);
            grphcs2D.draw(this.commentPathConnector);
        }
    }
}

