/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui.managers;

import cz.miroslavbartyzal.psdiagram.app.debug.DebugAnimator;
import cz.miroslavbartyzal.psdiagram.app.debug.function.FunctionManager;
import cz.miroslavbartyzal.psdiagram.app.debug.function.variables.VariableModel;
import cz.miroslavbartyzal.psdiagram.app.flowchart.Flowchart;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.Layout;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutSegment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Comment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import cz.miroslavbartyzal.psdiagram.app.gui.MainWindow;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;

public final class FlowchartDebugManager
implements KeyListener,
ActionListener,
MouseMotionListener,
MouseListener {
    private final MainWindow mainWindow;
    private final JSlider jSliderSpeed;
    private final JButton jButtonToolPlayPause;
    private final JButton jButtonToolPrevious;
    private final JButton jButtonToolNext;
    private final JButton jButtonToolStop;
    private final JButton jButtonLaunch;
    private final JPopupMenu breakpointPopup;
    private final Layout layout;
    private final DebugAnimator animator;
    private final VariableModel variableModel;
    private final JPanel jPanelDiagram;
    private Symbol breakpointSymbol = null;
    private FunctionManager functionManager;
    private boolean easterEgg = false;
    private Point2D easterPoint;

    public FlowchartDebugManager(MainWindow mainWindow, VariableModel variableModel, JPanel jPanelDiagram, JSlider jSliderSpeed, JButton jButtonToolPlayPause, JButton jButtonToolPrevious, JButton jButtonToolNext, JButton jButtonToolStop, JButton jButtonLaunch) {
        this.mainWindow = mainWindow;
        this.variableModel = variableModel;
        this.jPanelDiagram = jPanelDiagram;
        this.jSliderSpeed = jSliderSpeed;
        this.jButtonToolPlayPause = jButtonToolPlayPause;
        this.jButtonToolPrevious = jButtonToolPrevious;
        this.jButtonToolNext = jButtonToolNext;
        this.jButtonToolStop = jButtonToolStop;
        this.jButtonLaunch = jButtonLaunch;
        this.layout = mainWindow.getFlowchartLayout();
        this.functionManager = new FunctionManager(this.layout, jPanelDiagram, jSliderSpeed, this);
        this.animator = this.functionManager.getAnimator();
        this.breakpointPopup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Vlo\u017eit/Smazat breakpoint         Poklep\u00e1n\u00ed", new ImageIcon(this.getClass().getResource("/img/menuitems/16-Breakpoint.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FlowchartDebugManager.this.functionManager.toggleBreakpoint(FlowchartDebugManager.this.breakpointSymbol);
                FlowchartDebugManager.this.breakpointSymbol = null;
            }
        });
        this.breakpointPopup.add(menuItem);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String[] action = ae.getActionCommand().split("/");
        block4 : switch (action[0]) {
            case "mode": {
                if (!action[1].equals("animationMode")) break;
                if (!this.mainWindow.getAnimationMode()) {
                    for (LayoutSegment segment : this.layout.getFlowchart()) {
                        if (segment == null) continue;
                        for (LayoutElement element : segment) {
                            if (element == null || element.getSymbol() == null) continue;
                            element.getSymbol().resetFontStyle(1);
                        }
                    }
                    this.variableModel.clearVariables();
                    this.functionManager.entryAnimMode();
                } else {
                    for (LayoutSegment segment : this.layout.getFlowchart()) {
                        if (segment == null) continue;
                        for (LayoutElement element : segment) {
                            if (element == null || element.getSymbol() == null) continue;
                            element.getSymbol().resetFontStyle(0);
                        }
                    }
                    this.functionManager.exitAnimMode();
                    this.exitAnimMode();
                }
                this.mainWindow.setAnimationMode(!this.mainWindow.getAnimationMode());
                break;
            }
            case "animation": {
                switch (action[1]) {
                    case "play": {
                        this.functionManager.play();
                        this.play();
                        break block4;
                    }
                    case "pause": {
                        this.pause();
                        this.jButtonToolPrevious.setEnabled(this.functionManager.pause());
                        break block4;
                    }
                    case "previous": {
                        this.jButtonToolPrevious.setEnabled(this.functionManager.previous());
                        this.setForwardEnabled(true);
                        break block4;
                    }
                    case "next": {
                        if (!this.jButtonToolPlayPause.getActionCommand().equals("animation/pause")) {
                            this.jButtonToolPrevious.setEnabled(this.functionManager.next().stepBacksNotEmpty);
                            break block4;
                        }
                        this.functionManager.next();
                        break block4;
                    }
                    case "stop": {
                        this.functionManager.stop();
                        this.variableModel.clearVariables();
                        this.stop();
                        break block4;
                    }
                    case "launch": {
                        this.launch();
                        this.functionManager.launch();
                    }
                }
            }
        }
    }

    public void paintFlowchart(Graphics2D g2d) {
        this.animator.paintFlowchart(g2d);
    }

    public void animationDone(boolean prevButtonEnabled) {
        this.jSliderSpeed.setEnabled(true);
        this.setPlayPauseButton(true);
        this.setForwardEnabled(false);
        this.jButtonToolPrevious.setEnabled(prevButtonEnabled);
        this.jButtonToolStop.setEnabled(true);
    }

    public HashMap<String, String> getLastUpdateVars() {
        return this.variableModel.getLastUpdateVars();
    }

    public HashMap<String, String> updateVariables(HashMap<String, String> updatedVariables) {
        HashMap<String, String> updatedVarsWithoutAdditionalInfo = this.removeAdditionalInfoFromVariables(updatedVariables);
        return this.variableModel.updateVariables(updatedVarsWithoutAdditionalInfo);
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        Symbol symbol;
        if (me.getClickCount() % 2 == 0 && (symbol = this.getNoCommentSymbolContaining(this.layout.getFlowchart(), this.getTransformedPoint(me.getPoint(), new Point2D.Double()))) != null) {
            this.functionManager.toggleBreakpoint(symbol);
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.maybeShowPopup(me);
        if (!this.easterEgg && !me.isControlDown()) {
            Point2D p = this.getTransformedPoint(me.getPoint(), new Point2D.Double());
            if (!this.animator.isPlaying() && this.animator.ballContains(p.getX(), p.getY())) {
                this.easterEgg = true;
                this.easterPoint = this.animator.getBallCoordenates();
                this.jPanelDiagram.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(new BufferedImage(3, 3, 2), new Point(0, 0), "null"));
                MainWindow.setStatusText("Easter-egg! :)", 2000);
            } else {
                this.mainWindow.getFlowchartOverlookManager().setStartDragGrab(me);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.maybeShowPopup(me);
        if (this.easterEgg) {
            this.easterEgg = false;
            this.animator.setBallToPos(this.easterPoint.getX(), this.easterPoint.getY());
            this.easterPoint = null;
            this.jPanelDiagram.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (this.easterEgg) {
            Point2D p = this.getTransformedPoint(me.getPoint(), new Point2D.Double());
            this.animator.setBallToPos(p.getX(), p.getY());
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        if (this.easterEgg) {
            this.easterEgg = false;
            this.animator.setBallToPos(this.easterPoint.getX(), this.easterPoint.getY());
            this.easterPoint = null;
            this.jPanelDiagram.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 32 && this.jButtonToolPlayPause.isEnabled()) {
            if (this.jButtonToolPlayPause.getActionCommand().equals("animation/play")) {
                this.actionPerformed(new ActionEvent(this, this.hashCode(), "animation/play"));
            } else {
                this.actionPerformed(new ActionEvent(this, this.hashCode(), "animation/pause"));
            }
        } else if ((ke.getKeyCode() == 37 || ke.getKeyCode() == 38) && ke.isControlDown() && this.jButtonToolPrevious.isEnabled()) {
            this.actionPerformed(new ActionEvent(this, this.hashCode(), "animation/previous"));
        } else if ((ke.getKeyCode() == 39 || ke.getKeyCode() == 40) && ke.isControlDown() && this.jButtonToolNext.isEnabled()) {
            this.actionPerformed(new ActionEvent(this, this.hashCode(), "animation/next"));
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    private HashMap<String, String> removeAdditionalInfoFromVariables(HashMap<String, String> updatedVariables) {
        HashMap<String, String> varsWithoutAdditionalInfo = new HashMap<String, String>(updatedVariables);
        for (String varName : varsWithoutAdditionalInfo.keySet()) {
            String varValue = varsWithoutAdditionalInfo.get(varName);
            if (!varValue.matches("^\\d+\\|.*$")) continue;
            int idx = varValue.indexOf(124);
            varsWithoutAdditionalInfo.put(varName, varValue.substring(idx + 1));
        }
        return varsWithoutAdditionalInfo;
    }

    private Symbol getNoCommentSymbolContaining(Flowchart<LayoutSegment, LayoutElement> flowchart, Point2D p) {
        for (LayoutSegment segment : flowchart) {
            if (segment == null) continue;
            for (LayoutElement element : segment) {
                Symbol symbol = element.getSymbol();
                if (symbol instanceof Comment || !symbol.contains(p)) continue;
                return symbol;
            }
        }
        return null;
    }

    private boolean maybeShowPopup(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.breakpointSymbol = this.getNoCommentSymbolContaining(this.layout.getFlowchart(), this.getTransformedPoint(me.getPoint(), new Point2D.Double()));
            if (this.breakpointPopup != null && this.breakpointSymbol != null) {
                this.breakpointPopup.show(me.getComponent(), me.getX(), me.getY());
            }
            return true;
        }
        return false;
    }

    private void exitAnimMode() {
        this.setPlayPauseButton(true);
    }

    private void play() {
        this.setPlayPauseButton(false);
        this.jButtonToolPrevious.setEnabled(false);
        this.jButtonLaunch.setEnabled(false);
    }

    private void pause() {
        this.jSliderSpeed.setEnabled(true);
        this.setPlayPauseButton(true);
        this.setForwardEnabled(true);
    }

    private void stop() {
        this.jSliderSpeed.setEnabled(true);
        this.setPlayPauseButton(true);
        this.setForwardEnabled(true);
        this.jButtonToolPrevious.setEnabled(false);
        this.jButtonToolStop.setEnabled(true);
    }

    private void launch() {
        this.jSliderSpeed.setEnabled(false);
        this.setForwardEnabled(false);
        this.setPlayPauseButton(false);
        this.jButtonToolPlayPause.setEnabled(true);
        this.jButtonToolStop.setEnabled(true);
        this.jButtonToolPrevious.setEnabled(false);
    }

    private void setPlayPauseButton(boolean play) {
        if (play) {
            this.jButtonToolPlayPause.setIcon(new ImageIcon(this.getClass().getResource("/img/toolBar/24-Play.png")));
            this.jButtonToolPlayPause.setToolTipText("<html>Spustit animaci<br />(mezern\u00edk)</html>");
            this.jButtonToolPlayPause.setActionCommand("animation/play");
        } else {
            this.jButtonToolPlayPause.setIcon(new ImageIcon(this.getClass().getResource("/img/toolBar/24-Pause.png")));
            this.jButtonToolPlayPause.setToolTipText("<html>Pozastavit animaci<br />(mezern\u00edk)</html>");
            this.jButtonToolPlayPause.setActionCommand("animation/pause");
        }
    }

    private void setForwardEnabled(boolean enabled) {
        this.jButtonToolPlayPause.setEnabled(enabled);
        this.jButtonToolNext.setEnabled(enabled);
        this.jButtonLaunch.setEnabled(enabled);
    }

    private Point2D getTransformedPoint(Point2D mousePoint, Point2D destPoint) {
        try {
            this.mainWindow.getAffineTransform().createInverse().transform(mousePoint, destPoint);
        }
        catch (NoninvertibleTransformException e) {
            throw new Error("Error while transforming coordnates!");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return destPoint;
    }
}

