/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui.managers;

import cz.miroslavbartyzal.psdiagram.app.flowchart.Flowchart;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.Layout;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutSegment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Comment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Decision;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.EnumSymbol;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Joint;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.LoopEnd;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.StartEnd;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import cz.miroslavbartyzal.psdiagram.app.global.GlobalFunctions;
import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import cz.miroslavbartyzal.psdiagram.app.gui.MainWindow;
import cz.miroslavbartyzal.psdiagram.app.gui.dialog.MyJOptionPane;
import cz.miroslavbartyzal.psdiagram.app.gui.managers.FlowchartCommentSymbolManager;
import cz.miroslavbartyzal.psdiagram.app.gui.managers.FlowchartEditUndoManager;
import cz.miroslavbartyzal.psdiagram.app.gui.managers.FlowchartSymbolDragManager;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.AbstractSymbolFunctionForm;
import jakarta.xml.bind.JAXBException;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public final class FlowchartEditManager
implements ActionListener,
MouseListener,
MouseMotionListener,
DocumentListener,
KeyListener,
FocusListener {
    private final Layout layout;
    private final MainWindow mainWindow;
    private JPopupMenu symbolPopup;
    private JMenuItem jSymbolPopupDelete;
    private JMenuItem jSymbolPopupCut;
    private JMenuItem jSymbolPopupCopy;
    private JMenuItem jSymbolPopupPaste;
    private final JCheckBox jCheckBoxDefaultText;
    private final JComboBox<String> jComboBoxSegment;
    private final JTextField jTextFieldTextSegment;
    private final JTextArea jTextAreaTextSymbol;
    private final FlowchartEditUndoManager flowchartEditUndoManager;
    private final FlowchartCommentSymbolManager commentsManager;
    private final FlowchartSymbolDragManager symbolDragManager;
    private LinkedHashMap<ByteArrayOutputStream, Boolean> elementsToPaste;
    private LayoutElement lastMarkedElement = null;
    private boolean puttingText = false;
    private boolean segmentTextBuffered = false;
    private boolean symbolTextBuffered = false;
    private boolean defaultTextBeingEdited = false;

    public FlowchartEditManager(Layout layout, MainWindow mainWindow, JPanel canvasPanel, FlowchartEditUndoManager flowchartEditUndoManager, JCheckBox jCheckBoxDefaultText, JComboBox<String> jComboBoxSegment, JTextField jTextFieldTextSegment, JTextArea jTextAreaTextSymbol) {
        this.layout = layout;
        this.mainWindow = mainWindow;
        this.flowchartEditUndoManager = flowchartEditUndoManager;
        this.jCheckBoxDefaultText = jCheckBoxDefaultText;
        this.jComboBoxSegment = jComboBoxSegment;
        this.jTextFieldTextSegment = jTextFieldTextSegment;
        this.jTextAreaTextSymbol = jTextAreaTextSymbol;
        this.commentsManager = new FlowchartCommentSymbolManager(layout);
        this.symbolDragManager = new FlowchartSymbolDragManager(layout, canvasPanel);
        this.loadMarkedSymbol(false);
        flowchartEditUndoManager.init(layout);
    }

    public void resetUndoManager() {
        this.flowchartEditUndoManager.discardAllEdits();
        this.flowchartEditUndoManager.init(this.layout);
    }

    public void undo() {
        this.doPendingUndoRedos(true);
        this.flowchartEditUndoManager.undo();
    }

    public void redo() {
        this.doPendingUndoRedos(true);
        this.flowchartEditUndoManager.redo();
    }

    public void resetVariables() {
        this.resetVariables(true);
    }

    private void resetVariables(boolean resetCommentsManager) {
        if (resetCommentsManager) {
            this.commentsManager.resetVariables();
        }
        this.defaultTextBeingEdited = false;
    }

    public void paint(Graphics2D grphcs2D) {
        this.commentsManager.paint(grphcs2D);
        this.symbolDragManager.paint(grphcs2D);
    }

    public void repaintJPanelDiagram() {
        this.mainWindow.repaintJPanelDiagram();
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void loadMarkedSymbolText() {
        this.puttingText = true;
        this.loadMarkedSymbol(false);
        this.puttingText = false;
    }

    public void setSymbolPopup(JPopupMenu symbolPopup) {
        this.symbolPopup = symbolPopup;
        for (MenuElement menuElement : symbolPopup.getSubElements()) {
            if (!(menuElement instanceof JMenuItem)) continue;
            JMenuItem jMenuItem = (JMenuItem)menuElement;
            switch (jMenuItem.getActionCommand()) {
                case "edit/delete": {
                    this.jSymbolPopupDelete = jMenuItem;
                    break;
                }
                case "edit/cut": {
                    this.jSymbolPopupCut = jMenuItem;
                    break;
                }
                case "edit/copy": {
                    this.jSymbolPopupCopy = jMenuItem;
                    break;
                }
                case "edit/paste": {
                    this.jSymbolPopupPaste = jMenuItem;
                    break;
                }
                default: {
                    this.symbolPopup.remove(jMenuItem);
                }
            }
            jMenuItem.setActionCommand(jMenuItem.getActionCommand() + "/popup");
        }
        for (Component c : this.symbolPopup.getComponents()) {
            if (!(c instanceof JSeparator)) break;
            this.symbolPopup.remove(c);
        }
        Component[] cps = this.symbolPopup.getComponents();
        for (int i = cps.length - 1; i > 0 && cps[i] instanceof JSeparator; --i) {
            this.symbolPopup.remove(cps[i]);
        }
        this.symbolPopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                FlowchartEditManager.this.updateEditMenuEnablers();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    private void doPendingUndoRedos(boolean resetCommentsManager) {
        if (this.segmentTextBuffered) {
            this.segmentTextBuffered = false;
            this.flowchartEditUndoManager.addEdit(this.layout, this, "Editace textu v\u011btve symbolu");
        } else if (this.symbolTextBuffered) {
            this.symbolTextBuffered = false;
            this.flowchartEditUndoManager.addEdit(this.layout, this, "Editace textu symbolu");
        }
        if (this.commentsManager.isCommentOrJointBeingDragged() || this.symbolDragManager.isAbleToDrag() || this.symbolDragManager.isCreatingSymbol()) {
            if (this.commentsManager.isCommentOrJointBeingDragged()) {
                this.layout.prepareFlowchart();
                this.flowchartEditUndoManager.addEdit(this.layout, this, this.commentsManager.getCommentAction());
            } else if (this.symbolDragManager.isAbleToDrag()) {
                if (this.symbolDragManager.mouseReleased()) {
                    this.flowchartEditUndoManager.addEdit(this.layout, this, this.symbolDragManager.getDragAction());
                    this.puttingText = true;
                    this.loadMarkedSymbol(false);
                    this.puttingText = false;
                }
            } else if (this.symbolDragManager.isCreatingSymbol()) {
                this.symbolDragManager.cancelCreationProcess();
            }
            this.repaintJPanelDiagram();
        }
        this.resetVariables(resetCommentsManager);
    }

    public void cancelDragCreationProcess() {
        if (this.symbolDragManager.isCreatingSymbol()) {
            this.symbolDragManager.cancelCreationProcess();
            this.repaintJPanelDiagram();
        }
    }

    public void refreshSymbolTextsDueToChangeOfFunctionFiltersState() {
        for (LayoutSegment segment : this.layout.getFlowchart()) {
            if (segment == null) continue;
            for (LayoutElement element : segment) {
                boolean setDefaults = this.defaultsEqualsValues(element);
                EnumSymbol.getEnumSymbol(element.getSymbol().getClass()).regenerateSymbolValues(element);
                if (setDefaults) {
                    element.getSymbol().setValueAndSize(element.getSymbol().getDefaultValue());
                    continue;
                }
                if (!this.jCheckBoxDefaultText.isVisible() || this.jCheckBoxDefaultText.isSelected() || !this.defaultsEqualsValues(element)) continue;
                this.jCheckBoxDefaultText.removeActionListener(this);
                this.jCheckBoxDefaultText.setSelected(true);
                this.jCheckBoxDefaultText.addActionListener(this);
            }
        }
        this.puttingText = true;
        this.loadMarkedSymbol(true);
        this.puttingText = false;
        this.repaintJPanelDiagram();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void actionPerformed(final ActionEvent ae) {
        action = ae.getActionCommand().split("/");
        resetCommentsManager = action.length != 3 || this.commentsManager.isCommentPathConnectorVisible() == false || action[0].equals("edit") == false || action[1].equals("delete") == false || action[2].equals("popup") == false;
        this.doPendingUndoRedos(resetCommentsManager);
        var4_4 = action[0];
        var5_5 = -1;
        switch (var4_4.hashCode()) {
            case 0x3339A3: {
                if (!var4_4.equals("mode")) break;
                var5_5 = 0;
                break;
            }
            case 5315993: {
                if (!var4_4.equals("addSymbol")) break;
                var5_5 = 1;
                break;
            }
            case 3108362: {
                if (!var4_4.equals("edit")) break;
                var5_5 = 2;
            }
        }
        switch (var5_5) {
            case 0: {
                if (!action[1].equals("editMode")) break;
                if (!this.mainWindow.getEditMode()) {
                    this.lastMarkedElement = null;
                    this.loadMarkedSymbol(false);
                }
                this.mainWindow.setEditMode(this.mainWindow.getEditMode() == false);
                this.repaintJPanelDiagram();
                break;
            }
            case 1: {
                var6_6 = action[1];
                var7_8 = -1;
                switch (var6_6.hashCode()) {
                    case 1668381247: {
                        if (!var6_6.equals("COMMENT")) break;
                        var7_8 = 0;
                        break;
                    }
                    case 719169458: {
                        if (!var6_6.equals("LOOPCONDITIONUP")) break;
                        var7_8 = 1;
                        break;
                    }
                    case -368390151: {
                        if (!var6_6.equals("LOOPCONDITIONDOWN")) break;
                        var7_8 = 2;
                        break;
                    }
                    case 2099429689: {
                        if (!var6_6.equals("STARTEND")) break;
                        var7_8 = 3;
                    }
                }
                switch (var7_8) {
                    case 0: {
                        symbol = EnumSymbol.valueOf(action[1]).getInstance("");
                        if (this.layout.getFocusedElement() != null) {
                            symbol.setHasPairSymbol(true);
                        }
                        this.layout.addNewSymbol(symbol);
                        break;
                    }
                    case 1: {
                        if (action.length == 3 && action[2].equals("byDnD")) {
                            this.symbolDragManager.createSymbol(EnumSymbol.valueOf(action[1]).getInstance(""), new FlowchartSymbolDragManager.ValidSymbolJointDropListener(){

                                @Override
                                public void validDropPerformed() {
                                    FlowchartEditManager.this.actionPerformed(new ActionEvent(ae.getSource(), ae.getID(), ae.getActionCommand().substring(0, ae.getActionCommand().lastIndexOf("/"))));
                                }
                            });
                            return;
                        }
                    }
                    case 2: {
                        if (action.length == 3 && action[2].equals("byDnD")) {
                            this.symbolDragManager.createSymbol(new LoopEnd(), new FlowchartSymbolDragManager.ValidSymbolJointDropListener(){

                                @Override
                                public void validDropPerformed() {
                                    FlowchartEditManager.this.actionPerformed(new ActionEvent(ae.getSource(), ae.getID(), ae.getActionCommand().substring(0, ae.getActionCommand().lastIndexOf("/"))));
                                }
                            });
                            return;
                        }
                        this.layout.addNewSymbol(new LoopEnd());
                        this.layout.addNewSymbol(EnumSymbol.valueOf(action[1]).getInstance(""));
                        break;
                    }
                    case 3: {
                        symbol = EnumSymbol.valueOf(action[1]).getInstance("Konec");
                        if (action.length == 3 && action[2].equals("byDnD")) {
                            this.symbolDragManager.createSymbol(symbol, new FlowchartSymbolDragManager.ValidSymbolJointDropListener(){

                                @Override
                                public void validDropPerformed() {
                                    FlowchartEditManager.this.actionPerformed(new ActionEvent(ae.getSource(), ae.getID(), ae.getActionCommand().substring(0, ae.getActionCommand().lastIndexOf("/"))));
                                }
                            });
                            return;
                        }
                        this.layout.addNewSymbol(symbol);
                        break;
                    }
                    default: {
                        symbol = EnumSymbol.valueOf(action[1]).getInstance("");
                        if (action.length == 3 && action[2].equals("byDnD")) {
                            this.symbolDragManager.createSymbol(symbol, new FlowchartSymbolDragManager.ValidSymbolJointDropListener(){

                                @Override
                                public void validDropPerformed() {
                                    FlowchartEditManager.this.actionPerformed(new ActionEvent(ae.getSource(), ae.getID(), ae.getActionCommand().substring(0, ae.getActionCommand().lastIndexOf("/"))));
                                }
                            });
                            return;
                        }
                        innerOutCount = 0;
                        if (symbol.getInnerOutsCount() != -1) ** GOTO lbl100
                        max = 50;
                        min = 0;
                        def = min + 1;
                        if (symbol.hasElseSegment()) {
                            ++def;
                        }
                        defaultString = String.valueOf(def);
                        do {
                            str = this.askForNumber(min, max, defaultString);
                            try {
                                innerOutCount = Integer.parseInt(str);
                            }
                            catch (NumberFormatException e) {
                                if (str != null) ** GOTO lbl96
                                return;
                            }
lbl96:
                            // 2 sources

                            defaultString = str;
                        } while (innerOutCount < min || innerOutCount > max);
                        if (symbol.hasElseSegment()) {
                            ++innerOutCount;
                        }
lbl100:
                        // 4 sources

                        this.layout.addNewSymbol(symbol, innerOutCount);
                    }
                }
                this.repaintJPanelDiagram();
                this.puttingText = true;
                this.loadMarkedSymbol(false);
                this.puttingText = false;
                this.flowchartEditUndoManager.addEdit(this.layout, this, "P\u0159id\u00e1n\u00ed symbolu");
                break;
            }
            case 2: {
                var6_7 = action[1];
                var7_9 = -1;
                switch (var6_7.hashCode()) {
                    case -1335458389: {
                        if (!var6_7.equals("delete")) break;
                        var7_9 = 0;
                        break;
                    }
                    case 98882: {
                        if (!var6_7.equals("cut")) break;
                        var7_9 = 1;
                        break;
                    }
                    case 3059573: {
                        if (!var6_7.equals("copy")) break;
                        var7_9 = 2;
                        break;
                    }
                    case 106438291: {
                        if (!var6_7.equals("paste")) break;
                        var7_9 = 3;
                        break;
                    }
                    case -952924416: {
                        if (!var6_7.equals("segmentText")) break;
                        var7_9 = 4;
                        break;
                    }
                    case -436959474: {
                        if (!var6_7.equals("defaultText")) break;
                        var7_9 = 5;
                        break;
                    }
                    case -1398200318: {
                        if (!var6_7.equals("defaultsChanged")) break;
                        var7_9 = 6;
                    }
                }
                switch (var7_9) {
                    case 0: {
                        if (this.commentsManager.isCommentPathConnectorVisible()) {
                            if (!this.commentsManager.isCommentPathConnectorDeletable()) break;
                            this.commentsManager.deleteCommentPathConnector();
                            this.resetVariables();
                            this.layout.prepareFlowchart();
                            this.repaintJPanelDiagram();
                            this.flowchartEditUndoManager.addEdit(this.layout, this, "Smaz\u00e1n\u00ed bodu koment\u00e1\u0159e");
                            break;
                        }
                        this.removeFocusedElement();
                        this.repaintJPanelDiagram();
                        this.flowchartEditUndoManager.addEdit(this.layout, this, "Smaz\u00e1n\u00ed symbolu");
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (this.commentsManager.isCommentPathConnectorVisible() || (focusedElement = this.layout.getFocusedElement()) == null) break;
                        this.elementsToPaste = new LinkedHashMap<K, V>();
                        try {
                            for (LayoutElement element : this.layout.getMeAndMyDependants(focusedElement)) {
                                baos = new ByteArrayOutputStream();
                                MainWindow.marshal((Object)element, baos, false);
                                this.elementsToPaste.put(baos, element.getSymbol().hasPairSymbol() != false && element.getSymbol() instanceof Comment != false);
                            }
                        }
                        catch (JAXBException ex) {
                            MyExceptionHandler.handle(ex);
                            this.elementsToPaste = null;
                            break;
                        }
                        if (!action[1].equals("cut")) break;
                        this.removeFocusedElement();
                        this.repaintJPanelDiagram();
                        this.flowchartEditUndoManager.addEdit(this.layout, this, "Vyjmut\u00ed symbolu");
                        break;
                    }
                    case 3: {
                        if (this.commentsManager.isCommentPathConnectorVisible() || this.elementsToPaste == null) break;
                        elementsToAdd = new ArrayList<LayoutElement>();
                        try {
                            for (ByteArrayOutputStream baos : this.elementsToPaste.keySet()) {
                                newElement = (LayoutElement)GlobalFunctions.unsafeCast(MainWindow.unmarshal(new ByteArrayInputStream(baos.toByteArray())));
                                elementsToAdd.add(newElement);
                            }
                        }
                        catch (JAXBException ex) {
                            MyExceptionHandler.handle(ex);
                            break;
                        }
                        this.layout.addElements(elementsToAdd);
                        this.repaintJPanelDiagram();
                        this.flowchartEditUndoManager.addEdit(this.layout, this, "Vlo\u017een\u00ed symbolu");
                        break;
                    }
                    case 4: {
                        this.puttingText = true;
                        this.jTextFieldTextSegment.setText(((LayoutSegment)this.getMarkedElement().getInnerSegment(this.jComboBoxSegment.getSelectedIndex())).getDescription());
                        this.puttingText = false;
                        return;
                    }
                    case 5: {
                        if (this.jCheckBoxDefaultText.isSelected()) {
                            this.loadDefaults(this.getMarkedElement());
                        } else {
                            this.defaultTextBeingEdited = true;
                            this.loadCustom(this.getMarkedElement());
                        }
                        this.layout.prepareFlowchart();
                        this.repaintJPanelDiagram();
                        this.flowchartEditUndoManager.addEdit(this.layout, this, "V\u00fdchoz\u00ed text symbolu");
                        break;
                    }
                    case 6: {
                        this.defaultTextBeingEdited = true;
                        element = this.getMarkedElement();
                        if (this.defaultsEqualsValues(element) || (!this.jCheckBoxDefaultText.isVisible() || !this.jCheckBoxDefaultText.isSelected()) && (this.jCheckBoxDefaultText.isVisible() || this.jCheckBoxDefaultText.isSelected() || this.consistsCustomValues(element))) break;
                        this.loadDefaults(element);
                        this.layout.prepareFlowchart();
                        this.repaintJPanelDiagram();
                        this.flowchartEditUndoManager.addEdit(this.layout, this, "Funkce symbolu");
                        break;
                    }
                }
                this.puttingText = true;
                this.loadMarkedSymbol(false);
                this.puttingText = false;
            }
        }
        if (action.length < 2 || !action[1].equals("defaultsChanged")) {
            this.mainWindow.setJPanelDiagramFocus();
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        Point2D p = this.getTransformedPoint(me.getPoint(), new Point2D.Double());
        this.doPendingUndoRedos(true);
        if (this.commentsManager.wasMousePressedEventRelevantForConnector(p)) {
            this.maybeShowPopup(me);
            return;
        }
        Joint joint = this.getJointContaining(p);
        if (joint != null) {
            this.layout.setFocusedJoint(joint);
            this.puttingText = true;
            this.loadMarkedSymbol(false);
            this.puttingText = false;
            this.repaintJPanelDiagram();
            this.maybeShowPopup(me);
            return;
        }
        LayoutElement element = this.getElementContaining(this.layout.getFlowchart(), p);
        if (element != null) {
            this.layout.setFocusedElement(element);
            this.puttingText = true;
            this.loadMarkedSymbol(false);
            this.puttingText = false;
            this.repaintJPanelDiagram();
            if (element.getSymbol() instanceof Comment) {
                this.commentsManager.mousePressedOnComment(element, p);
            } else {
                this.updateEditMenuEnablers();
                if (this.jSymbolPopupCut.isEnabled()) {
                    this.symbolDragManager.mousePressedOnSymbol(element, p);
                }
            }
            this.maybeShowPopup(me);
            return;
        }
        if (this.layout.getBoldPathComment() == null) {
            this.mainWindow.getFlowchartOverlookManager().setStartDragGrab(me);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (this.symbolDragManager.isCreatingSymbol() && !this.symbolDragManager.mouseReleased()) {
            this.repaintJPanelDiagram();
        }
        if (this.commentsManager.isCommentOrJointBeingDragged()) {
            this.layout.prepareFlowchart();
        } else if (this.symbolDragManager.isAbleToDrag()) {
            if (this.symbolDragManager.mouseReleased()) {
                this.flowchartEditUndoManager.addEdit(this.layout, this, this.symbolDragManager.getDragAction());
                this.puttingText = true;
                this.loadMarkedSymbol(false);
                this.puttingText = false;
            }
            this.repaintJPanelDiagram();
        }
        Point2D p = this.getTransformedPoint(me.getPoint(), new Point2D.Double());
        if (this.commentsManager.isCommentOrJointBeingDragged()) {
            if (!this.symbolPopup.isVisible()) {
                this.commentsManager.analyzeMouseToCommentPathAndConnector(p);
            }
            this.repaintJPanelDiagram();
            this.flowchartEditUndoManager.addEdit(this.layout, this, this.commentsManager.getCommentAction());
        }
        if (this.commentsManager.isCommentPathConnectorVisible()) {
            if (this.commentsManager.wereMouseReleasedCoordsInsideConnector(p) && this.maybeShowPopup(me)) {
                return;
            }
        } else if (this.layout.getFocusedElement() != null && this.layout.getFocusedElement().getSymbol().contains(p) || this.layout.getFocusedJoint() != null && this.layout.getFocusedJoint().contains(p)) {
            this.maybeShowPopup(me);
        }
        this.resetVariables();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        Point2D p = this.getTransformedPoint(me.getPoint(), new Point2D.Double());
        if (this.commentsManager.isAbleToDrag()) {
            this.commentsManager.performDrag(p);
            this.repaintJPanelDiagram();
        } else if (this.symbolDragManager.isCreatingSymbol()) {
            this.symbolDragManager.performSymbolCreationDrag(p);
            this.repaintJPanelDiagram();
        } else if (this.symbolDragManager.isAbleToDrag()) {
            this.symbolDragManager.performDrag(p, me.isControlDown());
            this.repaintJPanelDiagram();
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        Point2D p = this.getTransformedPoint(me.getPoint(), new Point2D.Double());
        if (!this.symbolPopup.isVisible()) {
            this.commentsManager.analyzeMouseToCommentPathAndConnector(p);
        }
        this.repaintJPanelDiagram();
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        if (this.puttingText) {
            return;
        }
        try {
            if (de.getDocument().equals(this.jTextFieldTextSegment.getDocument())) {
                this.setSegmentDescription((LayoutSegment)this.getMarkedElement().getInnerSegment(this.jComboBoxSegment.getSelectedIndex()), de.getDocument().getText(0, de.getDocument().getLength()));
            } else {
                this.setSymbolText(this.getMarkedElement(), de.getDocument().getText(0, de.getDocument().getLength()));
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        if (this.puttingText) {
            return;
        }
        try {
            if (de.getDocument().equals(this.jTextFieldTextSegment.getDocument())) {
                this.setSegmentDescription((LayoutSegment)this.getMarkedElement().getInnerSegment(this.jComboBoxSegment.getSelectedIndex()), de.getDocument().getText(0, de.getDocument().getLength()));
            } else {
                this.setSymbolText(this.getMarkedElement(), de.getDocument().getText(0, de.getDocument().getLength()));
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        this.updateEditMenuEnablers();
        if (ke.getKeyCode() == 8) {
            this.dispatchKeyEventToSymbolTextComponent(ke);
        } else if (this.symbolDragManager.isDragging() && ke.getKeyCode() == 17 && this.symbolDragManager.controlKeyUpdate(true)) {
            this.repaintJPanelDiagram();
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if (ke.getKeyCode() == 8) {
            this.dispatchKeyEventToSymbolTextComponent(ke);
        } else if (this.symbolDragManager.isDragging() && ke.getKeyCode() == 17 && this.symbolDragManager.controlKeyUpdate(false)) {
            this.repaintJPanelDiagram();
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        if (!ke.isControlDown() && !ke.isAltDown() && ke.getKeyChar() != '\u007f' && ke.getKeyChar() != '\n') {
            this.dispatchKeyEventToSymbolTextComponent(ke);
        }
    }

    @Override
    public void focusGained(FocusEvent fe) {
    }

    @Override
    public void focusLost(FocusEvent fe) {
        if (fe.getComponent().equals(this.jTextFieldTextSegment)) {
            if (this.segmentTextBuffered) {
                this.segmentTextBuffered = false;
                this.flowchartEditUndoManager.addEdit(this.layout, this, "Editace textu v\u011btve symbolu");
            }
        } else if (this.symbolTextBuffered) {
            this.symbolTextBuffered = false;
            this.flowchartEditUndoManager.addEdit(this.layout, this, "Editace textu symbolu");
        }
    }

    private void dispatchKeyEventToSymbolTextComponent(final KeyEvent ke) {
        boolean focusSuccess;
        JTextComponent textCompToEditIn;
        if (this.mainWindow.getJTabbedPaneEdit().getSelectedIndex() == 0 && this.mainWindow.getJScrollPaneFunctionViewportView() instanceof AbstractSymbolFunctionForm && ((AbstractSymbolFunctionForm)this.mainWindow.getJScrollPaneFunctionViewportView()).hasCommandsToSet()) {
            textCompToEditIn = ((AbstractSymbolFunctionForm)this.mainWindow.getJScrollPaneFunctionViewportView()).getJTextFieldToDispatchKeyEventsAt();
            if (textCompToEditIn == null) {
                return;
            }
            focusSuccess = textCompToEditIn.requestFocusInWindow();
        } else {
            textCompToEditIn = this.jTextAreaTextSymbol;
            focusSuccess = textCompToEditIn.requestFocusInWindow();
            if (!focusSuccess && this.mainWindow.getJTabbedPaneEdit().getSelectedIndex() == 1) {
                return;
            }
        }
        textCompToEditIn.setCaretPosition(textCompToEditIn.getDocument().getLength());
        if (focusSuccess) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    textCompToEditIn.dispatchEvent(ke);
                }
            });
        } else {
            textCompToEditIn.dispatchEvent(ke);
        }
    }

    private void loadMarkedSymbol(boolean forced) {
        LayoutElement markedElement = this.getMarkedElement();
        if (!markedElement.equals(this.lastMarkedElement)) {
            this.defaultTextBeingEdited = false;
        }
        this.loadMarkedSymbolText(markedElement);
        this.loadMarkedSymbolFunction(markedElement, forced);
        this.lastMarkedElement = markedElement;
    }

    private LayoutElement getMarkedElement() {
        LayoutElement element = this.layout.getFocusedElement();
        if (element == null) {
            element = this.layout.getFocusedJoint().getParentElement();
        }
        return element;
    }

    private void loadDefaults(LayoutElement element) {
        element.getSymbol().setValueAndSize(element.getSymbol().getDefaultValue());
        if (element.getSymbol().getInnerOutsCount() == -1) {
            for (int i = element.getSymbol().getDefaultSegmentDescriptions().length; i < element.getInnerSegments().size(); ++i) {
                ((LayoutSegment)element.getInnerSegment(i)).setDescription(((LayoutSegment)element.getInnerSegment(i)).getDefaultDescription());
            }
        }
    }

    private void loadCustom(LayoutElement element) {
        element.getSymbol().setValueAndSize(element.getSymbol().getCustomValue());
        if (element.getSymbol().getInnerOutsCount() == -1) {
            for (int i = element.getSymbol().getDefaultSegmentDescriptions().length; i < element.getInnerSegments().size(); ++i) {
                ((LayoutSegment)element.getInnerSegment(i)).setDescription(((LayoutSegment)element.getInnerSegment(i)).getCustomDescription());
            }
        }
    }

    private void loadMarkedSymbolText(LayoutElement markedElement) {
        this.jTextAreaTextSymbol.setText(markedElement.getSymbol().getValue());
        if (markedElement.getSymbol() instanceof Decision) {
            if (this.lastMarkedElement == null || !this.lastMarkedElement.equals(markedElement)) {
                this.mainWindow.setJPanelTextSegmentVisible(true);
                this.jComboBoxSegment.removeActionListener(this);
                this.jComboBoxSegment.removeAllItems();
                for (int i = 0; i < markedElement.getInnerSegmentsCount(); ++i) {
                    if (i == 0) {
                        this.jComboBoxSegment.addItem(i + ". - Else v\u011btev");
                        continue;
                    }
                    this.jComboBoxSegment.addItem(i + ".");
                }
                this.jComboBoxSegment.setSelectedIndex(0);
                this.jComboBoxSegment.addActionListener(this);
                this.jTextFieldTextSegment.setText(((LayoutSegment)markedElement.getInnerSegment(0)).getDescription());
            }
        } else {
            this.jComboBoxSegment.removeActionListener(this);
            this.mainWindow.setJPanelTextSegmentVisible(false);
        }
        if (this.consistsDefaultValues(markedElement) || this.consistsCustomValues(markedElement) && this.defaultsEqualsValues(markedElement)) {
            if (this.jCheckBoxDefaultText.isVisible()) {
                this.jCheckBoxDefaultText.removeActionListener(this);
            }
            if (this.defaultsEqualsValues(markedElement)) {
                this.jCheckBoxDefaultText.setSelected(true);
            } else {
                this.jCheckBoxDefaultText.setSelected(false);
            }
            this.jCheckBoxDefaultText.setVisible(true);
            this.jCheckBoxDefaultText.addActionListener(this);
        } else if (this.jCheckBoxDefaultText.isVisible() && !this.defaultTextBeingEdited) {
            this.jCheckBoxDefaultText.removeActionListener(this);
            this.jCheckBoxDefaultText.setSelected(false);
            this.jCheckBoxDefaultText.setVisible(false);
        }
        this.mainWindow.packJPanelInnerText();
    }

    private void loadMarkedSymbolFunction(LayoutElement markedElement, boolean forced) {
        if (!forced && this.lastMarkedElement != null && this.lastMarkedElement.equals(markedElement)) {
            return;
        }
        this.mainWindow.setJScrollPaneFunctionViewportView(EnumSymbol.getEnumSymbol(markedElement.getSymbol().getClass()).getFunctionFormInstance(markedElement, this, this.mainWindow.getMaxBalloonSizeCallback()));
    }

    private boolean defaultsEqualsValues(LayoutElement element) {
        if (element.getSymbol().getValue() != null && element.getSymbol().getValue().equals(element.getSymbol().getDefaultValue()) || (element.getSymbol().getValue() == null || element.getSymbol().getValue().isEmpty()) && (element.getSymbol().getDefaultValue() == null || element.getSymbol().getDefaultValue().isEmpty())) {
            if (element.getSymbol().getInnerOutsCount() == -1) {
                for (int i = element.getSymbol().getDefaultSegmentDescriptions().length; i < element.getInnerSegments().size(); ++i) {
                    String desc = ((LayoutSegment)element.getInnerSegment(i)).getDescription();
                    String defDesc = ((LayoutSegment)element.getInnerSegment(i)).getDefaultDescription();
                    if (desc == null && defDesc == null || desc == null && defDesc != null && defDesc.equals("") || defDesc == null && desc != null && desc.equals("") || desc != null && desc.equals(defDesc)) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean consistsDefaultValues(LayoutElement element) {
        if (element.getSymbol().getDefaultValue() != null && !element.getSymbol().getDefaultValue().equals("")) {
            if (element.getSymbol().getInnerOutsCount() == -1) {
                for (int i = element.getSymbol().getDefaultSegmentDescriptions().length; i < element.getInnerSegments().size(); ++i) {
                    if (((LayoutSegment)element.getInnerSegment(i)).getDefaultDescription() != null && !((LayoutSegment)element.getInnerSegment(i)).getDefaultDescription().equals("")) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean consistsCustomValues(LayoutElement element) {
        if (element.getSymbol().getCustomValue() != null && !element.getSymbol().getCustomValue().equals("")) {
            if (element.getSymbol().getInnerOutsCount() == -1) {
                for (int i = element.getSymbol().getDefaultSegmentDescriptions().length; i < element.getInnerSegments().size(); ++i) {
                    if (((LayoutSegment)element.getInnerSegment(i)).getCustomDescription() != null && !((LayoutSegment)element.getInnerSegment(i)).getCustomDescription().equals("")) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private void setSegmentDescription(LayoutSegment segment, String text) {
        if (segment.getDescription() == null || !segment.getDescription().equals(text)) {
            if (!this.segmentTextBuffered) {
                this.segmentTextBuffered = true;
            }
            segment.setDescription(text);
            if (segment.getDefaultDescription() != null) {
                if (!segment.getDefaultDescription().equals(text)) {
                    segment.setCustomDescription(text);
                    if (this.jCheckBoxDefaultText.isVisible() && this.jCheckBoxDefaultText.isSelected()) {
                        this.jCheckBoxDefaultText.removeActionListener(this);
                        this.jCheckBoxDefaultText.setSelected(false);
                        this.jCheckBoxDefaultText.addActionListener(this);
                    }
                } else if (this.jCheckBoxDefaultText.isVisible() && !this.jCheckBoxDefaultText.isSelected() && this.defaultsEqualsValues(this.getMarkedElement())) {
                    this.jCheckBoxDefaultText.removeActionListener(this);
                    this.jCheckBoxDefaultText.setSelected(true);
                    this.jCheckBoxDefaultText.addActionListener(this);
                }
            } else {
                segment.setCustomDescription(text);
            }
            this.layout.prepareFlowchart();
            this.repaintJPanelDiagram();
        }
    }

    private void setSymbolText(LayoutElement element, String text) {
        if (element.getSymbol().getValue() == null || !element.getSymbol().getValue().equals(text)) {
            if (this.jTextAreaTextSymbol.isFocusOwner()) {
                if (!this.symbolTextBuffered) {
                    this.symbolTextBuffered = true;
                }
            } else {
                this.symbolTextBuffered = false;
            }
            double prevSymbolWidth = element.getSymbol().getWidth();
            double prevSymbolHeight = element.getSymbol().getHeight();
            element.getSymbol().setValueAndSize(text);
            if (element.getSymbol().getDefaultValue() != null) {
                if (!element.getSymbol().getDefaultValue().equals(text)) {
                    element.getSymbol().setCustomValue(text);
                    if (this.jCheckBoxDefaultText.isVisible() && this.jCheckBoxDefaultText.isSelected()) {
                        this.jCheckBoxDefaultText.removeActionListener(this);
                        this.jCheckBoxDefaultText.setSelected(false);
                        this.jCheckBoxDefaultText.addActionListener(this);
                    }
                } else if (this.jCheckBoxDefaultText.isVisible() && !this.jCheckBoxDefaultText.isSelected() && this.defaultsEqualsValues(element)) {
                    this.jCheckBoxDefaultText.removeActionListener(this);
                    this.jCheckBoxDefaultText.setSelected(true);
                    this.jCheckBoxDefaultText.addActionListener(this);
                }
            } else {
                element.getSymbol().setCustomValue(text);
            }
            if (element.getSymbol().getWidth() != prevSymbolWidth || element.getSymbol().getHeight() != prevSymbolHeight) {
                this.layout.prepareFlowchart();
            }
            if (!this.symbolTextBuffered) {
                this.flowchartEditUndoManager.addEdit(this.layout, this, "Editace textu symbolu");
            }
            this.repaintJPanelDiagram();
        }
    }

    private void removeFocusedElement() {
        LayoutElement focusedElement = this.layout.getFocusedElement();
        if (focusedElement != null) {
            this.layout.removeElement(focusedElement);
        }
    }

    private Point2D getTransformedPoint(Point2D mousePoint, Point2D destPoint) {
        try {
            this.mainWindow.getAffineTransform().createInverse().transform(mousePoint, destPoint);
        }
        catch (NoninvertibleTransformException e) {
            throw new Error("Error while transforming coordnates!");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return destPoint;
    }

    private String askForNumber(int min, int max, String defaultString) {
        return (String)MyJOptionPane.showInputDialog(this.mainWindow, "Zadej, kolik m\u00e1 tento symbol m\u00edt v\u011btv\u00ed (else v\u011btev se nepo\u010d\u00edt\u00e1):\n(minim\u00e1ln\u011b " + min + ", maxim\u00e1ln\u011b " + max + ")", "Po\u010det v\u011btv\u00ed", 3, null, null, defaultString);
    }

    public void updateUndoRedoEnablers() {
        this.flowchartEditUndoManager.setButtons();
    }

    public void updateEditMenuEnablers() {
        if (!this.mainWindow.getEditMode()) {
            this.setEditMenuEnablers(false);
        } else if (this.commentsManager.isCommentPathConnectorVisible()) {
            this.setEditMenuEnablers(true);
        } else {
            LayoutElement element = this.layout.getFocusedElement();
            if (!(element == null || ((LayoutSegment)element.getParentSegment()).getParentElement() == null && (((LayoutSegment)element.getParentSegment()).indexOfElement(element) + 1 == ((LayoutSegment)element.getParentSegment()).size() || ((LayoutSegment)element.getParentSegment()).indexOfElement(element) == 0 && element.getSymbol() instanceof StartEnd || ((LayoutSegment)element.getParentSegment()).indexOfElement(element) == 1 && ((LayoutElement)((LayoutSegment)element.getParentSegment()).getElement(0)).getSymbol() instanceof Comment))) {
                this.mainWindow.setjMenuItemDeleteEnabled(true);
                this.mainWindow.setjMenuItemCutEnabled(true);
                this.mainWindow.setjMenuItemCopyEnabled(true);
                if (this.jSymbolPopupDelete != null) {
                    this.jSymbolPopupDelete.setEnabled(true);
                }
                if (this.jSymbolPopupCut != null) {
                    this.jSymbolPopupCut.setEnabled(true);
                }
                if (this.jSymbolPopupCopy != null) {
                    this.jSymbolPopupCopy.setEnabled(true);
                }
            } else {
                this.mainWindow.setjMenuItemDeleteEnabled(false);
                this.mainWindow.setjMenuItemCutEnabled(false);
                this.mainWindow.setjMenuItemCopyEnabled(false);
                if (this.jSymbolPopupDelete != null) {
                    this.jSymbolPopupDelete.setEnabled(false);
                }
                if (this.jSymbolPopupCut != null) {
                    this.jSymbolPopupCut.setEnabled(false);
                }
                if (this.jSymbolPopupCopy != null) {
                    this.jSymbolPopupCopy.setEnabled(false);
                }
            }
            this.setPasteEnabled();
        }
    }

    public void revalidateSymbolCommands() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (LayoutSegment segment : FlowchartEditManager.this.layout.getFlowchart()) {
                            if (segment == null) continue;
                            for (LayoutElement element : segment) {
                                Symbol symbol = element.getSymbol();
                                symbol.setCommandsValid(EnumSymbol.getEnumSymbol(symbol.getClass()).areCommandsValid(symbol));
                            }
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                FlowchartEditManager.this.repaintJPanelDiagram();
                            }
                        });
                    }
                }).start();
            }
        });
    }

    private void setEditMenuEnablers(boolean enabled) {
        if (this.jSymbolPopupDelete != null) {
            this.jSymbolPopupDelete.setEnabled(enabled);
        }
        this.mainWindow.setjMenuItemDeleteEnabled(enabled);
        if (enabled) {
            this.setPasteEnabled();
        } else {
            if (this.jSymbolPopupPaste != null) {
                this.jSymbolPopupPaste.setEnabled(false);
            }
            this.mainWindow.setjMenuItemPasteEnabled(false);
        }
        if (this.commentsManager.isCommentPathConnectorVisible()) {
            enabled = false;
        }
        if (this.jSymbolPopupCut != null) {
            this.jSymbolPopupCut.setEnabled(enabled);
        }
        if (this.jSymbolPopupCopy != null) {
            this.jSymbolPopupCopy.setEnabled(enabled);
        }
        this.mainWindow.setjMenuItemCutEnabled(enabled);
        this.mainWindow.setjMenuItemCopyEnabled(enabled);
    }

    private void setPasteEnabled() {
        if (this.elementsToPaste != null && !this.elementsToPaste.isEmpty() && !this.commentsManager.isCommentPathConnectorVisible()) {
            if (this.jSymbolPopupPaste != null) {
                this.jSymbolPopupPaste.setEnabled(true);
            }
            this.mainWindow.setjMenuItemPasteEnabled(true);
        } else {
            if (this.jSymbolPopupPaste != null) {
                this.jSymbolPopupPaste.setEnabled(false);
            }
            this.mainWindow.setjMenuItemPasteEnabled(false);
        }
    }

    private boolean maybeShowPopup(MouseEvent me) {
        if (me.isPopupTrigger()) {
            if (this.symbolPopup != null) {
                this.symbolPopup.show(me.getComponent(), me.getX(), me.getY());
            }
            return true;
        }
        return false;
    }

    private Joint getJointContaining(Point2D p) {
        for (Joint joint : this.layout.getlJoints()) {
            if (!joint.getShape().contains(p)) continue;
            return joint;
        }
        return null;
    }

    private LayoutElement getElementContaining(Flowchart<LayoutSegment, LayoutElement> flowchart, Point2D p) {
        for (LayoutSegment segment : flowchart) {
            if (segment == null) continue;
            for (LayoutElement element : segment) {
                if (!element.getSymbol().contains(p)) continue;
                return element;
            }
        }
        return null;
    }
}

