/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui.managers;

import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.Layout;
import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import cz.miroslavbartyzal.psdiagram.app.gui.MainWindow;
import cz.miroslavbartyzal.psdiagram.app.gui.managers.FlowchartEditManager;
import cz.miroslavbartyzal.psdiagram.app.gui.managers.undoableEdits.UniversalEdit;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public final class FlowchartEditUndoManager
extends UndoManager {
    private final JMenuItem jMenuItemUndo;
    private final JMenuItem jMenuItemRedo;
    private final JButton jButtonToolUndo;
    private final JButton jButtonToolRedo;
    private int[] beforeFocusedPath;
    private boolean beforeIsJoint;
    private ByteArrayOutputStream lastSeenFlowchart;

    public FlowchartEditUndoManager(JMenuItem jMenuItemUndo, JMenuItem jMenuItemRedo, JButton jButtonToolUndo, JButton jButtonToolRedo) {
        this.jMenuItemUndo = jMenuItemUndo;
        this.jMenuItemRedo = jMenuItemRedo;
        this.jButtonToolUndo = jButtonToolUndo;
        this.jButtonToolRedo = jButtonToolRedo;
        super.setLimit(1000);
    }

    protected void init(Layout layout) {
        this.beforeFocusedPath = this.getFocusedPath(layout);
        this.beforeIsJoint = layout.getFocusedJoint() != null;
        this.lastSeenFlowchart = new ByteArrayOutputStream();
        try {
            MainWindow.marshal(layout.getFlowchart(), this.lastSeenFlowchart, false);
        }
        catch (JAXBException ex) {
            MyExceptionHandler.handle(ex);
        }
    }

    protected void addEdit(Layout layout, FlowchartEditManager flowchartEditManager, String presentationName) {
        if (this.lastSeenFlowchart != null) {
            ByteArrayOutputStream currentFlowchart = new ByteArrayOutputStream();
            try {
                MainWindow.marshal(layout.getFlowchart(), currentFlowchart, false);
            }
            catch (JAXBException ex) {
                MyExceptionHandler.handle(ex);
            }
            if (!Arrays.equals(this.lastSeenFlowchart.toByteArray(), currentFlowchart.toByteArray())) {
                int[] currentFocusedPath = this.getFocusedPath(layout);
                boolean currentIsJoint = layout.getFocusedJoint() != null;
                this.addEdit(new UniversalEdit(flowchartEditManager, this, this.lastSeenFlowchart, currentFlowchart, this.beforeFocusedPath, this.beforeIsJoint, currentFocusedPath, currentIsJoint, presentationName));
                this.beforeFocusedPath = currentFocusedPath;
                this.beforeIsJoint = currentIsJoint;
                this.lastSeenFlowchart = currentFlowchart;
            }
        } else {
            this.discardAllEdits();
        }
    }

    private void replaceLastEdit(FlowchartEditManager flowchartEditManager) {
        if (!super.canUndo() || super.canRedo()) {
            return;
        }
        Layout layout = flowchartEditManager.getLayout();
        UniversalEdit uedit = (UniversalEdit)super.editToBeUndone();
        ByteArrayOutputStream undoFlowchart = uedit.getUndoFlowchart();
        if (undoFlowchart.size() > 0) {
            ByteArrayOutputStream currentFlowchart = new ByteArrayOutputStream();
            try {
                MainWindow.marshal(layout.getFlowchart(), currentFlowchart, false);
            }
            catch (JAXBException ex) {
                MyExceptionHandler.handle(ex);
            }
            if (!Arrays.equals(undoFlowchart.toByteArray(), currentFlowchart.toByteArray())) {
                int[] undoFocusedPath = uedit.getBeforeFocusedPath();
                boolean undoIsJoint = uedit.isBeforeIsJoint();
                UniversalEdit ueditNew = new UniversalEdit(flowchartEditManager, this, undoFlowchart, currentFlowchart, undoFocusedPath, undoIsJoint, this.beforeFocusedPath, this.beforeIsJoint, uedit.getPresentationName());
                this.edits.set(this.edits.indexOf(uedit), ueditNew);
                this.lastSeenFlowchart = currentFlowchart;
            }
        }
    }

    public synchronized void setButtons() {
        String tooltip;
        if (super.canUndo()) {
            tooltip = super.editToBeUndone().getPresentationName();
            this.jMenuItemUndo.setEnabled(true);
            this.jMenuItemUndo.setToolTipText("<html>Zp\u011bt " + tooltip + "<br />(Ctrl + Z)</html>");
            this.jButtonToolUndo.setEnabled(true);
            this.jButtonToolUndo.setToolTipText("<html>Zp\u011bt " + tooltip + "<br />(Ctrl + Z)</html>");
        } else {
            this.jMenuItemUndo.setEnabled(false);
            this.jMenuItemUndo.setToolTipText("<html>Zp\u011bt<br />(Ctrl + Z)</html>");
            this.jButtonToolUndo.setEnabled(false);
            this.jButtonToolUndo.setToolTipText("<html>Zp\u011bt<br />(Ctrl + Z)</html>");
        }
        if (super.canRedo()) {
            tooltip = super.editToBeRedone().getPresentationName();
            this.jMenuItemRedo.setEnabled(true);
            this.jMenuItemRedo.setToolTipText("<html>Znovu " + tooltip + "<br />(Ctrl + Y)</html>");
            this.jButtonToolRedo.setEnabled(true);
            this.jButtonToolRedo.setToolTipText("<html>Znovu " + tooltip + "<br />(Ctrl + Y)</html>");
        } else {
            this.jMenuItemRedo.setEnabled(false);
            this.jMenuItemRedo.setToolTipText("<html>Znovu<br />(Ctrl + Y)</html>");
            this.jButtonToolRedo.setEnabled(false);
            this.jButtonToolRedo.setToolTipText("<html>Znovu<br />(Ctrl + Y)</html>");
        }
    }

    private int[] getFocusedPath(Layout layout) {
        if (layout.getFocusedElement() != null) {
            return layout.getFocusedElement().getPathFromMainSegment();
        }
        if (layout.getFocusedJoint().getParentElement().getInnerSegmentsCount() == 0) {
            return layout.getFocusedJoint().getParentElement().getPathFromMainSegment();
        }
        return layout.getFocusedJoint().getParentSegment().getPathFromMainSegment();
    }

    @Override
    public synchronized boolean addEdit(UndoableEdit ue) {
        boolean ret = super.addEdit(ue);
        this.setButtons();
        return ret;
    }

    @Override
    public synchronized void discardAllEdits() {
        super.discardAllEdits();
        this.setButtons();
    }

    @Override
    public synchronized void end() {
        super.end();
        this.setButtons();
    }

    @Override
    public synchronized void redo() throws CannotRedoException {
        if (super.canRedo()) {
            UniversalEdit UEdit = (UniversalEdit)super.editToBeRedone();
            super.redo();
            this.init(UEdit.getFlowchartEditManager().getLayout());
        }
        this.setButtons();
    }

    @Override
    protected void redoTo(UndoableEdit ue) throws CannotRedoException {
        if (super.canRedo()) {
            super.redoTo(ue);
            this.init(((UniversalEdit)ue).getFlowchartEditManager().getLayout());
        }
        this.setButtons();
    }

    @Override
    protected void trimEdits(int i, int i1) {
        super.trimEdits(i, i1);
        this.setButtons();
    }

    @Override
    public synchronized void undo() throws CannotUndoException {
        if (super.canUndo()) {
            UniversalEdit UEdit = (UniversalEdit)super.editToBeUndone();
            this.replaceLastEdit(UEdit.getFlowchartEditManager());
            super.undo();
            this.init(UEdit.getFlowchartEditManager().getLayout());
        }
        this.setButtons();
    }

    @Override
    protected void undoTo(UndoableEdit ue) throws CannotUndoException {
        if (super.canUndo()) {
            super.undoTo(ue);
            this.init(((UniversalEdit)ue).getFlowchartEditManager().getLayout());
        }
        this.setButtons();
    }

    public ByteArrayOutputStream getLastSeenFlowchart() {
        return this.lastSeenFlowchart;
    }
}

