/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui.managers;

import cz.miroslavbartyzal.psdiagram.app.gui.MainWindow;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class FlowchartOverlookManager
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
ChangeListener,
ActionListener {
    private MainWindow mainWindow;
    private JScrollBar horizontalScrollbar;
    private JScrollBar verticalScrollbar;
    private JSlider sliderZoom;
    private Cursor grab = null;
    private Integer pressedCursorX = null;
    private Integer pressedCursorY = null;
    private boolean horizontalScrolled = false;
    private Point2D zoomAnchorPoint = null;

    public FlowchartOverlookManager(MainWindow mainWindow, JScrollBar horizontalScrollbar, JScrollBar verticalScrollbar, JSlider sliderZoom) {
        this.mainWindow = mainWindow;
        this.horizontalScrollbar = horizontalScrollbar;
        this.verticalScrollbar = verticalScrollbar;
        this.sliderZoom = sliderZoom;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("/img/cursors/cursor_grab.png").openStream());
            this.grab = toolkit.createCustomCursor(image, new Point(0, 0), "grab");
        }
        catch (IOException e) {
            throw new Error("Error while loading cursor image!");
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String[] action = ae.getActionCommand().split("/");
        block3 : switch (action[0]) {
            case "overlook": {
                switch (action[1]) {
                    case "zoomIn": {
                        int zoomValue = this.sliderZoom.getValue();
                        if (zoomValue == this.sliderZoom.getMaximum()) {
                            return;
                        }
                        this.sliderZoom.setValue(zoomValue + 1);
                        break block3;
                    }
                    case "zoomOut": {
                        int zoomValue = this.sliderZoom.getValue();
                        if (zoomValue == this.sliderZoom.getMinimum()) {
                            return;
                        }
                        this.sliderZoom.setValue(zoomValue - 1);
                        break block3;
                    }
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.mainWindow.setJPanelDiagramFocus();
        if (!this.mainWindow.getEditMode() && !this.mainWindow.getAnimationMode()) {
            this.setStartDragGrab(me);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (this.pressedCursorX != null || this.pressedCursorY != null) {
            this.resetVariables(me);
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (this.pressedCursorX != null || this.pressedCursorY != null) {
            if (!me.getComponent().getCursor().equals(this.grab)) {
                me.getComponent().setCursor(this.grab);
            }
            int moveX = this.pressedCursorX - me.getXOnScreen();
            int moveY = this.pressedCursorY - me.getYOnScreen();
            this.horizontalScrollbar.setValue(this.horizontalScrollbar.getValue() + moveX);
            this.verticalScrollbar.setValue(this.verticalScrollbar.getValue() + moveY);
            if (this.mainWindow.graphicsXTransformedByScrollbar()) {
                this.pressedCursorX = me.getXOnScreen();
            }
            if (this.mainWindow.graphicsYTransformedByScrollbar()) {
                this.pressedCursorY = me.getYOnScreen();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        if (this.pressedCursorX != null || this.pressedCursorY != null) {
            this.resetVariables(me);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        if (mwe.isControlDown()) {
            if (mwe.getWheelRotation() < 0) {
                int zoomValue = this.sliderZoom.getValue();
                if (zoomValue == this.sliderZoom.getMaximum()) {
                    return;
                }
                this.zoomAnchorPoint = mwe.getPoint();
                this.sliderZoom.setValue(zoomValue + 1);
            } else {
                int zoomValue = this.sliderZoom.getValue();
                if (zoomValue == this.sliderZoom.getMinimum()) {
                    return;
                }
                this.zoomAnchorPoint = mwe.getPoint();
                this.sliderZoom.setValue(zoomValue - 1);
            }
            return;
        }
        int totalScrollAmount = mwe.getWheelRotation() * Math.abs(mwe.getUnitsToScroll());
        if (mwe.isAltDown() || mwe.isShiftDown()) {
            this.horizontalScrolled = true;
            this.horizontalScrollbar.setValue(this.horizontalScrollbar.getValue() + (totalScrollAmount *= this.horizontalScrollbar.getUnitIncrement()));
        } else {
            this.verticalScrollbar.setValue(this.verticalScrollbar.getValue() + (totalScrollAmount *= this.verticalScrollbar.getUnitIncrement()));
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if (ke.getKeyCode() == 18 && this.horizontalScrolled) {
            this.horizontalScrolled = false;
            ke.consume();
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        int value = this.sliderZoom.getValue();
        this.mainWindow.setJLabelZoomText(value * 10 + "%");
        this.mainWindow.setScale((double)value * 0.1, this.zoomAnchorPoint);
        this.zoomAnchorPoint = null;
    }

    protected void setStartDragGrab(MouseEvent me) {
        this.pressedCursorX = me.getXOnScreen();
        this.pressedCursorY = me.getYOnScreen();
    }

    private void resetVariables(MouseEvent me) {
        this.pressedCursorX = null;
        this.pressedCursorY = null;
        if (me.getComponent().getCursor().equals(this.grab)) {
            me.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }
}

