/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui.managers;

import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.Layout;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Joint;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import cz.miroslavbartyzal.psdiagram.app.global.GlobalFunctions;
import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import cz.miroslavbartyzal.psdiagram.app.gui.MainWindow;
import jakarta.xml.bind.JAXBException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.dnd.DragSource;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import javax.swing.JPanel;

public class FlowchartSymbolDragManager {
    private final Layout layout;
    private final JPanel canvasPanel;
    private LayoutElement processedElement = null;
    private ArrayList<LayoutElement> elementsToMove = null;
    private ArrayList<LayoutElement> elementsToAdd = null;
    private Symbol processedSymbol = null;
    private Joint defaultJoint = null;
    private Joint dockedJoint = null;
    private boolean dragging = false;
    private boolean copying = false;
    private final double SCALE = 0.5;
    private String dragAction = null;
    private Point2D lastP = new Point2D.Double();
    private Point2D lastPScaled = new Point2D.Double();
    private boolean creatingSymbol = false;
    private LayoutElement defaultElement = null;
    private ValidSymbolJointDropListener callback = null;

    public FlowchartSymbolDragManager(Layout layout, JPanel canvasPanel) {
        this.layout = layout;
        this.canvasPanel = canvasPanel;
    }

    protected void createSymbol(Symbol symbolToCreate, ValidSymbolJointDropListener validSymbolJointDropListener) {
        this.processedSymbol = symbolToCreate;
        this.callback = validSymbolJointDropListener;
        this.creatingSymbol = true;
        this.defaultJoint = this.layout.getFocusedJoint();
        this.defaultElement = this.layout.getFocusedElement();
    }

    protected void mousePressedOnSymbol(LayoutElement element, Point2D mouseCoords) {
        this.creatingSymbol = false;
        this.processedElement = element;
        try {
            this.processedSymbol = this.cloneElement(element).getSymbol();
        }
        catch (JAXBException ex) {
            MyExceptionHandler.handle(ex);
        }
    }

    protected boolean mouseReleased() {
        boolean retVal = false;
        this.processedElement = null;
        this.processedSymbol = null;
        this.defaultElement = null;
        if (this.creatingSymbol) {
            this.creatingSymbol = false;
            if (this.dockedJoint != null) {
                this.dragAction = "P\u0159id\u00e1n\u00ed symbolu";
                this.callback.validDropPerformed();
                retVal = true;
            } else {
                this.layout.setFocusPaintToDefault();
            }
            return retVal;
        }
        if (this.dragging) {
            if (!this.copying) {
                if (!this.isFocusedJointDefaultJoint()) {
                    retVal = true;
                    this.dragAction = "P\u0159esunut\u00ed symbolu";
                }
                this.layout.addElements(this.elementsToMove);
            } else {
                this.canvasPanel.setCursor(Cursor.getDefaultCursor());
                if (this.dockedJoint != null) {
                    this.layout.addElements(this.elementsToAdd);
                    retVal = true;
                    this.dragAction = "Kop\u00edrov\u00e1n\u00ed symbolu";
                }
            }
            this.dragging = false;
            this.defaultJoint = null;
            this.dockedJoint = null;
            this.elementsToMove = null;
            this.elementsToAdd = null;
            this.copying = false;
            this.layout.setFocusPaintToDefault();
        }
        return retVal;
    }

    protected void cancelCreationProcess() {
        if (this.creatingSymbol) {
            this.dockedJoint = null;
            this.mouseReleased();
        }
    }

    protected boolean isDragging() {
        return this.dragging;
    }

    protected boolean isAbleToDrag() {
        return this.processedElement != null;
    }

    protected boolean isSymbolBeingDragged() {
        return this.dragging;
    }

    protected boolean isCreatingSymbol() {
        return this.creatingSymbol;
    }

    protected boolean controlKeyUpdate(boolean isControlDown) {
        if (this.dragging) {
            if (isControlDown && !this.copying) {
                this.copying = true;
                if (this.elementsToAdd == null) {
                    this.elementsToAdd = new ArrayList();
                    try {
                        for (LayoutElement element : this.elementsToMove) {
                            this.elementsToAdd.add(this.cloneElement(element));
                        }
                    }
                    catch (JAXBException ex) {
                        MyExceptionHandler.handle(ex);
                        this.copying = false;
                        this.elementsToAdd = null;
                        return false;
                    }
                }
                this.canvasPanel.setCursor(DragSource.DefaultCopyDrop);
                if (this.dockedJoint != null) {
                    this.layout.setFocusedJoint(this.defaultJoint);
                    this.layout.addElements(this.elementsToMove);
                    this.layout.setFocusedJoint(this.dockedJoint);
                    this.dockedJoint = this.layout.getFocusedJoint();
                    this.processedSymbol.setCenterX(this.dockedJoint.getCenterX() / 0.5);
                    this.processedSymbol.setCenterY(this.dockedJoint.getCenterY() / 0.5);
                    this.layout.setFocusJointOnly();
                    this.performMouseUpdate();
                } else {
                    this.layout.addElements(this.elementsToMove);
                    this.layout.setNoFocusPaint();
                }
                return true;
            }
            if (!isControlDown && this.copying) {
                this.copying = false;
                this.canvasPanel.setCursor(Cursor.getDefaultCursor());
                this.layout.setFocusedElement(this.processedElement);
                this.layout.removeElementFocusItsJoint(this.processedElement);
                this.layout.setFocusJointOnly();
                if (this.dockedJoint != null) {
                    this.layout.setFocusedJoint(this.dockedJoint);
                    this.dockedJoint = this.layout.getFocusedJoint();
                    this.processedSymbol.setCenterX(this.dockedJoint.getCenterX() / 0.5);
                    this.processedSymbol.setCenterY(this.dockedJoint.getCenterY() / 0.5);
                    this.performMouseUpdate();
                }
                return true;
            }
        }
        return false;
    }

    private LayoutElement cloneElement(LayoutElement element) throws JAXBException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MainWindow.marshal((Object)element, baos, false);
        return (LayoutElement)GlobalFunctions.unsafeCast(MainWindow.unmarshal(new ByteArrayInputStream(baos.toByteArray())));
    }

    private boolean isFocusedJointDefaultJoint() {
        return this.layout.getFocusedJoint().getParentElement().equals(this.defaultJoint.getParentElement()) && this.layout.getFocusedJoint().getParentSegment().equals(this.defaultJoint.getParentSegment());
    }

    protected void performDrag(Point2D p, boolean isControlDown) {
        this.lastP = p;
        if (!this.dragging && !this.processedElement.getSymbol().contains(p)) {
            this.dragging = true;
            this.dragAction = null;
            this.elementsToMove = this.layout.getMeAndMyDependants(this.processedElement);
            this.layout.removeElementFocusItsJoint(this.processedElement);
            this.layout.setFocusJointOnly();
            this.defaultJoint = this.layout.getFocusedJoint();
        }
        if (this.dragging) {
            this.controlKeyUpdate(isControlDown);
            this.lastPScaled = new Point2D.Double(p.getX() / 0.5, p.getY() / 0.5);
            this.performMouseUpdate();
        }
    }

    protected void performSymbolCreationDrag(Point2D p) {
        if (this.creatingSymbol) {
            this.lastP = p;
            this.lastPScaled = new Point2D.Double(p.getX() / 0.5, p.getY() / 0.5);
            this.performMouseUpdate();
        }
    }

    private void performMouseUpdate() {
        if (this.dockedJoint != null && (this.processedSymbol.contains(this.lastPScaled) || this.dockedJoint.contains(this.lastP))) {
            return;
        }
        for (Joint joint : this.layout.getlJoints()) {
            this.processedSymbol.setCenterX(joint.getCenterX() / 0.5);
            this.processedSymbol.setCenterY(joint.getCenterY() / 0.5);
            if (!this.processedSymbol.contains(this.lastPScaled) && !joint.contains(this.lastP)) continue;
            this.layout.setFocusedJoint(joint);
            this.dockedJoint = joint;
            this.layout.setFocusJointOnly();
            return;
        }
        if (this.copying || this.creatingSymbol) {
            this.layout.setNoFocusPaint();
        }
        this.dockedJoint = null;
        this.processedSymbol.setCenterX(this.lastPScaled.getX());
        this.processedSymbol.setCenterY(this.lastPScaled.getY());
        if (this.creatingSymbol && this.defaultJoint == null) {
            this.layout.setFocusedElement(this.defaultElement);
        } else {
            this.layout.setFocusedJoint(this.defaultJoint);
        }
    }

    public String getDragAction() {
        return this.dragAction;
    }

    public void paint(Graphics2D grphcs2D) {
        if ((this.dragging || this.creatingSymbol) && this.processedSymbol != null) {
            Color shapeDownColor;
            Color shapeUpColor;
            grphcs2D.scale(0.5, 0.5);
            grphcs2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.dockedJoint != null) {
                shapeUpColor = new Color(Layout.FOCUSED_UP_COLOR.getRed(), Layout.FOCUSED_UP_COLOR.getGreen(), Layout.FOCUSED_UP_COLOR.getBlue(), 220);
                shapeDownColor = new Color(Layout.FOCUSED_DOWN_COLOR.getRed(), Layout.FOCUSED_DOWN_COLOR.getGreen(), Layout.FOCUSED_DOWN_COLOR.getBlue(), 220);
            } else {
                shapeUpColor = new Color(this.processedSymbol.getShapeUpColor().getRed(), this.processedSymbol.getShapeUpColor().getGreen(), this.processedSymbol.getShapeUpColor().getBlue(), 220);
                shapeDownColor = new Color(this.processedSymbol.getShapeDownColor().getRed(), this.processedSymbol.getShapeDownColor().getGreen(), this.processedSymbol.getShapeDownColor().getBlue(), 220);
            }
            Color borderColor = new Color(this.processedSymbol.getBorderColor().getRed(), this.processedSymbol.getBorderColor().getGreen(), this.processedSymbol.getBorderColor().getBlue(), 220);
            if (this.processedSymbol.getShapeUpColor().equals(this.processedSymbol.getShapeDownColor())) {
                grphcs2D.setColor(shapeUpColor);
            } else {
                grphcs2D.setPaint(new GradientPaint((float)(this.processedSymbol.getX() + this.processedSymbol.getWidth() * 0.25), (float)this.processedSymbol.getY(), shapeUpColor, (float)(this.processedSymbol.getX() + this.processedSymbol.getWidth() * 0.75), (float)(this.processedSymbol.getY() + this.processedSymbol.getHeight()), shapeDownColor));
            }
            grphcs2D.fill(this.processedSymbol.getShape());
            grphcs2D.setColor(borderColor);
            grphcs2D.setStroke(new BasicStroke(1.0f));
            grphcs2D.draw(this.processedSymbol.getShape());
            for (int i = 0; i < this.processedSymbol.getTextLayoutLines().size(); ++i) {
                Point2D p = this.processedSymbol.getTextLayoutOrigins().get(i);
                this.processedSymbol.getTextLayoutLines().get(i).draw(grphcs2D, (float)p.getX(), (float)p.getY());
            }
        }
    }

    public static interface ValidSymbolJointDropListener {
        public void validDropPerformed();
    }
}

