/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui.managers.undoableEdits;

import cz.miroslavbartyzal.psdiagram.app.flowchart.Flowchart;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutSegment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Joint;
import cz.miroslavbartyzal.psdiagram.app.global.GlobalFunctions;
import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import cz.miroslavbartyzal.psdiagram.app.gui.MainWindow;
import cz.miroslavbartyzal.psdiagram.app.gui.managers.FlowchartEditManager;
import cz.miroslavbartyzal.psdiagram.app.gui.managers.FlowchartEditUndoManager;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public final class UniversalEdit
extends AbstractUndoableEdit {
    private int firstIndex;
    private byte[] undoChange;
    private byte[] redoChange;
    private final FlowchartEditManager flowchartEditManager;
    private final FlowchartEditUndoManager flowchartEditUndoManager;
    private int[] beforeFocusedPath;
    private boolean beforeIsJoint;
    private int[] afterFocusedPath;
    private boolean afterIsJoint;
    private String presentationName;

    public UniversalEdit(FlowchartEditManager flowchartEditManager, FlowchartEditUndoManager flowchartEditUndoManager, ByteArrayOutputStream before, ByteArrayOutputStream after, int[] beforeFocusedPath, boolean beforeIsJoint, int[] afterFocusedPath, boolean afterIsJoint, String presentationName) {
        byte[] largerArr;
        byte[] smallerArr;
        this.flowchartEditManager = flowchartEditManager;
        this.flowchartEditUndoManager = flowchartEditUndoManager;
        this.beforeFocusedPath = beforeFocusedPath;
        this.beforeIsJoint = beforeIsJoint;
        this.afterFocusedPath = afterFocusedPath;
        this.afterIsJoint = afterIsJoint;
        this.presentationName = presentationName;
        if (before.size() < after.size()) {
            smallerArr = before.toByteArray();
            largerArr = after.toByteArray();
        } else {
            smallerArr = after.toByteArray();
            largerArr = before.toByteArray();
        }
        for (int i = 0; i < smallerArr.length; ++i) {
            if (smallerArr[i] == largerArr[i]) continue;
            this.firstIndex = i;
            break;
        }
        int remainLength = smallerArr.length - this.firstIndex;
        for (int i = 1; i <= remainLength; ++i) {
            if (smallerArr[smallerArr.length - i] == largerArr[largerArr.length - i] && i != remainLength) continue;
            if (i == remainLength && smallerArr[smallerArr.length - i] == largerArr[largerArr.length - i]) {
                ++i;
            }
            int largerLastIndex = largerArr.length - i;
            int smallerLastIndex = smallerArr.length - i;
            byte[] largerChange = new byte[largerLastIndex - this.firstIndex + 1];
            for (int j = this.firstIndex; j <= largerLastIndex; ++j) {
                largerChange[j - this.firstIndex] = largerArr[j];
            }
            byte[] smallerChange = new byte[smallerLastIndex - this.firstIndex + 1];
            for (int j = this.firstIndex; j <= smallerLastIndex; ++j) {
                smallerChange[j - this.firstIndex] = smallerArr[j];
            }
            if (before.size() < after.size()) {
                this.undoChange = smallerChange;
                this.redoChange = largerChange;
                break;
            }
            this.undoChange = largerChange;
            this.redoChange = smallerChange;
            break;
        }
    }

    @Override
    public synchronized void redo() throws CannotRedoException {
        super.redo();
        Flowchart<LayoutSegment, LayoutElement> futureFlowchart = this.getFutureFlowchart(this.undoChange, this.redoChange);
        if (futureFlowchart != null) {
            this.flowchartEditManager.getLayout().setFlowchart(futureFlowchart);
            this.setFocused(this.afterFocusedPath, this.afterIsJoint);
            this.flowchartEditManager.resetVariables();
            this.flowchartEditManager.loadMarkedSymbolText();
            this.flowchartEditManager.repaintJPanelDiagram();
        }
    }

    @Override
    public synchronized void undo() throws CannotUndoException {
        super.undo();
        Flowchart<LayoutSegment, LayoutElement> futureFlowchart = this.getFutureFlowchart(this.redoChange, this.undoChange);
        if (futureFlowchart != null) {
            this.flowchartEditManager.getLayout().setFlowchart(futureFlowchart);
            this.setFocused(this.beforeFocusedPath, this.beforeIsJoint);
            this.flowchartEditManager.resetVariables();
            this.flowchartEditManager.loadMarkedSymbolText();
            this.flowchartEditManager.repaintJPanelDiagram();
        }
    }

    public synchronized ByteArrayOutputStream getUndoFlowchart() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] undoFlowchart = this.getFutureFlowchartAsArray(this.redoChange, this.undoChange);
        baos.write(undoFlowchart, 0, undoFlowchart.length);
        return baos;
    }

    @Override
    public String getPresentationName() {
        return this.presentationName;
    }

    private Flowchart<LayoutSegment, LayoutElement> getFutureFlowchart(byte[] currentChange, byte[] futureChange) {
        Flowchart futureFlowchart = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.getFutureFlowchartAsArray(currentChange, futureChange));
            futureFlowchart = (Flowchart)GlobalFunctions.unsafeCast(MainWindow.unmarshal(bais));
        }
        catch (JAXBException | IndexOutOfBoundsException ex) {
            MyExceptionHandler.handle(ex);
            this.flowchartEditManager.resetUndoManager();
        }
        return futureFlowchart;
    }

    private byte[] getFutureFlowchartAsArray(byte[] currentChange, byte[] futureChange) {
        ByteArrayOutputStream baos = this.flowchartEditUndoManager.getLastSeenFlowchart();
        byte[] curFl = baos.toByteArray();
        byte[] futureFl = new byte[curFl.length - currentChange.length + futureChange.length];
        System.arraycopy(curFl, 0, futureFl, 0, this.firstIndex);
        System.arraycopy(futureChange, 0, futureFl, this.firstIndex, futureChange.length);
        System.arraycopy(curFl, this.firstIndex + currentChange.length, futureFl, this.firstIndex + futureChange.length, futureFl.length - this.firstIndex - futureChange.length);
        return futureFl;
    }

    private void setFocused(int[] focusedPath, boolean focusedIsJoint) {
        LayoutSegment segment = this.flowchartEditManager.getLayout().getFlowchart().getMainSegment();
        LayoutElement element = (LayoutElement)segment.getElement(focusedPath[0]);
        for (int i = 1; i < focusedPath.length; i += 2) {
            segment = (LayoutSegment)element.getInnerSegment(focusedPath[i]);
            if (i + 1 >= focusedPath.length) continue;
            element = (LayoutElement)segment.getElement(focusedPath[i + 1]);
        }
        if (focusedIsJoint) {
            Joint joint = new Joint(element, segment);
            this.flowchartEditManager.getLayout().setFocusedJoint(joint);
        } else {
            this.flowchartEditManager.getLayout().setFocusedElement(element);
        }
    }

    public FlowchartEditManager getFlowchartEditManager() {
        return this.flowchartEditManager;
    }

    public int[] getBeforeFocusedPath() {
        return this.beforeFocusedPath;
    }

    public boolean isBeforeIsJoint() {
        return this.beforeIsJoint;
    }
}

