/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms;

import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.global.RegexFunctions;
import cz.miroslavbartyzal.psdiagram.app.gui.managers.FlowchartEditManager;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.documentFilters.AbstractFilter;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public abstract class AbstractSymbolFunctionForm
extends JPanel
implements DocumentListener {
    private FlowchartEditManager flowchartEditManager;
    private final LayoutElement element;
    private boolean hasCommandsToSet = true;

    AbstractSymbolFunctionForm(LayoutElement element, FlowchartEditManager flowchartEditManager) {
        this.element = element;
        this.flowchartEditManager = flowchartEditManager;
    }

    abstract void addDocumentListeners();

    abstract void generateValues();

    public abstract JTextField getJTextFieldToDispatchKeyEventsAt();

    LayoutElement getElement() {
        return this.element;
    }

    void fireChangeEventToEditManager() {
        this.flowchartEditManager.actionPerformed(new ActionEvent(this, this.hashCode(), "edit/defaultsChanged"));
    }

    void trimSize() {
        this.setPreferredSize(this.getLayout().minimumLayoutSize(this));
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        this.trimSize();
        return super.getPreferredSize();
    }

    FlowchartEditManager getFlowchartEditManager() {
        return this.flowchartEditManager;
    }

    void setFlowchartEditManager(FlowchartEditManager flowchartEditManager) {
        this.flowchartEditManager = flowchartEditManager;
    }

    public boolean hasCommandsToSet() {
        return this.hasCommandsToSet;
    }

    void setHasCommandsToSet(boolean hasCommandsToSet) {
        this.hasCommandsToSet = hasCommandsToSet;
    }

    public static void enhanceWithUndoRedoCapability(final JTextComponent textcomp) {
        final UndoManager undo = new UndoManager();
        undo.setLimit(1000);
        textcomp.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                undo.addEdit(evt.getEdit());
            }
        });
        textcomp.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canUndo()) {
                        undo.undo();
                        DocumentFilter documentFilter = ((AbstractDocument)textcomp.getDocument()).getDocumentFilter();
                        if (documentFilter != null && documentFilter instanceof AbstractFilter) {
                            ((AbstractFilter)documentFilter).parseInputAndUpdateGUI();
                        }
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        textcomp.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        textcomp.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canRedo()) {
                        undo.redo();
                        DocumentFilter documentFilter = ((AbstractDocument)textcomp.getDocument()).getDocumentFilter();
                        if (documentFilter != null && documentFilter instanceof AbstractFilter) {
                            ((AbstractFilter)documentFilter).parseInputAndUpdateGUI();
                        }
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        textcomp.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }

    public static String convertToPSDDisplayCommands(String command) {
        if (command == null) {
            return command;
        }
        String[] commandWithoutQ = RegexFunctions.splitString(command, "\"([^\"\\\\]|\\\\.)*\"?");
        for (int i = 0; i < commandWithoutQ.length; i += 2) {
            commandWithoutQ[i] = commandWithoutQ[i].replace("!=", "\u2260").replace("!", "\u00ac").replace(">=", "\u2265").replace("<=", "\u2264");
        }
        Object cmnd = "";
        for (String commandPart : commandWithoutQ) {
            cmnd = (String)cmnd + commandPart;
        }
        return cmnd;
    }
}

