/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms;

import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.EnumSymbol;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import cz.miroslavbartyzal.psdiagram.app.global.SettingsHolder;
import cz.miroslavbartyzal.psdiagram.app.gui.balloonToolTip.MaxBalloonSizeCallback;
import cz.miroslavbartyzal.psdiagram.app.gui.managers.FlowchartEditManager;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.AbstractSymbolFunctionForm;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.JPanelSymbol;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.ValidationListener;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.WatermarkJTextField;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.documentFilters.NoArrayVariableFilter;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.documentFilters.NumericValueFilter;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.documentFilters.VariableFilter;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;

public final class For
extends AbstractSymbolFunctionForm {
    private final JLabel jLabelDescription;
    private final Symbol mySymbol = EnumSymbol.FOR.getInstance(null);
    private final ForValidationListener validationListener = new ForValidationListener();
    private ButtonGroup buttonGroup;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabelExampleLabel1;
    private JLabel jLabelExampleLabel2;
    private JLabel jLabelExamples1;
    private JLabel jLabelExamples2;
    private JLabel jLabelVar;
    private JPanel jPanel1;
    private JPanel jPanelFor;
    private JPanel jPanelForeach;
    private JRadioButton jRadioButtonFor;
    private JRadioButton jRadioButtonForeach;
    private JTextField jTextFieldForTo;
    private JTextField jTextFieldForeach;
    private JTextField jTextFieldFrom;
    private JTextField jTextFieldIncrement;
    private JTextField jTextFieldVar;

    public For(LayoutElement element, FlowchartEditManager flowchartEditManager, MaxBalloonSizeCallback maxBalloonSizeCallback) {
        super(element, flowchartEditManager);
        this.jLabelDescription = new JLabel("<html><p>- hodnota prom\u011bnn\u00e9 cyklu se postupn\u011b m\u011bn\u00ed a je k dispozici pro v\u00fdpo\u010dty v t\u011ble cyklu");
        if (SettingsHolder.settings.isBlockScopeVariables()) {
            this.jLabelDescription.setText(this.jLabelDescription.getText() + "<br />- prom\u011bnn\u00e9, vytvo\u0159en\u00e9 uvnit\u0159 t\u011bla cyklu, existuj\u00ed jen po dobu aktu\u00e1ln\u00ed, prob\u00edhaj\u00edc\u00ed smy\u010dky");
        }
        this.jLabelDescription.setText(this.jLabelDescription.getText() + "</p></html>");
        this.jLabelDescription.setFont(SettingsHolder.SMALLFONT_SYMBOLDESC);
        this.initComponents();
        this.jTextFieldVar.setFont(SettingsHolder.CODEFONT);
        this.jTextFieldFrom.setFont(SettingsHolder.CODEFONT);
        this.jTextFieldForTo.setFont(SettingsHolder.CODEFONT);
        this.jTextFieldIncrement.setFont(SettingsHolder.CODEFONT);
        this.jTextFieldForeach.setFont(SettingsHolder.CODEFONT);
        this.jLabelExamples1.setFont(SettingsHolder.SMALL_CODEFONT);
        this.jLabelExamples2.setFont(SettingsHolder.SMALL_CODEFONT);
        if (element.getSymbol().getCommands() != null) {
            this.jTextFieldVar.setText(element.getSymbol().getCommands().get("var"));
            if (element.getSymbol().getCommands().containsKey("from")) {
                this.jTextFieldFrom.setText(element.getSymbol().getCommands().get("from"));
                this.jTextFieldForTo.setText(element.getSymbol().getCommands().get("to"));
                this.jTextFieldIncrement.setText(element.getSymbol().getCommands().get("inc"));
                this.jRadioButtonFor.setSelected(true);
                this.setForVisible();
            } else {
                this.jTextFieldForeach.setText(element.getSymbol().getCommands().get("array"));
                this.jRadioButtonForeach.setSelected(true);
                this.setForeachVisible();
            }
        } else {
            this.jRadioButtonFor.setSelected(true);
            this.setForVisible();
        }
        ((AbstractDocument)this.jTextFieldVar.getDocument()).setDocumentFilter(new NoArrayVariableFilter(this.jTextFieldVar, this.validationListener, maxBalloonSizeCallback));
        ((AbstractDocument)this.jTextFieldFrom.getDocument()).setDocumentFilter(new NumericValueFilter(this.jTextFieldFrom, this.validationListener, maxBalloonSizeCallback));
        ((AbstractDocument)this.jTextFieldForTo.getDocument()).setDocumentFilter(new NumericValueFilter(this.jTextFieldForTo, this.validationListener, maxBalloonSizeCallback));
        ((AbstractDocument)this.jTextFieldIncrement.getDocument()).setDocumentFilter(new NumericValueFilter(this.jTextFieldIncrement, this.validationListener, maxBalloonSizeCallback));
        ((AbstractDocument)this.jTextFieldForeach.getDocument()).setDocumentFilter(new VariableFilter(this.jTextFieldForeach, this.validationListener, maxBalloonSizeCallback));
        AbstractSymbolFunctionForm.enhanceWithUndoRedoCapability(this.jTextFieldVar);
        AbstractSymbolFunctionForm.enhanceWithUndoRedoCapability(this.jTextFieldFrom);
        AbstractSymbolFunctionForm.enhanceWithUndoRedoCapability(this.jTextFieldForTo);
        AbstractSymbolFunctionForm.enhanceWithUndoRedoCapability(this.jTextFieldIncrement);
        AbstractSymbolFunctionForm.enhanceWithUndoRedoCapability(this.jTextFieldForeach);
        this.addDocumentListeners();
        super.trimSize();
    }

    @Override
    void addDocumentListeners() {
        this.jTextFieldVar.getDocument().addDocumentListener(this);
        this.jTextFieldFrom.getDocument().addDocumentListener(this);
        this.jTextFieldForTo.getDocument().addDocumentListener(this);
        this.jTextFieldIncrement.getDocument().addDocumentListener(this);
        this.jTextFieldForeach.getDocument().addDocumentListener(this);
    }

    @Override
    void generateValues() {
        String var = "";
        String from = "";
        String to = "";
        String inc = "";
        String array = "";
        try {
            var = this.jTextFieldVar.getDocument().getText(0, this.jTextFieldVar.getDocument().getLength());
            from = this.jTextFieldFrom.getDocument().getText(0, this.jTextFieldFrom.getDocument().getLength());
            to = this.jTextFieldForTo.getDocument().getText(0, this.jTextFieldForTo.getDocument().getLength());
            inc = this.jTextFieldIncrement.getDocument().getText(0, this.jTextFieldIncrement.getDocument().getLength());
            array = this.jTextFieldForeach.getDocument().getText(0, this.jTextFieldForeach.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (this.jRadioButtonFor.isSelected()) {
            For.generateForValues(super.getElement().getSymbol(), var.trim(), from.trim(), to.trim(), inc.trim());
        } else if (this.jRadioButtonForeach.isSelected()) {
            For.generateForeachValues(super.getElement().getSymbol(), var.trim(), array.trim());
        }
    }

    public static void generateForValues(Symbol symbol, String var, String from, String to, String inc) {
        if (!(var.isEmpty() || from.isEmpty() || to.isEmpty() || inc.isEmpty())) {
            boolean setIncToDef = false;
            if (!inc.equals("1")) {
                setIncToDef = true;
            }
            try {
                double dfrom = Double.parseDouble(from);
                double dto = Double.parseDouble(to);
                double dinc = Double.parseDouble(inc);
                if (dfrom > dto) {
                    if (dinc == -1.0) {
                        setIncToDef = false;
                    } else if (dinc == 1.0) {
                        setIncToDef = true;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            symbol.setDefaultValue(AbstractSymbolFunctionForm.convertToPSDDisplayCommands(var) + " \u2190 " + AbstractSymbolFunctionForm.convertToPSDDisplayCommands(from) + ".." + AbstractSymbolFunctionForm.convertToPSDDisplayCommands(to));
            if (setIncToDef) {
                symbol.setDefaultValue(symbol.getDefaultValue() + "(" + AbstractSymbolFunctionForm.convertToPSDDisplayCommands(inc) + ")");
            }
        } else {
            symbol.setDefaultValue(null);
        }
        LinkedHashMap<String, String> commands = new LinkedHashMap<String, String>();
        commands.put("var", var);
        commands.put("from", from);
        commands.put("to", to);
        commands.put("inc", inc);
        symbol.setCommands(commands);
    }

    public static void generateForeachValues(Symbol symbol, String var, String array) {
        if (!var.isEmpty() && !array.isEmpty()) {
            symbol.setDefaultValue(AbstractSymbolFunctionForm.convertToPSDDisplayCommands(var) + " \u2190 " + AbstractSymbolFunctionForm.convertToPSDDisplayCommands(array) + "[]");
        } else {
            symbol.setDefaultValue(null);
        }
        LinkedHashMap<String, String> commands = new LinkedHashMap<String, String>();
        commands.put("var", var);
        commands.put("array", array);
        symbol.setCommands(commands);
    }

    public static boolean areValuesValid(String var, String from, String to, String inc) {
        return NoArrayVariableFilter.isValid(var) && NumericValueFilter.isValid(from) && NumericValueFilter.isValid(to) && NumericValueFilter.isValid(inc);
    }

    public static boolean areValuesValid(String var, String array) {
        return NoArrayVariableFilter.isValid(var) && VariableFilter.isValid(array);
    }

    private void setForVisible() {
        ((WatermarkJTextField)this.jTextFieldVar).setWatermarkText("do kter\u00e9 ukl\u00e1dat po\u010d\u00edt\u00e1n\u00ed");
        this.jPanelForeach.setVisible(false);
        this.jPanelFor.setVisible(true);
    }

    private void setForeachVisible() {
        ((WatermarkJTextField)this.jTextFieldVar).setWatermarkText("do kter\u00e9 ukl\u00e1dat prvky pole");
        this.jPanelFor.setVisible(false);
        this.jPanelForeach.setVisible(true);
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jLabelVar = new JLabel();
        this.jTextFieldVar = new WatermarkJTextField("");
        this.jPanel1 = new JPanelSymbol(this.mySymbol, this.jLabelDescription);
        this.jRadioButtonFor = new JRadioButton();
        this.jRadioButtonForeach = new JRadioButton();
        this.jPanelFor = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldFrom = new WatermarkJTextField("od kolika po\u010d\u00edtat");
        this.jLabel2 = new JLabel();
        this.jTextFieldForTo = new WatermarkJTextField("do kolika po\u010d\u00edtat");
        this.jLabelExampleLabel1 = new JLabel();
        this.jLabelExamples1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldIncrement = new JTextField();
        this.jPanelForeach = new JPanel();
        this.jLabel3 = new JLabel();
        this.jTextFieldForeach = new WatermarkJTextField("pole, kter\u00e9 proch\u00e1zet");
        this.jLabelExampleLabel2 = new JLabel();
        this.jLabelExamples2 = new JLabel();
        this.setBorder(BorderFactory.createTitledBorder("<html>Cyklus s pevn\u00fdm po\u010dtem opakov\u00e1n\u00ed</html>"));
        this.setPreferredSize(new Dimension(187, 493));
        this.jLabelVar.setText("Prom\u011bnn\u00e1 cyklu:");
        this.jTextFieldVar.setToolTipText("<html>\nProm\u011bnn\u00e1, do kter\u00e9 bude ukl\u00e1d\u00e1na aktu\u00e1ln\u00ed hodnota prob\u00edhaj\u00edc\u00edho cyklu.<br />\nV p\u0159\u00edpad\u011b for cyklu se hodnota rovn\u00e1 aktu\u00e1ln\u00ed hodnot\u011b po\u010d\u00edtadla.<br />\nV p\u0159\u00edpad\u011b for-each cyklu se hodnota rovn\u00e1 aktu\u00e1ln\u00edmu prvku z dan\u00e9ho pole.<br />\n</html>");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 206, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.buttonGroup.add(this.jRadioButtonFor);
        this.jRadioButtonFor.setText("<html>\nZadan\u00fd po\u010det opakov\u00e1n\u00ed<br />\n(cyklus for)\n</html>");
        this.jRadioButtonFor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                For.this.jRadioButtonForActionPerformed(evt);
            }
        });
        this.buttonGroup.add(this.jRadioButtonForeach);
        this.jRadioButtonForeach.setText("<html>\nProj\u00edt v\u0161echny prvky pole<br />\n(cyklus for-each)\n</html>");
        this.jRadioButtonForeach.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                For.this.jRadioButtonForeachActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Za\u010d\u00edt od:");
        this.jTextFieldFrom.setToolTipText("<html>\nCyklus inkrementuje (navy\u0161uje) po\u010d\u00e1te\u010dn\u00ed \u010d\u00edselnou hodnotu v\u017edy o hodnotu inkrementu,<br />\ndokud nen\u00ed dosa\u017eena maxim\u00e1ln\u00ed stanoven\u00e1 hodnota - t\u00edm cyklus kon\u010d\u00ed.\n</html>");
        this.jLabel2.setText("Po\u010d\u00edtat do (v\u010detn\u011b):");
        this.jTextFieldForTo.setToolTipText("<html>\nCyklus inkrementuje (navy\u0161uje) po\u010d\u00e1te\u010dn\u00ed \u010d\u00edselnou hodnotu v\u017edy o hodnotu inkrementu,<br />\ndokud nen\u00ed dosa\u017eena maxim\u00e1ln\u00ed stanoven\u00e1 hodnota - t\u00edm cyklus kon\u010d\u00ed.\n</html>");
        this.jLabelExampleLabel1.setText("P\u0159\u00edklady:");
        this.jLabelExamples1.setText("<html>\n- I; 1; 10;1<br />\n- I; 10; 1;-1<br />\n- I; 0; pole.length-1;1\n</html>");
        this.jLabelExamples1.setVerticalAlignment(1);
        this.jLabel4.setText("Inkrement:");
        this.jTextFieldIncrement.setText("1");
        this.jTextFieldIncrement.setToolTipText("<html>\nNej\u010dast\u011bji se pou\u017e\u00edv\u00e1 inkrement 1. Pro dekrementaci pou\u017eijte z\u00e1pornou hodnotu.\n</html>");
        GroupLayout jPanelForLayout = new GroupLayout(this.jPanelFor);
        this.jPanelFor.setLayout(jPanelForLayout);
        jPanelForLayout.setHorizontalGroup(jPanelForLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldFrom).addComponent(this.jLabel2, -1, 206, Short.MAX_VALUE).addComponent(this.jTextFieldForTo).addComponent(this.jLabelExampleLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelExamples1, -2, 0, Short.MAX_VALUE).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldIncrement));
        jPanelForLayout.setVerticalGroup(jPanelForLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelForLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFrom, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldForTo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldIncrement, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelExampleLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelExamples1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel3.setText("Prom\u011bnn\u00e1 pole:");
        this.jLabelExampleLabel2.setText("P\u0159\u00edklady:");
        this.jLabelExamples2.setText("<html>\n- prvek; pole<br />\n</html>");
        this.jLabelExamples2.setVerticalAlignment(1);
        GroupLayout jPanelForeachLayout = new GroupLayout(this.jPanelForeach);
        this.jPanelForeach.setLayout(jPanelForeachLayout);
        jPanelForeachLayout.setHorizontalGroup(jPanelForeachLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldForeach).addComponent(this.jLabelExampleLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelExamples2, -2, 0, Short.MAX_VALUE));
        jPanelForeachLayout.setVerticalGroup(jPanelForeachLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelForeachLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldForeach, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelExampleLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelExamples2, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelVar, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldVar).addComponent(this.jRadioButtonFor, -1, 159, Short.MAX_VALUE).addComponent(this.jRadioButtonForeach).addComponent(this.jPanelFor, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelForeach, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonFor, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonForeach, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelVar).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldVar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelFor, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelForeach, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jRadioButtonForActionPerformed(ActionEvent evt) {
        this.setForVisible();
        super.trimSize();
        this.generateValues();
        this.validationListener.validationStateChanged();
        super.fireChangeEventToEditManager();
    }

    private void jRadioButtonForeachActionPerformed(ActionEvent evt) {
        this.setForeachVisible();
        super.trimSize();
        this.generateValues();
        this.validationListener.validationStateChanged();
        super.fireChangeEventToEditManager();
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        this.generateValues();
        super.fireChangeEventToEditManager();
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        this.generateValues();
        super.fireChangeEventToEditManager();
    }

    @Override
    public JTextField getJTextFieldToDispatchKeyEventsAt() {
        return this.jTextFieldVar;
    }

    private class ForValidationListener
    implements ValidationListener {
        private ForValidationListener() {
        }

        @Override
        public void validationStateChanged() {
            Boolean varValid = (Boolean)For.this.jTextFieldVar.getDocument().getProperty("commandValid");
            if (For.this.jRadioButtonFor.isSelected()) {
                Boolean fromValid = (Boolean)For.this.jTextFieldFrom.getDocument().getProperty("commandValid");
                Boolean toValid = (Boolean)For.this.jTextFieldForTo.getDocument().getProperty("commandValid");
                Boolean incValid = (Boolean)For.this.jTextFieldIncrement.getDocument().getProperty("commandValid");
                if (varValid == null || fromValid == null || toValid == null || incValid == null) {
                    return;
                }
                if (varValid.booleanValue() && fromValid.booleanValue() && toValid.booleanValue() && incValid.booleanValue()) {
                    For.super.getElement().getSymbol().setCommandsValid(true);
                } else {
                    For.super.getElement().getSymbol().setCommandsValid(false);
                }
            } else if (For.this.jRadioButtonForeach.isSelected()) {
                Boolean arrayValid = (Boolean)For.this.jTextFieldForeach.getDocument().getProperty("commandValid");
                if (varValid == null || arrayValid == null) {
                    return;
                }
                if (varValid.booleanValue() && arrayValid.booleanValue()) {
                    For.super.getElement().getSymbol().setCommandsValid(true);
                } else {
                    For.super.getElement().getSymbol().setCommandsValid(false);
                }
            }
            For.super.getFlowchartEditManager().repaintJPanelDiagram();
        }
    }
}

