/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms;

import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.EnumSymbol;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import cz.miroslavbartyzal.psdiagram.app.global.SettingsHolder;
import cz.miroslavbartyzal.psdiagram.app.gui.balloonToolTip.MaxBalloonSizeCallback;
import cz.miroslavbartyzal.psdiagram.app.gui.managers.FlowchartEditManager;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.AbstractSymbolFunctionForm;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.JPanelSymbol;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.ValidationListener;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.WatermarkJTextField;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.documentFilters.ValueFilter;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.documentFilters.VariableFilter;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;

public final class IO
extends AbstractSymbolFunctionForm {
    private final JLabel jLabelDescription;
    private final Symbol mySymbol = EnumSymbol.IO.getInstance(null);
    private final IOValidationListener validationListener = new IOValidationListener();
    private ButtonGroup buttonGroup;
    private JLabel jLabelExampleLabel;
    private JLabel jLabelExamples;
    private JLabel jLabelValue;
    private JLabel jLabelVar;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonInput;
    private JRadioButton jRadioButtonOutput;
    private JTextField jTextFieldValue;
    private JTextField jTextFieldVar;

    public IO(LayoutElement element, FlowchartEditManager flowchartEditManager, MaxBalloonSizeCallback maxBalloonSizeCallback) {
        super(element, flowchartEditManager);
        this.jLabelDescription = new JLabel("<html><p>- vstup/v\u00fdstup pomoc\u00ed dialogu<br />- v p\u0159\u00edpad\u011b, \u017ee p\u0159i vstupn\u00ed operaci c\u00edlov\u00e1 prom\u011bnn\u00e1 neexistuje, bude vytvo\u0159ena</p></html>");
        this.jLabelDescription.setFont(SettingsHolder.SMALLFONT_SYMBOLDESC);
        this.initComponents();
        this.jTextFieldVar.setFont(SettingsHolder.CODEFONT);
        this.jTextFieldValue.setFont(SettingsHolder.CODEFONT);
        this.jLabelExamples.setFont(SettingsHolder.SMALL_CODEFONT);
        if (element.getSymbol().getCommands() != null) {
            if (element.getSymbol().getCommands().containsKey("var")) {
                this.jTextFieldVar.setText(element.getSymbol().getCommands().get("var"));
                this.jRadioButtonInput.setSelected(true);
                this.setInputVisible();
            } else {
                this.jTextFieldValue.setText(element.getSymbol().getCommands().get("value"));
                this.jRadioButtonOutput.setSelected(true);
                this.setOutputVisible();
            }
        } else {
            this.jRadioButtonInput.setSelected(true);
            this.setInputVisible();
        }
        ((AbstractDocument)this.jTextFieldVar.getDocument()).setDocumentFilter(new VariableFilter(this.jTextFieldVar, this.validationListener, maxBalloonSizeCallback));
        ((AbstractDocument)this.jTextFieldValue.getDocument()).setDocumentFilter(new ValueFilter(this.jTextFieldValue, this.validationListener, maxBalloonSizeCallback));
        AbstractSymbolFunctionForm.enhanceWithUndoRedoCapability(this.jTextFieldVar);
        AbstractSymbolFunctionForm.enhanceWithUndoRedoCapability(this.jTextFieldValue);
        this.addDocumentListeners();
        super.trimSize();
    }

    @Override
    void addDocumentListeners() {
        this.jTextFieldVar.getDocument().addDocumentListener(this);
        this.jTextFieldValue.getDocument().addDocumentListener(this);
    }

    @Override
    void generateValues() {
        String var = "";
        String value = "";
        try {
            var = this.jTextFieldVar.getDocument().getText(0, this.jTextFieldVar.getDocument().getLength());
            value = this.jTextFieldValue.getDocument().getText(0, this.jTextFieldValue.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (this.jRadioButtonInput.isSelected()) {
            IO.generateIValues(super.getElement().getSymbol(), var.trim());
        } else if (this.jRadioButtonOutput.isSelected()) {
            IO.generateOValues(super.getElement().getSymbol(), value.trim());
        }
    }

    public static void generateIValues(Symbol symbol, String var) {
        if (!var.isEmpty()) {
            symbol.setDefaultValue(AbstractSymbolFunctionForm.convertToPSDDisplayCommands(var) + " \u2190");
        } else {
            symbol.setDefaultValue(null);
        }
        LinkedHashMap<String, String> commands = new LinkedHashMap<String, String>();
        commands.put("var", var);
        symbol.setCommands(commands);
    }

    public static void generateOValues(Symbol symbol, String value) {
        if (!value.isEmpty()) {
            symbol.setDefaultValue(AbstractSymbolFunctionForm.convertToPSDDisplayCommands(value) + " \u2192");
        } else {
            symbol.setDefaultValue(null);
        }
        LinkedHashMap<String, String> commands = new LinkedHashMap<String, String>();
        commands.put("value", value);
        symbol.setCommands(commands);
    }

    public static boolean isIVarValid(String var) {
        return VariableFilter.isValid(var);
    }

    public static boolean isOValueValid(String value) {
        return ValueFilter.isValid(value);
    }

    private void setInputVisible() {
        this.jLabelValue.setVisible(false);
        this.jTextFieldValue.setVisible(false);
        this.jLabelExampleLabel.setVisible(false);
        this.jLabelExamples.setVisible(false);
        this.jLabelVar.setVisible(true);
        this.jTextFieldVar.setVisible(true);
    }

    private void setOutputVisible() {
        this.jLabelValue.setVisible(true);
        this.jTextFieldValue.setVisible(true);
        this.jLabelExampleLabel.setVisible(true);
        this.jLabelExamples.setVisible(true);
        this.jLabelVar.setVisible(false);
        this.jTextFieldVar.setVisible(false);
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jLabelVar = new JLabel();
        this.jTextFieldVar = new WatermarkJTextField("kam ulo\u017eit co u\u017eivatel nap\u00ed\u0161e");
        this.jLabelValue = new JLabel();
        this.jTextFieldValue = new WatermarkJTextField("co u\u017eivateli zobrazit");
        this.jPanel1 = new JPanelSymbol(this.mySymbol, this.jLabelDescription);
        this.jLabelExampleLabel = new JLabel();
        this.jLabelExamples = new JLabel();
        this.jRadioButtonInput = new JRadioButton();
        this.jRadioButtonOutput = new JRadioButton();
        this.setBorder(BorderFactory.createTitledBorder("<html>Vstup/V\u00fdstup</html>"));
        this.setPreferredSize(new Dimension(187, 493));
        this.jLabelVar.setText("Do prom\u011bnn\u00e9:");
        this.jTextFieldVar.setToolTipText("Prom\u011bnn\u00e1, do kter\u00e9 bude vstupn\u00ed hodnota ulo\u017eena.");
        this.jLabelValue.setText("Hodnota pro v\u00fdstup:");
        this.jTextFieldValue.setToolTipText("<html>\nHodnota, kter\u00e1 se m\u00e1 zobrazit na v\u00fdstupu.<br />\n\u0158et\u011bzcovou hodnotu ohrani\u010dte uvozovkami, matematick\u00e9 operace z\u00e1vorkami.\n</html>");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 159, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 2, Short.MAX_VALUE));
        this.jLabelExampleLabel.setText("P\u0159\u00edklady:");
        this.jLabelExamples.setText("<html>\n- A<br />\n- \"n\u011bjak\u00fd text\"<br />\n- \"hodnota A: \" + A<br />\n- \"A+B = \" + (A+B)<br />\n- pole[2][0]<br />\n</html>");
        this.jLabelExamples.setVerticalAlignment(1);
        this.buttonGroup.add(this.jRadioButtonInput);
        this.jRadioButtonInput.setText("Vstup");
        this.jRadioButtonInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IO.this.jRadioButtonInputActionPerformed(evt);
            }
        });
        this.buttonGroup.add(this.jRadioButtonOutput);
        this.jRadioButtonOutput.setText("V\u00fdstup");
        this.jRadioButtonOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IO.this.jRadioButtonOutputActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelVar, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelValue, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldValue).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelExamples, -2, 0, Short.MAX_VALUE).addComponent(this.jLabelExampleLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldVar).addComponent(this.jRadioButtonInput, -1, -1, Short.MAX_VALUE).addComponent(this.jRadioButtonOutput, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonInput).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonOutput).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelVar).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldVar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldValue, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelExampleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelExamples, -2, -1, -2).addContainerGap(169, Short.MAX_VALUE)));
    }

    private void jRadioButtonInputActionPerformed(ActionEvent evt) {
        this.setInputVisible();
        super.trimSize();
        this.generateValues();
        this.validationListener.validationStateChanged();
        super.fireChangeEventToEditManager();
    }

    private void jRadioButtonOutputActionPerformed(ActionEvent evt) {
        this.setOutputVisible();
        super.trimSize();
        this.generateValues();
        this.validationListener.validationStateChanged();
        super.fireChangeEventToEditManager();
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        this.generateValues();
        super.fireChangeEventToEditManager();
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        this.generateValues();
        super.fireChangeEventToEditManager();
    }

    @Override
    public JTextField getJTextFieldToDispatchKeyEventsAt() {
        if (this.jRadioButtonInput.isSelected()) {
            return this.jTextFieldVar;
        }
        if (this.jRadioButtonOutput.isSelected()) {
            return this.jTextFieldValue;
        }
        return null;
    }

    private class IOValidationListener
    implements ValidationListener {
        private IOValidationListener() {
        }

        @Override
        public void validationStateChanged() {
            if (IO.this.jRadioButtonInput.isSelected()) {
                Boolean varValid = (Boolean)IO.this.jTextFieldVar.getDocument().getProperty("commandValid");
                if (varValid == null) {
                    return;
                }
                IO.super.getElement().getSymbol().setCommandsValid(varValid);
            } else if (IO.this.jRadioButtonOutput.isSelected()) {
                Boolean valueValid = (Boolean)IO.this.jTextFieldValue.getDocument().getProperty("commandValid");
                if (valueValid == null) {
                    return;
                }
                IO.super.getElement().getSymbol().setCommandsValid(valueValid);
            }
            IO.super.getFlowchartEditManager().repaintJPanelDiagram();
        }
    }
}

