/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms;

import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class JPanelSymbol
extends JPanel {
    private Symbol symbol;
    private int minWidth;
    private int minHeight;
    private int symbolBottomPadding = 10;
    public JLabel jLabelDescription;

    protected JPanelSymbol(Symbol symbol, JLabel jLabelDescription) {
        this.symbol = symbol;
        this.jLabelDescription = jLabelDescription;
        super.setBorder(BorderFactory.createTitledBorder("<html>Symbol</html>"));
        super.setLayout(new BoxLayout(this, 3));
        Insets ins = super.getInsets();
        this.minWidth = (int)symbol.getWidth() + ins.left + ins.right;
        this.minHeight = (int)symbol.getHeight() + this.symbolBottomPadding;
        super.add(Box.createRigidArea(new Dimension(0, this.minHeight)));
        if (jLabelDescription != null) {
            jLabelDescription.setSize(jLabelDescription.getPreferredSize());
            jLabelDescription.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent ce) {
                    JPanelSymbol.this.revalidMinHeight();
                }
            });
            this.minHeight += jLabelDescription.getHeight() + ins.top + ins.bottom;
            super.add(jLabelDescription);
        }
        Dimension dim = new Dimension(this.minWidth, this.minHeight);
        super.setMinimumSize(dim);
        super.setPreferredSize(dim);
    }

    private void revalidMinHeight() {
        this.minHeight = super.getLayout().minimumLayoutSize((Container)this).height;
        super.setMinimumSize(new Dimension(this.minWidth, this.minHeight));
        super.revalidate();
    }

    private void initSymbol() {
        Insets ins = super.getInsets();
        Dimension dm = super.getSize();
        this.symbol.setCenterX(dm.width / 2);
        this.symbol.setCenterY((double)ins.top + this.symbol.getHeight() / 2.0);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.initSymbol();
    }

    @Override
    public void setBounds(Rectangle rctngl) {
        this.setBounds(rctngl.x, rctngl.y, rctngl.width, rctngl.height);
    }

    @Override
    public void setMinimumSize(Dimension dmnsn) {
        super.setMinimumSize(new Dimension(this.minWidth, this.minHeight));
    }

    @Override
    public void setPreferredSize(Dimension dmnsn) {
        if (dmnsn.width < this.minWidth) {
            dmnsn.width = this.minWidth;
        }
        if (dmnsn.height < this.minHeight) {
            dmnsn.height = this.minHeight;
        }
        super.setPreferredSize(dmnsn);
        this.initSymbol();
    }

    @Override
    public void setLayout(LayoutManager lm) {
    }

    @Override
    protected void paintComponent(Graphics grphcs) {
        Color borderColor;
        Graphics2D g2d;
        super.paintComponent(grphcs);
        if (grphcs instanceof Graphics2D) {
            g2d = (Graphics2D)grphcs;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            AffineTransform af = g2d.getTransform();
            Color shapeUpColor = this.symbol.getShapeUpColor();
            Color shapeDownColor = this.symbol.getShapeDownColor();
            borderColor = this.symbol.getBorderColor();
            Color ShadowColor = new Color(0, 0, 0, 100);
            if (!super.isEnabled()) {
                shapeUpColor = null;
                borderColor = new Color(100, 100, 100);
                ShadowColor = new Color(0, 0, 0, 50);
            }
            if (shapeUpColor != null) {
                if (this.symbol.hasShadow()) {
                    g2d.setColor(ShadowColor);
                    g2d.translate(2, 2);
                    g2d.fill(this.symbol.getShape());
                    g2d.setTransform(af);
                }
                if (this.symbol.getShapeUpColor().equals(this.symbol.getShapeDownColor())) {
                    g2d.setColor(shapeUpColor);
                } else {
                    g2d.setPaint(new GradientPaint((float)(this.symbol.getX() + this.symbol.getWidth() * 0.25), (float)this.symbol.getY(), shapeUpColor, (float)(this.symbol.getX() + this.symbol.getWidth() * 0.75), (float)(this.symbol.getY() + this.symbol.getHeight()), shapeDownColor));
                }
                g2d.fill(this.symbol.getShape());
            } else if (this.symbol.hasShadow()) {
                g2d.setColor(ShadowColor);
                g2d.translate(1, 1);
                g2d.draw(this.symbol.getShape());
                g2d.setTransform(af);
            }
        } else {
            throw new Error("Parameter Graphics g is not instance of Graphics2D!");
        }
        g2d.setColor(borderColor);
        g2d.draw(this.symbol.getShape());
    }
}

