/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms;

import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.EnumSymbol;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import cz.miroslavbartyzal.psdiagram.app.global.SettingsHolder;
import cz.miroslavbartyzal.psdiagram.app.gui.balloonToolTip.MaxBalloonSizeCallback;
import cz.miroslavbartyzal.psdiagram.app.gui.managers.FlowchartEditManager;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.AbstractSymbolFunctionForm;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.JPanelSymbol;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.ValidationListener;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.WatermarkJTextField;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.documentFilters.ValueFilter;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.documentFilters.VariableFilter;
import java.awt.Dimension;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;

public final class Process
extends AbstractSymbolFunctionForm {
    private final JLabel jLabelDescription;
    private final Symbol mySymbol = EnumSymbol.PROCESS.getInstance(null);
    private final ProcessValidationListener validationListener = new ProcessValidationListener();
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelExamples;
    private JPanel jPanel1;
    private JTextField jTextFieldValue;
    private JTextField jTextFieldVar;

    public Process(LayoutElement element, FlowchartEditManager flowchartEditManager, MaxBalloonSizeCallback maxBalloonSizeCallback) {
        super(element, flowchartEditManager);
        this.jLabelDescription = new JLabel("<html><p>- p\u0159i\u0159azen\u00ed hodnoty do prom\u011bnn\u00e9<br />- v p\u0159\u00edpad\u011b, \u017ee prom\u011bnn\u00e1 neexistuje, bude vytvo\u0159ena</p></html>");
        this.jLabelDescription.setFont(SettingsHolder.SMALLFONT_SYMBOLDESC);
        this.initComponents();
        this.jTextFieldVar.setFont(SettingsHolder.CODEFONT);
        this.jTextFieldValue.setFont(SettingsHolder.CODEFONT);
        this.jLabelExamples.setFont(SettingsHolder.SMALL_CODEFONT);
        if (element.getSymbol().getCommands() != null) {
            this.jTextFieldVar.setText(element.getSymbol().getCommands().get("var"));
            this.jTextFieldValue.setText(element.getSymbol().getCommands().get("value"));
        }
        ((AbstractDocument)this.jTextFieldVar.getDocument()).setDocumentFilter(new VariableFilter(this.jTextFieldVar, this.validationListener, maxBalloonSizeCallback));
        ((AbstractDocument)this.jTextFieldValue.getDocument()).setDocumentFilter(new ValueFilter(this.jTextFieldValue, this.validationListener, maxBalloonSizeCallback));
        AbstractSymbolFunctionForm.enhanceWithUndoRedoCapability(this.jTextFieldVar);
        AbstractSymbolFunctionForm.enhanceWithUndoRedoCapability(this.jTextFieldValue);
        this.addDocumentListeners();
        super.trimSize();
    }

    @Override
    void addDocumentListeners() {
        this.jTextFieldVar.getDocument().addDocumentListener(this);
        this.jTextFieldValue.getDocument().addDocumentListener(this);
    }

    @Override
    void generateValues() {
        String var = "";
        String value = "";
        try {
            var = this.jTextFieldVar.getDocument().getText(0, this.jTextFieldVar.getDocument().getLength());
            value = this.jTextFieldValue.getDocument().getText(0, this.jTextFieldValue.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        Process.generateValues(super.getElement().getSymbol(), var.trim(), value.trim());
    }

    public static void generateValues(Symbol symbol, String var, String value) {
        if (!var.isEmpty() && !value.isEmpty()) {
            symbol.setDefaultValue(AbstractSymbolFunctionForm.convertToPSDDisplayCommands(var) + " \u2190 " + AbstractSymbolFunctionForm.convertToPSDDisplayCommands(value));
        } else {
            symbol.setDefaultValue(null);
        }
        LinkedHashMap<String, String> commands = new LinkedHashMap<String, String>();
        commands.put("var", var);
        commands.put("value", value);
        symbol.setCommands(commands);
    }

    public static boolean areValuesValid(String var, String value) {
        return VariableFilter.isValid(var) && ValueFilter.isValid(value);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldVar = new WatermarkJTextField("do jak\u00e9 prom\u011bnn\u00e9 ukl\u00e1dat");
        this.jLabel2 = new JLabel();
        this.jTextFieldValue = new WatermarkJTextField("co ulo\u017eit");
        this.jPanel1 = new JPanelSymbol(this.mySymbol, this.jLabelDescription);
        this.jLabel3 = new JLabel();
        this.jLabelExamples = new JLabel();
        this.setBorder(BorderFactory.createTitledBorder("<html>Zpracov\u00e1n\u00ed</html>"));
        this.setPreferredSize(new Dimension(187, 493));
        this.jLabel1.setText("Prom\u011bnn\u00e1:");
        this.jTextFieldVar.setToolTipText("Prom\u011bnn\u00e1, do kter\u00e9 se ulo\u017e\u00ed hodnota n\u00ed\u017ee.");
        this.jLabel2.setText("Hodnota:");
        this.jTextFieldValue.setToolTipText("<html>\nHodnota, kter\u00e1 se ulo\u017e\u00ed do prom\u011bnn\u00e9 v\u00fd\u0161e.<br />\n\u0158et\u011bzcovou hodnotu ohrani\u010dte uvozovkami.\n</html>");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jLabel3.setText("P\u0159\u00edklady:");
        this.jLabelExamples.setText("<html>\n- A; 0<br />\n- B; B + A<br />\n- D; A // 5<br />\n- A; Math.sqrt(A*2)<br />\n- A; Math.floor(<br />Math.random()*10)+1<br />\n- A; B % C<br />\n- C; \"text\"<br />\n- C; \"hodnota A: \" + A<br />\n- A; \"B na druhou: \" + Math.pow(B,2)<br />\n- A; \"retezec\"[2]<br />\n- D; false<br />\n- pole; [1, 2, 3]<br />\n- pole[3]; 4<br />\n- pole[pole.length]; 5<br />\n- E; pole[2][0]<br />\n</html>");
        this.jLabelExamples.setVerticalAlignment(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldValue).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelExamples).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldVar));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldVar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldValue, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelExamples, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        this.generateValues();
        super.fireChangeEventToEditManager();
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        this.generateValues();
        super.fireChangeEventToEditManager();
    }

    @Override
    public JTextField getJTextFieldToDispatchKeyEventsAt() {
        return this.jTextFieldVar;
    }

    private class ProcessValidationListener
    implements ValidationListener {
        private ProcessValidationListener() {
        }

        @Override
        public void validationStateChanged() {
            Boolean varValid = (Boolean)Process.this.jTextFieldVar.getDocument().getProperty("commandValid");
            Boolean valueValid = (Boolean)Process.this.jTextFieldValue.getDocument().getProperty("commandValid");
            if (varValid == null || valueValid == null) {
                return;
            }
            if (varValid.booleanValue() && valueValid.booleanValue()) {
                Process.super.getElement().getSymbol().setCommandsValid(true);
            } else {
                Process.super.getElement().getSymbol().setCommandsValid(false);
            }
            Process.super.getFlowchartEditManager().repaintJPanelDiagram();
        }
    }
}

