/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms;

import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

public class SquiggleHighlighter
extends DefaultHighlighter.DefaultHighlightPainter {
    private static final int SIZE = 2;
    private static final int MIN_BORDER = 3;
    private int p0;
    private int p1;

    public SquiggleHighlighter(Color color, int p0, int p1) throws BadLocationException {
        super(color);
        if (p0 < 0) {
            throw new BadLocationException("Invalid start offset", p0);
        }
        if (p1 < p0) {
            throw new BadLocationException("Invalid end offset", p1);
        }
        this.p0 = p0;
        this.p1 = p1;
    }

    public int getP0() {
        return this.p0;
    }

    public int getP1() {
        if (this.p1 == 0) {
            return 1;
        }
        return this.p1;
    }

    @Override
    public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
        Rectangle r = this.getDrawingArea(offs0, offs1, bounds, view);
        if (r != null) {
            Color color = this.getColor();
            if (color == null) {
                g.setColor(c.getSelectionColor());
            } else {
                g.setColor(color);
            }
            this.paintSquiggle(g, r);
        }
        return r;
    }

    private Rectangle getDrawingArea(int offs0, int offs1, Shape bounds, View view) {
        if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
            Rectangle alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            return alloc;
        }
        try {
            Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
            Rectangle r = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            return r;
        }
        catch (BadLocationException e) {
            MyExceptionHandler.handle(e);
            return null;
        }
    }

    private void paintSquiggle(Graphics g, Rectangle r) {
        Rectangle clipRec = g.getClipBounds();
        if (clipRec.y > 3) {
            int hInc = 1;
            if (hInc > clipRec.y - 3) {
                hInc = clipRec.y - 3;
            }
            r.height += hInc;
            g.setClip(clipRec.x, clipRec.y, clipRec.width, r.height);
        }
        if (this.p1 == 0) {
            r.width = 0;
            g.setClip(r.x - 2, clipRec.y, clipRec.width + 2, clipRec.height);
        }
        if (r.width < 4) {
            r.x = r.x + r.width / 2 - 2;
            r.width = 5;
        }
        int x = r.x;
        int y = r.y + r.height - 2;
        int delta = -2;
        if ((r.width - 1) / 2 % 2 == 1) {
            y -= 2;
            delta = 2;
        }
        while (x + 2 < r.x + r.width) {
            g.drawLine(x, y, x + 2, y + delta);
            x += 2;
            y += delta;
            delta = -delta;
        }
        g.setClip(clipRec.x, clipRec.y, clipRec.width, clipRec.height);
    }
}

