/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Timer;
import javax.swing.border.AbstractBorder;

public class UnknownSyntaxJTextFieldBorder
extends AbstractBorder {
    private static final int ANIM_TIME = 1500;
    private static final int FADEIN_TIME = 1000;
    private static final int FPS = 30;
    private final int stepTime = 33;
    private final int stepsPerAnim = 45;
    private final float fadeInInc = 0.033f;
    private final double paddingHeightRatio = 0.25;
    private float currentTransparency = 0.033f;
    private int currentStep = 0;
    private Timer nextPaintTimer = null;
    private boolean incStep = true;
    private AbstractBorder defaultBorder;

    public UnknownSyntaxJTextFieldBorder(AbstractBorder defaultBorder) {
        this.defaultBorder = defaultBorder;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.defaultBorder.paintBorder(c, g, x, y, width, height);
        this.paintAnimation(c, g, x, y, width, height);
    }

    public void paintAnimation(final Component c, Graphics g, int x, int y, int width, int height) {
        if (this.incStep) {
            this.incStep = false;
            ++this.currentStep;
            if (this.currentStep > 45) {
                this.currentStep = 1;
            }
        }
        double currentProgress = (double)this.currentStep / 45.0;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.currentTransparency < 1.0f) {
            g2d.setComposite(AlphaComposite.SrcOver.derive(this.currentTransparency));
            this.currentTransparency += 0.033f;
        }
        double padding = 0.25 * (double)height;
        double shapeSize = (double)height - 2.0 * padding;
        double outterPadding = padding * 0.3;
        double shapeX = (double)(x + width) - shapeSize - padding;
        double shapeY = (double)y + padding;
        Rectangle2D.Double outterBounds = new Rectangle2D.Double(shapeX - outterPadding, shapeY - outterPadding, shapeSize + outterPadding * 2.0, shapeSize + outterPadding * 2.0);
        Ellipse2D.Double circleOutter = new Ellipse2D.Double(outterBounds.x, outterBounds.y, outterBounds.width, outterBounds.height);
        g2d.setColor(c.getBackground());
        g2d.fill(circleOutter);
        Ellipse2D.Double circle = new Ellipse2D.Double(shapeX, shapeY, shapeSize, shapeSize);
        g2d.setColor(Color.BLACK);
        g2d.draw(circle);
        Arc2D.Double arcMask = new Arc2D.Double(outterBounds, -360.0 * currentProgress, 70.0, 2);
        g2d.setColor(c.getBackground());
        g2d.fill(arcMask);
        if (this.nextPaintTimer == null) {
            this.nextPaintTimer = new Timer(33, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UnknownSyntaxJTextFieldBorder.this.incStep = true;
                    if (c.isShowing()) {
                        c.repaint();
                    }
                }
            });
            this.nextPaintTimer.setRepeats(false);
        }
        this.nextPaintTimer.start();
    }

    public AbstractBorder getDefaultBorder() {
        return this.defaultBorder;
    }

    public void initFadeIn() {
        this.currentTransparency = 0.033f;
    }

    public void setDefaultBorder(AbstractBorder defaultBorder, Component c, boolean fadeIn) {
        this.defaultBorder = defaultBorder;
        if (fadeIn) {
            this.currentTransparency = 0.033f;
        }
        c.repaint();
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(Component c) {
        return this.defaultBorder.getBaselineResizeBehavior(c);
    }

    @Override
    public int getBaseline(Component c, int width, int height) {
        return this.defaultBorder.getBaseline(c, width, height);
    }

    @Override
    public Rectangle getInteriorRectangle(Component c, int x, int y, int width, int height) {
        return this.defaultBorder.getInteriorRectangle(c, x, y, width, height);
    }

    @Override
    public boolean isBorderOpaque() {
        return this.defaultBorder.isBorderOpaque();
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return this.defaultBorder.getBorderInsets(c, insets);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.defaultBorder.getBorderInsets(c);
    }
}

