/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class WatermarkJTextField
extends JTextField {
    private final WatermarkFocusListener focusListener = new WatermarkFocusListener();
    private final WatermarkDocumentListener documentListener = new WatermarkDocumentListener();
    private String watermarkText = null;
    private boolean watermarkVisible = false;
    private boolean hideOnFocus = false;

    public WatermarkJTextField(String watermarkText) {
        this.watermarkText = watermarkText;
        super.addFocusListener(this.focusListener);
        super.getDocument().addDocumentListener(this.documentListener);
        this.updateWatermarkVisibility();
    }

    public WatermarkJTextField(String text, String watermarkText) {
        super(text);
        this.watermarkText = watermarkText;
        super.addFocusListener(this.focusListener);
        super.getDocument().addDocumentListener(this.documentListener);
        this.updateWatermarkVisibility();
    }

    public WatermarkJTextField(int columns, String watermarkText) {
        super(columns);
        this.watermarkText = watermarkText;
        super.addFocusListener(this.focusListener);
        super.getDocument().addDocumentListener(this.documentListener);
        this.updateWatermarkVisibility();
    }

    public WatermarkJTextField(String text, int columns, String watermarkText) {
        super(text, columns);
        this.watermarkText = watermarkText;
        super.addFocusListener(this.focusListener);
        super.getDocument().addDocumentListener(this.documentListener);
        this.updateWatermarkVisibility();
    }

    public WatermarkJTextField(Document doc, String text, int columns, String watermarkText) {
        super(doc, text, columns);
        this.watermarkText = watermarkText;
        super.addFocusListener(this.focusListener);
        super.getDocument().addDocumentListener(this.documentListener);
        this.updateWatermarkVisibility();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.watermarkVisible) {
            if (g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setFont(super.getFont());
                g2d.setColor(new Color(195, 195, 195));
                Insets insets = super.getInsets();
                FontMetrics metrics = g2d.getFontMetrics();
                g2d.drawString(this.watermarkText, (float)insets.left + (float)metrics.getMaxAdvance() * 0.3f, (float)(insets.top + metrics.getAscent() + 1));
            } else {
                throw new Error("Parameter Graphics g is not instance of Graphics2D!");
            }
        }
    }

    public String getWatermarkText() {
        return this.watermarkText;
    }

    public void setWatermarkText(String watermarkText) {
        this.watermarkText = watermarkText;
        this.updateWatermarkVisibility();
    }

    public boolean isHideOnFocus() {
        return this.hideOnFocus;
    }

    public void setHideOnFocus(boolean hideOnFocus) {
        this.hideOnFocus = hideOnFocus;
        this.updateWatermarkVisibility();
    }

    public boolean isWatermarkVisible() {
        return this.watermarkVisible;
    }

    private boolean isTextFieldEmpty() {
        String text = "";
        try {
            text = this.getDocument().getText(0, this.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return text.isEmpty();
    }

    private void updateWatermarkVisibility() {
        boolean prevWatermarkVisible = this.watermarkVisible;
        boolean bl = this.watermarkVisible = this.isTextFieldEmpty() && (!this.hideOnFocus || !super.isFocusOwner());
        if (prevWatermarkVisible != this.watermarkVisible) {
            super.repaint();
        }
    }

    private class WatermarkFocusListener
    implements FocusListener {
        private WatermarkFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            WatermarkJTextField.this.updateWatermarkVisibility();
        }

        @Override
        public void focusLost(FocusEvent e) {
            WatermarkJTextField.this.updateWatermarkVisibility();
        }
    }

    private class WatermarkDocumentListener
    implements DocumentListener {
        private WatermarkDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            WatermarkJTextField.this.updateWatermarkVisibility();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            WatermarkJTextField.this.updateWatermarkVisibility();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            WatermarkJTextField.this.updateWatermarkVisibility();
        }
    }
}

