/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.documentFilters;

import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import cz.miroslavbartyzal.psdiagram.app.global.StringFunctions;
import cz.miroslavbartyzal.psdiagram.app.gui.balloonToolTip.MaxBalloonSizeCallback;
import cz.miroslavbartyzal.psdiagram.app.gui.balloonToolTip.PSDBalloonToolTip;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.BadSyntaxJTextFieldBorder;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.SquiggleHighlighter;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.UnknownSyntaxJTextFieldBorder;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.ValidationListener;
import cz.miroslavbartyzal.psdiagram.app.parser.ParseError;
import cz.miroslavbartyzal.psdiagram.app.parser.ParseResult;
import cz.miroslavbartyzal.psdiagram.app.parser.psd.AntlrPsdParser;
import cz.miroslavbartyzal.psdiagram.app.parser.psd.EnumRule;
import cz.miroslavbartyzal.psdiagram.app.parser.psd.PsdParser;
import cz.miroslavbartyzal.psdiagram.app.parser.psd.PsdParserListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public abstract class AbstractFilter
extends DocumentFilter {
    private static final int MAX_CHARS = 800;
    private final PSDBalloonToolTip balloonToolTip;
    private final JTextField parentJTextField;
    private final ValidationListener validationListener;
    private final Border validBorder;
    private final Border errorBorder;
    private final UnknownSyntaxJTextFieldBorder unknownSyntaxBorder;
    private Border currentBorder;
    private final List<Object> highlighterTags = new ArrayList<Object>();
    private final PsdParserListener syntaxErrorListener = new SyntaxErrorListener();
    private final PsdParser PARSER = new AntlrPsdParser();

    public AbstractFilter(JTextField parentJTextField, ValidationListener validationListener, MaxBalloonSizeCallback maxBalloonSizeCallback) {
        this.parentJTextField = parentJTextField;
        this.validationListener = validationListener;
        this.currentBorder = this.validBorder = parentJTextField.getBorder();
        this.errorBorder = new BadSyntaxJTextFieldBorder((AbstractBorder)this.validBorder);
        this.unknownSyntaxBorder = new UnknownSyntaxJTextFieldBorder((AbstractBorder)this.validBorder);
        this.balloonToolTip = new PSDBalloonToolTip(parentJTextField, maxBalloonSizeCallback);
    }

    protected static boolean parseInput(String input, EnumRule rule) {
        if (input.matches("^\\s*$")) {
            return true;
        }
        return rule.parse(new AntlrPsdParser(), input);
    }

    public void parseInputAndUpdateGUI() {
        this.parseInputAndUpdateGUI(this.parentJTextField.getText());
    }

    protected void parseInputAndUpdateGUI(String input) {
        this.discardParseErrorInfos();
        boolean isEmpty = input.matches("^\\s*$");
        if (!isEmpty) {
            this.getRule().parseReportErrors(this.PARSER, input, this.syntaxErrorListener);
        } else {
            this.PARSER.stopParsing();
            this.syntaxErrorListener.onValidationComplete(true);
        }
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(fb.getDocument().getText(0, fb.getDocument().getLength()));
            sb.insert(offset, text);
            if (sb.length() > 800) {
                this.balloonToolTip.showTemporaryMessage("Bylo zabr\u00e1n\u011bno p\u0159ekro\u010den\u00ed maxim\u00e1ln\u00ed d\u00e9lky p\u0159\u00edkazu.", 2000);
                return;
            }
            this.parseInputAndUpdateGUI(sb.toString());
            fb.insertString(offset, text, attr);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(fb.getDocument().getText(0, fb.getDocument().getLength()));
            sb.delete(offset, offset + length);
            this.parseInputAndUpdateGUI(sb.toString());
            fb.remove(offset, length);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(fb.getDocument().getText(0, fb.getDocument().getLength()));
            sb.replace(offset, offset + length, text);
            if (sb.length() > 800) {
                this.balloonToolTip.showTemporaryMessage("Bylo zabr\u00e1n\u011bno p\u0159ekro\u010den\u00ed maxim\u00e1ln\u00ed d\u00e9lky p\u0159\u00edkazu.", 2000);
                return;
            }
            this.parseInputAndUpdateGUI(sb.toString());
            fb.replace(offset, length, text, attrs);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected final void refreshSyntaxInfo(boolean isValid, boolean parsingInProgress) {
        Boolean commandValidProperty;
        if (isValid) {
            if (!parsingInProgress) {
                if (this.currentBorder != this.validBorder) {
                    this.parentJTextField.setBorder(this.validBorder);
                    this.currentBorder = this.validBorder;
                }
            } else if (this.currentBorder != this.unknownSyntaxBorder || this.unknownSyntaxBorder.getDefaultBorder() != this.validBorder) {
                this.unknownSyntaxBorder.setDefaultBorder((AbstractBorder)this.validBorder, this.parentJTextField, true);
                this.parentJTextField.setBorder(this.unknownSyntaxBorder);
                this.currentBorder = this.unknownSyntaxBorder;
            } else {
                this.unknownSyntaxBorder.initFadeIn();
            }
        } else if (!parsingInProgress) {
            if (this.currentBorder != this.errorBorder) {
                this.parentJTextField.setBorder(this.errorBorder);
                this.currentBorder = this.errorBorder;
            }
        } else if (this.currentBorder != this.unknownSyntaxBorder || this.unknownSyntaxBorder.getDefaultBorder() != this.errorBorder) {
            this.unknownSyntaxBorder.setDefaultBorder((AbstractBorder)this.errorBorder, this.parentJTextField, false);
            this.parentJTextField.setBorder(this.unknownSyntaxBorder);
            this.currentBorder = this.unknownSyntaxBorder;
        }
        if (!(parsingInProgress || (commandValidProperty = (Boolean)this.parentJTextField.getDocument().getProperty("commandValid")) != null && commandValidProperty == isValid)) {
            this.parentJTextField.getDocument().putProperty("commandValid", isValid);
            this.validationListener.validationStateChanged();
        }
    }

    private void underlineParseErrors(ParseResult parseResult) {
        if (!this.highlighterTags.isEmpty()) {
            for (Object highlighterTag : this.highlighterTags) {
                this.parentJTextField.getHighlighter().removeHighlight(highlighterTag);
            }
            this.highlighterTags.clear();
        }
        if (parseResult != null) {
            for (ParseError errorInfo : parseResult.getParseErrors()) {
                if (errorInfo.getStartIndex() < 0 || errorInfo.getEndIndex() < errorInfo.getStartIndex()) continue;
                try {
                    SquiggleHighlighter squiggler = new SquiggleHighlighter(Color.RED, errorInfo.getStartIndex(), errorInfo.getEndIndex());
                    this.highlighterTags.add(this.parentJTextField.getHighlighter().addHighlight(squiggler.getP0(), squiggler.getP1(), squiggler));
                }
                catch (BadLocationException ex) {
                    MyExceptionHandler.handle(ex);
                }
            }
        }
    }

    private void showParseErrorsAsBalloonInfo(ParseResult parseResult) {
        this.balloonToolTip.dismiss();
        if (parseResult == null || parseResult.isInputValid()) {
            this.balloonToolTip.wipeMessage();
            return;
        }
        ArrayList<String> messagesAndCommands = new ArrayList<String>();
        Iterator<ParseError> it = parseResult.getParseErrors().iterator();
        while (it.hasNext()) {
            ParseError errorInfo = it.next();
            Object message = "<html>";
            message = errorInfo.getErrorMessage() == null || errorInfo.getErrorMessage().length() == 0 ? (String)message + "Detekov\u00e1na syntaktick\u00e1 chyba!" : (String)message + StringFunctions.escapeHTML(errorInfo.getErrorMessage()).replaceAll("\\n", "<br/>");
            String command = parseResult.getInput();
            message = (String)message + "<br/>&gt;&nbsp;&nbsp;";
            if (errorInfo.getStartIndex() >= 0 && errorInfo.getEndIndex() >= errorInfo.getStartIndex()) {
                message = (String)message + StringFunctions.escapeHTML(command.substring(0, errorInfo.getStartIndex()));
                message = (String)message + "<span style=\"color: #ff0000;";
                message = errorInfo.getStartIndex() == errorInfo.getEndIndex() ? (String)message + " font-family: PSDSpecialSymbols; font-size: 18px;\">\u02f0" : (String)message + " font-weight: bold;\">" + StringFunctions.escapeHTML(command.substring(errorInfo.getStartIndex(), errorInfo.getEndIndex()));
                message = (String)message + "</span>";
                message = (String)message + StringFunctions.escapeHTML(command.substring(errorInfo.getEndIndex()));
            } else {
                message = (String)message + StringFunctions.escapeHTML(command);
            }
            if (it.hasNext()) {
                message = (String)message + "<br/><br/>";
            }
            message = (String)message + "</html>";
            messagesAndCommands.add((String)message);
        }
        this.balloonToolTip.showMessages(messagesAndCommands, -1);
    }

    private void discardParseErrorInfos() {
        this.refreshSyntaxInfo(true, true);
        this.underlineParseErrors(null);
        this.balloonToolTip.wipeMessage();
    }

    abstract EnumRule getRule();

    private class SyntaxErrorListener
    implements PsdParserListener {
        private SyntaxErrorListener() {
        }

        @Override
        public void onValidationComplete(boolean isValid) {
            if (isValid) {
                AbstractFilter.this.refreshSyntaxInfo(isValid, false);
            } else {
                AbstractFilter.this.refreshSyntaxInfo(isValid, true);
            }
        }

        @Override
        public void onRecoveryFinished(ParseResult parseResult) {
            AbstractFilter.this.refreshSyntaxInfo(false, false);
            AbstractFilter.this.underlineParseErrors(parseResult);
            AbstractFilter.this.showParseErrorsAsBalloonInfo(parseResult);
        }
    }
}

