/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.network;

import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import cz.miroslavbartyzal.psdiagram.app.global.SettingsHolder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class TimeCollector {
    public static Date getTimeAndDate(String url) {
        try {
            return TimeCollector.getTimeAndDate(new URL(url));
        }
        catch (MalformedURLException ex) {
            MyExceptionHandler.handle(ex);
            return null;
        }
    }

    public static Date getTimeAndDate(URL url) {
        try {
            URLConnection urlConn = url.openConnection();
            urlConn.setConnectTimeout(15000);
            urlConn.setReadTimeout(15000);
            urlConn.setRequestProperty("accept", "Date");
            urlConn.setRequestProperty("user-agent", "psdiagram-" + SettingsHolder.PSDIAGRAM_VERSION + "(" + SettingsHolder.PSDIAGRAM_BUILD_NUMBER + ")");
            urlConn.setRequestProperty("psdiagram-version", SettingsHolder.PSDIAGRAM_VERSION + "(" + SettingsHolder.PSDIAGRAM_BUILD_NUMBER + ")");
            urlConn.connect();
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
            return sdf.parse(urlConn.getHeaderField("Date"));
        }
        catch (IOException | NullPointerException | ParseException ex) {
            MyExceptionHandler.handle(ex);
            return null;
        }
    }
}

