/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.network;

import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import cz.miroslavbartyzal.psdiagram.app.network.HTTPParser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;

public class URLFileDownloader
extends SwingWorker<File, Void> {
    private static final int BUFFER_SIZE = 1024;
    private String status;
    private String serverURL;
    private Map<String, String> parameters;
    private File downloadFolder;
    private String fileName;
    private DownloadFinishListener downloadFinishedListener;
    private final Timer tmrSpeed = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            URLFileDownloader.this.riseBandwithInfo();
        }
    });
    private long timerData = 0L;
    private long downloadedDataSize;

    private void riseBandwithInfo() {
        long currentData = this.downloadedDataSize;
        this.firePropertyChange("speed", null, (int)(currentData - this.timerData));
        this.timerData = currentData;
        this.firePropertyChange("currentsize", null, currentData);
    }

    public void sendRequest(String serverURL, Map<String, String> parameters, File downloadFolder, String fileName, DownloadFinishListener downloadFinishedListener) {
        this.serverURL = serverURL;
        this.parameters = parameters;
        this.downloadFolder = downloadFolder;
        this.fileName = fileName;
        this.downloadFinishedListener = downloadFinishedListener;
        super.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected File doInBackground() throws Exception {
        File file;
        URLConnection conn;
        URL url;
        try {
            url = HTTPParser.urlConcatenation(this.serverURL, this.parameters);
        }
        catch (UnsupportedEncodingException ex) {
            MyExceptionHandler.handle(ex);
            super.firePropertyChange("error", null, "chyba: \u0161patn\u00e9 k\u00f3dov\u00e1n\u00ed URL");
            return null;
        }
        catch (MalformedURLException ex) {
            MyExceptionHandler.handle(ex);
            super.firePropertyChange("error", null, "chyba: \u0161patn\u00fd form\u00e1t URL");
            return null;
        }
        this.fireStatusChanged("navazuji spojen\u00ed...");
        try {
            conn = url.openConnection();
        }
        catch (IOException ex) {
            MyExceptionHandler.handle(ex);
            super.firePropertyChange("error", null, "chyba p\u0159i navazov\u00e1n\u00ed spojen\u00ed");
            return null;
        }
        conn.setDoOutput(true);
        conn.setConnectTimeout(15000);
        conn.setReadTimeout(15000);
        long filesize = conn.getContentLengthLong();
        if (filesize > 0L) {
            super.firePropertyChange("filesize", null, filesize);
        }
        if (!this.downloadFolder.exists()) {
            this.downloadFolder.mkdirs();
        }
        if (this.fileName == null) {
            this.fileName = this.getFilename(conn, "downloadedfile");
        }
        if ((file = new File(this.downloadFolder, this.fileName)).exists() && !file.delete()) {
            super.firePropertyChange("error", null, "chyba: soubor \"" + file.getName() + "\" ji\u017e existuje a nelze smazat");
            return null;
        }
        FileOutputStream fos = null;
        FilterOutputStream bout = null;
        BufferedInputStream rd = null;
        try {
            fos = new FileOutputStream(file);
            bout = new BufferedOutputStream(fos, 1024);
            byte[] data = new byte[1024];
            int chunkSize = 0;
            this.downloadedDataSize = 0L;
            this.fireStatusChanged("otev\u00edr\u00e1m vstupn\u00ed stream...");
            try {
                rd = new BufferedInputStream(conn.getInputStream());
            }
            catch (IOException ex) {
                MyExceptionHandler.handle(ex);
                super.firePropertyChange("error", null, "chyba p\u0159i otev\u00edr\u00e1n\u00ed vstupn\u00edho streamu");
                File file2 = null;
                try {
                    if (bout != null) {
                        bout.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                    if (rd != null) {
                        rd.close();
                    }
                }
                catch (IOException ex2) {
                    MyExceptionHandler.handle(ex2);
                    this.tmrSpeed.stop();
                    this.riseBandwithInfo();
                    super.firePropertyChange("error", null, "chyba p\u0159i uzav\u00edr\u00e1n\u00ed streamu");
                    return null;
                }
                return file2;
            }
            this.tmrSpeed.start();
            this.fireStatusChanged("stahuji...");
            while (!super.isCancelled() && (chunkSize = rd.read(data, 0, 1024)) != -1) {
                try {
                    ((BufferedOutputStream)bout).write(data, 0, chunkSize);
                }
                catch (IOException ex) {
                    MyExceptionHandler.handle(ex);
                    this.tmrSpeed.stop();
                    this.riseBandwithInfo();
                    super.firePropertyChange("error", null, "chyba p\u0159i stahov\u00e1n\u00ed souboru");
                    File file3 = null;
                    try {
                        if (bout != null) {
                            bout.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                        if (rd != null) {
                            rd.close();
                        }
                    }
                    catch (IOException ex3) {
                        MyExceptionHandler.handle(ex3);
                        this.tmrSpeed.stop();
                        this.riseBandwithInfo();
                        super.firePropertyChange("error", null, "chyba p\u0159i uzav\u00edr\u00e1n\u00ed streamu");
                        return null;
                    }
                    return file3;
                }
                this.downloadedDataSize += (long)chunkSize;
                int progress = (int)(this.downloadedDataSize * 100L / filesize);
                if (super.getProgress() == progress) continue;
                super.setProgress(progress);
            }
        }
        finally {
            try {
                if (bout != null) {
                    bout.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (rd != null) {
                    rd.close();
                }
            }
            catch (IOException ex) {
                MyExceptionHandler.handle(ex);
                this.tmrSpeed.stop();
                this.riseBandwithInfo();
                super.firePropertyChange("error", null, "chyba p\u0159i uzav\u00edr\u00e1n\u00ed streamu");
                return null;
            }
        }
        this.tmrSpeed.stop();
        this.riseBandwithInfo();
        if (super.isCancelled()) {
            file.delete();
            this.fireStatusChanged("stahov\u00e1n\u00ed zru\u0161eno");
            return null;
        }
        this.fireStatusChanged("stahov\u00e1n\u00ed \u00fasp\u011b\u0161n\u011b dokon\u010deno");
        return file;
    }

    @Override
    protected void done() {
        if (this.downloadFinishedListener != null && !super.isCancelled()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        URLFileDownloader.this.downloadFinishedListener.onDownloadFinished((File)URLFileDownloader.super.get());
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        MyExceptionHandler.handle(ex);
                        URLFileDownloader.super.firePropertyChange("error", null, "intern\u00ed chyba");
                        URLFileDownloader.this.downloadFinishedListener.onDownloadFinished(null);
                    }
                }
            });
        }
    }

    private void fireStatusChanged(String newStatus) {
        super.firePropertyChange("status", this.status, newStatus);
        this.status = newStatus;
    }

    private String getFilename(URLConnection conn, String defaultname) {
        String filename = null;
        String header = conn.getHeaderField("Content-Disposition");
        if (header != null && header.contains("filename=")) {
            filename = header.substring(header.indexOf("filename=") + 9);
        }
        if (filename == null || filename.equals("")) {
            filename = defaultname;
        }
        return filename;
    }

    public static interface DownloadFinishListener {
        public void onDownloadFinished(File var1);
    }
}

