/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.network;

import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import cz.miroslavbartyzal.psdiagram.app.network.HTTPParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class URLPostUploader
extends SwingWorker<Integer, Void> {
    private String status;
    private String serverURL;
    private Map<String, String> parameters;
    private UploadFinishListener uploadFinishedListener;

    public void sendRequest(String serverURL, Map<String, String> parameters, UploadFinishListener uploadFinishedListener) {
        this.serverURL = serverURL;
        this.parameters = parameters;
        this.uploadFinishedListener = uploadFinishedListener;
        super.execute();
    }

    @Override
    protected Integer doInBackground() throws Exception {
        HttpURLConnection conn;
        URL url;
        try {
            url = HTTPParser.urlConcatenation(this.serverURL, null);
        }
        catch (UnsupportedEncodingException ex) {
            MyExceptionHandler.handle(ex);
            super.firePropertyChange("error", null, "chyba: \u0161patn\u00e9 k\u00f3dov\u00e1n\u00ed URL");
            return null;
        }
        catch (MalformedURLException ex) {
            MyExceptionHandler.handle(ex);
            super.firePropertyChange("error", null, "chyba: \u0161patn\u00fd form\u00e1t URL");
            return null;
        }
        this.fireStatusChanged("navazuji spojen\u00ed...");
        try {
            conn = (HttpURLConnection)url.openConnection();
        }
        catch (IOException ex) {
            MyExceptionHandler.handle(ex);
            super.firePropertyChange("error", null, "chyba p\u0159i navazov\u00e1n\u00ed spojen\u00ed");
            return null;
        }
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setConnectTimeout(15000);
        conn.setReadTimeout(15000);
        StringJoiner sj = new StringJoiner("&");
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            sj.add(URLEncoder.encode(entry.getKey(), "UTF-8") + "=" + URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
        int length = out.length;
        conn.setFixedLengthStreamingMode(length);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        try {
            conn.connect();
            this.fireStatusChanged("otev\u00edr\u00e1m v\u00fdstupn\u00ed stream...");
            try (OutputStream os = conn.getOutputStream();){
                this.fireStatusChanged("odes\u00edl\u00e1m informace...");
                os.write(out);
            }
        }
        catch (IOException ex) {
            MyExceptionHandler.handle(ex);
            super.firePropertyChange("error", null, "chyba p\u0159i odes\u00edl\u00e1n\u00ed informac\u00ed");
            return null;
        }
        int httpResponseCode = conn.getResponseCode();
        this.fireStatusChanged("odesl\u00e1n\u00ed \u00fasp\u011b\u0161n\u011b dokon\u010deno");
        return httpResponseCode;
    }

    private void sendFile(OutputStream out, String name, InputStream in, String fileName) throws UnsupportedEncodingException, IOException {
        String o = "Content-Disposition: form-data; name=\"" + URLEncoder.encode(name, "UTF-8") + "\"; filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\"\r\n\r\n";
        out.write(o.getBytes(StandardCharsets.UTF_8));
        byte[] buffer = new byte[2048];
        int n = 0;
        while (n >= 0) {
            out.write(buffer, 0, n);
            n = in.read(buffer);
        }
        out.write("\r\n".getBytes(StandardCharsets.UTF_8));
    }

    private void sendField(OutputStream out, String name, String field) throws UnsupportedEncodingException, IOException {
        String o = "Content-Disposition: form-data; name=\"" + URLEncoder.encode(name, "UTF-8") + "\"\r\n\r\n";
        out.write(o.getBytes(StandardCharsets.UTF_8));
        out.write(URLEncoder.encode(field, "UTF-8").getBytes(StandardCharsets.UTF_8));
        out.write("\r\n".getBytes(StandardCharsets.UTF_8));
    }

    private void fireStatusChanged(String newStatus) {
        super.firePropertyChange("status", this.status, newStatus);
        this.status = newStatus;
    }

    @Override
    protected void done() {
        if (this.uploadFinishedListener != null && !super.isCancelled()) {
            SwingUtilities.invokeLater(() -> {
                try {
                    this.uploadFinishedListener.onUploadFinished((Integer)URLPostUploader.super.get());
                }
                catch (InterruptedException | ExecutionException ex) {
                    MyExceptionHandler.handle(ex);
                    URLPostUploader.super.firePropertyChange("error", null, "intern\u00ed chyba");
                    this.uploadFinishedListener.onUploadFinished(null);
                }
            });
        }
    }

    public static interface UploadFinishListener {
        public void onUploadFinished(Integer var1);
    }
}

