/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.network;

import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import cz.miroslavbartyzal.psdiagram.app.network.HTTPParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class URLStringDownloader
extends SwingWorker<String, Void> {
    private String status;
    private String serverURL;
    private Map<String, String> parameters;
    private DownloadFinishListener downloadFinishedListener;
    private Charset charset;

    public void sendRequest(String serverURL, Map<String, String> parameters, DownloadFinishListener downloadFinishedListener) {
        this.serverURL = serverURL;
        this.parameters = parameters;
        this.downloadFinishedListener = downloadFinishedListener;
        super.execute();
    }

    @Override
    protected String doInBackground() throws Exception {
        BufferedReader rd;
        URLConnection conn;
        URL url;
        try {
            url = HTTPParser.urlConcatenation(this.serverURL, this.parameters);
        }
        catch (UnsupportedEncodingException ex) {
            MyExceptionHandler.handle(ex);
            super.firePropertyChange("error", null, "chyba: \u0161patn\u00e9 k\u00f3dov\u00e1n\u00ed URL");
            return null;
        }
        catch (MalformedURLException ex) {
            MyExceptionHandler.handle(ex);
            super.firePropertyChange("error", null, "chyba: \u0161patn\u00fd form\u00e1t URL");
            return null;
        }
        this.fireStatusChanged("navazuji spojen\u00ed...");
        try {
            conn = url.openConnection();
        }
        catch (IOException ex) {
            MyExceptionHandler.handle(ex);
            super.firePropertyChange("error", null, "chyba p\u0159i navazov\u00e1n\u00ed spojen\u00ed");
            return null;
        }
        conn.setDoOutput(true);
        conn.setConnectTimeout(15000);
        conn.setReadTimeout(15000);
        this.charset = this.getCharset(conn, "UTF-8");
        this.fireStatusChanged("otev\u00edr\u00e1m vstupn\u00ed stream...");
        try {
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), this.charset));
        }
        catch (IOException ex) {
            if (ex instanceof ConnectException) {
                System.err.println("Nepoda\u0159ilo se nav\u00e1zat spojen\u00ed s " + url + ".");
            } else {
                MyExceptionHandler.handle(ex);
            }
            super.firePropertyChange("error", null, "chyba p\u0159i otev\u00edr\u00e1n\u00ed vstupn\u00edho streamu");
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean firstLine = true;
        this.fireStatusChanged("stahuji informace...");
        try {
            String line;
            while ((line = rd.readLine()) != null) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    sb.append("\n");
                }
                sb.append(line);
            }
        }
        catch (IOException ex) {
            MyExceptionHandler.handle(ex);
            super.firePropertyChange("error", null, "chyba p\u0159i stahov\u00e1n\u00ed informac\u00ed");
            return null;
        }
        try {
            rd.close();
        }
        catch (IOException ex) {
            MyExceptionHandler.handle(ex);
            super.firePropertyChange("error", null, "chyba p\u0159i uzav\u00edr\u00e1n\u00ed streamu");
            return null;
        }
        this.fireStatusChanged("stahov\u00e1n\u00ed \u00fasp\u011b\u0161n\u011b dokon\u010deno");
        return sb.toString();
    }

    @Override
    protected void done() {
        if (this.downloadFinishedListener != null && !super.isCancelled()) {
            SwingUtilities.invokeLater(() -> {
                try {
                    this.downloadFinishedListener.onDownloadFinished((String)URLStringDownloader.super.get(), this.charset);
                }
                catch (InterruptedException | ExecutionException ex) {
                    MyExceptionHandler.handle(ex);
                    URLStringDownloader.super.firePropertyChange("error", null, "intern\u00ed chyba");
                    this.downloadFinishedListener.onDownloadFinished(null, this.charset);
                }
            });
        }
    }

    private void fireStatusChanged(String newStatus) {
        super.firePropertyChange("status", this.status, newStatus);
        this.status = newStatus;
    }

    private Charset getCharset(URLConnection conn, String defaultCharset) {
        String chs = conn.getContentEncoding();
        String header = conn.getHeaderField("Content-Type");
        if (chs == null && header != null && header.contains("charset=")) {
            chs = header.substring(header.indexOf("charset=") + 8);
        }
        if (chs == null || chs.equals("") || !Charset.isSupported(chs)) {
            chs = defaultCharset;
        }
        return Charset.forName(chs);
    }

    public static interface DownloadFinishListener {
        public void onDownloadFinished(String var1, Charset var2);
    }
}

