/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.parser;

import cz.miroslavbartyzal.psdiagram.app.flowchart.Flowchart;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutSegment;
import cz.miroslavbartyzal.psdiagram.app.global.StringFunctions;
import cz.miroslavbartyzal.psdiagram.app.parser.AntlrErrorStrategyTranslated;
import cz.miroslavbartyzal.psdiagram.app.parser.ConversionResult;
import cz.miroslavbartyzal.psdiagram.app.parser.MyAntlrSyntaxErrorListener;
import cz.miroslavbartyzal.psdiagram.app.parser.ParseError;
import cz.miroslavbartyzal.psdiagram.app.parser.ParseResult;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;

public abstract class CodeToFlowchartConvertor<P extends Parser, L extends Lexer> {
    private final int maxParseErrorsAllowed;
    private ParseResult parseResult;

    protected CodeToFlowchartConvertor(int maxParseErrorsAllowed) {
        this.maxParseErrorsAllowed = maxParseErrorsAllowed;
    }

    public ConversionResult convertToPsd(String code) {
        this.parseResult = new ParseResult(code);
        Flowchart<LayoutSegment, LayoutElement> flowchart = this.generateFlowchart(code);
        ConversionResult conversionResult = new ConversionResult();
        conversionResult.setFlowchart(flowchart);
        if (!this.parseResult.isInputValid()) {
            String errorMessage = this.createErrorMessage(code);
            conversionResult.setErrorMessage(errorMessage);
        }
        if (flowchart == null && conversionResult.getErrorMessage() == null) {
            String message = "P\u0159i vytv\u00e1\u0159en\u00ed diagramu do\u0161lo k neo\u010dek\u00e1van\u00e9 chyb\u011b";
            conversionResult.setErrorMessage(message);
        }
        return conversionResult;
    }

    protected abstract L getLexer(CharStream var1);

    protected abstract P getParser(CommonTokenStream var1);

    protected abstract ParseTree createParseTree(P var1);

    protected abstract Flowchart<LayoutSegment, LayoutElement> generateFlowchartFromParseTree(ParseTree var1, String var2);

    private Flowchart<LayoutSegment, LayoutElement> generateFlowchart(String code) {
        try {
            L lexer = this.getLexer(CharStreams.fromString(code));
            ((Recognizer)lexer).removeErrorListeners();
            ((Recognizer)lexer).addErrorListener(new MyAntlrSyntaxErrorListener(false){

                @Override
                public void onSyntaxError(String errorMessage, int beginIndex, int endIndex) {
                    if (CodeToFlowchartConvertor.this.parseResult.getParseErrors().size() >= CodeToFlowchartConvertor.this.maxParseErrorsAllowed) {
                        CodeToFlowchartConvertor.this.parseResult.setWholeInputParsed(false);
                        throw new ParseCancellationException(String.format("Maximum parser errors reached (%s)", CodeToFlowchartConvertor.this.maxParseErrorsAllowed));
                    }
                    CodeToFlowchartConvertor.this.parseResult.addErrorInfo(errorMessage, beginIndex, endIndex);
                }
            });
            P parser = this.getParser(new CommonTokenStream((TokenSource)lexer));
            ((Recognizer)parser).removeErrorListeners();
            ((Recognizer)parser).addErrorListener(new MyAntlrSyntaxErrorListener(false){

                @Override
                public void onSyntaxError(String errorMessage, int beginIndex, int endIndex) {
                    if (CodeToFlowchartConvertor.this.parseResult.getParseErrors().size() >= CodeToFlowchartConvertor.this.maxParseErrorsAllowed) {
                        CodeToFlowchartConvertor.this.parseResult.setWholeInputParsed(false);
                        throw new ParseCancellationException(String.format("Maximum parser errors reached (%s)", CodeToFlowchartConvertor.this.maxParseErrorsAllowed));
                    }
                    CodeToFlowchartConvertor.this.parseResult.addErrorInfo(errorMessage, beginIndex, endIndex);
                }
            });
            ((Parser)parser).setErrorHandler(new AntlrErrorStrategyTranslated(false));
            if (!this.parseResult.isInputValid()) {
                return null;
            }
            ParseTree tree = this.createParseTree(parser);
            return this.generateFlowchartFromParseTree(tree, code);
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }

    private String createErrorMessage(String code) {
        StringBuilder message = new StringBuilder("<html>Diagram se nepoda\u0159ilo vytvo\u0159it!");
        List<ParseError> parseErrors = this.parseResult.getParseErrors();
        if (!parseErrors.isEmpty()) {
            message.append("<br /><br />Probl\u00e9mov\u00e1 m\u00edsta:<ul>");
            for (ParseError parseError : parseErrors) {
                if (parseError.getStartIndex() == parseError.getEndIndex()) {
                    message.append(String.format("<li>(m\u00edsto na pozici %s)", parseError.getStartIndex()));
                } else {
                    String thePart = code.substring(parseError.getStartIndex(), parseError.getEndIndex());
                    message.append(String.format("<li>`%s` (\u0159et\u011bzec na pozici %s)", thePart, parseError.getStartIndex()));
                }
                String errorMessage = parseError.getErrorMessage();
                if (errorMessage != null) {
                    errorMessage = errorMessage.replaceAll(" *\\n *", " ");
                    errorMessage = StringFunctions.escapeHTML(errorMessage);
                    message.append(String.format("<ul><li>%s</li></ul>", errorMessage));
                }
                message.append("</li>");
            }
            if (!this.parseResult.isWholeInputParsed()) {
                message.append("<li>a tak d\u00e1le ...</li>");
            }
            message.append("</ul>");
        }
        message.append("</html>");
        return message.toString();
    }
}

