/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.parser.java;

import cz.miroslavbartyzal.psdiagram.app.flowchart.Flowchart;
import cz.miroslavbartyzal.psdiagram.app.flowchart.FlowchartElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutElement;
import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.LayoutSegment;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.EnumSymbol;
import cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.Symbol;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.Decision;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.For;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.Goto;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.IO;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.LoopEnd;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.LoopStart;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.Process;
import cz.miroslavbartyzal.psdiagram.app.gui.symbolFunctionForms.Switch;
import cz.miroslavbartyzal.psdiagram.app.parser.CannotParseException;
import cz.miroslavbartyzal.psdiagram.app.parser.FlowchartGenerator;
import cz.miroslavbartyzal.psdiagram.app.parser.java.JavaParser;
import cz.miroslavbartyzal.psdiagram.app.parser.java.JavaParserBaseVisitor;
import cz.miroslavbartyzal.psdiagram.app.parser.java.pojo.AssignmentFields;
import cz.miroslavbartyzal.psdiagram.app.parser.java.pojo.BasicForIncField;
import cz.miroslavbartyzal.psdiagram.app.parser.java.pojo.BasicForToField;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class JavaToFlowchartVisitor
extends JavaParserBaseVisitor<String>
implements FlowchartGenerator {
    private final List<Class<?>> loopStatementClasses = List.of(JavaParser.ForStatementContext.class, JavaParser.WhileStatementContext.class, JavaParser.DoStatementContext.class);
    private final String input;
    private final Flowchart<LayoutSegment, LayoutElement> flowchart;
    private LayoutSegment currentSegment;
    private LayoutElement lastElement;
    private int namedSwitchesCount;
    private final Deque<String> switchNamesStack = new ArrayDeque<String>();
    private final Set<String> scannerVariables = new HashSet<String>();
    private final Set<String> consoleVariables = new HashSet<String>();

    public JavaToFlowchartVisitor(String input) {
        this.input = input;
        this.currentSegment = new LayoutSegment(null);
        this.flowchart = new Flowchart(this.currentSegment);
        this.lastElement = this.currentSegment.addSymbol(null, EnumSymbol.STARTEND.getInstance("Za\u010d\u00e1tek"));
        this.currentSegment.addSymbol(this.lastElement, EnumSymbol.STARTEND.getInstance("Konec"));
    }

    public Flowchart<LayoutSegment, LayoutElement> getFlowchart() {
        return this.flowchart;
    }

    @Override
    public String visitLocalVariableDeclaration(JavaParser.LocalVariableDeclarationContext ctx) {
        if (ctx.identifier() != null) {
            return this.visitLocalVarVariableDeclaration(ctx);
        }
        try {
            for (JavaParser.VariableDeclaratorContext variableDeclaratorContext : ctx.variableDeclarators().variableDeclarator()) {
                JavaParser.VariableDeclaratorIdContext variableDeclaratorIdContext = variableDeclaratorContext.variableDeclaratorId();
                JavaParser.VariableInitializerContext variableInitializerContext = variableDeclaratorContext.variableInitializer();
                if (variableInitializerContext == null) continue;
                String variable = ((String)this.visit(variableDeclaratorIdContext)).trim();
                if (this.isNewScanner(variableInitializerContext.expression())) {
                    this.scannerVariables.add(variable);
                    return "--VARIABLE-DECLARATION-(SCANNER)--";
                }
                if (this.isConsole(variableInitializerContext.expression())) {
                    this.consoleVariables.add(variable);
                    return "--VARIABLE-DECLARATION-(CONSOLE)--";
                }
                if (this.isInput(variableInitializerContext.expression())) {
                    this.addInput(variable, ctx);
                    return "--IO-(SCANNER)--";
                }
                String value = ((String)this.visit(variableInitializerContext)).trim();
                if (!Process.areValuesValid(variable, value)) {
                    throw new CannotParseException("Values are not PSD valid");
                }
                Symbol symbol = EnumSymbol.PROCESS.getInstance("");
                Process.generateValues(symbol, variable, value);
                symbol.setValueAndSize(symbol.getDefaultValue());
                this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
            }
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            this.resolveParseException(EnumSymbol.PROCESS, ctx);
        }
        return "--VARIABLE-DECLARATION--";
    }

    private String visitLocalVarVariableDeclaration(JavaParser.LocalVariableDeclarationContext ctx) {
        try {
            String variable = ((String)this.visit(ctx.identifier())).trim();
            if (this.isNewScanner(ctx.expression())) {
                this.scannerVariables.add(variable);
                return "--VAR-VARIABLE-DECLARATION-(SCANNER)--";
            }
            if (this.isConsole(ctx.expression())) {
                this.consoleVariables.add(variable);
                return "--VAR-VARIABLE-DECLARATION-(CONSOLE)--";
            }
            if (this.isInput(ctx.expression())) {
                this.addInput(variable, ctx);
                return "--IO-(SCANNER)--";
            }
            String value = ((String)this.visit(ctx.expression())).trim();
            Symbol symbol = EnumSymbol.PROCESS.getInstance("");
            Process.generateValues(symbol, variable, value);
            symbol.setValueAndSize(symbol.getDefaultValue());
            this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            this.resolveParseException(EnumSymbol.PROCESS, ctx);
        }
        return "--VAR-VARIABLE-DECLARATION--";
    }

    @Override
    public String visitAssignment(JavaParser.AssignmentContext ctx) {
        return this.visitAssignment(ctx, true);
    }

    private String visitAssignment(JavaParser.AssignmentContext ctx, boolean performAncestorCheck) {
        if (performAncestorCheck) {
            ParserRuleContext parent = ctx.getParent();
            while (parent instanceof JavaParser.AssignmentContext) {
                parent = parent.getParent();
            }
            if (!this.ancestorExists(parent, JavaParser.ExpressionStatementContext.class, 0)) {
                return (String)this.visitChildren(ctx);
            }
        }
        try {
            AssignmentFields assignmentFields = this.extractAssignmentFields(ctx);
            String variable = assignmentFields.getVariable().trim();
            if (this.isNewScanner(ctx.expression(1))) {
                this.scannerVariables.add(variable);
                return variable;
            }
            if (this.isConsole(ctx.expression(1))) {
                this.consoleVariables.add(variable);
                return variable;
            }
            if (this.isInput(ctx.expression(1))) {
                this.addInput(variable, ctx);
                return "--IO-(SCANNER)--";
            }
            String valueProcessed = assignmentFields.getValue().trim();
            if (!Process.areValuesValid(variable, valueProcessed)) {
                throw new CannotParseException("Values are not PSD valid");
            }
            Symbol symbol = EnumSymbol.PROCESS.getInstance("");
            Process.generateValues(symbol, variable, valueProcessed);
            symbol.setValueAndSize(symbol.getDefaultValue());
            this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
            return variable;
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            this.resolveParseException(EnumSymbol.PROCESS, ctx);
            return "";
        }
    }

    private void addInput(String variable, ParserRuleContext ctx) {
        if (!IO.isIVarValid(variable)) {
            this.resolveParseException(EnumSymbol.IO, ctx);
            return;
        }
        Symbol symbol = EnumSymbol.IO.getInstance("");
        IO.generateIValues(symbol, variable);
        symbol.setValueAndSize(symbol.getDefaultValue());
        this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
    }

    @Override
    public String visitPost(JavaParser.PostContext ctx) {
        return this.visitGeneralCrementExpression(ctx, ctx.expression(), ctx.postfix, true);
    }

    @Override
    public String visitPre(JavaParser.PreContext ctx) {
        return this.visitGeneralCrementExpression(ctx, ctx.expression(), ctx.prefix, true);
    }

    private String visitGeneralCrementExpression(ParserRuleContext originalContext, JavaParser.ExpressionContext expressionContext, Token operator, boolean performAncestorCheck) {
        if (performAncestorCheck && !this.ancestorExists(originalContext, JavaParser.ExpressionStatementContext.class, 1)) {
            return (String)this.visitChildren(originalContext);
        }
        try {
            JavaParser.IdentifierContext identifierContext = this.getTheOnlyChildFromSingleChildrenTree(expressionContext, JavaParser.IdentifierContext.class, 2);
            String variable = ((String)this.visit(identifierContext)).trim();
            Object value = variable;
            if (operator.getType() == 100) {
                value = (String)value + " + 1";
            } else if (operator.getType() == 101) {
                value = (String)value + " - 1";
            } else {
                throw new CannotParseException(String.format("Unexpected operator ('%s')", operator.getText()));
            }
            Symbol symbol = EnumSymbol.PROCESS.getInstance("");
            Process.generateValues(symbol, variable, (String)value);
            symbol.setValueAndSize(symbol.getDefaultValue());
            this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            this.resolveParseException(EnumSymbol.PROCESS, originalContext);
        }
        return "--CREMENT--";
    }

    @Override
    public String visitMethodInvocation(JavaParser.MethodInvocationContext ctx) {
        return this.visitGeneralInvocation(ctx, true);
    }

    @Override
    public String visitInvocation(JavaParser.InvocationContext ctx) {
        return this.visitGeneralInvocation(ctx, true);
    }

    private String visitGeneralInvocation(ParserRuleContext ctx, boolean performAncestorCheck) {
        if (performAncestorCheck && !this.ancestorExists(ctx, JavaParser.ExpressionStatementContext.class, 1)) {
            return (String)this.visitChildren(ctx);
        }
        try {
            if (ctx.getText().matches("^System\\.out\\.print(ln|f)?\\(.+\\)$")) {
                JavaParser.ExpressionContext firstExpressionContext = ctx.getChild(JavaParser.MethodCallContext.class, 0).getChild(JavaParser.ExpressionListContext.class, 0).getChild(JavaParser.ExpressionContext.class, 0);
                String outputValue = ((String)this.visit(firstExpressionContext)).trim();
                if (!IO.isOValueValid(outputValue)) {
                    throw new CannotParseException(ctx, this.input);
                }
                Symbol symbol = EnumSymbol.IO.getInstance("");
                IO.generateOValues(symbol, outputValue);
                symbol.setValueAndSize(symbol.getDefaultValue());
                this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
                return (String)this.visitChildren(ctx);
            }
            if (ctx.getText().matches("^System\\.exit\\(.+\\)$")) {
                this.lastElement = this.currentSegment.addSymbol(this.lastElement, EnumSymbol.STARTEND.getInstance("Konec"));
                return (String)this.visitChildren(ctx);
            }
            String value = (String)this.visitChildren(ctx);
            Symbol symbol = EnumSymbol.SUBROUTINE.getInstance(value);
            this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
            return value;
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            this.resolveParseException(EnumSymbol.SUBROUTINE, ctx);
            return "";
        }
    }

    @Override
    public String visitIfStatement(JavaParser.IfStatementContext ctx) {
        JavaParser.ParExpressionContext parExpressionContext = ctx.parExpression();
        JavaParser.CommentAfterStatementContext commentContext = ctx.commentAfterStatement();
        JavaParser.StatementContext ifSegmentContext = ctx.statement(0);
        JavaParser.StatementContext elseSegmentContext = ctx.statement(1);
        try {
            JavaParser.ExpressionContext conditionExpressionContext = parExpressionContext.expression();
            String condition = ((String)this.visit(conditionExpressionContext)).trim();
            if (!Decision.isConditionValid(condition)) {
                throw new CannotParseException(parExpressionContext, this.input);
            }
            Symbol symbol = EnumSymbol.DECISION.getInstance("");
            Decision.generateValues(symbol, condition);
            symbol.setValueAndSize(symbol.getDefaultValue());
            this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
            this.visitIfNotNull(commentContext);
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            int startIdx = ctx.getStart().getStartIndex();
            int stopIdx = parExpressionContext.getStop().getStopIndex() + 1;
            this.resolveParseException(EnumSymbol.DECISION, startIdx, stopIdx);
            LayoutSegment originalSegment = this.currentSegment;
            LayoutElement originalElement = this.lastElement;
            this.currentSegment = (LayoutSegment)this.lastElement.getInnerSegment(1);
            this.visitIfNotNull(commentContext);
            this.currentSegment = originalSegment;
            this.lastElement = originalElement;
        }
        LayoutSegment originalSegment = this.currentSegment;
        LayoutElement originalElement = this.lastElement;
        this.currentSegment = (LayoutSegment)this.lastElement.getInnerSegment(1);
        this.visitIfNotNull(ifSegmentContext);
        this.currentSegment = originalSegment;
        this.lastElement = originalElement;
        if (elseSegmentContext != null) {
            this.currentSegment = (LayoutSegment)this.lastElement.getInnerSegment(0);
            this.visitIfNotNull(elseSegmentContext);
            this.currentSegment = originalSegment;
            this.lastElement = originalElement;
        }
        return "--IF(+ELSE)--";
    }

    @Override
    public String visitSwitchStatementJava17(JavaParser.SwitchStatementJava17Context ctx) {
        this.resolveParseException(EnumSymbol.SWITCH, ctx, 1);
        return "--SWITCH-Java17--";
    }

    @Override
    public String visitSwitchExpression(JavaParser.SwitchExpressionContext ctx) {
        throw new CannotParseException("Java 17 Switch expression is not supported");
    }

    @Override
    public String visitSwitchStatement(JavaParser.SwitchStatementContext ctx) {
        Object symbol;
        List<String> segmentCases;
        String conditionVar;
        LinkedHashMap<String, JavaParser.BlockStatementsContext> segments = new LinkedHashMap<String, JavaParser.BlockStatementsContext>();
        JavaParser.CommentAfterStatementContext commentContext = ctx.commentAfterStatement();
        try {
            JavaParser.ExpressionContext expression = ctx.parExpression().expression();
            conditionVar = ((String)this.visit(expression)).trim();
            boolean defaultLabelVisited = false;
            List<JavaParser.SwitchBlockStatementGroupContext> blockStatementGroupContexts = ctx.switchBlockStatementGroup();
            for (JavaParser.SwitchBlockStatementGroupContext blockStatementGroupContext : blockStatementGroupContexts) {
                List<JavaParser.SwitchLabelContext> list = blockStatementGroupContext.switchLabel();
                String labelAggregated = this.getAggregatedLabel(list, defaultLabelVisited);
                if (labelAggregated == null) {
                    defaultLabelVisited = true;
                }
                segments.put(labelAggregated, blockStatementGroupContext.blockStatements());
            }
            List<JavaParser.SwitchLabelContext> emptyLabelContexts = ctx.switchLabel();
            if (emptyLabelContexts != null && !emptyLabelContexts.isEmpty()) {
                String labelAggregated = this.getAggregatedLabel(emptyLabelContexts, defaultLabelVisited);
                segments.put(labelAggregated, null);
            }
            if (!Switch.areValuesValid(conditionVar, segmentCases = segments.keySet().stream().filter(Objects::nonNull).collect(Collectors.toList()))) {
                throw new CannotParseException("Switch values are not PSD valid");
            }
            symbol = EnumSymbol.SWITCH.getInstance("");
            this.lastElement = this.currentSegment.addSymbol(this.lastElement, (Symbol)symbol, 1);
            this.visitIfNotNull(commentContext);
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            this.visitIfNotNull(commentContext);
            this.resolveParseException(EnumSymbol.SWITCH, ctx, 1);
            return "--SWITCH--";
        }
        this.switchNamesStack.push(this.pickupSwitchName());
        boolean connectWithPreviousCase = false;
        boolean breakSituatedNotAtTheRootOfCasePresent = false;
        LayoutSegment originalSegment = this.currentSegment;
        LayoutElement originalElement = this.lastElement;
        for (Map.Entry entry : segments.entrySet()) {
            String label = (String)entry.getKey();
            JavaParser.BlockStatementsContext innerSegmentContext = (JavaParser.BlockStatementsContext)entry.getValue();
            int innerSegmentIndex = this.prepareNextInnerSegment(originalElement, label == null);
            String gotoLabel = this.createGotoSymbolIfAppropriate(connectWithPreviousCase, innerSegmentIndex);
            this.currentSegment = (LayoutSegment)originalElement.getInnerSegment(innerSegmentIndex);
            this.createGotoLabelIfAppropriate(connectWithPreviousCase, originalElement, gotoLabel);
            this.visitIfNotNull(innerSegmentContext);
            boolean bl = connectWithPreviousCase = !this.containsBreak(innerSegmentContext);
            if (breakSituatedNotAtTheRootOfCasePresent) continue;
            breakSituatedNotAtTheRootOfCasePresent = this.isAnyBreakStatementNotAtTheRootOfSwitchSegment(innerSegmentContext);
        }
        this.lastElement = originalElement;
        this.currentSegment = originalSegment;
        this.generateSwitchValues(conditionVar, segmentCases);
        if (breakSituatedNotAtTheRootOfCasePresent) {
            symbol = EnumSymbol.GOTOLABEL.getInstance(this.switchNamesStack.peek() + LINE_SEP + "BR");
            this.lastElement = this.currentSegment.addSymbol(this.lastElement, (Symbol)symbol);
        }
        this.switchNamesStack.pop();
        return "--SWITCH--";
    }

    private void createGotoLabelIfAppropriate(boolean connectWithPreviousCase, LayoutElement switchElement, String gotoLabel) {
        if (connectWithPreviousCase) {
            Symbol symbol = EnumSymbol.GOTOLABEL.getInstance(gotoLabel);
            this.lastElement = this.currentSegment.addSymbol(switchElement, symbol);
        }
    }

    private String createGotoSymbolIfAppropriate(boolean connectWithPreviousCase, int innerSegmentIndex) {
        String gotoLabel = null;
        if (connectWithPreviousCase) {
            gotoLabel = this.switchNamesStack.peek() + LINE_SEP + innerSegmentIndex;
            Symbol symbol = EnumSymbol.GOTO.getInstance(gotoLabel);
            Goto.generateGotoValues(symbol);
            this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
        }
        return gotoLabel;
    }

    private int prepareNextInnerSegment(LayoutElement switchElement, boolean defaultCase) {
        if (defaultCase) {
            return 0;
        }
        int innerSegmentIndex = switchElement.getInnerSegmentsCount();
        switchElement.addInnerSegment(new LayoutSegment(switchElement));
        return innerSegmentIndex;
    }

    private void generateSwitchValues(String conditionVar, List<String> segmentCases) {
        Switch.generateValues(this.lastElement, conditionVar, (String[])segmentCases.toArray(String[]::new));
        this.lastElement.getSymbol().setValueAndSize(this.lastElement.getSymbol().getDefaultValue());
        for (int i = 1; i < this.lastElement.getInnerSegmentsCount(); ++i) {
            LayoutSegment innerSegment = (LayoutSegment)this.lastElement.getInnerSegment(i);
            innerSegment.setDescription(innerSegment.getDefaultDescription());
        }
    }

    private String pickupSwitchName() {
        ++this.namedSwitchesCount;
        Object name = "switch";
        name = (String)name + "_" + this.namedSwitchesCount;
        return name;
    }

    private boolean containsBreak(JavaParser.BlockStatementsContext innerSegmentContext) {
        List<JavaParser.BlockStatementContext> blockStatementContexts = innerSegmentContext.blockStatement();
        return blockStatementContexts.stream().anyMatch(b -> b.statement() instanceof JavaParser.BreakStatementContext);
    }

    private boolean isAnyBreakStatementNotAtTheRootOfSwitchSegment(ParserRuleContext root) {
        for (ParseTree child : root.children) {
            JavaParser.BreakStatementContext breakStatementContext;
            if (this.loopStatementClasses.stream().anyMatch(loopClass -> loopClass.isInstance(child)) || child instanceof JavaParser.SwitchStatementContext || !(child instanceof JavaParser.BreakStatementContext ? (breakStatementContext = (JavaParser.BreakStatementContext)child).identifier() == null && !this.ancestorExists(breakStatementContext, JavaParser.SwitchBlockStatementGroupContext.class, 3) : child instanceof ParserRuleContext && this.isAnyBreakStatementNotAtTheRootOfSwitchSegment((ParserRuleContext)child))) continue;
            return true;
        }
        return false;
    }

    private String getAggregatedLabel(List<JavaParser.SwitchLabelContext> labelContexts, boolean throwExceptionIfDefaultLabelPresent) {
        StringBuilder labelAggregated = new StringBuilder();
        for (JavaParser.SwitchLabelContext labelContext : labelContexts) {
            if (labelContext.DEFAULT() == null) {
                if (labelAggregated.length() > 0) {
                    labelAggregated.append(",");
                }
                String label = ((String)this.visit(labelContext.switchLabelCase())).trim();
                labelAggregated.append(label);
                continue;
            }
            if (throwExceptionIfDefaultLabelPresent) {
                throw new CannotParseException("Duplicate default label");
            }
            return null;
        }
        return labelAggregated.toString();
    }

    @Override
    public String visitBlockStatements(JavaParser.BlockStatementsContext ctx) {
        if (ctx.getParent() instanceof JavaParser.SwitchBlockStatementGroupContext) {
            for (JavaParser.BlockStatementContext blockStatementContext : ctx.blockStatement()) {
                if (blockStatementContext.statement() != null && blockStatementContext.statement() instanceof JavaParser.BreakStatementContext) break;
                this.visit(blockStatementContext);
            }
            return "--SWITCH-BLOCK-STATEMENTS--";
        }
        return (String)this.visitChildren(ctx);
    }

    @Override
    public String visitForStatement(JavaParser.ForStatementContext ctx) {
        JavaParser.ForControlContext forControlContext = ctx.forControl();
        JavaParser.CommentAfterStatementContext commentAfterStatementContext = ctx.commentAfterStatement();
        JavaParser.StatementContext statementContext = ctx.statement();
        if (this.directChildrenContain(forControlContext, JavaParser.BasicForControlContext.class)) {
            JavaParser.BasicForControlContext basicForControlContext = forControlContext.basicForControl();
            return this.visitBasicForStatement(ctx, basicForControlContext, commentAfterStatementContext, statementContext);
        }
        JavaParser.EnhancedForControlContext enhancedForControlContext = forControlContext.enhancedForControl();
        return this.visitEnhancedForStatement(ctx, enhancedForControlContext, commentAfterStatementContext, statementContext);
    }

    private String visitBasicForStatement(JavaParser.ForStatementContext originalCtx, JavaParser.BasicForControlContext ctx, JavaParser.CommentAfterStatementContext commentContext, JavaParser.StatementContext statementContext) {
        try {
            boolean negativeInc;
            JavaParser.ForInitContext forInitContext = ctx.forInit();
            JavaParser.RelationalContext relationalContext = ctx.getChild(JavaParser.RelationalContext.class, 0);
            JavaParser.ForUpdateContext forUpdateContext = ctx.forUpdate();
            ParserRuleContext variableContext = this.extractVariableContext(forUpdateContext);
            String variableText = variableContext.getText();
            String variable = ((String)this.visit(variableContext)).trim();
            String from = this.extractFromField(forInitContext, variable, variableText).trim();
            BasicForToField basicForToField = this.extractToField(relationalContext, variableText);
            String to = basicForToField.getTo().trim();
            BasicForIncField basicForIncField = this.extractIncField(forUpdateContext, variableText);
            String inc = basicForIncField.getInc().trim();
            if (basicForIncField.isSimpleFormWithoutVariables() && ((negativeInc = inc.startsWith("-")) && basicForToField.getOperatorType() == BasicForToField.RelationalOperatorType.LESSER_THAN || !negativeInc && basicForToField.getOperatorType() == BasicForToField.RelationalOperatorType.GREATER_THAN)) {
                throw new CannotParseException(String.format("Infinity loop detected '%s'", ctx.getText()));
            }
            if (!For.areValuesValid(variable, from, to, inc)) {
                throw new CannotParseException("Values are not PSD valid");
            }
            Symbol symbol = EnumSymbol.FOR.getInstance("");
            For.generateForValues(symbol, variable, from, to, inc);
            symbol.setValueAndSize(symbol.getDefaultValue());
            this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
            this.visitIfNotNull(commentContext);
        }
        catch (RuntimeException e) {
            try {
                this.transformForLoopIntoWhileLoop(ctx, commentContext, statementContext);
                return "--FOR-TRANSFORMED--";
            }
            catch (RuntimeException relationalContext) {
                System.err.println(e.getMessage());
                int startIdx = originalCtx.getStart().getStartIndex();
                int stopIdx = commentContext == null ? statementContext.getStart().getStartIndex() : commentContext.getStart().getStartIndex();
                this.resolveParseException(EnumSymbol.FOR, startIdx, stopIdx);
                LayoutSegment originalSegment = this.currentSegment;
                LayoutElement originalElement = this.lastElement;
                this.currentSegment = (LayoutSegment)this.lastElement.getInnerSegment(1);
                this.visitIfNotNull(commentContext);
                this.visitIfNotNull(statementContext);
                this.currentSegment = originalSegment;
                this.lastElement = originalElement;
                return "--FOR--";
            }
        }
        LayoutSegment originalSegment = this.currentSegment;
        LayoutElement originalElement = this.lastElement;
        this.currentSegment = (LayoutSegment)this.lastElement.getInnerSegment(1);
        this.visitIfNotNull(statementContext);
        this.currentSegment = originalSegment;
        this.lastElement = originalElement;
        return "--FOR--";
    }

    private String visitEnhancedForStatement(JavaParser.ForStatementContext originalCtx, JavaParser.EnhancedForControlContext ctx, JavaParser.CommentAfterStatementContext commentContext, JavaParser.StatementContext statementContext) {
        try {
            JavaParser.VariableDeclaratorIdContext variableDeclaratorIdContext = ctx.variableDeclaratorId();
            JavaParser.ExpressionContext expressionContext = ctx.expression();
            String variable = ((String)this.visit(variableDeclaratorIdContext)).trim();
            String arrayVariable = ((String)this.visit(expressionContext)).trim();
            if (!For.areValuesValid(variable, arrayVariable)) {
                throw new CannotParseException("Values are not PSD valid");
            }
            Symbol symbol = EnumSymbol.FOR.getInstance("");
            For.generateForeachValues(symbol, variable, arrayVariable);
            symbol.setValueAndSize(symbol.getDefaultValue());
            this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
            this.visitIfNotNull(commentContext);
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            int startIdx = originalCtx.getStart().getStartIndex();
            int stopIdx = commentContext == null ? statementContext.getStart().getStartIndex() : commentContext.getStart().getStartIndex();
            this.resolveParseException(EnumSymbol.FOR, startIdx, stopIdx);
            LayoutSegment originalSegment = this.currentSegment;
            LayoutElement originalElement = this.lastElement;
            this.currentSegment = (LayoutSegment)this.lastElement.getInnerSegment(1);
            this.visitIfNotNull(commentContext);
            this.visitIfNotNull(statementContext);
            this.currentSegment = originalSegment;
            this.lastElement = originalElement;
            return "--FOR-EACH--";
        }
        LayoutSegment originalSegment = this.currentSegment;
        LayoutElement originalElement = this.lastElement;
        this.currentSegment = (LayoutSegment)this.lastElement.getInnerSegment(1);
        this.visitIfNotNull(statementContext);
        this.currentSegment = originalSegment;
        this.lastElement = originalElement;
        return "--FOR-EACH--";
    }

    private ParserRuleContext extractVariableContext(JavaParser.ForUpdateContext forUpdateContext) {
        if (forUpdateContext == null) {
            throw new CannotParseException("No 'ForUpdateContext' present in for loop");
        }
        JavaParser.ExpressionContext expressionContext = this.getTheOnlyChildFromSingleChildrenTree(forUpdateContext, JavaParser.ExpressionContext.class, 2);
        if (expressionContext instanceof JavaParser.AssignmentContext || expressionContext instanceof JavaParser.PreContext || expressionContext instanceof JavaParser.PostContext) {
            JavaParser.ExpressionContext variableContext = this.getChildren(expressionContext, JavaParser.ExpressionContext.class).get(0);
            return variableContext;
        }
        throw new CannotParseException("No supported rule present in for loop 'ForUpdateContext'");
    }

    private String extractFromField(JavaParser.ForInitContext forInitContext, String variable, String variableText) {
        if (forInitContext == null) {
            return variable;
        }
        if (this.directChildrenContain(forInitContext, JavaParser.LocalVariableDeclarationContext.class)) {
            JavaParser.VariableDeclaratorContext declarator = this.getChildren(forInitContext, JavaParser.VariableDeclaratorContext.class, 1).get(0);
            String forInitVariable = declarator.variableDeclaratorId().getText();
            if (!forInitVariable.equals(variableText)) {
                throw new CannotParseException(String.format("Variable in 'ForInitContext' ('%s') does not equal to expected variable ('%s')", forInitVariable, variableText));
            }
            return (String)this.visit(declarator.variableInitializer());
        }
        JavaParser.AssignmentContext assignmentContext = this.getTheOnlyChildFromSingleChildrenTree(forInitContext, JavaParser.AssignmentContext.class, 2);
        JavaParser.ExpressionContext leftHandSideContext = assignmentContext.expression(0);
        String forInitVariableText = leftHandSideContext.getText();
        if (!forInitVariableText.equals(variableText)) {
            throw new CannotParseException(String.format("Variable in 'ForInitContext' ('%s') does not equal to expected variable ('%s')", forInitVariableText, variableText));
        }
        AssignmentFields assignmentFields = this.extractAssignmentFields(assignmentContext);
        return assignmentFields.getValue();
    }

    private BasicForToField extractToField(JavaParser.RelationalContext relationalExpression, String variableText) {
        Object to;
        BasicForToField.RelationalOperatorType relationalOperatorType;
        int increment;
        String operator;
        if (relationalExpression == null) {
            throw new CannotParseException("No 'RelationalContext' present in for loop");
        }
        this.getChildren(relationalExpression, JavaParser.RelationalOperatorContext.class, 1);
        JavaParser.RelationalOperatorContext relationalExpressionOperator = relationalExpression.relationalOperator();
        JavaParser.ExpressionContext variableExpression = relationalExpression.expression(0);
        JavaParser.ExpressionContext toExpression = relationalExpression.expression(1);
        String expressionVariable = variableExpression.getText();
        if (!expressionVariable.equals(variableText)) {
            throw new CannotParseException(String.format("Variable in 'ExpressionContext' ('%s') does not equal to expected variable ('%s')", expressionVariable, variableText));
        }
        switch (operator = relationalExpressionOperator.getText()) {
            case ">": {
                increment = 1;
                relationalOperatorType = BasicForToField.RelationalOperatorType.GREATER_THAN;
                break;
            }
            case "<": {
                relationalOperatorType = BasicForToField.RelationalOperatorType.LESSER_THAN;
                increment = -1;
                break;
            }
            case ">=": {
                relationalOperatorType = BasicForToField.RelationalOperatorType.GREATER_THAN;
                increment = 0;
                break;
            }
            case "<=": {
                relationalOperatorType = BasicForToField.RelationalOperatorType.LESSER_THAN;
                increment = 0;
                break;
            }
            default: {
                throw new CannotParseException(String.format("Unexpected relational operator value ('%s')", operator));
            }
        }
        if (this.getChildren(toExpression, JavaParser.LiteralContext.class).size() == 1) {
            to = ((String)this.visit(toExpression)).trim();
            if (((String)to).contains(".")) {
                double toAsDouble = Double.parseDouble((String)to);
                to = String.valueOf(toAsDouble += (double)increment);
            } else {
                int toAsInt = Integer.parseInt((String)to);
                to = String.valueOf(toAsInt += increment);
            }
            return new BasicForToField((String)to, relationalOperatorType);
        }
        to = ((String)this.visit(toExpression)).trim();
        if (increment == 1) {
            to = "(" + (String)to + ")+1";
        } else if (increment == -1) {
            to = "(" + (String)to + ")-1";
        }
        return new BasicForToField((String)to, relationalOperatorType);
    }

    private BasicForIncField extractIncField(JavaParser.ForUpdateContext forUpdateContext, String variableText) {
        if (forUpdateContext == null) {
            throw new CannotParseException("No 'ForUpdateContext' present in for loop");
        }
        JavaParser.ExpressionListContext expressionListContext = forUpdateContext.expressionList();
        if (expressionListContext.getChildCount() != 1) {
            throw new CannotParseException(forUpdateContext, this.input);
        }
        if (this.directChildrenContain(expressionListContext, JavaParser.AssignmentContext.class)) {
            String operator;
            JavaParser.AssignmentContext assignment = this.getChildren(expressionListContext, JavaParser.AssignmentContext.class, 1).get(0);
            JavaParser.AssignmentOperatorContext assignmentOperator = this.getChildren(assignment, JavaParser.AssignmentOperatorContext.class, 1).get(0);
            JavaParser.ExpressionContext assignmentVariableContext = assignment.expression(0);
            JavaParser.ExpressionContext expressionContext = assignment.expression(1);
            String assignmentVariableText = assignmentVariableContext.getText();
            if (!assignmentVariableText.equals(variableText)) {
                throw new IllegalArgumentException(String.format("Supported parameter variableText ('%s') is different from expected value ('%s')", variableText, assignmentVariableText));
            }
            switch (operator = assignmentOperator.getText()) {
                case "=": {
                    if (!(expressionContext instanceof JavaParser.AdditiveContext)) {
                        throw new CannotParseException("Expected AdditiveContext");
                    }
                    JavaParser.AdditiveContext additiveExpression = (JavaParser.AdditiveContext)expressionContext;
                    JavaParser.ExpressionContext firstOperand = additiveExpression.expression(0);
                    String firstOperandText = firstOperand.getText();
                    if (!firstOperandText.equals(variableText)) {
                        throw new CannotParseException(String.format("Unsupported form of assignment expression in 'ForUpdateContext' ('%s')", assignment.getText()));
                    }
                    JavaParser.ExpressionContext incExpression = additiveExpression.expression(1);
                    Object inc = ((String)this.visit(incExpression)).trim();
                    boolean simpleFormWithoutVariables = !this.childrenContain((ParserRuleContext)incExpression, JavaParser.IdentifierContext.class);
                    JavaParser.AdditiveOperatorContext additiveOperatorContext = additiveExpression.additiveOperator();
                    String additiveOperator = additiveOperatorContext.getText();
                    if (additiveOperator.equals("-")) {
                        inc = (String)this.visit(additiveOperatorContext) + (String)inc;
                    }
                    return new BasicForIncField((String)inc, simpleFormWithoutVariables);
                }
                case "+=": {
                    boolean simpleFormWithoutVariables = !this.childrenContain((ParserRuleContext)expressionContext, JavaParser.IdentifierContext.class);
                    String inc = ((String)this.visit(expressionContext)).trim();
                    return new BasicForIncField(inc, simpleFormWithoutVariables);
                }
                case "-=": {
                    boolean simpleFormWithoutVariables = !this.childrenContain((ParserRuleContext)expressionContext, JavaParser.IdentifierContext.class);
                    String inc = ((String)this.visit(expressionContext)).trim();
                    String minusSignFormatted = ((String)this.visit(assignmentOperator)).replace("=", "").trim();
                    inc = String.format("%s(%s)", minusSignFormatted, inc);
                    return new BasicForIncField(inc, simpleFormWithoutVariables);
                }
            }
            throw new CannotParseException(String.format("Unexpected assignment operator value ('%s')", operator));
        }
        if (this.directChildrenContain(expressionListContext, JavaParser.PreContext.class)) {
            JavaParser.PreContext preContext = expressionListContext.getChild(JavaParser.PreContext.class, 0);
            JavaParser.ExpressionContext preExpressionContext = preContext.expression();
            String unaryExpressionText = preExpressionContext.getText();
            if (!unaryExpressionText.equals(variableText)) {
                throw new IllegalArgumentException(String.format("Supported parameter variableText ('%s') is different from expected value ('%s')", variableText, unaryExpressionText));
            }
            if (preContext.prefix.getType() == 100) {
                return new BasicForIncField("1", true);
            }
            if (preContext.prefix.getType() == 101) {
                return new BasicForIncField("-1", true);
            }
            throw new CannotParseException(String.format("Unexpected PreContext ('%s')", preContext.prefix.getText()));
        }
        if (this.childrenContain((ParserRuleContext)expressionListContext, JavaParser.PostContext.class)) {
            JavaParser.PostContext postContext = expressionListContext.getChild(JavaParser.PostContext.class, 0);
            JavaParser.ExpressionContext postExpressionContext = postContext.expression();
            String postfixExpressionText = postExpressionContext.getText();
            if (!postfixExpressionText.equals(variableText)) {
                throw new IllegalArgumentException(String.format("Supported parameter variableText ('%s') is different from expected value ('%s')", variableText, postfixExpressionText));
            }
            if (postContext.postfix.getType() == 100) {
                return new BasicForIncField("1", true);
            }
            if (postContext.postfix.getType() == 101) {
                return new BasicForIncField("-1", true);
            }
            throw new CannotParseException(String.format("Unexpected PreContext ('%s')", postContext.postfix.getText()));
        }
        throw new CannotParseException("No supported rule present in for loop 'ForUpdateContext'");
    }

    private void transformForLoopIntoWhileLoop(JavaParser.BasicForControlContext ctx, JavaParser.CommentAfterStatementContext commentContext, JavaParser.StatementContext statementContext) {
        LayoutElement originalLastElement = this.lastElement;
        int preInitElementsCount = this.currentSegment.size();
        JavaParser.ForInitContext forInitContext = ctx.forInit();
        if (forInitContext != null) {
            JavaParser.LocalVariableDeclarationContext localVariableDeclarationContext = forInitContext.localVariableDeclaration();
            if (localVariableDeclarationContext == null) {
                this.processExpressionsPresentInForLoopWhichIsBeingTransformed(forInitContext.expressionList().expression());
            } else {
                this.visitLocalVariableDeclaration(localVariableDeclarationContext);
            }
        }
        String expressionContextVisited = null;
        JavaParser.ExpressionContext expressionContext = ctx.expression();
        if (expressionContext == null) {
            expressionContextVisited = "true";
        }
        try {
            this.visitWhileStatement(expressionContext, commentContext, statementContext, -1, false, true, expressionContextVisited);
        }
        catch (RuntimeException e) {
            int indexOfOriginalLastElement = this.currentSegment.indexOfElement(originalLastElement);
            int elementCountForRollback = this.currentSegment.size() - preInitElementsCount;
            for (int i = 0; i < elementCountForRollback; ++i) {
                LayoutElement elementToRemove = (LayoutElement)this.currentSegment.getElement(indexOfOriginalLastElement + 1);
                this.currentSegment.removeElement(elementToRemove);
            }
            this.lastElement = originalLastElement;
            throw e;
        }
        JavaParser.ForUpdateContext forUpdateContext = ctx.forUpdate();
        if (forUpdateContext != null) {
            LayoutSegment originalSegment = this.currentSegment;
            LayoutElement originalElement = this.lastElement;
            this.currentSegment = (LayoutSegment)this.lastElement.getInnerSegment(1);
            if (!this.currentSegment.isEmpty()) {
                this.lastElement = (LayoutElement)this.currentSegment.getElement(this.currentSegment.size() - 1);
            }
            this.processExpressionsPresentInForLoopWhichIsBeingTransformed(forUpdateContext.expressionList().expression());
            this.currentSegment = originalSegment;
            this.lastElement = originalElement;
        }
        this.lastElement = this.currentSegment.addSymbol(this.lastElement, new cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.LoopEnd());
    }

    private void processExpressionsPresentInForLoopWhichIsBeingTransformed(List<JavaParser.ExpressionContext> expressionContexts) {
        for (JavaParser.ExpressionContext expressionContext : expressionContexts) {
            JavaParser.ExpressionContext ctx;
            if (expressionContext instanceof JavaParser.InvocationContext || expressionContext instanceof JavaParser.MethodInvocationContext) {
                this.visitGeneralInvocation(expressionContext, false);
                continue;
            }
            if (expressionContext instanceof JavaParser.PostContext) {
                ctx = (JavaParser.PostContext)expressionContext;
                this.visitGeneralCrementExpression(ctx, ctx.expression(), ctx.postfix, false);
                continue;
            }
            if (expressionContext instanceof JavaParser.PreContext) {
                ctx = (JavaParser.PreContext)expressionContext;
                this.visitGeneralCrementExpression(ctx, ((JavaParser.PreContext)ctx).expression(), ((JavaParser.PreContext)ctx).prefix, false);
                continue;
            }
            if (!(expressionContext instanceof JavaParser.AssignmentContext)) continue;
            ctx = (JavaParser.AssignmentContext)expressionContext;
            this.visitAssignment((JavaParser.AssignmentContext)ctx, false);
        }
    }

    @Override
    public String visitWhileStatement(JavaParser.WhileStatementContext ctx) {
        JavaParser.ExpressionContext expressionContext = ctx.parExpression().expression();
        JavaParser.CommentAfterStatementContext commentContext = ctx.commentAfterStatement();
        JavaParser.StatementContext statementContext = ctx.statement();
        return this.visitWhileStatement(expressionContext, commentContext, statementContext, ctx.getStart().getStartIndex(), true, false, null);
    }

    private String visitWhileStatement(JavaParser.ExpressionContext expressionContext, JavaParser.CommentAfterStatementContext commentContext, JavaParser.StatementContext statementContext, int startIdx, boolean includeLoopEnd, boolean rethrowExceptions, String expressionContextVisited) {
        try {
            String condition = Objects.requireNonNullElseGet(expressionContextVisited, () -> ((String)this.visit(expressionContext)).trim());
            if (!LoopStart.isConditionValid(condition)) {
                throw new CannotParseException("While condition expression is not PSD valid");
            }
            Symbol symbol = EnumSymbol.LOOPCONDITIONUP.getInstance("");
            LoopStart.generateValues(symbol, condition);
            symbol.setValueAndSize(symbol.getDefaultValue());
            this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
            this.visitIfNotNull(commentContext);
        }
        catch (RuntimeException e) {
            if (rethrowExceptions) {
                throw e;
            }
            System.err.println(e.getMessage());
            int stopIdx = commentContext == null ? statementContext.getStart().getStartIndex() : commentContext.getStart().getStartIndex();
            this.resolveParseException(EnumSymbol.LOOPCONDITIONUP, startIdx, stopIdx);
            LayoutSegment originalSegment = this.currentSegment;
            LayoutElement originalElement = this.lastElement;
            this.currentSegment = (LayoutSegment)this.lastElement.getInnerSegment(1);
            this.visitIfNotNull(commentContext);
            this.currentSegment = originalSegment;
            this.lastElement = originalElement;
        }
        LayoutSegment originalSegment = this.currentSegment;
        LayoutElement originalElement = this.lastElement;
        this.currentSegment = (LayoutSegment)this.lastElement.getInnerSegment(1);
        this.visitIfNotNull(statementContext);
        this.currentSegment = originalSegment;
        this.lastElement = originalElement;
        if (includeLoopEnd) {
            this.lastElement = this.currentSegment.addSymbol(this.lastElement, new cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.LoopEnd());
        }
        return "--WHILE--";
    }

    @Override
    public String visitDoStatement(JavaParser.DoStatementContext ctx) {
        JavaParser.CommentAfterStatementContext commentContext = ctx.commentAfterStatement();
        JavaParser.StatementContext statementContext = ctx.statement();
        JavaParser.ParExpressionContext parExpressionContext = ctx.parExpression();
        Symbol symbol = EnumSymbol.LOOPCONDITIONDOWN.getInstance("");
        LayoutElement loopElement = this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
        this.visitIfNotNull(commentContext);
        LayoutSegment originalSegment = this.currentSegment;
        LayoutElement originalElement = this.lastElement;
        this.currentSegment = (LayoutSegment)loopElement.getInnerSegment(1);
        this.visitIfNotNull(statementContext);
        this.currentSegment = originalSegment;
        this.lastElement = originalElement;
        try {
            JavaParser.ExpressionContext conditionExpressionContext = parExpressionContext.expression();
            String condition = ((String)this.visit(conditionExpressionContext)).trim();
            if (!LoopEnd.isConditionValid(condition)) {
                throw new CannotParseException(parExpressionContext, this.input);
            }
            this.lastElement = this.currentSegment.addSymbol(this.lastElement, new cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.LoopEnd());
            LoopEnd.generateValues(this.lastElement.getSymbol(), condition);
            this.lastElement.getSymbol().setValueAndSize(this.lastElement.getSymbol().getDefaultValue());
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            int startIdx = statementContext.getStop().getStopIndex() + 1;
            int stopIdx = parExpressionContext.getStop().getStopIndex() + 1;
            String thePart = this.input.substring(startIdx, stopIdx);
            this.lastElement = this.currentSegment.addSymbol(this.lastElement, new cz.miroslavbartyzal.psdiagram.app.flowchart.symbols.LoopEnd(INVALID_COMMAND));
            this.lastElement = FlowchartGenerator.super.addComment(this.currentSegment, this.lastElement, thePart, true);
        }
        return "--DO-WHILE--";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String visitLabeledStatement(JavaParser.LabeledStatementContext ctx) {
        String labelValue = ((String)this.visit(ctx.identifier())).trim();
        JavaParser.StatementContext statement = ctx.statement();
        boolean breakPresent = false;
        boolean continuePresent = false;
        List<JavaParser.BreakStatementContext> breakStatementContexts = this.getChildren(statement, JavaParser.BreakStatementContext.class);
        for (JavaParser.BreakStatementContext breakStatementContext : breakStatementContexts) {
            String breakLabelValue;
            JavaParser.IdentifierContext identifier = breakStatementContext.identifier();
            if (identifier == null || (breakLabelValue = (String)this.visit(identifier)) == null || !breakLabelValue.trim().equals(labelValue)) continue;
            breakPresent = true;
            break;
        }
        if (this.loopStatementClasses.stream().anyMatch(loopClass -> loopClass.isInstance(statement))) {
            List<JavaParser.ContinueStatementContext> continueStatementContexts = this.getChildren(statement, JavaParser.ContinueStatementContext.class);
            for (JavaParser.ContinueStatementContext continueStatementContext : continueStatementContexts) {
                String continueLabelValue;
                JavaParser.IdentifierContext identifier = continueStatementContext.identifier();
                if (identifier == null || (continueLabelValue = (String)this.visit(identifier)) == null || !continueLabelValue.trim().equals(labelValue)) continue;
                continuePresent = true;
                break;
            }
        }
        this.visitIfNotNull(statement);
        if (continuePresent) {
            void var8_12;
            FlowchartElement loopElement = null;
            int n = this.currentSegment.indexOfElement(this.lastElement);
            while (var8_12 >= 0 && (loopElement = (LayoutElement)this.currentSegment.getElement((int)var8_12)).getInnerSegmentsCount() <= 0) {
                --var8_12;
            }
            if (loopElement == null) {
                throw new IllegalStateException("Expected a loop element");
            }
            LayoutSegment layoutSegment = (LayoutSegment)loopElement.getInnerSegment(1);
            Symbol symbol = EnumSymbol.GOTOLABEL.getInstance(labelValue + LINE_SEP + "CT");
            layoutSegment.addSymbol((LayoutElement)layoutSegment.getElement(layoutSegment.size() - 1), symbol);
        }
        if (breakPresent) {
            Symbol symbol = EnumSymbol.GOTOLABEL.getInstance(labelValue + LINE_SEP + "BR");
            this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
        }
        return "--LABELED-STATEMENT--";
    }

    @Override
    public String visitBreakStatement(JavaParser.BreakStatementContext ctx) {
        JavaParser.IdentifierContext identifier = ctx.identifier();
        if (identifier == null) {
            int depth = 1;
            for (ParserRuleContext parent = ctx.getParent(); parent != null; parent = parent.getParent()) {
                ParserRuleContext finalParent = parent;
                if (this.loopStatementClasses.stream().anyMatch(loopClass -> loopClass.isInstance(finalParent))) {
                    this.createBreakSymbol();
                    return "--BREAK--";
                }
                if (parent instanceof JavaParser.SwitchBlockStatementGroupContext) {
                    if (depth > 3) {
                        Symbol symbol = EnumSymbol.GOTO.getInstance(this.switchNamesStack.peek() + LINE_SEP + "BR");
                        Goto.generateGotoValues(symbol);
                        this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
                    }
                    return "--BREAK--";
                }
                ++depth;
            }
            this.createBreakSymbol();
        } else {
            String gotoLabel = ((String)this.visit(identifier)).trim();
            Symbol symbol = EnumSymbol.GOTO.getInstance(gotoLabel + LINE_SEP + "BR");
            Goto.generateGotoValues(symbol);
            this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
        }
        return "--BREAK--";
    }

    private void createBreakSymbol() {
        Symbol symbol = EnumSymbol.GOTO.getInstance("");
        Goto.generateBreakValues(symbol);
        symbol.setValueAndSize(symbol.getDefaultValue());
        this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
    }

    @Override
    public String visitContinueStatement(JavaParser.ContinueStatementContext ctx) {
        JavaParser.IdentifierContext identifier = ctx.identifier();
        String gotoLabel = ((String)this.visit(identifier)).trim();
        Symbol symbol = EnumSymbol.GOTO.getInstance(gotoLabel + LINE_SEP + "CT");
        Goto.generateGotoValues(symbol);
        this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
        return "--CONTINUE--";
    }

    @Override
    public String visitComment(JavaParser.CommentContext ctx) {
        String charBefore;
        int startIdx = ctx.getStart().getStartIndex();
        for (int i = startIdx - 1; i >= 0 && !(charBefore = this.input.substring(i, i + 1)).matches("[\\r\\n]"); --i) {
            if (charBefore.matches("[ \\t]")) continue;
            return this.visitGeneralComment(ctx, true);
        }
        return this.visitGeneralComment(ctx, false);
    }

    @Override
    public String visitCommentAfterStatement(JavaParser.CommentAfterStatementContext ctx) {
        return this.visitGeneralComment(ctx, true);
    }

    private String visitGeneralComment(ParserRuleContext ctx, boolean pair) {
        String value = (String)this.visitChildren(ctx);
        this.lastElement = FlowchartGenerator.super.addComment(this.currentSegment, this.lastElement, value, pair);
        return "";
    }

    @Override
    public String visitReturnStatement(JavaParser.ReturnStatementContext ctx) {
        JavaParser.ExpressionContext expressionContext = ctx.expression();
        if (expressionContext != null) {
            try {
                String outputValue = ((String)this.visit(expressionContext)).trim();
                if (!IO.isOValueValid(outputValue)) {
                    throw new CannotParseException(ctx, this.input);
                }
                Symbol symbol = EnumSymbol.IO.getInstance("");
                IO.generateOValues(symbol, outputValue);
                symbol.setValueAndSize(symbol.getDefaultValue());
                this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
            }
            catch (RuntimeException e) {
                System.err.println(e.getMessage());
                this.resolveParseException(EnumSymbol.IO, expressionContext);
            }
        }
        this.lastElement = this.currentSegment.addSymbol(this.lastElement, EnumSymbol.STARTEND.getInstance("Konec"));
        return "--RETURN--";
    }

    @Override
    public String visitAssertStatement(JavaParser.AssertStatementContext ctx) {
        this.resolveParseException(EnumSymbol.PROCESS, ctx);
        return "--ASSERT--";
    }

    @Override
    public String visitTryStatement(JavaParser.TryStatementContext ctx) {
        this.visitGeneralTryStatement(ctx.block(), ctx.catchClause(), ctx.finallyBlock());
        return "--TRY--";
    }

    @Override
    public String visitTryStatementWithResources(JavaParser.TryStatementWithResourcesContext ctx) {
        HashSet<String> scannerVariablesToAdd = new HashSet<String>();
        boolean resourcesOnlyContainScanners = true;
        for (JavaParser.ResourceContext resourceContext : ctx.resourceSpecification().resources().resource()) {
            if (this.isNewScanner(resourceContext.expression())) {
                String scannerVariable = resourceContext.variableDeclaratorId() == null ? ((String)this.visit(resourceContext.identifier())).trim() : ((String)this.visit(resourceContext.variableDeclaratorId())).trim();
                scannerVariablesToAdd.add(scannerVariable);
                continue;
            }
            resourcesOnlyContainScanners = false;
            break;
        }
        if (!resourcesOnlyContainScanners) {
            int startIdx = ctx.getStart().getStartIndex();
            int stopIdx = ctx.block().getStart().getStartIndex();
            this.resolveParseException(EnumSymbol.PROCESS, startIdx, stopIdx);
        }
        this.scannerVariables.addAll(scannerVariablesToAdd);
        this.visitGeneralTryStatement(ctx.block(), ctx.catchClause(), ctx.finallyBlock());
        this.scannerVariables.removeAll(scannerVariablesToAdd);
        return "--TRY-WITH-RESOURCES--";
    }

    private boolean isNewScanner(JavaParser.ExpressionContext expressionContext) {
        if (!(expressionContext instanceof JavaParser.NewContext)) {
            return false;
        }
        JavaParser.NewContext newContext = (JavaParser.NewContext)expressionContext;
        if (newContext.creator().nonWildcardTypeArguments() != null) {
            return false;
        }
        String createdNameText = newContext.creator().createdName().getText();
        if (!createdNameText.matches("^(java\\.util\\.)?Scanner$")) {
            return false;
        }
        List<JavaParser.ExpressionContext> argumentExpressionContexts = newContext.creator().classCreatorRest().arguments().expressionList().expression();
        if (argumentExpressionContexts.isEmpty() || argumentExpressionContexts.size() > 2) {
            return false;
        }
        return argumentExpressionContexts.get(0).getText().equals("System.in");
    }

    private boolean isConsole(JavaParser.ExpressionContext expressionContext) {
        if (!(expressionContext instanceof JavaParser.InvocationContext)) {
            return false;
        }
        JavaParser.InvocationContext invocationContext = (JavaParser.InvocationContext)expressionContext;
        String invocationContextText = invocationContext.getText();
        return invocationContextText.equals("System.console()");
    }

    private boolean isInput(JavaParser.ExpressionContext expressionContext) {
        return this.isScannerInput(expressionContext) || this.isConsoleInput(expressionContext);
    }

    private boolean isScannerInput(JavaParser.ExpressionContext expressionContext) {
        String variableText;
        if (!(expressionContext instanceof JavaParser.InvocationContext)) {
            return false;
        }
        JavaParser.InvocationContext invocationContext = (JavaParser.InvocationContext)expressionContext;
        try {
            variableText = this.getTheOnlyChildFromSingleChildrenTree(invocationContext.expression(), JavaParser.IdentifierContext.class, 2).getText().trim();
        }
        catch (RuntimeException e) {
            return false;
        }
        if (invocationContext.methodCall() == null || invocationContext.methodCall().identifier() == null) {
            return false;
        }
        String methodNameText = invocationContext.methodCall().identifier().getText();
        return this.scannerVariables.contains(variableText) && methodNameText.startsWith("next");
    }

    private boolean isConsoleInput(JavaParser.ExpressionContext expressionContext) {
        String variableText;
        if (!(expressionContext instanceof JavaParser.InvocationContext)) {
            return false;
        }
        JavaParser.InvocationContext invocationContext = (JavaParser.InvocationContext)expressionContext;
        if (invocationContext.getText().startsWith("System.console().readLine(")) {
            this.addOutputSymbolIfAppropriate(invocationContext);
            return true;
        }
        try {
            variableText = this.getTheOnlyChildFromSingleChildrenTree(invocationContext.expression(), JavaParser.IdentifierContext.class, 2).getText().trim();
        }
        catch (RuntimeException e) {
            return false;
        }
        if (invocationContext.methodCall() == null || invocationContext.methodCall().identifier() == null) {
            return false;
        }
        String methodNameText = invocationContext.methodCall().identifier().getText();
        if (this.consoleVariables.contains(variableText) && methodNameText.equals("readLine")) {
            this.addOutputSymbolIfAppropriate(invocationContext);
            return true;
        }
        return false;
    }

    private void addOutputSymbolIfAppropriate(JavaParser.InvocationContext consoleInvocationContext) {
        if (consoleInvocationContext.methodCall() == null || consoleInvocationContext.methodCall().expressionList() == null) {
            return;
        }
        JavaParser.ExpressionContext firstArgumentContext = consoleInvocationContext.methodCall().expressionList().expression(0);
        String outputValue = (String)this.visit(firstArgumentContext);
        if (IO.isOValueValid(outputValue)) {
            Symbol symbol = EnumSymbol.IO.getInstance("");
            IO.generateOValues(symbol, outputValue);
            symbol.setValueAndSize(symbol.getDefaultValue());
            this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol);
        } else {
            this.resolveParseException(EnumSymbol.IO, firstArgumentContext);
        }
    }

    private void visitGeneralTryStatement(JavaParser.BlockContext blockContext, List<JavaParser.CatchClauseContext> catchClauseContexts, JavaParser.FinallyBlockContext finallyBlockContext) {
        this.visitIfNotNull(blockContext);
        for (JavaParser.CatchClauseContext catchClauseContext : catchClauseContexts) {
            this.resolveParseException(EnumSymbol.PROCESS, catchClauseContext);
        }
        if (finallyBlockContext != null) {
            this.visitIfNotNull(finallyBlockContext);
        }
    }

    @Override
    public String visitSynchronizedStatement(JavaParser.SynchronizedStatementContext ctx) {
        int startIdx = ctx.getStart().getStartIndex();
        int stopIdx = ctx.block().getStart().getStartIndex();
        this.resolveParseException(EnumSymbol.PROCESS, startIdx, stopIdx);
        this.visitIfNotNull(ctx.block());
        return "--SYNCHRONIZED--";
    }

    @Override
    public String visitThrowStatement(JavaParser.ThrowStatementContext ctx) {
        this.resolveParseException(EnumSymbol.PROCESS, ctx);
        return "--THROW--";
    }

    @Override
    public String visitYieldStatement(JavaParser.YieldStatementContext ctx) {
        this.resolveParseException(EnumSymbol.PROCESS, ctx);
        return "--YIELD--";
    }

    @Override
    public String visitLocalTypeDeclaration(JavaParser.LocalTypeDeclarationContext ctx) {
        this.resolveParseException(EnumSymbol.PROCESS, ctx);
        return "--LOCAL-TYPE-DECLARATION--";
    }

    @Override
    public String visitNew(JavaParser.NewContext ctx) {
        if (this.isNewScanner(ctx)) {
            return (String)this.visitChildren(ctx);
        }
        JavaParser.CreatorContext creatorContext = ctx.creator();
        if (!this.directChildrenContain(creatorContext, JavaParser.ArrayCreatorRestContext.class)) {
            throw new CannotParseException(ctx, this.input);
        }
        JavaParser.ArrayCreatorRestContext arrayCreatorRestContext = creatorContext.arrayCreatorRest();
        JavaParser.ArrayInitializerContext arrayInitializerContext = arrayCreatorRestContext.arrayInitializer();
        if (arrayInitializerContext != null) {
            return (String)this.visit(arrayInitializerContext);
        }
        JavaParser.PrimitiveTypeContext primitiveTypeContext = creatorContext.createdName().primitiveType();
        JavaParser.DimExprsContext dimExprsContext = arrayCreatorRestContext.dimExprs();
        JavaParser.DimsContext dimsContext = arrayCreatorRestContext.dims();
        String dimExprs = (String)this.visit(dimExprsContext);
        String dimExprsText = dimExprsContext.getText();
        if (!dimExprsText.matches("(\\[(0|([1-9][0-9]*))\\])+")) {
            throw new CannotParseException(creatorContext, this.input);
        }
        String fillingContent = "null";
        if (primitiveTypeContext != null && dimsContext == null) {
            fillingContent = this.childrenContain((ParserRuleContext)primitiveTypeContext, JavaParser.NumericTypeContext.class) ? "0" : "false";
        }
        String arrayInitValue = this.explodeArrayDimensions(dimExprs, fillingContent);
        return arrayInitValue;
    }

    private String explodeArrayDimensions(String dimExprs, String fillingContent) {
        if (dimExprs.isEmpty()) {
            return fillingContent;
        }
        int stopIdx = dimExprs.indexOf(93);
        int dimension = Integer.parseInt(dimExprs.substring(1, stopIdx));
        String restDimExprs = dimExprs.substring(stopIdx + 1);
        String elementFill = this.explodeArrayDimensions(restDimExprs, fillingContent);
        StringBuilder result = new StringBuilder("[");
        for (int i = 0; i < dimension; ++i) {
            result.append(elementFill).append(", ");
        }
        if (dimension > 0) {
            result.replace(result.length() - 2, result.length(), "]");
        } else {
            result.append("]");
        }
        return result.toString();
    }

    @Override
    public String visitArrayInitializer(JavaParser.ArrayInitializerContext ctx) {
        JavaParser.VariableInitializerListContext variableInitializerListContext = ctx.variableInitializerList();
        String arrayInitValue = "";
        if (variableInitializerListContext != null) {
            arrayInitValue = (String)this.visit(variableInitializerListContext);
        }
        return "[" + arrayInitValue + "]";
    }

    @Override
    public String visitMultiplicativeOperator(JavaParser.MultiplicativeOperatorContext ctx) {
        JavaParser.MultiplicativeContext multiplicativeContext = this.getParent(ctx, JavaParser.MultiplicativeContext.class, 1);
        if (!multiplicativeContext.isInteger || ctx.DIV() == null) {
            return (String)this.visitChildren(ctx);
        }
        return ((String)this.visitChildren(ctx)).replace("/", "//");
    }

    @Override
    public String visitAnnotation(JavaParser.AnnotationContext ctx) {
        return "";
    }

    @Override
    public String visitDims(JavaParser.DimsContext ctx) {
        return "";
    }

    @Override
    public String visitTypeType(JavaParser.TypeTypeContext ctx) {
        return "";
    }

    @Override
    public String visitTerminal(TerminalNode node) {
        String nodeText;
        if (node.getSymbol().getType() == -1) {
            return "";
        }
        String spaceRight = this.getTerminalSpaceRight(node.getSymbol().getStopIndex());
        switch (node.getSymbol().getType()) {
            case 67: {
                nodeText = node.getText().replaceAll("_", "").replaceAll("[lL]$", "");
                break;
            }
            case 71: {
                nodeText = node.getText().replaceAll("[fFdD]$", "");
                break;
            }
            case 94: {
                nodeText = "=";
                break;
            }
            case 126: {
                nodeText = node.getText().replaceFirst("^/\\*\\s*", "").replaceFirst("\\s*\\*/$", "");
                spaceRight = "";
                break;
            }
            case 127: {
                nodeText = node.getText().replaceFirst("^//", "").trim();
                break;
            }
            default: {
                nodeText = node.getText();
            }
        }
        return nodeText + spaceRight;
    }

    @Override
    protected String aggregateResult(String aggregate, String nextResult) {
        if (aggregate == null) {
            return nextResult;
        }
        return aggregate + nextResult;
    }

    private AssignmentFields extractAssignmentFields(JavaParser.AssignmentContext assignmentContext) {
        JavaParser.ExpressionContext leftHandExpressionContext = assignmentContext.expression(0);
        JavaParser.AssignmentOperatorContext assignmentOperatorContext = assignmentContext.assignmentOperator();
        JavaParser.ExpressionContext expressionContext = assignmentContext.expression(1);
        String variable = (String)this.visit(leftHandExpressionContext);
        String operator = (String)this.visit(assignmentOperatorContext);
        String value = (String)this.visit(expressionContext);
        String valueProcessed = this.extractAssignmentValue(variable, operator, value, assignmentContext.isInteger);
        return new AssignmentFields(variable, operator, valueProcessed);
    }

    private String extractAssignmentValue(String variable, String operator, String value, boolean isInteger) {
        switch (operator.trim()) {
            case "=": {
                return value;
            }
            case "/=": {
                if (isInteger) {
                    return variable + operator.replace("=", "/") + value;
                }
            }
            case "+=": 
            case "-=": 
            case "*=": 
            case "%=": {
                return variable + operator.replace("=", "") + value;
            }
        }
        throw new CannotParseException(String.format("Unsupported assignment operator '%s'", operator.trim()));
    }

    private String getTerminalSpaceRight(int stopIdx) {
        int rightSpaceIdx;
        for (rightSpaceIdx = stopIdx + 1; rightSpaceIdx < this.input.length() && this.input.substring(rightSpaceIdx, rightSpaceIdx + 1).matches("[ \t]"); ++rightSpaceIdx) {
        }
        return this.input.substring(stopIdx + 1, rightSpaceIdx);
    }

    private void resolveParseException(EnumSymbol enumSymbol, ParserRuleContext ctx) {
        this.resolveParseException(enumSymbol, ctx, 0);
    }

    private void resolveParseException(EnumSymbol enumSymbol, ParserRuleContext ctx, int innerOutCount) {
        int startIdx = ctx.getStart().getStartIndex();
        int stopIdx = ctx.getStop().getStopIndex() + 1;
        this.resolveParseException(enumSymbol, startIdx, stopIdx, innerOutCount);
    }

    private void resolveParseException(EnumSymbol enumSymbol, int startIdx, int stopIdx) {
        this.resolveParseException(enumSymbol, startIdx, stopIdx, 0);
    }

    private void resolveParseException(EnumSymbol enumSymbol, int startIdx, int stopIdx, int innerOutCount) {
        String thePart = this.input.substring(startIdx, stopIdx);
        Symbol symbol = enumSymbol.getInstance(INVALID_COMMAND);
        this.lastElement = this.currentSegment.addSymbol(this.lastElement, symbol, innerOutCount);
        this.lastElement = FlowchartGenerator.super.addComment(this.currentSegment, this.lastElement, thePart, true);
    }

    private void visitIfNotNull(ParserRuleContext ctx) {
        if (ctx != null) {
            this.visit(ctx);
        }
    }
}

